// barrier.h 
//	Barrier data structures for synchronizing threads.
//
//	Note that all the synchronization objects take a "name" as
//	part of the initialization.  This is solely for debugging purposes.
//
// Copyright (c) 1992-1993 The Regents of the University of California.
// All rights reserved.  See copyright.h for copyright notice and limitation 
// lockcond.h -- synchronization primitives.  

#ifndef BARRIER_H
#define BARRIER_H

#include "copyright.h"
#include "thread.h"
#include "list.h"

class Barrier {
  public:
    Barrier(char *debugName, int size);
    Barrier(char *debugName, int ways, int size);
    ~Barrier();
    char* getName() { return name; }	// debugging assist
    void barrierSynch();
    int barrierSynch(int threadtype);
    void print();

  private:
    char* name;				// for debugging
    // plus some other stuff you'll need to define
};
#endif // BARRIER_H
