/*
 * sample_alpha.c
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <assert.h>
#include <gsl/gsl_sf.h>
#include <gsl/gsl_rng.h>
#include <gsl/gsl_randist.h>

#include "util.h"
#include "seqTM.h"

extern gsl_rng* glob_r;

void sample_alpha(Cts* cts, Model* model, Corpus* c)
{
	int i, d, k, l, iter;
	double alpha, sumnk, sumz, sumlogxd;

  	alpha = model->alpha;

	for(iter = 0; iter < 3; iter++){
		sumz = 0;
		sumlogxd = 0;
		for(d = 0; d < c->ndocs; d++){
			sumnk = 0;
			for(k = 0; k < model->K; k++){
				sumnk += cts->n[d][k];
				for(l = 0; l < cts->n[d][k]; l++){
					if(alpha / (alpha + l) > next_uniform()){
						sumz += 1;
					}
				}
			}
			sumlogxd += log(gsl_ran_beta(glob_r, model->K * alpha, sumnk));
		}
		alpha = gsl_ran_gamma(glob_r, sumz + 0.1, 1.0 / (0.1 - model->K * sumlogxd));
	}
	model->alpha = alpha;		
}

