function [vdata_h vdata_t] = transform_validation(filename)

fid = fopen(filename);

if fid < 0
    error('can not open file\n');
end

nl = 0;
n = 1000;
vdata = cell(1, n);
line = fgets(fid);

while ischar(line)
    c = textscan(line, '%d');
    c = double(c{1});
    nl = nl + 1;
    if nl > length(vdata)
        vdata = [vdata, cell(1, n)];
    end
    p = randperm(length(c));
    vdata{nl} = c(p) + 1;
    line = fgets(fid);
end

vdata = vdata(1:nl);
n = length(vdata);
vdata_h = cell(1, n);
vdata_t = cell(1, n);
for i = 1:n
    nn = ceil(0.2 * length(vdata{i}));
    vdata_h{i} = vdata{i}(1:nn);
    assert(~isempty(vdata_h{i}));
    vdata_t{i} = vdata{i}(nn+1:end);
    %assert(~isempty(vdata_t{i}));
end

fclose(fid);