import re
import random

def countSequence(seq, dict = {}):
  for x in seq:
    dict[x] = dict.get(x, 0) + 1 

  return dict

def wordCount(filename):
  d = {}
  with open(filename, "r") as f:
    for line in f:
      line = line.rstrip("\n").lower()
      words = re.split("[^a-zA-Z']+",line)
      d = countSequence(words, d)

  return d

# Create a dictionary of word counts in frankenstein.txt
frankenDict = wordCount("frankenstein.txt")

# Define a function that gets a random word from the dictionary
# of word counts in frankenstein.txt
def randomWord():
  # random.randint is a function that returns a random integer
  # in the range [min,max].
  i = random.randint(0,len(frankenDict)-1)
  # Convert the keys in the dictionary to a list, and return
  # the i-th element in that list
  return list(frankenDict.keys())[i]