import sys
import gc

import selectionSort
import timSort
import mergeSort
import timing

cutoff = 100000

#slow = []
slow = [selectionSort]
#fast = []
#fast = [mergeSort]
fast = [mergeSort,timSort]
#fast = [timSort]

longest = 0
for v in slow:
    print("Slow sort: "+v.name())
    longest = max(len(v.name()), longest)
for v in fast:
    print("Fast sort: "+v.name())
    longest = max(len(v.name()), longest)

if 2 <= len(sys.argv) <= 3:
    if len(sys.argv) == 2:
        problemSize = int(sys.argv[1])
    else:
        cutoff = int(sys.argv[1])
        problemSize = int(sys.argv[2])

    gc.disable()
    prefix = "Generating random list of size "+str(problemSize)
    print(prefix+" --> ", end='')
    orig = timing.timeMe(timing.randomList,problemSize)
    gc.enable()

    if problemSize < cutoff:
        for v in slow:
            copy = timing.copyList(orig)
            print( ("Sorting with "+v.name().ljust(longest)).rjust(len(prefix))+" --> ", end='')
            timing.timeMe(v.sort,copy)

    for v in fast:
        copy = timing.copyList(orig)
        print( ("Sorting with "+v.name().ljust(longest)).rjust(len(prefix))+" --> ", end='')
        timing.timeMe(v.sort,copy)

else:
    print("Usage: "+sys.argv[0]+" n")
    print("   or: "+sys.argv[0]+" cutoff n")
    print("n is the size of the list to be sorted")
    print("if n < cutoff both slow and fast sorts will be run")
    print("if n >= cutoff only fast sorts will be run")
    print("The default value for cutoff is {0}".format(cutoff))
