import sqlite3

# Create the variables we will rely upon
database_filename = "songs.db"
songs_table = "songs"
ratings_table = "ratings"

# Do the work needed when the system starts up
conn = sqlite3.connect(database_filename)
cur = conn.cursor()
cur.execute("CREATE TABLE IF NOT EXISTS " + songs_table + " ('id', 'title', 'artist')")
cur.execute("CREATE TABLE IF NOT EXISTS " + ratings_table + " ('id', 'rating')")
cur2 = conn.cursor()

def allSongs():
    return cur.execute("SELECT * FROM " + songs_table)

def ratingsForSong(id):
    listOfRatings = []
    ratingsSeq = cur2.execute("SELECT * FROM " + ratings_table + " WHERE id=?", (id,))
    for rating in ratingsSeq :
        listOfRatings.append(rating[1])
    return listOfRatings

def insertSong(song):
    cur.execute('INSERT INTO ' + songs_table + ' VALUES (?,?,?)', \
                (song['song_id'], song['title'], song['artist']))
    conn.commit()

def insertRating(rating):
    cur.execute('INSERT INTO ' + ratings_table + ' VALUES (?,?)', (rating['song_id'], rating['rating']))
    conn.commit()

def songNotAdded(song):
    songSeq = cur.execute("SELECT * FROM " + songs_table + " WHERE id=?", (song['song_id'],))
    val = list(songSeq)
    if len(val) == 0 :
      return True
    return False

def get_songs():
    songDict = {}
    for row in allSongs():
        id = row[0]
        title = row[1]
        artist = row[2]
        rats = ratingsForSong(id)
        songDict[id] = {"song_id": id, "title": title, "artist": artist, "ratings": rats}
    return songDict


def validSongId(song):
    return 'song_id' in song and len(song['song_id']) == 11

def validTitle(song) :
    return 'title' in song and song['title'] != ""

def validRate(rating):
    return 'rating' in rating and rating['rating'] in [1, 2, 3, 4, 5]

def validArtist(song) :
    return 'artist' in song and song['artist'] != ""

def add_song(song):
      # Stop if song has missing or invalid data
    if not (validSongId(song) and validTitle(song) and validArtist(song) and\
    songNotAdded(song)) :
      return
    insertSong(song)


def rate_song(rating):
    if not validSongId(rating) or not validRate(rating) or\
            songNotAdded(rating) :
        return

    insertRating(rating)