// ============================================================================
// algos.cpp
// ~~~~~~~~~
// author: hqn
// ============================================================================

#include <stdexcept>
#include <algorithm>
#include <string>
#include <sstream>
#include <iostream>
#include <fstream>
#include <cstdlib>
#include <set>
#include "Lexer.h"
#include "algos.h"
using namespace std; // BAD PRACTICE

void tryToOpen(const string& filename, ifstream& ifs)
{
    string msg;
    ifs.clear();                                                        
    ifs.open(filename.c_str());                                                
    if (ifs.fail()) {                                                       
        msg = string("Failed to open file ");
        msg += filename;
        throw runtime_error(msg);
    }
}

// read the next edge from the file and return true
// if EOF reached, return false
// throw an exception if a badly formatted line is encountered
bool getNextEdge(ifstream& ifs, pair<int, int>& p)
{
    string line;
    int a, b, c;
    istringstream iss;
    while (getline(ifs, line)) {
        if (line[0] == '#') 
            continue;

        iss.clear();    
        iss.str(line);
        if (!(iss >> a) || !(iss >> b) || (iss >> c)) {
            ifs.close();
            throw runtime_error("Input file not well-formatted");
        }

        p = make_pair(min(a,b), max(a,b));
        return true;
    }
    return false;
}

int sba(string filename)
{
    set<pair<int, int> > mySet;

    ifstream ifs;
    tryToOpen(filename, ifs);

    string line;
    pair<int, int> p;
    while (getNextEdge(ifs, p)) {
        mySet.insert(p);
    }
    ifs.close();
    return mySet.size();
}

int vba(string filename)
{
    ifstream ifs;
    tryToOpen(filename, ifs);

    pair<int, int> p;
    vector<pair<int, int> > edgeVec;
    while (getNextEdge(ifs, p))
        edgeVec.push_back(p);

    ifs.close();

    sort(edgeVec.begin(), edgeVec.end());
    vector<pair<int, int> >::iterator i = edgeVec.begin();

    while (i != edgeVec.end()) {
        vector<pair<int, int> >::iterator j = i+1;
        if (j != edgeVec.end() && *i == *j) {
            i = edgeVec.erase(i);
        } else {
            i = j;
        }
    }

    return edgeVec.size();
}

int fastvba(string filename)
{
    ifstream ifs;
    tryToOpen(filename, ifs);

    pair<int, int> p;
    vector<pair<int, int> > edgeVec;
    while (getNextEdge(ifs, p))
        edgeVec.push_back(p);

    ifs.close();

    sort(edgeVec.begin(), edgeVec.end());
    int count=0;
    for (size_t i=0; i<edgeVec.size(); i++) {
        if (i+1 < edgeVec.size()) {
            if (edgeVec[i] < edgeVec[i+1])
                count++;
        } else {
            count++;
            break;
        }
    }
    return count;
}
