// ============================================================================
// BinaryTree.cpp
// ~~~~~~~~~~~~~~
// hqn
// - Implementation of a Very Basic Binary Tree Class
// - Illustration of how to use deque
// - Common traversal order
// ============================================================================

#include <algorithm> // for sort()
#include <stdexcept>
#include <deque>
#include <map>
#include <sstream>
#include <iostream>
#include <iomanip>

#include "BinaryTree.h"
#include "term_control.h"

using namespace std; // BAD PRACTICE

BinaryTree::BinaryTree()
{
    root_ = NULL;
}

BinaryTree::BinaryTree(vector<string>& a, vector<string>& b)
{
    root_ = NULL;
    setTree(a, b);
}

BinaryTree::~BinaryTree()
{
    coordinate_.clear();
    width_.clear();
    clearTree(root_);
    root_ = NULL;
}

void BinaryTree::clearTree(Node* node) 
{
    if (node != NULL) {
        clearTree(node->left);
        clearTree(node->right);
        delete node;
    }
}


bool BinaryTree::isEmpty() const
{
    return root_ == NULL;
}

string BinaryTree::levelOrderSequence()
{
    ostringstream oss;
    if (root_ != NULL) {
        deque<Node*> nodeQ;
        nodeQ.push_front(root_);
        while (!nodeQ.empty()) {
            Node* cur = nodeQ.back();
            nodeQ.pop_back();
            if (cur->left != NULL) 
                nodeQ.push_front(cur->left);
            if (cur->right != NULL) 
                nodeQ.push_front(cur->right);
            oss << cur->payload << " ";
        }
    }
    return oss.str();
}

string BinaryTree::inOrderSequence()
{
    return inOrderSequence(root_);
}

string BinaryTree::preOrderSequence()
{
    return preOrderSequence(root_);
}

string BinaryTree::postOrderSequence()
{
    return postOrderSequence(root_);
}

string BinaryTree::inOrderSequence(Node* node) 
{
    ostringstream oss;
    if (node != NULL) {
        oss << inOrderSequence(node->left) 
            << node->payload << " "
            << inOrderSequence(node->right);
    }
    return oss.str();
}

string BinaryTree::postOrderSequence(Node* node) 
{
    ostringstream oss;
    if (node != NULL) {
        oss << postOrderSequence(node->left)
            << postOrderSequence(node->right)
            << node->payload << " ";
    }
    return oss.str();
}

string BinaryTree::preOrderSequence(Node* node) 
{
    ostringstream oss;
    if (node != NULL) {
        oss << node->payload << " "
            << preOrderSequence(node->left)
            << preOrderSequence(node->right);
    }
    return oss.str();
}

bool BinaryTree::setTree(vector<string>& a, vector<string>& b)
{
    if (!isPermutation(a,b))
        return false;
    this->~BinaryTree();
    root_ = constructTree(a, 0, b, 0, a.size());
    return true;
}

BinaryTree::Node* BinaryTree::constructTree(
        vector<string>& a, size_t a_start, 
        vector<string>& b, size_t b_start, 
        size_t len)
{
    if (len == 0) 
        return NULL;

    Node* node = new Node(a[a_start]); // root_ of new tree

    size_t i;
    for (i=0; i<len; i++) {
        if (b[b_start+i].compare(a[a_start]) == 0) 
            break;
    }

    if (i == len)
        throw runtime_error("Invalid PRE/IN-order sequences");

    node->left  = constructTree(a, a_start+1, b, b_start, i);
    node->right = constructTree(a, a_start+i+1, b, b_start+i+1, len-i-1);

    return node;
}

bool BinaryTree::isPermutation(vector<string> a, vector<string> b) 
{
    if (a.size() != b.size()) 
        return false;

    sort(a.begin(), a.end());
    sort(b.begin(), b.end());

    for (size_t i=0; i<a.size(); i++)
        if (a[i].compare(b[i]) != 0) 
            return false;

    return true;
}

string BinaryTree::vertical()
{
    vector<bool> path; 
    return term_cc(CYAN) + verticalHelper(root_, path) + term_cc();
}

string BinaryTree::printBars(vector<bool>& path, bool underscore) 
{
    size_t i;
    ostringstream oss;
    for (i=0; i+1<path.size(); ++i)
        oss << (path[i] ? "|  " : "   ");
    if (path.size() > 0)
        oss << (underscore? "|__" : "|");
    return oss.str();
}

string BinaryTree::verticalHelper(Node* node, vector<bool>& path) 
{
    ostringstream oss;

    oss << printBars(path) << (node == NULL? "x" : node->payload) << endl;

    if ( (node == NULL) || (node->right == NULL && node->left == NULL) ) 
        return oss.str();

    path.push_back(true);                     // right branch
    oss << verticalHelper(node->right, path);
    oss << printBars(path, false) << endl;    // transition line
    path.back() = false;                      // left branch
    oss << verticalHelper(node->left, path);
    path.pop_back();
    return oss.str();
}

string BinaryTree::horizontal() 
{
    if (root_ == NULL) 
        return "";

    ostringstream oss;

    computeSubtreeWidths(root_);

    deque<Node*> nodeQ; 
    nodeQ.push_front(root_);
    deque<size_t> indentationQ;        
    indentationQ.push_front(0);
    size_t c = 1;  // # of nodes on the current level still in the Q
    size_t n = 0;  // # of nodes on the next level already in the Q
    string horiLine; // the _____ part
    size_t indentation;
    size_t horiLineLen;
    vector<Text> node_vec;
    vector<Text> conn_vec;
    while (!nodeQ.empty()) {
        Node* cur = nodeQ.back();          // head of Q
        nodeQ.pop_back();

        indentation = indentationQ.back(); // head of indentation Q
        indentationQ.pop_back();
        --c;

        if (cur == NULL) {
            node_vec.push_back(Text("x", indentation));
        } else if (cur->left == NULL && cur->right == NULL) {
            node_vec.push_back(Text(cur->payload, indentation));
        } else {
            // left child has the same indentation as parent
            nodeQ.push_front(cur->left);
            indentationQ.push_front(indentation);
            // right child is indented further by left-width + 1
            nodeQ.push_front(cur->right);
            indentationQ.push_front(indentation + 
                   max(cur->payload.length(), width_[cur->left]) + 1);
            n += 2;
            horiLineLen = max(cur->payload.length(), width_[cur->left])
                           - cur->payload.length(); 
            horiLine = cur->payload + string(horiLineLen, '_');

            node_vec.push_back(Text(horiLine, indentation));
            conn_vec.push_back(Text("|", indentation));
            conn_vec.push_back(Text("\\", indentation + horiLine.length()));
        }

        if (c == 0) { // reached the end of a level
            oss << printLevel(node_vec); 
            node_vec.clear();
            oss << printLevel(conn_vec); 
            conn_vec.clear();
            c = n;
            n = 0;
        }
    } // end while (!nodeQ.empty()))
    return oss.str();
}


void BinaryTree::computeSubtreeWidths(Node* node)
{
    if (node == NULL) { 
        width_[NULL] = 1; 
        return; 
    }
    computeSubtreeWidths(node->left);
    computeSubtreeWidths(node->right);
    width_[node] = max(node->payload.length(), width_[node->left]) 
                   + 1 + width_[node->right];
}

string BinaryTree::printLevel(const vector<Text>& vec) 
{
    ostringstream oss;
    size_t cur_pos = 0; // where we are on the line
    size_t new_pos;
    for (size_t i=0; i<vec.size(); i++) {
        new_pos = vec[i].pos + vec[i].text.length();
        oss << setfill(' ') << right << setw(new_pos - cur_pos) << vec[i].text;
        cur_pos = new_pos;
    }
    if (!vec.empty()) oss << endl;
    return oss.str();
}

string BinaryTree::symmetric() 
{
    if (root_ == NULL) 
        return "";

    ostringstream oss;
    computeCoordinates(root_);

    deque<Node*> nodeQ; nodeQ.push_front(root_);
    deque<size_t> indentationQ;        indentationQ.push_front(0);
    size_t c = 1;  // # of nodes on the current level in queue
    size_t n = 0;  // # of nodes on the next level in queue
    string horiLine; // the _____ part
    Coordinate lc, rc;
    size_t horiLineLen, x;
    vector<Text> node_vec;
    vector<Text> conn_vec;
    while (!nodeQ.empty()) 
    {
        Node* cur = nodeQ.back(); // head of Q
        size_t indent = indentationQ.back();     // head of indent Q
        nodeQ.pop_back();
        indentationQ.pop_back();
        --c;

        if (cur == NULL) {
            node_vec.push_back(Text("x", indent));
        } else if (cur->left == NULL && cur->right == NULL) {
            node_vec.push_back(Text(cur->payload, indent));
        } else {
            lc = coordinate_[cur->left];
            rc = coordinate_[cur->right];
            x = max(cur->payload.length()+lc.offset+rc.width-
                    rc.offset+2,lc.width+rc.width) - lc.width-rc.width+1;

            nodeQ.push_front(cur->left); 
            indentationQ.push_front(indent);
            nodeQ.push_front(cur->right);
            indentationQ.push_front(indent + lc.width + x);

            n += 2;
            horiLineLen = x+lc.width+rc.width-2-lc.offset-(rc.width-rc.offset+1)
                          -cur->payload.length();
            horiLine = string(horiLineLen/2, '_') + cur->payload + 
                       string(horiLineLen - horiLineLen/2, '_');

            node_vec.push_back(Text(horiLine, indent+lc.offset+1));
            conn_vec.push_back(Text("/", indent+lc.offset));
            conn_vec.push_back(Text("\\", indent+lc.width+x+rc.offset-2));
        }

        if (c == 0) { // reached the end of a level
            oss << printLevel(node_vec); 
            node_vec.clear();
            oss << printLevel(conn_vec); 
            conn_vec.clear();
            c = n;
            n = 0;
        }
    } // end while (!nodeQ.empty()))
    return oss.str();
}

void BinaryTree::computeCoordinates(Node* node)
{
    Coordinate ret, lc, rc;
    size_t x;
    if (node == NULL) { 
        ret.width  = 1;
        ret.offset = 1;
    } else if (node->left == NULL && node->right == NULL) {
        ret.width = node->payload.length();
        ret.offset = 1 + ret.width/2;
    } else {
        computeCoordinates(node->left);
        computeCoordinates(node->right);
        lc = coordinate_[node->left];
        rc = coordinate_[node->right];
        x = max(node->payload.length()+lc.offset+rc.width-
                rc.offset+2,lc.width+rc.width) - lc.width-rc.width+1;
        ret.width = lc.width+rc.width+x;
        ret.offset = lc.offset + 1 + (lc.width+rc.offset+x-1-lc.offset)/2;
    }
    coordinate_[node] = ret;
}
