/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.apps;

import net.sourceforge.jiu.apps.EditorState;
import net.sourceforge.jiu.apps.MenuIndexConstants;
import net.sourceforge.jiu.data.BilevelImage;
import net.sourceforge.jiu.data.Gray16Image;
import net.sourceforge.jiu.data.Gray8Image;
import net.sourceforge.jiu.data.Paletted8Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.data.RGB48Image;

public abstract class OperationProcessor
implements MenuIndexConstants {
    private EditorState state;

    public OperationProcessor(EditorState editorState) {
        this.state = editorState;
    }

    public abstract void colorAdjustBrightness();

    public abstract void colorAdjustContrast();

    public abstract void colorAdjustGamma();

    public abstract void colorAdjustHueSaturationValue();

    public abstract void colorHistogramCountColorsUsed();

    public abstract void colorHistogramEqualize();

    public abstract void colorHistogramNormalize();

    public abstract void colorHistogramTextureProperties();

    public abstract void colorHistogramSaveHistogramAs();

    public abstract void colorHistogramSaveCoOccurrenceMatrixAs();

    public abstract void colorHistogramSaveCoOccurrenceFrequencyMatrixAs();

    public abstract void colorPaletteSaveAs();

    public abstract void colorPromotePromoteToPaletted();

    public abstract void colorPromotePromoteToGray8();

    public abstract void colorPromotePromoteToGray16();

    public abstract void colorPromotePromoteToRgb24();

    public abstract void colorPromotePromoteToRgb48();

    public abstract void colorReduceReduceNumberOfShadesOfGray();

    public abstract void colorReduceConvertToGrayscale();

    public abstract void colorReduceMedianCut();

    public abstract void colorReduceOctree();

    public abstract void colorReduceReduceToBilevelThreshold();

    public abstract void colorReduceUniformPalette();

    public abstract void colorReduceMapToArbitraryPalette();

    public abstract void colorConvertToMinimumColorType();

    public abstract void colorInvert();

    public abstract void editRedo();

    public abstract void editUndo();

    public abstract void filtersBlur();

    public abstract void filtersSharpen();

    public abstract void filtersEdgeDetection();

    public abstract void filtersEmboss();

    public abstract void filtersPsychedelicDistillation();

    public abstract void filtersLithograph();

    public abstract void filtersHorizontalSobel();

    public abstract void filtersVerticalSobel();

    public abstract void filtersHorizontalPrewitt();

    public abstract void filtersVerticalPrewitt();

    public abstract void filtersMaximum();

    public abstract void filtersMedian();

    public abstract void filtersMean();

    public abstract void filtersMinimum();

    public abstract void filtersOil();

    public abstract void transformationsFlip();

    public abstract void transformationsMirror();

    public abstract void transformationsRotate90Left();

    public abstract void transformationsRotate90Right();

    public abstract void transformationsRotate180();

    public abstract void transformationsCrop();

    public abstract void transformationsShear();

    public abstract void transformationsScale();

    public abstract void viewInterpolationTypeBicubic();

    public abstract void viewInterpolationTypeBilinear();

    public abstract void viewInterpolationTypeNearestNeighbor();

    public abstract void viewZoomIn();

    public abstract void viewZoomOut();

    public abstract void viewSetOriginalSize();

    public abstract void fileClose();

    public abstract void fileExit();

    public abstract void fileOpen(String var1);

    public abstract void fileSaveAsBmp();

    public abstract void fileSaveAsGif();

    public abstract void fileSaveAsPalm();

    public abstract void fileSaveAsPbm();

    public abstract void fileSaveAsPgm();

    public abstract void fileSaveAsPng();

    public abstract void fileSaveAsPpm();

    public abstract void fileSaveAsRas();

    public EditorState getEditorState() {
        return this.state;
    }

    public abstract void helpAbout();

    public abstract void helpSystemInformation();

    public boolean isAvailable(int menuIndex) {
        boolean hasImage = this.state.hasImage();
        PixelImage image = this.state.getImage();
        boolean bilevel = hasImage && image instanceof BilevelImage;
        boolean gray8 = hasImage && image instanceof Gray8Image;
        boolean gray16 = hasImage && image instanceof Gray16Image;
        boolean pal8 = hasImage && image instanceof Paletted8Image;
        boolean rgb24 = hasImage && image instanceof RGB24Image;
        boolean rgb48 = hasImage && image instanceof RGB48Image;
        boolean rgb = rgb24 || rgb48;
        switch (menuIndex) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 8: {
                return hasImage;
            }
            case 2: {
                return hasImage;
            }
            case 83: {
                return bilevel || gray8 || pal8;
            }
            case 81: {
                return bilevel || gray8 || pal8 || rgb24;
            }
            case 3: {
                return bilevel;
            }
            case 4: {
                return gray8 || gray16;
            }
            case 82: {
                return hasImage;
            }
            case 5: {
                return rgb24 || rgb48;
            }
            case 6: {
                return pal8;
            }
            case 7: {
                return bilevel || gray8 || pal8 || rgb24;
            }
            case 84: {
                return true;
            }
            case 9: {
                return true;
            }
            case 67: {
                return this.state.canUndo() || this.state.canRedo();
            }
            case 68: {
                return this.state.canUndo();
            }
            case 69: {
                return this.state.canRedo();
            }
            case 10: {
                return hasImage;
            }
            case 11: {
                return !bilevel;
            }
            case 12: {
                return gray8 || gray16 || pal8 || rgb24 || rgb48;
            }
            case 13: {
                return gray8 || gray16 || pal8 || rgb24 || rgb48;
            }
            case 14: {
                return gray8 || gray16 || pal8 || rgb24 || rgb48;
            }
            case 16: {
                return hasImage;
            }
            case 17: {
                return hasImage;
            }
            case 18: {
                return gray8 || pal8 || rgb24 || rgb48;
            }
            case 19: {
                return gray8 || pal8 || rgb24 || rgb48;
            }
            case 70: {
                return gray8;
            }
            case 66: {
                return hasImage;
            }
            case 20: {
                return pal8 || gray8 || bilevel;
            }
            case 21: {
                return pal8 || gray8 || bilevel;
            }
            case 22: {
                return pal8;
            }
            case 23: {
                return pal8;
            }
            case 24: {
                return !rgb48;
            }
            case 26: {
                return bilevel;
            }
            case 27: {
                return bilevel || gray8;
            }
            case 28: {
                return bilevel || gray8 || pal8;
            }
            case 29: {
                return bilevel || gray8 || gray16 || pal8 || rgb24;
            }
            case 25: {
                return bilevel || gray8;
            }
            case 15: {
                return pal8 || rgb24;
            }
            case 30: {
                return !bilevel;
            }
            case 33: {
                return pal8 || rgb;
            }
            case 32: {
                return gray8 || gray16;
            }
            case 31: {
                return gray8 || gray16;
            }
            case 34: {
                return rgb24;
            }
            case 35: {
                return rgb24;
            }
            case 36: {
                return rgb24;
            }
            case 37: {
                return rgb24;
            }
            case 38: {
                return hasImage;
            }
            case 39: {
                return !bilevel;
            }
            case 40: {
                return hasImage;
            }
            case 41: {
                return hasImage;
            }
            case 42: {
                return hasImage;
            }
            case 43: {
                return hasImage;
            }
            case 44: {
                return hasImage;
            }
            case 45: {
                return hasImage;
            }
            case 48: {
                return hasImage;
            }
            case 47: {
                return hasImage;
            }
            case 46: {
                return hasImage;
            }
            case 49: {
                return hasImage && !pal8;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: {
                return gray16 || gray8 || rgb24 || rgb48;
            }
            case 60: 
            case 71: 
            case 72: {
                return gray16 || gray8 || rgb24 || bilevel || rgb48;
            }
            case 73: 
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                return hasImage;
            }
            case 76: {
                return hasImage && !this.state.isZoomOriginalSize();
            }
            case 74: {
                return hasImage && !this.state.isMaximumZoom();
            }
            case 75: {
                return hasImage && !this.state.isMinimumZoom();
            }
            case 63: {
                return true;
            }
            case 64: {
                return true;
            }
            case 65: {
                return true;
            }
        }
        throw new IllegalArgumentException("Not a valid menu index: " + menuIndex);
    }

    public void process(int menuIndex) {
        switch (menuIndex) {
            case 1: {
                this.fileOpen(null);
                break;
            }
            case 83: {
                this.fileSaveAsGif();
                break;
            }
            case 81: {
                this.fileSaveAsPalm();
                break;
            }
            case 3: {
                this.fileSaveAsPbm();
                break;
            }
            case 4: {
                this.fileSaveAsPgm();
                break;
            }
            case 82: {
                this.fileSaveAsPng();
                break;
            }
            case 5: {
                this.fileSaveAsPpm();
                break;
            }
            case 6: {
                this.fileSaveAsRas();
                break;
            }
            case 7: {
                this.fileSaveAsBmp();
                break;
            }
            case 84: {
                this.fileOpen("/resources/images/image1.jpg");
                break;
            }
            case 8: {
                this.fileClose();
                break;
            }
            case 9: {
                this.fileExit();
                break;
            }
            case 68: {
                this.editUndo();
                break;
            }
            case 69: {
                this.editRedo();
                break;
            }
            case 12: {
                this.colorAdjustBrightness();
                break;
            }
            case 13: {
                this.colorAdjustContrast();
                break;
            }
            case 14: {
                this.colorAdjustGamma();
                break;
            }
            case 15: {
                this.colorAdjustHueSaturationValue();
                break;
            }
            case 17: {
                this.colorHistogramCountColorsUsed();
                break;
            }
            case 18: {
                this.colorHistogramEqualize();
                break;
            }
            case 19: {
                this.colorHistogramNormalize();
                break;
            }
            case 70: {
                this.colorHistogramTextureProperties();
                break;
            }
            case 66: {
                this.colorHistogramSaveHistogramAs();
                break;
            }
            case 20: {
                this.colorHistogramSaveCoOccurrenceMatrixAs();
                break;
            }
            case 21: {
                this.colorHistogramSaveCoOccurrenceFrequencyMatrixAs();
                break;
            }
            case 23: {
                this.colorPaletteSaveAs();
                break;
            }
            case 25: {
                this.colorPromotePromoteToPaletted();
                break;
            }
            case 26: {
                this.colorPromotePromoteToGray8();
                break;
            }
            case 27: {
                this.colorPromotePromoteToGray16();
                break;
            }
            case 28: {
                this.colorPromotePromoteToRgb24();
                break;
            }
            case 29: {
                this.colorPromotePromoteToRgb48();
                break;
            }
            case 31: {
                this.colorReduceReduceToBilevelThreshold();
                break;
            }
            case 32: {
                this.colorReduceReduceNumberOfShadesOfGray();
                break;
            }
            case 33: {
                this.colorReduceConvertToGrayscale();
                break;
            }
            case 34: {
                this.colorReduceMedianCut();
                break;
            }
            case 35: {
                this.colorReduceOctree();
                break;
            }
            case 36: {
                this.colorReduceUniformPalette();
                break;
            }
            case 37: {
                this.colorReduceMapToArbitraryPalette();
                break;
            }
            case 38: {
                this.colorInvert();
                break;
            }
            case 39: {
                this.colorConvertToMinimumColorType();
                break;
            }
            case 41: {
                this.transformationsFlip();
                break;
            }
            case 42: {
                this.transformationsMirror();
                break;
            }
            case 43: {
                this.transformationsRotate90Left();
                break;
            }
            case 44: {
                this.transformationsRotate90Right();
                break;
            }
            case 45: {
                this.transformationsRotate180();
                break;
            }
            case 46: {
                this.transformationsCrop();
                break;
            }
            case 47: {
                this.transformationsScale();
                break;
            }
            case 48: {
                this.transformationsShear();
                break;
            }
            case 50: {
                this.filtersBlur();
                break;
            }
            case 51: {
                this.filtersSharpen();
                break;
            }
            case 52: {
                this.filtersEdgeDetection();
                break;
            }
            case 53: {
                this.filtersEmboss();
                break;
            }
            case 54: {
                this.filtersPsychedelicDistillation();
                break;
            }
            case 55: {
                this.filtersLithograph();
                break;
            }
            case 56: {
                this.filtersHorizontalSobel();
                break;
            }
            case 57: {
                this.filtersVerticalSobel();
                break;
            }
            case 58: {
                this.filtersHorizontalPrewitt();
                break;
            }
            case 59: {
                this.filtersVerticalPrewitt();
                break;
            }
            case 71: {
                this.filtersMinimum();
                break;
            }
            case 72: {
                this.filtersMaximum();
                break;
            }
            case 60: {
                this.filtersMedian();
                break;
            }
            case 61: {
                this.filtersMean();
                break;
            }
            case 62: {
                this.filtersOil();
                break;
            }
            case 74: {
                this.viewZoomIn();
                break;
            }
            case 75: {
                this.viewZoomOut();
                break;
            }
            case 76: {
                this.viewSetOriginalSize();
                break;
            }
            case 78: {
                this.viewInterpolationTypeNearestNeighbor();
                break;
            }
            case 79: {
                this.viewInterpolationTypeBilinear();
                break;
            }
            case 80: {
                this.viewInterpolationTypeBicubic();
                break;
            }
            case 64: {
                this.helpAbout();
                break;
            }
            case 65: {
                this.helpSystemInformation();
                break;
            }
        }
    }
}

