/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.codecs;

import java.io.IOException;
import java.io.RandomAccessFile;
import net.sourceforge.jiu.codecs.CodecMode;
import net.sourceforge.jiu.codecs.ImageCodec;
import net.sourceforge.jiu.codecs.InvalidFileStructureException;
import net.sourceforge.jiu.codecs.UnsupportedCodecModeException;
import net.sourceforge.jiu.codecs.UnsupportedTypeException;
import net.sourceforge.jiu.codecs.WrongFileFormatException;
import net.sourceforge.jiu.color.YCbCrIndex;
import net.sourceforge.jiu.color.conversion.PCDYCbCrConversion;
import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.MemoryGray8Image;
import net.sourceforge.jiu.data.MemoryRGB24Image;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.OperationFailedException;
import net.sourceforge.jiu.util.ArrayRotation;
import net.sourceforge.jiu.util.ArrayScaling;

public class PCDCodec
extends ImageCodec
implements YCbCrIndex {
    public static final int PCD_RESOLUTION_1 = 0;
    public static final int PCD_RESOLUTION_2 = 1;
    public static final int PCD_RESOLUTION_3 = 2;
    public static final int PCD_RESOLUTION_4 = 3;
    public static final int PCD_RESOLUTION_5 = 4;
    public static final int PCD_RESOLUTION_6 = 5;
    public static final int PCD_RESOLUTION_DEFAULT = 2;
    public static final int[][] PCD_RESOLUTIONS = new int[][]{{192, 128}, {384, 256}, {768, 512}, {1536, 1024}, {3072, 2048}, {6144, 4096}};
    private static final long[] PCD_FILE_OFFSETS = new long[]{8192L, 47104L, 196608L};
    private static final long[] PCD_BASE_LENGTH = new long[]{8192L, 47104L, 196608L};
    private static final int NO_ROTATION = 0;
    private static final int ROTATE_90_LEFT = 1;
    private static final int ROTATE_180 = 2;
    private static final int ROTATE_90_RIGHT = 3;
    private static final int SECTOR_SIZE = 2048;
    private static final byte[] MAGIC = new byte[]{80, 67, 68, 95, 73, 80, 73};
    private boolean performColorConversion;
    private boolean monochrome;
    private int numChannels;
    private int resolutionIndex;
    private RandomAccessFile in;
    private byte[][] data;

    public PCDCodec() {
        this.setColorConversion(true);
        this.setMonochrome(false);
        this.setResolutionIndex(2);
    }

    private byte[][] allocateMemory() {
        int numPixels = PCD_RESOLUTIONS[this.resolutionIndex][0] * PCD_RESOLUTIONS[this.resolutionIndex][1];
        byte[][] result = new byte[this.numChannels][];
        int i = 0;
        while (i < this.numChannels) {
            result[i] = new byte[numPixels];
            ++i;
        }
        return result;
    }

    private void checkByteArray(byte[][] data, int numPixels) throws IllegalArgumentException {
        int channels;
        if (data == null) {
            throw new IllegalArgumentException("Error: Image channel array is not initialized.");
        }
        if (this.monochrome) {
            channels = 1;
            if (data.length < 1) {
                throw new IllegalArgumentException("Error: Image channel array must have at least one channel for monochrome images.");
            }
        } else {
            channels = 3;
            if (data.length < 3) {
                throw new IllegalArgumentException("Error: Image channel array must have at least three channels for color images.");
            }
        }
        int i = 0;
        while (i < channels) {
            if (data[i].length < numPixels) {
                throw new IllegalArgumentException("Error: Image channel #" + i + " is not large enough (" + numPixels + " entries required, " + data[i].length + " found).");
            }
            ++i;
        }
    }

    private void convertToRgb(int width, int height) {
        byte[] red = new byte[width];
        byte[] green = new byte[width];
        byte[] blue = new byte[width];
        int offset = 0;
        int y = 0;
        while (y < height) {
            PCDYCbCrConversion.convertYccToRgb(this.data[0], this.data[1], this.data[2], offset, red, green, blue, 0, width);
            System.arraycopy(red, 0, this.data[0], offset, width);
            System.arraycopy(green, 0, this.data[1], offset, width);
            System.arraycopy(blue, 0, this.data[2], offset, width);
            offset += width;
            ++y;
        }
    }

    private IntegerImage createImage(int width, int height) {
        if (this.monochrome) {
            MemoryGray8Image image = new MemoryGray8Image(width, height);
            int offset = 0;
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    image.putByteSample(0, x, y, this.data[0][offset++]);
                    ++x;
                }
                ++y;
            }
            return image;
        }
        if (this.performColorConversion) {
            MemoryRGB24Image image = new MemoryRGB24Image(width, height);
            int offset = 0;
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    image.putByteSample(0, x, y, this.data[0][offset]);
                    image.putByteSample(1, x, y, this.data[1][offset]);
                    image.putByteSample(2, x, y, this.data[2][offset]);
                    ++offset;
                    ++x;
                }
                ++y;
            }
            return image;
        }
        return null;
    }

    public String[] getFileExtensions() {
        return new String[]{".pcd"};
    }

    public String getFormatName() {
        return "Kodak Photo-CD (PCD)";
    }

    public String[] getMimeTypes() {
        return new String[]{"image/x-pcd"};
    }

    public boolean isLoadingSupported() {
        return true;
    }

    public boolean isSavingSupported() {
        return false;
    }

    private void load() throws InvalidFileStructureException, IOException, UnsupportedTypeException, WrongFileFormatException {
        if (this.resolutionIndex != 0 && this.resolutionIndex != 1 && this.resolutionIndex != 2) {
            throw new UnsupportedTypeException("Error reading PCD input stream. Only the three lowest resolutions are supported.");
        }
        if (this.in == null) {
            throw new IllegalArgumentException("Input file is missing (use PCDCodec.setInput(RandomAccessFile).");
        }
        if (this.in.length() < 16384L) {
            throw new WrongFileFormatException("Not a PCD file.");
        }
        byte[] sector = new byte[2048];
        this.in.readFully(sector);
        int i = 0;
        while (i < 7) {
            if (sector[i] != -1) {
                throw new WrongFileFormatException("Input is not a valid PCD file (wrong magic byte sequence).");
            }
            ++i;
        }
        this.in.readFully(sector);
        i = 0;
        while (i < MAGIC.length) {
            if (sector[i] != MAGIC[i]) {
                throw new WrongFileFormatException("Input is not a valid PCD file (wrong magic byte sequence).");
            }
            ++i;
        }
        int rotationAngle = sector[1538] & 3;
        int width = PCD_RESOLUTIONS[this.resolutionIndex][0];
        int height = PCD_RESOLUTIONS[this.resolutionIndex][1];
        int realWidth = width;
        int realHeight = height;
        if (rotationAngle == 1 || rotationAngle == 3) {
            realWidth = height;
            realHeight = width;
        }
        if (!this.hasBounds()) {
            this.setBounds(0, 0, realWidth - 1, realHeight - 1);
        }
        int uncompressedResolution = this.resolutionIndex;
        if (this.resolutionIndex > 2) {
            uncompressedResolution = 2;
        }
        this.data = this.allocateMemory();
        this.loadUncompressedImage(uncompressedResolution);
        if (!this.monochrome) {
            ArrayScaling.scaleUp200Percent(this.data[1], PCD_RESOLUTIONS[uncompressedResolution][0] / 2, PCD_RESOLUTIONS[uncompressedResolution][1] / 2);
            ArrayScaling.scaleUp200Percent(this.data[2], PCD_RESOLUTIONS[uncompressedResolution][0] / 2, PCD_RESOLUTIONS[uncompressedResolution][1] / 2);
        }
        if (!this.monochrome && this.performColorConversion) {
            this.convertToRgb(width, height);
        }
        this.rotateArrays(rotationAngle, width, height);
        if (rotationAngle == 1 || rotationAngle == 3) {
            int temp = width;
            width = height;
            height = temp;
        }
        this.setImage(this.createImage(width, height));
    }

    private void loadUncompressedImage(int resolution) throws IllegalArgumentException, IOException {
        if (resolution != 0 && resolution != 1 && resolution != 2) {
            throw new IllegalArgumentException("Error loading PCD image, only the lowest three resolutions are uncompressed.");
        }
        this.in.seek(PCD_FILE_OFFSETS[resolution]);
        int fullWidth = PCD_RESOLUTIONS[resolution][0];
        int fullHeight = PCD_RESOLUTIONS[resolution][1];
        int halfWidth = fullWidth / 2;
        int halfHeight = fullHeight / 2;
        int offset1 = 0;
        int offset2 = 0;
        int y = 0;
        while (y < halfHeight) {
            this.in.readFully(this.data[0], offset1, fullWidth * 2);
            offset1 += fullWidth * 2;
            if (this.monochrome) {
                if (this.in.skipBytes(fullWidth) != fullWidth) {
                    throw new IOException("Could not skip " + fullWidth + " bytes.");
                }
            } else {
                this.in.readFully(this.data[1], offset2, halfWidth);
                this.in.readFully(this.data[2], offset2, halfWidth);
                offset2 += halfWidth;
            }
            ++y;
        }
    }

    public void process() throws InvalidFileStructureException, MissingParameterException, OperationFailedException, UnsupportedTypeException, WrongFileFormatException {
        this.in = this.getRandomAccessFile();
        if (this.in == null) {
            throw new MissingParameterException("RandomAccessFile object needed in PCDCodec.");
        }
        if (this.getMode() != CodecMode.LOAD) {
            throw new UnsupportedTypeException("PCDCodec can only load images.");
        }
        try {
            this.load();
        }
        catch (IOException ioe) {
            throw new OperationFailedException("I/O error: " + ioe.toString());
        }
    }

    private void rotateArrays(int rotationAngle, int width, int height) {
        if (rotationAngle == 0) {
            return;
        }
        int numPixels = width * height;
        int i = 0;
        while (i < this.numChannels) {
            byte[] dest = new byte[numPixels];
            switch (rotationAngle) {
                case 1: {
                    ArrayRotation.rotate90Left(width, height, this.data[i], 0, dest, 0);
                    break;
                }
                case 3: {
                    ArrayRotation.rotate90Right(width, height, this.data[i], 0, dest, 0);
                    break;
                }
                case 2: {
                    ArrayRotation.rotate180(width, height, this.data[i], 0, dest, 0);
                }
            }
            System.arraycopy(dest, 0, this.data[i], 0, numPixels);
            ++i;
        }
    }

    private void scaleUp(int currentResolution) {
        int width = PCD_RESOLUTIONS[currentResolution][0];
        int height = PCD_RESOLUTIONS[currentResolution][1];
        ArrayScaling.scaleUp200Percent(this.data[0], width, height);
        if (!this.monochrome) {
            ArrayScaling.scaleUp200Percent(this.data[1], width, height);
            ArrayScaling.scaleUp200Percent(this.data[2], width, height);
        }
    }

    public void setColorConversion(boolean performColorConversion) {
        this.performColorConversion = performColorConversion;
    }

    public void setFile(String fileName, CodecMode codecMode) throws IOException, UnsupportedCodecModeException {
        if (codecMode != CodecMode.LOAD) {
            throw new UnsupportedCodecModeException("This PCD codec can only load images.");
        }
        this.setRandomAccessFile(new RandomAccessFile(fileName, "r"), CodecMode.LOAD);
    }

    public void setMonochrome(boolean monochrome) {
        this.monochrome = monochrome;
        this.numChannels = monochrome ? 1 : 3;
    }

    public void setResolutionIndex(int resolutionIndex) {
        this.resolutionIndex = resolutionIndex;
    }
}

