/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.codecs.tiff;

import java.io.DataInput;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.sourceforge.jiu.codecs.InvalidFileStructureException;
import net.sourceforge.jiu.codecs.tiff.TIFFDecoder;
import net.sourceforge.jiu.codecs.tiff.TIFFImageFileDirectory;
import net.sourceforge.jiu.ops.MissingParameterException;

public class TIFFDecoderDeflated
extends TIFFDecoder {
    private DataInput in;
    private int compressedSize;

    public void decode() throws InvalidFileStructureException, IOException {
        TIFFImageFileDirectory ifd;
        Inflater inflater = new Inflater();
        byte[] ioBuffer = new byte[20000];
        byte[] data = new byte[this.getBytesPerRow()];
        int numRows = this.getY2();
        if (numRows > (ifd = this.getImageFileDirectory()).getHeight() - 1) {
            numRows = ifd.getHeight() - 1;
        }
        int remainingBytes = (numRows -= this.getY1()) * data.length;
        while (this.compressedSize > 0 || remainingBytes > 0) {
            int numInflated;
            int numBytes;
            if (inflater.needsInput()) {
                numBytes = this.compressedSize > ioBuffer.length ? ioBuffer.length : this.compressedSize;
                this.in.readFully(ioBuffer, 0, numBytes);
                inflater.setInput(ioBuffer, 0, numBytes);
                this.compressedSize -= numBytes;
                continue;
            }
            numBytes = remainingBytes > data.length ? data.length : remainingBytes;
            try {
                numInflated = inflater.inflate(data, 0, numBytes);
            }
            catch (DataFormatException dfe) {
                throw new InvalidFileStructureException("Error in compressed input data: " + dfe.toString());
            }
            if (numInflated <= 0) continue;
            this.putBytes(data, 0, numInflated);
            remainingBytes -= numInflated;
        }
    }

    public Integer[] getCompressionTypes() {
        return new Integer[]{new Integer(32946), new Integer(8)};
    }

    public void initialize() throws IOException, MissingParameterException {
        super.initialize();
        this.in = this.getInput();
        this.compressedSize = this.getImageFileDirectory().getByteCount(this.getTileIndex());
    }
}

