/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.codecs.tiff;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import net.sourceforge.jiu.codecs.InvalidFileStructureException;
import net.sourceforge.jiu.codecs.UnsupportedTypeException;
import net.sourceforge.jiu.codecs.tiff.TIFFConstants;
import net.sourceforge.jiu.codecs.tiff.TIFFRational;
import net.sourceforge.jiu.codecs.tiff.TIFFTag;
import net.sourceforge.jiu.data.Palette;

public class TIFFImageFileDirectory
implements TIFFConstants {
    public static final int TYPE_BILEVEL_PACKED = 0;
    public static final int TYPE_GRAY4 = 1;
    public static final int TYPE_GRAY8 = 2;
    public static final int TYPE_GRAY16 = 3;
    public static final int TYPE_PALETTED4 = 4;
    public static final int TYPE_PALETTED8 = 5;
    public static final int TYPE_RGB24_INTERLEAVED = 6;
    public static final int TYPE_RGB48_INTERLEAVED = 7;
    public static final int TYPE_BILEVEL_BYTE = 8;
    public static final int TYPE_CMYK32_INTERLEAVED = 9;
    public static final int TYPE_CMYK32_PLANAR = 10;
    public static final int TYPE_LOGLUV32_INTERLEAVED = 11;
    public static final int TYPE_LOGL = 12;
    private String artist;
    private int[] bitsPerSample;
    private int bitsPerPixel;
    private int bitsPerRow;
    private int bytesBetweenSamples;
    private int[] bytesPerSample;
    private int bytesPerRow;
    private int compression;
    private String copyright;
    private Date date;
    private String dateTime;
    private int dpiX;
    private int dpiY;
    private int[] extraSamples;
    private int height;
    private int horizontalTiles;
    private String hostComputer;
    private String imageDescription;
    private int imageType;
    private boolean invertGraySamples;
    private String make;
    private String model;
    private int numStrips;
    private int numTiles;
    private int orientation;
    private Palette palette;
    private int pixelsPerRow;
    private int planarConfiguration;
    private int photometricInterpretation;
    private int predictor;
    private int[] sampleTypes;
    private int resolutionUnit;
    private double resolutionX;
    private double resolutionY;
    private int rowsPerStrip;
    private int samplesPerPixel;
    private String software;
    private Vector stripByteCounts;
    private Vector stripOffsets;
    private int t4Options;
    private int t6Options;
    private Vector tags;
    private Vector tileByteCounts;
    private Vector tileOffsets;
    private TimeZone timeZone;
    private int tileWidth;
    private int tileHeight;
    private int totalTiles;
    private int verticalTiles;
    private int width;

    public TIFFImageFileDirectory() {
        this.initMembers();
        this.tags = new Vector();
    }

    public void append(TIFFTag tag) {
        this.tags.addElement(tag);
    }

    private void checkContent() throws InvalidFileStructureException, UnsupportedTypeException {
        if (this.width < 1) {
            throw new InvalidFileStructureException("No valid width available.");
        }
        if (this.height < 1) {
            throw new InvalidFileStructureException("No valid width available.");
        }
        if (this.stripOffsets != null) {
            this.pixelsPerRow = this.width;
        } else if (this.tileOffsets != null) {
            this.pixelsPerRow = this.tileWidth;
        }
        if (this.rowsPerStrip == -1 && this.stripOffsets != null && this.stripOffsets.size() == 1) {
            this.rowsPerStrip = this.height;
        }
        switch (this.photometricInterpretation) {
            case 0: 
            case 1: {
                if (this.bitsPerSample[0] == 1) {
                    this.imageType = 0;
                    break;
                }
                if (this.bitsPerSample[0] == 4) {
                    this.imageType = 1;
                    break;
                }
                if (this.bitsPerSample[0] == 8) {
                    this.imageType = 2;
                    break;
                }
                throw new UnsupportedTypeException("Only bit depths 1, 4 and 8 are supported for bilevel and grayscale images.");
            }
            case 3: {
                if (this.getPalette() != null) break;
                throw new InvalidFileStructureException("No palette found in paletted image.");
            }
            case 2: {
                if (this.planarConfiguration != 1) {
                    throw new UnsupportedTypeException("Cannot handle planar configuration other than chunky for RGB images.");
                }
                if (this.bitsPerSample.length != 3) {
                    throw new UnsupportedTypeException("Found RGB truecolor image, but instead of three " + this.bitsPerSample.length + " component(s).");
                }
                if (this.bitsPerPixel == 24) {
                    this.imageType = 6;
                    break;
                }
                if (this.bitsPerPixel == 48) {
                    this.imageType = 7;
                    break;
                }
                throw new UnsupportedTypeException("Unsupported RGB truecolor image color depth: " + this.bitsPerPixel + ".");
            }
            case 32845: {
                if (this.planarConfiguration == 1) {
                    this.imageType = 11;
                    break;
                }
                throw new UnsupportedTypeException("Cannot handle planar configuration other than chunky for RGB images.");
            }
            case 32844: {
                this.imageType = 12;
                break;
            }
            case 5: {
                if (this.planarConfiguration == 1) {
                    this.imageType = 9;
                    break;
                }
                throw new UnsupportedTypeException("Cannot handle planar configuration other than chunky for CMYK images.");
            }
            default: {
                throw new UnsupportedTypeException("Unsupported color type: " + this.photometricInterpretation + ".");
            }
        }
        if (this.compression == 2) {
            if (this.bitsPerPixel != 1) {
                throw new UnsupportedTypeException("Number of bits per pixel must be 1 for compression type: " + TIFFImageFileDirectory.getCompressionName(this.compression) + ".");
            }
            this.imageType = 8;
        }
    }

    public int computeNumBytes(int numPixels) {
        if (this.bitsPerPixel == 1) {
            if (this.imageType == 8) {
                return numPixels;
            }
            return (numPixels + 7) / 8;
        }
        if (this.bitsPerPixel <= 4) {
            return (numPixels + 1) / 2;
        }
        if (this.bitsPerPixel <= 8) {
            return numPixels;
        }
        if (this.bitsPerPixel == 16) {
            return numPixels * 2;
        }
        if (this.bitsPerPixel == 24) {
            return numPixels * 3;
        }
        if (this.bitsPerPixel == 32) {
            return numPixels * 4;
        }
        if (this.bitsPerPixel == 48) {
            return numPixels * 6;
        }
        return -1;
    }

    public String getArtist() {
        return this.artist;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public int getByteCount(int tileIndex) {
        if (this.stripByteCounts != null) {
            return ((Number)this.stripByteCounts.elementAt(tileIndex)).intValue();
        }
        if (this.tileByteCounts != null) {
            return ((Number)this.tileByteCounts.elementAt(tileIndex)).intValue();
        }
        return 0;
    }

    public int getBytesPerRow() {
        return this.computeNumBytes(this.getTileWidth());
    }

    public int getCompression() {
        return this.compression;
    }

    public static String getCompressionName(int method) {
        switch (method) {
            case 2: {
                return "CCITT Group 3 1D Modified Huffman";
            }
            case 3: {
                return "CCITT T.4";
            }
            case 4: {
                return "CCITT T.6";
            }
            case 32946: {
                return "Deflated (inofficial, 32496)";
            }
            case 8: {
                return "Deflated (official, 8)";
            }
            case 5: {
                return "LZW";
            }
            case 1: {
                return "Uncompressed";
            }
            case 32773: {
                return "Packbits";
            }
            case 6: {
                return "JPEG (old style)";
            }
            case 7: {
                return "JPEG (new style)";
            }
            case 103: {
                return "Pegasus IMJ";
            }
            case 32766: {
                return "NeXT 2-bit RLE";
            }
            case 32771: {
                return "Uncompressed, word-aligned";
            }
            case 32809: {
                return "Thunderscan RLE";
            }
            case 32895: {
                return "IT8 CT with padding";
            }
            case 32896: {
                return "IT8 Linework RLE";
            }
            case 32897: {
                return "IT8 Monochrome picture";
            }
            case 32898: {
                return "IT8 Binary line art";
            }
            case 32908: {
                return "Pixar 10 bit LZW";
            }
            case 32909: {
                return "Pixar 11 bit ZIP";
            }
            case 32947: {
                return "Kodak DCS";
            }
            case 34661: {
                return "ISO JBIG";
            }
            case 34676: {
                return "SGI Log Luminance RLE";
            }
            case 34677: {
                return "SGI Log 24-bit packed";
            }
        }
        return "Unknown method (" + method + ")";
    }

    public String getCopyright() {
        return this.copyright;
    }

    public Date getDateTime() {
        return this.date;
    }

    public String getDateTimeString() {
        return this.dateTime;
    }

    public int getDpiX() {
        return this.dpiX;
    }

    public int getDpiY() {
        return this.dpiY;
    }

    public int getHeight() {
        return this.height;
    }

    public String getHostComputer() {
        return this.hostComputer;
    }

    public String getImageDescription() {
        return this.imageDescription;
    }

    public int getImageType() {
        return this.imageType;
    }

    public String getModel() {
        return this.model;
    }

    public int getNumHorizontalTiles() {
        return this.horizontalTiles;
    }

    public int getNumStrips() {
        return this.numStrips;
    }

    public int getNumTiles() {
        return this.numTiles;
    }

    public int getNumVerticalTiles() {
        return this.verticalTiles;
    }

    public Palette getPalette() {
        return this.palette;
    }

    public int getPhotometricInterpretation() {
        return this.photometricInterpretation;
    }

    public int getPredictor() {
        return this.predictor;
    }

    public int getRowsPerStrip() {
        return this.rowsPerStrip;
    }

    public int getSamplesPerPixel() {
        return this.samplesPerPixel;
    }

    public String getSoftware() {
        return this.software;
    }

    public Vector getStripOffsets() {
        return this.stripOffsets;
    }

    public int getT4Options() {
        return this.t4Options;
    }

    public int getT6Options() {
        return this.t6Options;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public long getTileOffset(int tileIndex) {
        if (this.stripOffsets != null) {
            Number number = (Number)this.stripOffsets.elementAt(tileIndex);
            return number.longValue();
        }
        if (this.tileOffsets != null) {
            Number number = (Number)this.tileOffsets.elementAt(tileIndex);
            return number.longValue();
        }
        throw new IllegalArgumentException("Tile index invalid: " + tileIndex);
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileX1(int tileIndex) {
        if (tileIndex < 0 || tileIndex >= this.getNumTiles()) {
            throw new IllegalArgumentException("Not a valid tile index: " + tileIndex);
        }
        return tileIndex % this.getNumHorizontalTiles() * this.getTileWidth();
    }

    public int getTileX2(int tileIndex) {
        if (tileIndex < 0 || tileIndex >= this.getNumTiles()) {
            throw new IllegalArgumentException("Not a valid tile index: " + tileIndex);
        }
        return (tileIndex % this.getNumHorizontalTiles() + 1) * this.getTileWidth() - 1;
    }

    public int getTileY1(int tileIndex) {
        if (tileIndex < 0 || tileIndex >= this.getNumTiles()) {
            throw new IllegalArgumentException("Not a valid tile index: " + tileIndex);
        }
        return tileIndex % this.getNumVerticalTiles() * this.getTileHeight();
    }

    public int getTileY2(int tileIndex) {
        if (tileIndex < 0 || tileIndex >= this.getNumTiles()) {
            throw new IllegalArgumentException("Not a valid tile index: " + tileIndex);
        }
        int result = (tileIndex % this.getNumVerticalTiles() + 1) * this.getTileHeight() - 1;
        if (result >= this.height) {
            result = this.height - 1;
        }
        return result;
    }

    public int getWidth() {
        return this.width;
    }

    public void initMembers() {
        this.bitsPerPixel = -1;
        this.bitsPerSample = null;
        this.compression = -1;
        this.height = -1;
        this.horizontalTiles = -1;
        this.invertGraySamples = false;
        this.numStrips = -1;
        this.numTiles = -1;
        this.orientation = 1;
        this.photometricInterpretation = -1;
        this.planarConfiguration = -1;
        this.resolutionUnit = 2;
        this.resolutionX = -1.0;
        this.resolutionY = -1.0;
        this.rowsPerStrip = -1;
        this.stripOffsets = null;
        this.tags = null;
        this.tileOffsets = null;
        this.tileWidth = -1;
        this.tileHeight = -1;
        this.totalTiles = -1;
        this.verticalTiles = -1;
        this.width = -1;
    }

    public void initFromTags(boolean check) throws InvalidFileStructureException, UnsupportedTypeException {
        int index = 0;
        block31: while (index < this.tags.size()) {
            TIFFTag tag = (TIFFTag)this.tags.elementAt(index++);
            int id = tag.getId();
            int count = tag.getCount();
            int type = tag.getType();
            boolean isNotInt = !tag.isInt();
            switch (id) {
                case 315: {
                    this.artist = tag.getString();
                    break;
                }
                case 258: {
                    if (isNotInt) {
                        throw new InvalidFileStructureException("Bits per sample value(s) must be byte/short/long; type=" + type);
                    }
                    if (count == 1) {
                        this.bitsPerSample = new int[1];
                        this.bitsPerSample[0] = tag.getOffset();
                        this.bitsPerPixel = this.bitsPerSample[0];
                        break;
                    }
                    this.bitsPerPixel = 0;
                    this.bitsPerSample = new int[count];
                    int i = 0;
                    while (i < count) {
                        this.bitsPerSample[i] = tag.getElementAsInt(i);
                        if (this.bitsPerSample[i] < 1) {
                            throw new InvalidFileStructureException("Bits per sample value #" + i + " is smaller than 1.");
                        }
                        this.bitsPerPixel += this.bitsPerSample[i];
                        ++i;
                    }
                    continue block31;
                }
                case 320: {
                    if (count % 3 != 0) {
                        throw new InvalidFileStructureException("Number of palette entries must be divideable by three without rest; " + count);
                    }
                    if (count < 3 || count > 768) {
                        throw new UnsupportedTypeException("Unsupported number of palette entries: " + count + ".");
                    }
                    if (type != 3) {
                        throw new UnsupportedTypeException("Unsupported number type for palette entries: " + type);
                    }
                    int numEntries = count / 3;
                    this.palette = new Palette(numEntries, 255);
                    int vectorIndex = 0;
                    int paletteIndex = 0;
                    while (paletteIndex < numEntries) {
                        this.palette.putSample(0, paletteIndex, tag.getElementAsInt(vectorIndex++) >> 8);
                        ++paletteIndex;
                    }
                    paletteIndex = 0;
                    while (paletteIndex < numEntries) {
                        this.palette.putSample(1, paletteIndex, tag.getElementAsInt(vectorIndex++) >> 8);
                        ++paletteIndex;
                    }
                    paletteIndex = 0;
                    while (paletteIndex < numEntries) {
                        this.palette.putSample(2, paletteIndex, tag.getElementAsInt(vectorIndex++) >> 8);
                        ++paletteIndex;
                    }
                    continue block31;
                }
                case 259: {
                    if (count != 1 || isNotInt) {
                        throw new InvalidFileStructureException("Expected  single byte/short/long value for compression (count=" + count + ", type=" + type + ").");
                    }
                    this.compression = tag.getOffset();
                    break;
                }
                case 306: {
                    this.dateTime = tag.getString();
                    if (this.dateTime != null) {
                        this.dateTime = this.dateTime.trim();
                    }
                    if (this.dateTime == null) break;
                    SimpleDateFormat format = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
                    if (this.timeZone != null) {
                        format.setCalendar(new GregorianCalendar(this.timeZone));
                    }
                    try {
                        this.date = format.parse(this.dateTime);
                    }
                    catch (ParseException pe) {
                        this.date = null;
                    }
                    continue block31;
                }
                case 316: {
                    this.hostComputer = tag.getString();
                    break;
                }
                case 270: {
                    this.imageDescription = tag.getString();
                    break;
                }
                case 256: {
                    if (count != 1 || isNotInt) {
                        throw new InvalidFileStructureException("Expected single byte/short/long value for image width (count=" + count + ", type=" + type + ").");
                    }
                    this.width = tag.getOffset();
                    break;
                }
                case 257: {
                    if (count != 1 || isNotInt) {
                        throw new InvalidFileStructureException("Expected single byte/short/long value for image height (count=" + count + ", type=" + type + ").");
                    }
                    this.height = tag.getOffset();
                    break;
                }
                case 271: {
                    this.make = tag.getString();
                    break;
                }
                case 272: {
                    this.model = tag.getString();
                    break;
                }
                case 274: {
                    if (count != 1 || isNotInt) {
                        throw new InvalidFileStructureException("Expected single byte/short/long value for image height (count=" + count + ", type=" + type + ").");
                    }
                    this.orientation = tag.getOffset();
                    break;
                }
                case 262: {
                    if (count != 1 || isNotInt) {
                        throw new InvalidFileStructureException("Expected single byte/short/long value for photometric interpretation.");
                    }
                    this.photometricInterpretation = tag.getOffset();
                    break;
                }
                case 296: {
                    if (count != 1 || isNotInt) {
                        throw new InvalidFileStructureException("Expected single byte/short/long value for planar configuration.");
                    }
                    this.resolutionUnit = tag.getOffset();
                    break;
                }
                case 282: {
                    if (count != 1 || type != 5) {
                        throw new InvalidFileStructureException("Expected single byte/short/long value for planar configuration.");
                    }
                    Object o = tag.getObject(0);
                    if (o == null || !(o instanceof TIFFRational)) continue block31;
                    TIFFRational rational = (TIFFRational)o;
                    this.resolutionX = rational.getAsDouble();
                    break;
                }
                case 283: {
                    if (count != 1 || type != 5) {
                        throw new InvalidFileStructureException("Expected single byte/short/long value for planar configuration.");
                    }
                    Object o = tag.getObject(0);
                    if (o == null || !(o instanceof TIFFRational)) continue block31;
                    TIFFRational rational = (TIFFRational)o;
                    this.resolutionY = rational.getAsDouble();
                    break;
                }
                case 284: {
                    if (count != 1 || isNotInt) {
                        throw new InvalidFileStructureException("Expected single byte/short/long value for planar configuration.");
                    }
                    this.planarConfiguration = tag.getOffset();
                    break;
                }
                case 278: {
                    if (count != 1 || isNotInt) {
                        throw new InvalidFileStructureException("Expected single byte/short/long value for image height.");
                    }
                    this.rowsPerStrip = tag.getOffset();
                    break;
                }
                case 277: {
                    if (count != 1 || isNotInt) {
                        throw new InvalidFileStructureException("Expected single byte/short/long value for samples per pixel.");
                    }
                    this.samplesPerPixel = tag.getOffset();
                    break;
                }
                case 305: {
                    this.software = tag.getString();
                    break;
                }
                case 279: {
                    if (count < 1) {
                        throw new InvalidFileStructureException("Need at least one strip offset.");
                    }
                    if (count == 1) {
                        if (isNotInt) {
                            throw new InvalidFileStructureException("There is only one strip offset, but its type is not integer.");
                        }
                        this.stripByteCounts = new Vector();
                        this.stripByteCounts.addElement(new Long(tag.getOffset()));
                        break;
                    }
                    this.stripByteCounts = tag.getVector();
                    break;
                }
                case 273: {
                    if (count < 1) {
                        throw new InvalidFileStructureException("Need at least one strip offset.");
                    }
                    if (count == 1) {
                        if (isNotInt) {
                            throw new InvalidFileStructureException("There is only one strip offset, but its type is not integer.");
                        }
                        this.stripOffsets = new Vector();
                        this.stripOffsets.addElement(new Long(tag.getOffset()));
                    } else {
                        this.stripOffsets = tag.getVector();
                    }
                    this.numStrips = count;
                    this.numTiles = count;
                    this.horizontalTiles = 1;
                    this.verticalTiles = count;
                    break;
                }
                case 292: {
                    if (count != 1 || isNotInt) {
                        throw new InvalidFileStructureException("Expected single byte/short/long value for T4 Options.");
                    }
                    this.t4Options = tag.getOffset();
                    break;
                }
                case 293: {
                    if (count != 1 || isNotInt) {
                        throw new InvalidFileStructureException("Expected single byte/short/long value for T6 Options.");
                    }
                    this.t6Options = tag.getOffset();
                    break;
                }
                case 323: {
                    if (count != 1 || isNotInt) {
                        throw new InvalidFileStructureException("Expected single byte/short/long value for image height (count=" + count + ", type=" + type + ").");
                    }
                    this.tileHeight = tag.getOffset();
                    if (this.tileHeight < 1) {
                        throw new InvalidFileStructureException("Tile height must be one or larger.");
                    }
                    this.verticalTiles = this.height / this.tileHeight;
                    if (this.height % this.tileHeight == 0) break;
                    ++this.verticalTiles;
                    break;
                }
                case 324: {
                    if (count < 1) {
                        throw new InvalidFileStructureException("Need at least one tile offset.");
                    }
                    if (count == 1) {
                        if (isNotInt) {
                            throw new InvalidFileStructureException("There is only one tile offset, but its type is not integer.");
                        }
                        this.tileOffsets = new Vector();
                        this.tileOffsets.addElement(new Long(tag.getOffset()));
                    } else {
                        this.tileOffsets = tag.getVector();
                    }
                    this.numStrips = count;
                    this.numTiles = count;
                    this.horizontalTiles = 1;
                    this.verticalTiles = count;
                    break;
                }
                case 322: {
                    if (count != 1 || isNotInt) {
                        throw new InvalidFileStructureException("Expected single byte/short/long value for image height (count=" + count + ", type=" + type + ").");
                    }
                    this.tileWidth = tag.getOffset();
                    if (this.tileWidth < 1) {
                        throw new InvalidFileStructureException("Tile width must be one or larger.");
                    }
                    this.horizontalTiles = this.width / this.tileWidth;
                    if (this.width % this.tileWidth == 0) break;
                    ++this.horizontalTiles;
                }
            }
        }
        if (this.planarConfiguration == -1) {
            this.planarConfiguration = 1;
        }
        if (this.photometricInterpretation == 3) {
            if (this.bitsPerPixel == 4) {
                this.imageType = 4;
            } else if (this.bitsPerPixel == 8) {
                this.imageType = 5;
            } else {
                throw new UnsupportedTypeException("Only paletted images with 4 or 8 bits per sample are supported.");
            }
        }
        if (this.resolutionUnit == 2 && this.resolutionX > 0.0 && this.resolutionY > 0.0) {
            this.dpiX = (int)this.resolutionX;
            this.dpiY = (int)this.resolutionY;
        }
        if (this.isStriped()) {
            this.tileWidth = this.width;
            if (this.numStrips == 1 && this.rowsPerStrip == -1) {
                this.rowsPerStrip = this.height;
            }
            this.tileHeight = this.rowsPerStrip;
        }
        if (check) {
            this.checkContent();
        }
    }

    public boolean isGrayscale() {
        return this.getBitsPerPixel() > 1 && (this.photometricInterpretation == 1 || this.photometricInterpretation == 0);
    }

    public boolean isPaletted() {
        return this.photometricInterpretation == 3;
    }

    public boolean isStriped() {
        return this.stripOffsets != null;
    }

    public boolean isTiled() {
        return this.tileOffsets != null;
    }

    public void setTimeZone(TimeZone tz) {
        this.timeZone = tz;
    }
}

