/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.adjustment;

import net.sourceforge.jiu.data.Palette;
import net.sourceforge.jiu.data.Paletted8Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.data.RGBIndex;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class HueSaturationValue
extends ImageToImageOperation
implements RGBIndex {
    private float hue;
    private boolean modifyHue;
    private float sMult;
    private boolean sNegative;
    private float vMult;
    private boolean vNegative;

    private final void adjust(int[] orig, int[] adjusted, float maxSample) {
        float h;
        float r = (float)orig[0] / maxSample;
        float g = (float)orig[1] / maxSample;
        float b = (float)orig[2] / maxSample;
        float max = Math.max(Math.max(r, g), b);
        float min = Math.min(Math.min(r, g), b);
        float v = max;
        float s = max != 0.0f ? (max - min) / max : 0.0f;
        if (s == 0.0f) {
            h = Float.NaN;
        } else {
            float delta = max - min;
            h = r == max ? (g - b) / delta : (g == max ? 2.0f + (b - r) / delta : 4.0f + (r - g) / delta);
            if ((h *= 60.0f) < 0.0f) {
                h += 360.0f;
            }
        }
        if (this.modifyHue) {
            h = this.hue;
        }
        s = this.sNegative ? (s *= this.sMult) : (s += (1.0f - s) * this.sMult);
        v = this.vNegative ? (v *= this.vMult) : (v += (1.0f - v) * this.vMult);
        if (s == 0.0f) {
            if (h == Float.NaN) {
                int value;
                adjusted[0] = value = (int)(v * maxSample);
                adjusted[1] = value;
                adjusted[2] = value;
                return;
            }
            return;
        }
        if (h == 360.0f) {
            h = 0.0f;
        }
        int i = (int)Math.floor(h /= 60.0f);
        float f = h - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - s * f);
        float t = v * (1.0f - s * (1.0f - f));
        switch (i) {
            case 0: {
                adjusted[0] = (int)(v * maxSample);
                adjusted[1] = (int)(t * maxSample);
                adjusted[2] = (int)(p * maxSample);
                break;
            }
            case 1: {
                adjusted[0] = (int)(q * maxSample);
                adjusted[1] = (int)(v * maxSample);
                adjusted[2] = (int)(p * maxSample);
                break;
            }
            case 2: {
                adjusted[0] = (int)(p * maxSample);
                adjusted[1] = (int)(v * maxSample);
                adjusted[2] = (int)(t * maxSample);
                break;
            }
            case 3: {
                adjusted[0] = (int)(p * maxSample);
                adjusted[1] = (int)(q * maxSample);
                adjusted[2] = (int)(v * maxSample);
                break;
            }
            case 4: {
                adjusted[0] = (int)(t * maxSample);
                adjusted[1] = (int)(p * maxSample);
                adjusted[2] = (int)(v * maxSample);
                break;
            }
            case 5: {
                adjusted[0] = (int)(v * maxSample);
                adjusted[1] = (int)(p * maxSample);
                adjusted[2] = (int)(q * maxSample);
            }
        }
    }

    private void process(Paletted8Image in, Paletted8Image out) {
        Palette inPal = in.getPalette();
        Palette outPal = out.getPalette();
        int[] orig = new int[3];
        int[] adjusted = new int[3];
        int MAX = inPal.getMaxValue();
        int WIDTH = in.getWidth();
        int HEIGHT = in.getHeight();
        int i = 0;
        while (i < inPal.getNumEntries()) {
            orig[0] = inPal.getSample(0, i);
            orig[1] = inPal.getSample(1, i);
            orig[2] = inPal.getSample(2, i);
            this.adjust(orig, adjusted, MAX);
            outPal.putSample(0, i, adjusted[0]);
            outPal.putSample(1, i, adjusted[1]);
            outPal.putSample(2, i, adjusted[2]);
            ++i;
        }
        int y = 0;
        while (y < HEIGHT) {
            int x = 0;
            while (x < WIDTH) {
                out.putSample(0, x, y, in.getSample(0, x, y));
                ++x;
            }
            this.setProgress(y, HEIGHT);
            ++y;
        }
    }

    private void process(RGB24Image in, RGB24Image out) {
        int MAX = in.getMaxSample(0);
        int WIDTH = in.getWidth();
        int HEIGHT = in.getHeight();
        int[] orig = new int[3];
        int[] adjusted = new int[3];
        int y = 0;
        while (y < HEIGHT) {
            int x = 0;
            while (x < WIDTH) {
                orig[0] = in.getSample(0, x, y);
                orig[1] = in.getSample(1, x, y);
                orig[2] = in.getSample(2, x, y);
                this.adjust(orig, adjusted, MAX);
                out.putSample(0, x, y, adjusted[0]);
                out.putSample(1, x, y, adjusted[1]);
                out.putSample(2, x, y, adjusted[2]);
                ++x;
            }
            this.setProgress(y, HEIGHT);
            ++y;
        }
    }

    public void process() throws MissingParameterException, WrongParameterException {
        PixelImage in = this.getInputImage();
        if (in == null) {
            throw new MissingParameterException("Input image missing.");
        }
        PixelImage out = this.getOutputImage();
        if (out == null) {
            out = in.createCompatibleImage(in.getWidth(), in.getHeight());
            this.setOutputImage(out);
        }
        if (in instanceof RGB24Image) {
            this.process((RGB24Image)in, (RGB24Image)out);
        } else if (in instanceof Paletted8Image) {
            this.process((Paletted8Image)in, (Paletted8Image)out);
        } else {
            throw new WrongParameterException("Input image type not supported.");
        }
    }

    public void setHueSaturationValue(int hue, int saturation, int value) {
        if (hue < 0 || hue >= 360) {
            throw new IllegalArgumentException("Hue must be from 0..359; got " + hue);
        }
        this.modifyHue = true;
        this.hue = hue;
        this.setSv(saturation, value);
    }

    public void setSaturationValue(int saturation, int value) {
        this.modifyHue = false;
        this.setSv(saturation, value);
    }

    private void setSv(int saturation, int value) {
        if (saturation < -100 || saturation > 100) {
            throw new IllegalArgumentException("Saturation must be from -100..100; got " + saturation);
        }
        boolean bl = this.sNegative = saturation < 0;
        this.sMult = this.sNegative ? (100.0f + (float)saturation) / 100.0f : (saturation > 0 ? (float)saturation / 100.0f : 0.0f);
        if (value < -100 || value > 100) {
            throw new IllegalArgumentException("Saturation must be from -100..100; got " + value);
        }
        boolean bl2 = this.vNegative = value < 0;
        this.vMult = this.vNegative ? (100.0f + (float)value) / 100.0f : (value > 0 ? (float)value / 100.0f : 0.0f);
    }
}

