/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.adjustment;

import net.sourceforge.jiu.color.analysis.Histogram1DCreator;
import net.sourceforge.jiu.color.data.Histogram1D;
import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.ops.LookupTableOperation;
import net.sourceforge.jiu.ops.OperationFailedException;

public class NormalizeHistogram
extends LookupTableOperation {
    public NormalizeHistogram(IntegerImage in) throws OperationFailedException {
        super(in.getNumChannels());
        this.setInputImage(in);
        this.initTables(in);
    }

    private void initTables(IntegerImage in) throws OperationFailedException {
        int channelIndex = 0;
        while (channelIndex < in.getNumChannels()) {
            int maxSample;
            Histogram1DCreator hc = new Histogram1DCreator();
            hc.setImage(in, channelIndex);
            hc.process();
            Histogram1D hist = hc.getHistogram();
            int min = 0;
            while (hist.getEntry(min) == 0) {
                ++min;
            }
            int max = maxSample = in.getMaxSample(channelIndex);
            while (hist.getEntry(max) == 0) {
                --max;
            }
            int[] data = new int[maxSample + 1];
            int usedInterval = max - min + 1;
            int i = 0;
            while (i < data.length) {
                data[i] = min + usedInterval * i / data.length;
                ++i;
            }
            this.setTable(channelIndex, data);
            ++channelIndex;
        }
    }
}

