/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.data;

import net.sourceforge.jiu.color.data.BaseCoOccurrenceFrequencyMatrix;

public class MemoryCoOccurrenceFrequencyMatrix
extends BaseCoOccurrenceFrequencyMatrix {
    private final int dimension;
    private int numValues;
    private double[] data;

    public MemoryCoOccurrenceFrequencyMatrix(int dimension) {
        if (dimension < 1) {
            throw new IllegalArgumentException("Dimension of co-occurrence frequency matrix must be >= 1.");
        }
        this.dimension = dimension;
        this.numValues = dimension * dimension;
        this.data = new double[this.numValues];
    }

    public void clear() {
        if (this.data == null) {
            return;
        }
        int i = 0;
        while (i < this.numValues) {
            this.data[i] = 0.0;
            ++i;
        }
    }

    public int getDimension() {
        return this.dimension;
    }

    public double getValue(int i) throws IllegalArgumentException {
        return this.getValue(i, i);
    }

    public double getValue(int i, int j) throws IllegalArgumentException {
        if (i < 0 || i >= this.dimension || j < 0 || j >= this.dimension) {
            throw new IllegalArgumentException("i/j arguments out of bounds: " + i + "/" + j);
        }
        return this.data[j * this.dimension + i];
    }

    public void setValue(int i, int j, double newValue) throws IllegalArgumentException {
        if (i < 0 || i >= this.dimension || j < 0 || j >= this.dimension) {
            throw new IllegalArgumentException("i/j coordinate out of bounds: " + i + "/" + j);
        }
        this.data[j * this.dimension + i] = newValue;
    }
}

