/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.quantization;

import net.sourceforge.jiu.color.quantization.RGBColor;
import net.sourceforge.jiu.data.RGBIndex;

public class MedianCutNode
implements RGBIndex {
    private int axis;
    private boolean axisDetermined;
    private int diff;
    private int index1;
    private int index2;
    private MedianCutNode leftSuccessor;
    private int[] max;
    private int medianValue;
    private int middleIndex;
    private int[] min;
    private int paletteIndex;
    private MedianCutNode parent;
    private int[] reprColor;
    private MedianCutNode rightSuccessor;

    public MedianCutNode(MedianCutNode parent, int index1, int index2) {
        if (index1 > index2) {
            throw new IllegalArgumentException("MedianCutNode constructor, index1 must be smaller than or equal to index2.");
        }
        this.parent = parent;
        this.index1 = index1;
        this.index2 = index2;
        this.determineMiddleIndex();
        this.leftSuccessor = null;
        this.rightSuccessor = null;
        this.diff = 0;
        this.axisDetermined = false;
        this.max = new int[3];
        this.min = new int[3];
        this.paletteIndex = -1;
    }

    public boolean canBeSplit() {
        return this.isLeaf() && this.index1 != this.index2;
    }

    public double computeRgbDistance(MedianCutNode node) {
        int[] c = node.reprColor;
        return RGBColor.computeDistance(this.reprColor[0], this.reprColor[1], this.reprColor[2], c[0], c[1], c[2]);
    }

    private void determineMiddleIndex() {
        this.middleIndex = this.index1 == this.index2 ? this.index1 : (this.index1 + this.index2) / 2;
    }

    public int getAxisOfLargestDistribution() {
        if (this.axisDetermined) {
            return this.axis;
        }
        throw new IllegalArgumentException("The axis has not been determined and can thus not be returned.");
    }

    public int getDifferenceOfLargestDistribution() {
        if (this.axisDetermined) {
            return this.diff;
        }
        throw new IllegalArgumentException("The axis has not been determined and can thus not be returned.");
    }

    public int getLeftIndex() {
        return this.index1;
    }

    public MedianCutNode getLeftSuccessor() {
        return this.leftSuccessor;
    }

    public int getMaxColorSample(int index) {
        return this.max[index];
    }

    public int getMedianValue() {
        return this.medianValue;
    }

    public int getMiddleIndex() {
        return this.middleIndex;
    }

    public int getMinColorSample(int index) {
        return this.min[index];
    }

    public int getNumColors() {
        return this.index2 - this.index1 + 1;
    }

    public int getPaletteIndex() {
        return this.paletteIndex;
    }

    public MedianCutNode getParentNode() {
        return this.parent;
    }

    public int[] getRepresentativeColor() {
        return this.reprColor;
    }

    public int getRightIndex() {
        return this.index2;
    }

    public MedianCutNode getRightSuccessor() {
        return this.rightSuccessor;
    }

    public MedianCutNode getSuccessor(int[] rgb) {
        if (rgb[this.axis] <= this.medianValue) {
            return this.leftSuccessor;
        }
        return this.rightSuccessor;
    }

    public boolean isAxisDetermined() {
        return this.axisDetermined;
    }

    public boolean isLeaf() {
        return this.leftSuccessor == null && this.rightSuccessor == null;
    }

    public void setLargestDistribution(int newAxis, int newDifference) {
        if (newAxis != 0 && newAxis != 1 && newAxis != 2) {
            throw new IllegalArgumentException("Axis must be either INDEX_RED, INDEX_GREEN or INDEX_BLUE.");
        }
        this.axis = newAxis;
        this.diff = newDifference;
        this.axisDetermined = true;
    }

    public void setMaxColor(int red, int green, int blue) {
        this.max[0] = red;
        this.max[1] = green;
        this.max[2] = blue;
    }

    public void setMaxColorSample(int index, int value) {
        this.max[index] = value;
    }

    public void setMedianValue(int newMedianValue) {
        this.medianValue = newMedianValue;
    }

    public void setMinColor(int red, int green, int blue) {
        this.min[0] = red;
        this.min[1] = green;
        this.min[2] = blue;
    }

    public void setMinColorSample(int index, int value) {
        this.min[index] = value;
    }

    public void setPaletteIndex(int newPaletteIndex) {
        this.paletteIndex = newPaletteIndex;
    }

    public void setRepresentativeColor(int[] aRepresentativeColor) {
        if (aRepresentativeColor != null && aRepresentativeColor.length != 3) {
            throw new IllegalArgumentException("Representative color array argument must have a length of 3.");
        }
        this.reprColor = aRepresentativeColor;
    }

    public void setSuccessors(MedianCutNode left, MedianCutNode right) {
        if (left == null && right != null || left != null && right == null) {
            throw new IllegalArgumentException("The successor nodes must be either both null or both initialized\t.");
        }
        if (left != null && left == right) {
            throw new IllegalArgumentException("The successor nodes must not be the same.");
        }
        this.leftSuccessor = left;
        this.rightSuccessor = right;
    }
}

