/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.reduction;

import net.sourceforge.jiu.color.data.Histogram3D;
import net.sourceforge.jiu.color.data.OnDemandHistogram3D;
import net.sourceforge.jiu.data.Gray16Image;
import net.sourceforge.jiu.data.Gray8Image;
import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.MemoryBilevelImage;
import net.sourceforge.jiu.data.MemoryGray8Image;
import net.sourceforge.jiu.data.MemoryPaletted8Image;
import net.sourceforge.jiu.data.MemoryRGB24Image;
import net.sourceforge.jiu.data.Palette;
import net.sourceforge.jiu.data.Paletted8Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.data.RGB48Image;
import net.sourceforge.jiu.data.RGBIntegerImage;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.Operation;
import net.sourceforge.jiu.ops.WrongParameterException;

public class AutoDetectColorType
extends Operation {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_BILEVEL = 0;
    public static final int TYPE_GRAY16 = 4;
    public static final int TYPE_GRAY8 = 1;
    public static final int TYPE_PALETTED8 = 2;
    public static final int TYPE_RGB24 = 3;
    public static final int TYPE_RGB48 = 5;
    private PixelImage inputImage;
    private PixelImage outputImage;
    private boolean doConvert = true;
    private int type = -1;
    private Histogram3D hist;

    private void createBilevelFromGrayOrRgb(IntegerImage in) {
        MemoryBilevelImage out = new MemoryBilevelImage(in.getWidth(), in.getHeight());
        out.clear(0);
        int y = 0;
        while (y < in.getHeight()) {
            int x = 0;
            while (x < in.getWidth()) {
                if (in.getSample(0, x, y) != 0) {
                    out.putWhite(x, y);
                }
                ++x;
            }
            this.setProgress(y, in.getHeight());
            ++y;
        }
        this.outputImage = out;
    }

    private void createBilevelFromPaletted(Paletted8Image in) {
        Palette palette = in.getPalette();
        MemoryBilevelImage out = new MemoryBilevelImage(in.getWidth(), in.getHeight());
        out.clear(0);
        int y = 0;
        while (y < in.getHeight()) {
            int x = 0;
            while (x < in.getWidth()) {
                if (palette.getSample(0, in.getSample(0, x, y)) != 0) {
                    out.putWhite(x, y);
                }
                ++x;
            }
            this.setProgress(y, in.getHeight());
            ++y;
        }
        this.outputImage = out;
    }

    private void createGrayFromRgb(IntegerImage in, IntegerImage out) {
        int y = 0;
        while (y < in.getHeight()) {
            int x = 0;
            while (x < in.getWidth()) {
                out.putSample(0, x, y, in.getSample(0, x, y));
                ++x;
            }
            this.setProgress(y, in.getHeight());
            ++y;
        }
        this.outputImage = out;
    }

    private void createGray8FromGray16(Gray16Image in) {
        MemoryGray8Image out = new MemoryGray8Image(in.getWidth(), in.getHeight());
        int y = 0;
        while (y < in.getHeight()) {
            int x = 0;
            while (x < in.getWidth()) {
                out.putSample(0, x, y, in.getSample(0, x, y) & 0xFF);
                ++x;
            }
            this.setProgress(y, in.getHeight());
            ++y;
        }
        this.outputImage = out;
    }

    private void createGray8FromPaletted8(Paletted8Image in, Gray8Image out) {
        Palette palette = in.getPalette();
        int y = 0;
        while (y < in.getHeight()) {
            int x = 0;
            while (x < in.getWidth()) {
                out.putSample(0, x, y, palette.getSample(0, in.getSample(0, x, y)));
                ++x;
            }
            this.setProgress(y, in.getHeight());
            ++y;
        }
        this.outputImage = out;
    }

    private void createPaletted8FromRgb24(RGB24Image in) {
        int uniqueColors = this.hist.getNumUsedEntries();
        Palette palette = new Palette(uniqueColors, 255);
        int index = 0;
        int r = 0;
        while (r < 256) {
            int g = 0;
            while (g < 256) {
                int b = 0;
                while (b < 256) {
                    if (this.hist.getEntry(r, g, b) != 0) {
                        this.hist.setEntry(r, g, b, index);
                        palette.putSample(0, index, r);
                        palette.putSample(1, index, g);
                        palette.putSample(2, index, b);
                        ++index;
                    }
                    ++b;
                }
                ++g;
            }
            ++r;
        }
        MemoryPaletted8Image out = new MemoryPaletted8Image(in.getWidth(), in.getHeight(), palette);
        int y = 0;
        while (y < in.getHeight()) {
            int x = 0;
            while (x < in.getWidth()) {
                int red = in.getSample(0, x, y);
                int green = in.getSample(1, x, y);
                int blue = in.getSample(2, x, y);
                out.putSample(0, x, y, this.hist.getEntry(red, green, blue));
                ++x;
            }
            this.setProgress(y, in.getHeight());
            ++y;
        }
        this.outputImage = out;
    }

    private void createPaletted8FromRgb48(RGB48Image in) {
        int uniqueColors = this.hist.getNumUsedEntries();
        Palette palette = new Palette(uniqueColors, 255);
        int index = 0;
        int r = 0;
        while (r < 256) {
            int g = 0;
            while (g < 256) {
                int b = 0;
                while (b < 256) {
                    if (this.hist.getEntry(r, g, b) != 0) {
                        this.hist.setEntry(r, g, b, index);
                        palette.putSample(0, index, r);
                        palette.putSample(1, index, g);
                        palette.putSample(2, index, b);
                        ++index;
                    }
                    ++b;
                }
                ++g;
            }
            ++r;
        }
        MemoryPaletted8Image out = new MemoryPaletted8Image(in.getWidth(), in.getHeight(), palette);
        int y = 0;
        while (y < in.getHeight()) {
            int x = 0;
            while (x < in.getWidth()) {
                int red = in.getSample(0, x, y) >> 8;
                int green = in.getSample(1, x, y) >> 8;
                int blue = in.getSample(2, x, y) >> 8;
                out.putSample(0, x, y, this.hist.getEntry(red, green, blue));
                ++x;
            }
            this.setProgress(y, in.getHeight());
            ++y;
        }
        this.outputImage = out;
    }

    private void createRgb24FromRgb48(RGB48Image in, RGB24Image out) {
        int y = 0;
        while (y < in.getHeight()) {
            int x = 0;
            while (x < in.getWidth()) {
                out.putSample(0, x, y, in.getSample(0, x, y) >> 8);
                out.putSample(1, x, y, in.getSample(1, x, y) >> 8);
                out.putSample(2, x, y, in.getSample(2, x, y) >> 8);
                ++x;
            }
            this.setProgress(y, in.getHeight());
            ++y;
        }
        this.outputImage = out;
    }

    public PixelImage getOutputImage() {
        return this.outputImage;
    }

    public int getType() {
        return this.type;
    }

    public boolean isReducible() {
        return this.type != -1;
    }

    private boolean isGrayBilevel(IntegerImage in) {
        int HEIGHT = in.getHeight();
        int MAX = in.getMaxSample(0);
        int y = 0;
        while (y < HEIGHT) {
            int x = 0;
            while (x < in.getWidth()) {
                int value = in.getSample(0, x, y);
                if (value != 0 && value != MAX) {
                    return false;
                }
                ++x;
            }
            ++y;
        }
        return true;
    }

    private boolean isGray16Gray8(Gray16Image in) {
        int HEIGHT = in.getHeight();
        int MAX = in.getMaxSample(0);
        int y = 0;
        while (y < HEIGHT) {
            int x = 0;
            while (x < in.getWidth()) {
                int msb;
                int value = in.getSample(0, x, y);
                int lsb = value & 0xFF;
                if (lsb != (msb = value >> 8 & 0xFF)) {
                    return false;
                }
                ++x;
            }
            ++y;
        }
        return true;
    }

    private boolean isRgb48Gray8(RGB48Image in) {
        int HEIGHT = in.getHeight();
        int y = 0;
        while (y < HEIGHT) {
            int x = 0;
            while (x < in.getWidth()) {
                int red = in.getSample(0, x, y);
                int green = in.getSample(1, x, y);
                int blue = in.getSample(2, x, y);
                if (red != green || green != blue) {
                    return false;
                }
                int lsb = red & 0xFF;
                int msb = red >> 8;
                if (lsb != msb) {
                    return false;
                }
                ++x;
            }
            ++y;
        }
        return true;
    }

    private boolean isRgb48Paletted8(RGB48Image in) {
        int uniqueColors = 0;
        this.hist = new OnDemandHistogram3D(255);
        int y = 0;
        while (y < in.getHeight()) {
            int x = 0;
            while (x < in.getWidth()) {
                int blue;
                int green;
                int red = in.getSample(0, x, y) >> 8;
                if (this.hist.getEntry(red, green = in.getSample(1, x, y) >> 8, blue = in.getSample(2, x, y) >> 8) == 0) {
                    this.hist.increaseEntry(red, green, blue);
                    if (++uniqueColors > 256) {
                        return false;
                    }
                }
                ++x;
            }
            ++y;
        }
        return true;
    }

    private boolean isRgb48Rgb24(RGB48Image in) {
        int HEIGHT = in.getHeight();
        int y = 0;
        while (y < HEIGHT) {
            int x = 0;
            while (x < in.getWidth()) {
                int channel = 0;
                while (channel < 3) {
                    int sample = in.getSample(channel, x, y);
                    if ((sample & 0xFF) != (sample & 0xFF00) >> 8) {
                        return false;
                    }
                    ++channel;
                }
                ++x;
            }
            ++y;
        }
        return true;
    }

    private boolean isRgbBilevel(IntegerImage in) {
        int HEIGHT = in.getHeight();
        int MAX = in.getMaxSample(0);
        int y = 0;
        while (y < HEIGHT) {
            int x = 0;
            while (x < in.getWidth()) {
                int red = in.getSample(0, x, y);
                int green = in.getSample(1, x, y);
                int blue = in.getSample(2, x, y);
                if (red != green || green != blue || blue != 0 && blue != MAX) {
                    return false;
                }
                ++x;
            }
            ++y;
        }
        return true;
    }

    private boolean isRgbGray(RGBIntegerImage in) {
        int HEIGHT = in.getHeight();
        int y = 0;
        while (y < HEIGHT) {
            int x = 0;
            while (x < in.getWidth()) {
                int red = in.getSample(0, x, y);
                int green = in.getSample(1, x, y);
                int blue = in.getSample(2, x, y);
                if (red != green || green != blue) {
                    return false;
                }
                ++x;
            }
            ++y;
        }
        return true;
    }

    private boolean isRgb24Paletted8(RGB24Image in) {
        int uniqueColors = 0;
        this.hist = new OnDemandHistogram3D(255);
        int y = 0;
        while (y < in.getHeight()) {
            int x = 0;
            while (x < in.getWidth()) {
                int blue;
                int green;
                int red = in.getSample(0, x, y);
                if (this.hist.getEntry(red, green = in.getSample(1, x, y), blue = in.getSample(2, x, y)) == 0) {
                    this.hist.increaseEntry(red, green, blue);
                    if (++uniqueColors > 256) {
                        return false;
                    }
                }
                ++x;
            }
            ++y;
        }
        return true;
    }

    public void process() throws MissingParameterException, WrongParameterException {
        if (this.inputImage == null) {
            throw new MissingParameterException("No input image available");
        }
        if (this.inputImage instanceof Gray8Image) {
            if (this.isGrayBilevel((Gray8Image)this.inputImage)) {
                this.type = 0;
                if (this.doConvert) {
                    this.createBilevelFromGrayOrRgb((Gray8Image)this.inputImage);
                }
            }
        } else if (this.inputImage instanceof Gray16Image) {
            if (this.isGrayBilevel((Gray16Image)this.inputImage)) {
                this.type = 0;
                if (this.doConvert) {
                    this.createBilevelFromGrayOrRgb((Gray16Image)this.inputImage);
                }
            } else if (this.isGray16Gray8((Gray16Image)this.inputImage)) {
                this.type = 4;
                if (this.doConvert) {
                    this.createGray8FromGray16((Gray16Image)this.inputImage);
                }
            }
        } else if (this.inputImage instanceof RGB24Image) {
            if (this.isRgbBilevel((RGB24Image)this.inputImage)) {
                this.type = 0;
                if (this.doConvert) {
                    this.createBilevelFromGrayOrRgb((RGB24Image)this.inputImage);
                }
            } else if (this.isRgbGray((RGB24Image)this.inputImage)) {
                this.type = 1;
                if (this.doConvert) {
                    this.outputImage = new MemoryGray8Image(this.inputImage.getWidth(), this.inputImage.getHeight());
                    this.createGrayFromRgb((RGB24Image)this.inputImage, (Gray8Image)this.outputImage);
                }
            } else if (this.isRgb24Paletted8((RGB24Image)this.inputImage)) {
                this.type = 2;
                if (this.doConvert) {
                    this.createPaletted8FromRgb24((RGB24Image)this.inputImage);
                }
            }
        } else if (this.inputImage instanceof RGB48Image) {
            if (this.isRgbBilevel((RGB48Image)this.inputImage)) {
                this.type = 0;
                if (this.doConvert) {
                    this.createBilevelFromGrayOrRgb((RGB48Image)this.inputImage);
                }
            } else if (this.isRgb48Gray8((RGB48Image)this.inputImage)) {
                this.type = 1;
                if (this.doConvert) {
                    this.outputImage = new MemoryGray8Image(this.inputImage.getWidth(), this.inputImage.getHeight());
                    this.createGrayFromRgb((RGB48Image)this.inputImage, (Gray8Image)this.outputImage);
                }
            } else if (this.isRgbGray((RGB48Image)this.inputImage)) {
                this.type = 4;
                if (this.doConvert) {
                    this.outputImage = new MemoryGray8Image(this.inputImage.getWidth(), this.inputImage.getHeight());
                    this.createGrayFromRgb((RGB24Image)this.inputImage, (Gray8Image)this.outputImage);
                }
            } else if (this.isRgb48Rgb24((RGB48Image)this.inputImage)) {
                if (this.isRgb48Paletted8((RGB48Image)this.inputImage)) {
                    this.type = 2;
                    if (this.doConvert) {
                        this.createPaletted8FromRgb48((RGB48Image)this.inputImage);
                    }
                } else {
                    this.type = 3;
                    if (this.doConvert) {
                        this.outputImage = new MemoryRGB24Image(this.inputImage.getWidth(), this.inputImage.getHeight());
                        this.createRgb24FromRgb48((RGB48Image)this.inputImage, (RGB24Image)this.outputImage);
                    }
                }
            }
        } else if (this.inputImage instanceof Paletted8Image) {
            Paletted8Image in = (Paletted8Image)this.inputImage;
            Palette palette = in.getPalette();
            if (palette.isBlackAndWhite()) {
                this.type = 0;
                if (this.doConvert) {
                    this.createBilevelFromPaletted(in);
                }
            } else if (palette.isGray()) {
                this.type = 1;
                if (this.doConvert) {
                    MemoryGray8Image out = new MemoryGray8Image(in.getWidth(), in.getHeight());
                    this.createGray8FromPaletted8(in, out);
                }
            }
        } else {
            throw new WrongParameterException("Not a supported or reducible image type: " + this.inputImage.toString());
        }
    }

    public void setConversion(boolean convert) {
        this.doConvert = convert;
    }

    public void setInputImage(PixelImage image) {
        this.inputImage = image;
    }
}

