/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.filters;

import net.sourceforge.jiu.data.IntegerImage;

public abstract class BorderSampleGenerator {
    private int areaWidth;
    private int areaHeight;
    private int channelIndex;
    private IntegerImage image;

    public BorderSampleGenerator(IntegerImage integerImage, int areaWidth, int areaHeight) {
        this.image = integerImage;
        if (this.image == null) {
            throw new IllegalArgumentException("The image argument must be non-null.");
        }
        this.areaWidth = areaWidth;
        if (areaWidth < 1 || areaWidth % 2 == 0) {
            throw new IllegalArgumentException("Area width must be a positive odd number.");
        }
        this.areaHeight = areaHeight;
        if (areaHeight < 1 || areaHeight % 2 == 0) {
            throw new IllegalArgumentException("Area height must be a positive odd number.");
        }
    }

    public abstract void fill(int var1, int var2, int[] var3);

    public int getAreaHeight() {
        return this.areaHeight;
    }

    public int getAreaWidth() {
        return this.areaWidth;
    }

    public int getChannelIndex() {
        return this.channelIndex;
    }

    public IntegerImage getImage() {
        return this.image;
    }

    public void setChannelIndex(int newChannelIndex) {
        if (newChannelIndex < 0 || newChannelIndex >= this.image.getNumChannels()) {
            throw new IllegalArgumentException("Illegal channel index: " + newChannelIndex + " (must be from 0 to " + (this.image.getNumChannels() - 1) + ").");
        }
        this.channelIndex = newChannelIndex;
    }
}

