/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.ops;

import java.io.File;
import java.util.Vector;
import net.sourceforge.jiu.ops.DirectoryTree;
import net.sourceforge.jiu.ops.Operation;

public abstract class BatchProcessorOperation
extends Operation {
    private boolean collectErrors;
    private Vector directoryTrees = new Vector();
    private Vector errorMessages = new Vector();
    private Vector inputFileNames = new Vector();
    private String outputDirectory;
    private boolean overwrite;

    public void addDirectoryTree(String rootDirectoryName) {
        this.addDirectoryTree(rootDirectoryName, null);
    }

    public void addDirectoryTree(String rootDirectoryName, String outputRootDirectoryName) {
        DirectoryTree tree = new DirectoryTree();
        tree.input = rootDirectoryName;
        tree.output = outputRootDirectoryName;
        this.directoryTrees.addElement(tree);
    }

    public void addInputFileName(String fileName) {
        this.inputFileNames.addElement(fileName);
    }

    public void addInputFileNames(Vector fileNameList) {
        int index = 0;
        while (index < fileNameList.size()) {
            String fileName = (String)fileNameList.elementAt(index++);
            this.inputFileNames.addElement(fileName);
        }
    }

    public Vector getErrorMessages() {
        return this.errorMessages;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public void process() {
        int index = 0;
        while (index < this.directoryTrees.size()) {
            DirectoryTree tree = (DirectoryTree)this.directoryTrees.elementAt(index++);
            String output = tree.output;
            if (output == null) {
                output = this.outputDirectory;
            }
            this.processDirectoryTree(tree.input, output);
        }
        index = 0;
        while (index < this.inputFileNames.size()) {
            String fileName;
            File file;
            if (!(file = new File(fileName = (String)this.inputFileNames.elementAt(index++))).isFile() && this.collectErrors) {
                this.errorMessages.addElement("Cannot process \"" + fileName + "\" (not a file).");
            }
            String inDir = file.getParent();
            String outDir = this.outputDirectory;
            if (outDir == null) {
                outDir = inDir;
            }
            this.processFile(inDir, file.getName(), outDir);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processDirectoryTree(String fromDir, String toDir) {
        fromDirFile = new File(fromDir);
        entries = fromDirFile.list();
        i = 0;
        while (i < entries.length) {
            block6: {
                block7: {
                    block5: {
                        name = entries[i];
                        entry = new File(fromDir, name);
                        if (!entry.isFile()) break block5;
                        this.processFile(fromDir, name, toDir);
                        break block6;
                    }
                    if (!entry.isDirectory()) break block6;
                    inSubDir = new File(fromDir, name);
                    outSubDir = new File(toDir, name);
                    if (!outSubDir.exists()) break block7;
                    if (!outSubDir.isFile()) ** GOTO lbl-1000
                    if (this.collectErrors) {
                        this.errorMessages.addElement("Cannot create output directory \"" + outSubDir.getAbsolutePath() + "\" because a file of that name already exists.");
                    }
                    break block6;
                }
                if (!outSubDir.mkdir()) {
                    if (this.collectErrors) {
                        this.errorMessages.addElement("Could not create output directory \"" + outSubDir.getAbsolutePath() + "\".");
                    }
                } else lbl-1000:
                // 2 sources

                {
                    this.processDirectoryTree(inSubDir.getAbsolutePath(), outSubDir.getAbsolutePath());
                }
            }
            ++i;
        }
    }

    public abstract void processFile(String var1, String var2, String var3);

    public void setCollectErrorMessages(boolean collectErrorMessages) {
        this.collectErrors = collectErrorMessages;
    }

    public void setOutputDirectory(String outputDirectoryName) {
        this.outputDirectory = outputDirectoryName;
    }

    public void setOverwrite(boolean newValue) {
        this.overwrite = newValue;
    }
}

