/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.ops;

import java.util.Vector;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.OperationFailedException;
import net.sourceforge.jiu.ops.ProgressListener;
import net.sourceforge.jiu.ops.WrongParameterException;

public abstract class Operation {
    private boolean abort = false;
    private Vector progressListeners = new Vector();

    public void addProgressListener(ProgressListener progressListener) {
        if (progressListener == null) {
            return;
        }
        if (!this.progressListeners.contains(progressListener)) {
            this.progressListeners.addElement(progressListener);
        }
    }

    public void addProgressListeners(Vector progressListeners) {
        if (progressListeners != null) {
            int index = 0;
            while (index < progressListeners.size()) {
                ProgressListener listener = (ProgressListener)progressListeners.elementAt(index++);
                this.addProgressListener(listener);
            }
        }
    }

    public boolean getAbort() {
        return this.abort;
    }

    public void process() throws MissingParameterException, OperationFailedException, WrongParameterException {
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.progressListeners.removeElement(progressListener);
    }

    public void setAbort(boolean newAbortStatus) {
        this.abort = newAbortStatus;
    }

    public void setProgress(float progress) {
        if (progress < 0.0f || progress > 1.0f) {
            throw new IllegalArgumentException("Progress values must be from 0.0f to 1.0f; got " + progress);
        }
        int index = 0;
        while (index < this.progressListeners.size()) {
            ProgressListener pl;
            if ((pl = (ProgressListener)this.progressListeners.elementAt(index++)) == null) continue;
            pl.setProgress(progress);
        }
    }

    public void setProgress(int zeroBasedIndex, int totalItems) {
        if (zeroBasedIndex < 0 || zeroBasedIndex >= totalItems || totalItems < 1) {
            throw new IllegalArgumentException("No valid arguments  zeroBasedIndex=" + zeroBasedIndex + ", totalItems=" + totalItems);
        }
        this.setProgress((float)zeroBasedIndex / (float)totalItems);
    }
}

