/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.ccb.graphshifts;

import edu.ucla.ccb.graphshifts.data.SingleFloatArrayDataItem;
import edu.ucla.ccb.graphshifts.graphs.HardGraphHierarchy;
import edu.ucla.ccb.graphshifts.graphs.ThinGraph;
import edu.ucla.ccb.graphshifts.image.AnalyzeHeader;
import edu.ucla.ccb.graphshifts.image.Colormap;
import edu.ucla.ccb.graphshifts.image.Image3PixelAccess;
import edu.ucla.ccb.graphshifts.image.ImageUtilities;
import edu.ucla.ccb.graphshifts.image.JIUIntegerImage_Image3PixelAccess_Adaptor;
import edu.ucla.ccb.graphshifts.image.ScalarImageB3;
import edu.ucla.ccb.graphshifts.observers.GraphShiftsObserver;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntIntIterator;
import gnu.trove.TLongByteHashMap;
import gnu.trove.TLongHashSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Random;
import net.sourceforge.jiu.codecs.ImageLoader;
import net.sourceforge.jiu.color.reduction.RGBToGrayConversion;
import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.MemoryRGB24Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;

public class GraphShifts {
    public static final long version = 20070712L;
    static int numClasses = -1;
    static PrintStream o = System.out;
    private static final long HIWORD = -4294967296L;
    private static final long LOWORD = 0xFFFFFFFFL;
    private static final SingleFloatArrayDataItem Tsfadi = new SingleFloatArrayDataItem();
    private static int minSpawnLevel = 1;
    double lambdaSmooth = 0.5;
    double lambdaAppearance = 0.5;
    HardGraphHierarchy hierarchy;
    ThinGraph[] tgHierarchy;
    ImageData image;
    LikelihoodMapSet lms;
    double[] LLmapLUT;
    TLongHashSet shifts;
    int w;
    int h;
    int d;
    int wh;
    private int unpackedLevel;
    private int unpackedNodeId;
    private int updateShiftsDownCount;
    private ArrayList<GraphShiftsObserver> observers;
    private boolean haveObservers = false;
    TLongHashSet shiftsTouched;
    TLongByteHashMap spawnShifts;
    int computeShiftCounter = 0;
    private TIntHashSet tempIntHashSet = new TIntHashSet();
    private TIntIntHashMap tempIIHM = new TIntIntHashMap(10);
    TIntIntHashMap boundaryLengthIIHM;
    TIntHashSet newNgbFromChildIHS;
    float[] LBUF = new float[numClasses];
    public boolean verboseB = false;
    public int verboseF = 0;
    FixedModelBinaryEnergyComputer BEC = new BECSmoothness();

    private static ARG0TYPE checkImageFileType(String arg) {
        File f;
        int lio = arg.lastIndexOf(46);
        if (lio != -1) {
            String suffix = arg.substring(lio + 1, arg.length());
            System.out.printf("parsing suffix %s\n", suffix);
            if (suffix.equalsIgnoreCase("HDR") || suffix.equalsIgnoreCase("IMG") || suffix.equalsIgnoreCase("BMP") || suffix.equalsIgnoreCase("GIF") || suffix.equalsIgnoreCase("PNG") || suffix.equalsIgnoreCase("PGM") || suffix.equalsIgnoreCase("TIF") || suffix.equalsIgnoreCase("PPM")) {
                return ARG0TYPE.JUSTIMAGE;
            }
        }
        if ((f = new File(arg + ".img")).exists()) {
            return ARG0TYPE.JUSTIMAGE;
        }
        f = new File(arg + ".hdr");
        if (f.exists()) {
            return ARG0TYPE.JUSTIMAGE;
        }
        try {
            BufferedReader in = new BufferedReader(new FileReader(arg));
            String line = in.readLine();
            in.close();
            System.out.println("read the line " + line);
            lio = line.lastIndexOf(44);
            System.out.println("lio is " + lio);
            if (lio != -1) {
                return ARG0TYPE.COMMASEP;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ARG0TYPE.MULTILINE;
    }

    public static void main(String[] args) {
        int classNum;
        PrintStream o;
        GraphShifts.o = o = System.out;
        o.printf(" -- starting up\n", new Object[0]);
        if (args.length != 4 && args.length != 5) {
            String usage = "\n// usage\n//  NOTE:  \n//     (1) All 3D images should be in the Analyze file format.  When specifying paths to images\n//          you can either use the prefix, prefix.hdr, or prefix.img.  All are acceptable, but \n//          for simplicity, I recommend just using the prefix.\n//         For 2D images, most popular formats are okay EXCEPT for JPG.\n//         3D is the default dimension.\n//     (2) Commas (',') or percents ('%') are not allowed to appear in any filename.\n\n//  args[0] is the image data.  You can specify it in three ways:\n//     (1) Just put the image filename here.  (e.g., /data/images/pat0.t1w.img)\n//           This method only works when you have a single image channel (or RGB natural image)\n//     (2) Use a text file that points to the image file(s) to use (multi-channels supported)\n//            Each line of the file specifies an image band/sequence,\n//             with the first line specifying the manual labels.\n//            During segmentation, the manual labels are completely disregarded and only used for evaluation.\n//            Example:  Line 1:   /data/CCB40/images/pat0.labels\n//                      Line 2:   /data/CCB40/images/pat0.t1w\n//            Give the path to the text file as the argument.\n//     (3) Also use a text file that points to the image file(s) with a different format.\n//            Give each image file (again with the labels image first) separated by commas\n//            Example:  Line 1:   /data/CCB40/images/pat0.labels,/data/CCB40/images/pat0.t1w\n\n//  args[1] is the likelihood map data.  You can specify it in two ways:\n//     (1) Use a printf style string format to the likelihood maps (e.g., /data/map_%02d)\n//     (2) Use a text file that point to the maps file -- sequentially, one path on each line.\n//            Example:  Line 1:   /data/map_00\n//                      Line 2:   /data/map_01\n//  args[2] number of classes (and thus likelihood maps) [integer]\n//  args[3] path for writing out the final labels volume (path to write the output file)\n\n//  args[4] (optional) option flag string that specifies various parameters to control the graph-shifts \n//           energy minimization process.  Format is flag1=value1,flag2=value2,etc... \n\n//          Allowable flags and default values: \n\n\n//          D=# (integer, default=3, range=2 or 3) -- Specifies dimension of the images.\n//          L=# (integer,default=-1) -- Specifies how many shift levels to consider during the \n//             energy minimization process.  -1 means consider all of the levels and it is default.\n//          M=# (integer,default=100000, range M>0) -- Maximum number of shifts to consider before stopping.\n//          W=# (float,default=0.7,range 0<=W<=1) -- Weight between appearance term and smoothness term.  \n//               For appearance (A) and smoothness (S), the energy is weighted    E = W*A+(1-W)*S.\n//          T=# (integer,default=1,range {1,2}) Type of shifts to include.  For value 1, only the original \n//               split/merge shifts are considered, for value 2, the split/merge and spawning shifts are \n//               considered.  Including the spawning shifts increases the computational cost and should \n//               only be used when necessary.\n//          V=# (integer,default=0, range >=0) Verbose output during shifting.  Outputs information every #-shifts.\n//               0 means no verbose output is made!\n//          S=# (integer, default=2, range >= 0 to H) Min level at which to consider spawning (if T=2).\n//          P=# (double, default=0.8 range = 0<x<=1) Appearance likelihood threshold when creating \n//                spawn edges.  A spawn edge is created if assigned node likelihood is lower than this.\n\n//          ********* Specifying alternate binary energy terms \n\n//          The default binary energy term is the boundary smoothness, which simply gives \n//           a weight of 1 to the binary term between any bordering pixels having different models.\n//           You can specify alternate binary energy terms by giving the following parameter:\n//          BEC=path/to/file  where path/to/file specifies the text file that contains the \n//           information to define the binary energy computer.\n//          The BEC file is an ASCII file wherein the first line contains the type of binary term\n//           and the following lines contains construction information.\n//          Types of terms and definitions:\n//            context     -- second line contains number of classes, N, (integer) and the third through\n//                            N+3 lines contain the energy terms defining the context matrix.\n//                           Each line is a row of the matrix with each entry separated by whitespace.\n\n//          ********* Less Important And Less Useful Flags (that very seldom if ever get changed \n\n//          H=# (integer,default=4,range H>1) Maximum height of the hierarchical representation.\n//          R=# (float, default=0.15, range 0<R<1) Desired reduction factor in the initial bottom-up \n//               construction of the graph hierarchy.\n\n//          ********* For evaluation and testing robustness\n\n//          BAD=#:# (double,long, no defaults for values, but default is OFF)  This initiates a sequence of \n//                  \"bad\" shifts that perturb the initialization to make the minimization more difficult.\n//                  The first is the scale-factor on the energy to achieve before stopping, the second is the random seed.\n//          MO=S:S (String to colormap file : String to write output image). Map-Output: This will take the\n//                  final output labels and map them into RGB using the colormap file.  \n//                  Currently only supported when D=2.\n";
            System.err.println(usage);
            System.exit(-1);
        }
        int opt_shiftLevels = -1;
        int opt_maxShifts = 100000;
        double opt_lambda = 0.7;
        int opt_shifts_type = 1;
        int opt_hierarchy_height = 4;
        double opt_reduction = 0.15;
        int opt_verbose = 0;
        int opt_minspawnlevel = 2;
        double opt_prunespawn = 0.1;
        boolean opt_dobad = false;
        double opt_badfactor = 1.0;
        long opt_badseed = 1L;
        int opt_dim = 3;
        boolean opt_bec = false;
        String opt_becpath = null;
        boolean opt_mapout = false;
        String opt_mapcmap = null;
        String opt_mapfn = null;
        if (args.length == 5) {
            String[] opts;
            for (String opt : opts = args[4].split(",")) {
                String[] vals2;
                String[] vals = opt.split("=");
                if (vals[0].equals("L")) {
                    opt_shiftLevels = Integer.parseInt(vals[1]);
                    continue;
                }
                if (vals[0].equals("D")) {
                    opt_dim = Integer.parseInt(vals[1]);
                    if (opt_dim == 2 || opt_dim == 3) continue;
                    System.err.printf("Bad value (%d) for dimension, setting to default 3\n", opt_dim);
                    opt_dim = 3;
                    continue;
                }
                if (vals[0].equals("M")) {
                    opt_maxShifts = Integer.parseInt(vals[1]);
                    if (opt_maxShifts >= 1) continue;
                    System.err.printf("Bad value (%d) for max shifts option, setting to default 100000\n", opt_maxShifts);
                    opt_maxShifts = 100000;
                    continue;
                }
                if (vals[0].equals("W")) {
                    opt_lambda = Double.parseDouble(vals[1]);
                    if (!(opt_lambda < 0.0) && !(opt_lambda > 1.0)) continue;
                    System.err.printf("Bad value (%f) for energy term weight, setting to default 0.7\n", opt_lambda);
                    opt_lambda = 0.7;
                    continue;
                }
                if (vals[0].equals("T")) {
                    opt_shifts_type = Integer.parseInt(vals[1]);
                    if (opt_shifts_type == 1 || opt_shifts_type == 2) continue;
                    System.err.printf("Bad value (%d) for shifts type option, setting to default 1\n", opt_shifts_type);
                    opt_shifts_type = 1;
                    continue;
                }
                if (vals[0].equals("H")) {
                    opt_hierarchy_height = Integer.parseInt(vals[1]);
                    if (opt_hierarchy_height > 1) continue;
                    System.err.printf("Bad value (%d) for max hierarchy height, setting to default 4\n", opt_hierarchy_height);
                    opt_hierarchy_height = 4;
                    continue;
                }
                if (vals[0].equals("R")) {
                    opt_reduction = Double.parseDouble(vals[1]);
                    if (!(opt_reduction > 1.0)) continue;
                    System.err.printf("Bad value (%f) for bottom-up reduction factor, setting to default 0.15\n", opt_reduction);
                    opt_reduction = 0.15;
                    continue;
                }
                if (vals[0].equals("V")) {
                    opt_verbose = Integer.parseInt(vals[1]);
                    if (opt_verbose >= 0) continue;
                    System.err.printf("Bad value (%d) for verbose output, setting to default 0\n", opt_verbose);
                    opt_verbose = 0;
                    continue;
                }
                if (vals[0].equals("S")) {
                    opt_minspawnlevel = Integer.parseInt(vals[1]);
                    if (opt_minspawnlevel >= 0) continue;
                    System.err.printf("Bad value (%d) for minspawnlevel output, setting to default 2\n", opt_minspawnlevel);
                    opt_minspawnlevel = 2;
                    continue;
                }
                if (vals[0].equals("P")) {
                    opt_prunespawn = Double.parseDouble(vals[1]);
                    if (!(opt_prunespawn <= 0.0) && !(opt_prunespawn > 1.0)) continue;
                    System.err.printf("Bad value (%f) for prune spawn threshold, setting to default 0.1\n", opt_prunespawn);
                    opt_prunespawn = 0.1;
                    continue;
                }
                if (vals[0].equals("BAD")) {
                    opt_dobad = true;
                    vals2 = vals[1].split(":");
                    opt_badfactor = Double.parseDouble(vals2[0]);
                    opt_badseed = Long.parseLong(vals2[1]);
                    continue;
                }
                if (vals[0].equals("BEC")) {
                    opt_bec = true;
                    opt_becpath = vals[1];
                    continue;
                }
                if (vals[0].equals("MO")) {
                    opt_mapout = true;
                    vals2 = vals[1].split(":");
                    opt_mapcmap = vals2[0];
                    opt_mapfn = vals2[1];
                    continue;
                }
                System.err.printf("Skipping misunderstood parameter string: %s.\n", opt);
            }
        }
        System.out.printf("Running GraphShifts code version %d\n", 20070712L);
        String lmapfmt = args[1];
        numClasses = classNum = Integer.parseInt(args[2]);
        o.printf("reading image data\n", new Object[0]);
        ARG0TYPE arg0type = GraphShifts.checkImageFileType(args[0]);
        System.out.println("arg0 is type " + (Object)((Object)arg0type));
        ImageData ID = arg0type == ARG0TYPE.MULTILINE ? ImageData.createFromMLFile(args[0], opt_dim) : (arg0type == ARG0TYPE.COMMASEP ? ImageData.createFromCSFile(args[0], opt_dim) : ImageData.createFromImage(args[0], opt_dim));
        ID.loadData();
        LikelihoodMapSet lms = new LikelihoodMapSet(lmapfmt, classNum, opt_dim);
        o.printf("working with %d classes\n", classNum);
        o.printf("data dimension is %d\n", opt_dim);
        o.printf("working with %d shift levels with %d maximum shifts \n", opt_shiftLevels, opt_maxShifts);
        o.printf("doing graph-shifts type %d\n", opt_shifts_type);
        o.printf("initializing the object\n", new Object[0]);
        GraphShifts a = new GraphShifts(ID, lms);
        if (opt_bec) {
            o.printf("updating binary energy computer:\n", opt_becpath);
            try {
                BufferedReader becbr = new BufferedReader(new FileReader(opt_becpath));
                String bectype = becbr.readLine();
                if (bectype.equalsIgnoreCase("context")) {
                    System.out.printf("BEC: using a context binary energy computer\n", new Object[0]);
                    a.BEC = new BECContext(becbr);
                } else {
                    System.err.println("Do not understand BEC of type: " + bectype + "  continuing with std smoothness");
                }
                becbr.close();
            }
            catch (IOException e) {
                a.BEC = new BECSmoothness();
                System.err.printf("Binary Energy Term creation from user specificied path failed.\n", new Object[0]);
                System.err.printf("This is not fatal-will just use standard smoothness term.\n", new Object[0]);
                e.printStackTrace();
            }
        }
        o.printf("initialization observers\n", new Object[0]);
        a.lambdaAppearance = opt_lambda;
        a.lambdaSmooth = 1.0 - opt_lambda;
        o.printf("working with appearance coeff %f and smoothness coeff %f\n", a.lambdaAppearance, a.lambdaSmooth);
        if (opt_verbose > 0) {
            a.verboseB = true;
            a.verboseF = opt_verbose;
        } else {
            a.verboseB = false;
        }
        minSpawnLevel = opt_minspawnlevel;
        Date startI = new Date();
        a.initializeGraph(new EdgeSampleInitializer(lms, opt_hierarchy_height, opt_reduction, 0.1, minSpawnLevel), opt_shifts_type == 2, opt_prunespawn);
        Date stopI = new Date();
        if (opt_dobad) {
            a.doBadGraphShifts(opt_badfactor, opt_badseed);
        }
        Date start = new Date();
        a.doGraphShifts(opt_shiftLevels, opt_maxShifts);
        Date stop = new Date();
        int seconds = (int)((stopI.getTime() - startI.getTime()) / 1000L);
        int minutes = seconds / 60;
        System.out.printf("initialization took %d:%02d (m:s)\n", minutes, seconds %= 60);
        seconds = (int)((stop.getTime() - start.getTime()) / 1000L);
        minutes = seconds / 60;
        System.out.printf("graph shifts took %d:%02d (m:s)\n", minutes, seconds %= 60);
        seconds = (int)((stop.getTime() - startI.getTime()) / 1000L);
        minutes = seconds / 60;
        System.out.printf("total took %d:%02d (m:s)\n", minutes, seconds %= 60);
        o.printf("writing the final labels image to disk\n", new Object[0]);
        ScalarImageB3 labels = a.getFinalLabels();
        if (opt_dim == 3) {
            AnalyzeHeader hdr = new AnalyzeHeader(args[3], labels);
            hdr.saveToDisk();
        } else if (opt_dim == 2) {
            ImageUtilities.writeViaJIU(labels, args[3], 0, 0);
        }
        o.printf("done.\n", new Object[0]);
        if (opt_mapout) {
            if (opt_dim != 2) {
                System.out.printf("Unsupported colormapping in 3D right now", new Object[0]);
            }
            o.printf("mapping final labels into rgb with %s\n", opt_mapcmap);
            Colormap cmap = Colormap.createFromFile(opt_mapcmap);
            int w = labels.getWidth();
            int h = labels.getHeight();
            MemoryRGB24Image RGB = new MemoryRGB24Image(w, h);
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    int packed = cmap.getColorAsIntARGB(labels.getPixelInt(x, y, 0));
                    RGB.putSample(0, x, y, (0xFF0000 & packed) >> 16);
                    RGB.putSample(1, x, y, (0xFF00 & packed) >> 8);
                    RGB.putSample(2, x, y, 0xFF & packed);
                }
            }
            ImageUtilities.writeViaJIU((IntegerImage)RGB, opt_mapfn);
        }
    }

    public GraphShifts(ImageData image, LikelihoodMapSet lms) {
        this.image = image;
        this.w = image.getWidth();
        this.h = image.getHeight();
        this.d = image.getDepth();
        this.wh = this.w * this.h;
        this.lms = lms;
        this.shifts = new TLongHashSet(image.getWidth());
        this.spawnShifts = new TLongByteHashMap();
        this.boundaryLengthIIHM = new TIntIntHashMap(20);
        this.newNgbFromChildIHS = new TIntHashSet(10);
        this.observers = new ArrayList(1);
        this.LLmapLUT = new double[256];
        this.LLmapLUT[0] = -7.0;
        for (int i = 1; i < 256; ++i) {
            double v = (double)i / 255.0;
            this.LLmapLUT[i] = Math.log(v);
        }
        o.printf("%s Class:  done construction\n", this.getClass().getSimpleName());
    }

    public void addObserver(GraphShiftsObserver O) {
        this.observers.add(O);
        this.haveObservers = true;
    }

    public void checkBoundaryLengths() {
        for (int layer = this.tgHierarchy.length - 2; layer > 0; --layer) {
            ThinGraph qG = this.tgHierarchy[layer];
            for (int qi = 0; qi < qG.getNumberOfNodes(); ++qi) {
                int qn = qG.NDgetNumberOfNeighbors(qi);
                for (int qni = 0; qni < qn; ++qni) {
                    int nBL;
                    int qnid = qG.NDgetNeighbor(qi, qni);
                    int uBL = this.computeBoundaryLengthToNeighborViaChildren(layer, qi, qnid);
                    if (uBL == (nBL = qG.NDgetBoundaryLength(qi, qni))) continue;
                    o.printf("layer %d check %d, n#%d (id%d), uBL is %d and nBL is %d\t\t\t%b\n", layer, qi, qni, qnid, uBL, nBL, uBL == nBL);
                }
            }
        }
    }

    public void checkBoundaryLengths(int layer) {
        ThinGraph qG = this.tgHierarchy[layer];
        for (int qi = 0; qi < qG.getNumberOfNodes(); ++qi) {
            int qn = qG.NDgetNumberOfNeighbors(qi);
            for (int qni = 0; qni < qn; ++qni) {
                int qnid = qG.NDgetNeighbor(qi, qni);
                int uBL = this.computeBoundaryLengthToNeighborViaChildren(layer, qi, qnid);
                int nBL = qG.NDgetBoundaryLength(qi, qni);
                o.printf("check %d, n#%d (id%d), uBL is %d and nBL is %d\t\t\t%b\n", qi, qni, qnid, uBL, nBL, uBL == nBL);
            }
        }
    }

    public int computeBoundaryLengthToNeighborViaChildren(int level, int nodeIndex, int neighborIndex) {
        int d = 0;
        int nc = this.tgHierarchy[level].NDgetNumberOfChildren(nodeIndex);
        for (int ci = 0; ci < nc; ++ci) {
            int cid = this.tgHierarchy[level].NDgetChild(nodeIndex, ci);
            int n = this.tgHierarchy[level - 1].NDgetNumberOfNeighbors(cid);
            for (int i = 0; i < n; ++i) {
                int ni = this.tgHierarchy[level - 1].NDgetNeighbor(cid, i);
                if (this.tgHierarchy[level - 1].NDgetParent(ni) != neighborIndex) continue;
                d += this.tgHierarchy[level - 1].NDgetBoundaryLength(cid, i);
            }
        }
        return d;
    }

    public double computeLLAtLeaves(int level, int nodeIndex, Image3PixelAccess LLmap) {
        ThinGraph G = this.tgHierarchy[level];
        int nc = G.NDgetNumberOfChildren(nodeIndex);
        if (nc == 0) {
            if (level != 0) {
                return 0.0;
            }
            int z = (int)((double)nodeIndex / (double)this.wh);
            int y = (int)((double)(nodeIndex - z * this.wh) / (double)this.w);
            int x = (nodeIndex - z * this.wh) % this.w;
            return this.LLmapLUT[LLmap.getPixelInt(x, y, z)];
        }
        double LL = 0.0;
        for (int i = 0; i < nc; ++i) {
            LL += this.computeLLAtLeaves(level - 1, G.NDgetChild(nodeIndex, i), LLmap);
        }
        return LL;
    }

    public double computeLLAtLeavesCache(int level, int nodeIndex, int cIndex) {
        ThinGraph G = this.tgHierarchy[level];
        if (level == 0) {
            Image3PixelAccess LLmap = this.lms.maps[cIndex];
            int z = (int)((double)nodeIndex / (double)this.wh);
            int y = (int)((double)(nodeIndex - z * this.wh) / (double)this.w);
            int x = (nodeIndex - z * this.wh) % this.w;
            return this.LLmapLUT[LLmap.getPixelInt(x, y, z)];
        }
        if (level == 1) {
            int nc = G.NDgetNumberOfChildren(nodeIndex);
            if (nc == 0) {
                return 0.0;
            }
            Image3PixelAccess LLmap = this.lms.maps[cIndex];
            double d = 0.0;
            for (int ni = 0; ni < nc; ++ni) {
                int cid = G.NDgetChild(nodeIndex, ni);
                int z = (int)((double)cid / (double)this.wh);
                int y = (int)((double)(cid - z * this.wh) / (double)this.w);
                int x = (cid - z * this.wh) % this.w;
                d += this.LLmapLUT[LLmap.getPixelInt(x, y, z)];
            }
            return d;
        }
        ThinGraph G_ = this.tgHierarchy[level - 1];
        int nc = G.NDgetNumberOfChildren(nodeIndex);
        if (nc == 0) {
            return 0.0;
        }
        double LL = 0.0;
        for (int i = 0; i < nc; ++i) {
            int cid = G.NDgetChild(nodeIndex, i);
            LL += (double)G_.NDgetLikelihood(cid, cIndex);
        }
        return LL;
    }

    public int computeMultiBoundaryLength(int level, int nodeIndex, int classIndex) {
        int d = 0;
        int n = this.tgHierarchy[level].NDgetNumberOfNeighbors(nodeIndex);
        for (int i = 0; i < n; ++i) {
            int ni = this.tgHierarchy[level].NDgetNeighbor(nodeIndex, i);
            if (this.tgHierarchy[level].NDgetClassIndex(ni) == classIndex) continue;
            d += this.tgHierarchy[level].NDgetBoundaryLength(nodeIndex, i);
        }
        return d;
    }

    public double computeSegmentationLL() {
        ThinGraph top = this.tgHierarchy[this.tgHierarchy.length - 1];
        int topNum = top.getNumberOfNodes();
        double LL = 0.0;
        for (int i = 0; i < topNum; ++i) {
            double dE = -this.computeLLAtLeaves(this.tgHierarchy.length - 1, i, this.lms.maps[top.NDgetClassIndex(i)]);
            double bE = 0.5 * (double)this.computeTopLevelBoundaryLength(i);
            LL += this.lambdaAppearance * dE + this.lambdaSmooth * bE;
        }
        return LL;
    }

    private int computeShift(int level, int uId) {
        ++this.computeShiftCounter;
        this.spawnShifts.remove(this.packShift(level, uId));
        int uCI = this.tgHierarchy[level].NDgetClassIndex(uId);
        int unN = this.tgHierarchy[level].NDgetNumberOfNeighbors(uId);
        double bestDelta = -1.0E-5;
        int bestVId = -1;
        boolean attempted = false;
        boolean bestShiftIsSpawn = false;
        double uLL = Double.POSITIVE_INFINITY;
        for (int uni = 0; uni < unN; ++uni) {
            double delta;
            double deltaAppearance;
            double vLL;
            int vId = this.tgHierarchy[level].NDgetNeighbor(uId, uni);
            if (vId == 0 && level >= minSpawnLevel) {
                for (int cl = 0; cl < numClasses; ++cl) {
                    if (cl == uCI) continue;
                    attempted = true;
                    if (uLL == Double.POSITIVE_INFINITY) {
                        uLL = -this.computeLLAtLeavesCache(level, uId, uCI);
                    }
                    vLL = -this.computeLLAtLeavesCache(level, uId, cl);
                    deltaAppearance = vLL - uLL;
                    double deltaBL = 0.0;
                    double binaryOld = 0.0;
                    double binaryNew = 0.0;
                    for (int un = 0; un < unN; ++un) {
                        int cluni = this.tgHierarchy[level].NDgetNeighbor(uId, un);
                        if (cluni == 0) continue;
                        int cllength = this.tgHierarchy[level].NDgetBoundaryLength(uId, un);
                        int clunc = this.tgHierarchy[level].NDgetClassIndex(cluni);
                        binaryOld += this.BEC.computeEnergy(cllength, uCI, clunc);
                        binaryNew += this.BEC.computeEnergy(cllength, cl, clunc);
                    }
                    deltaBL = binaryNew - binaryOld;
                    delta = this.lambdaAppearance * deltaAppearance + this.lambdaSmooth * deltaBL;
                    if (!(delta < bestDelta)) continue;
                    bestDelta = delta;
                    bestVId = cl;
                    bestShiftIsSpawn = true;
                }
                continue;
            }
            int vCI = this.tgHierarchy[level].NDgetClassIndex(vId);
            if (uCI == vCI) continue;
            attempted = true;
            if (uLL == Double.POSITIVE_INFINITY) {
                uLL = -this.computeLLAtLeavesCache(level, uId, uCI);
            }
            vLL = -this.computeLLAtLeavesCache(level, uId, vCI);
            deltaAppearance = vLL - uLL;
            double binaryOld = 0.0;
            double binaryNew = 0.0;
            for (int un = 0; un < unN; ++un) {
                int cluni = this.tgHierarchy[level].NDgetNeighbor(uId, un);
                if (cluni == 0) continue;
                int cllength = this.tgHierarchy[level].NDgetBoundaryLength(uId, un);
                int clunc = this.tgHierarchy[level].NDgetClassIndex(cluni);
                binaryOld += this.BEC.computeEnergy(cllength, uCI, clunc);
                binaryNew += this.BEC.computeEnergy(cllength, vCI, clunc);
            }
            double deltaBinary = binaryNew - binaryOld;
            delta = this.lambdaAppearance * deltaAppearance + this.lambdaSmooth * deltaBinary;
            if (!(delta < bestDelta)) continue;
            bestDelta = delta;
            bestVId = vId;
            bestShiftIsSpawn = false;
        }
        if (bestVId == -1) {
            this.tgHierarchy[level].NDsetGraphShift(uId, -1, 0.0f);
            if (!attempted) {
                return -2;
            }
            return -1;
        }
        if (bestShiftIsSpawn) {
            this.tgHierarchy[level].NDsetGraphShift(uId, 0, (float)bestDelta);
            this.spawnShifts.put(this.packShift(level, uId), (byte)bestVId);
            return 0;
        }
        this.tgHierarchy[level].NDsetGraphShift(uId, bestVId, (float)bestDelta);
        return bestVId;
    }

    public int computeSingleBoundaryLength(int level, int nodeIndex, int classIndex) {
        int d = 0;
        int n = this.tgHierarchy[level].NDgetNumberOfNeighbors(nodeIndex);
        for (int i = 0; i < n; ++i) {
            int ni = this.tgHierarchy[level].NDgetNeighbor(nodeIndex, i);
            if (this.tgHierarchy[level].NDgetClassIndex(ni) != classIndex) continue;
            d += this.tgHierarchy[level].NDgetBoundaryLength(nodeIndex, i);
        }
        return d;
    }

    private double computeShiftSingle(int level, int uId, int nid) {
        int uCI = this.tgHierarchy[level].NDgetClassIndex(uId);
        int vId = this.tgHierarchy[level].NDgetNeighbor(uId, nid);
        int vCI = this.tgHierarchy[level].NDgetClassIndex(vId);
        double uLL = -this.computeLLAtLeavesCache(level, uId, uCI);
        double vLL = -this.computeLLAtLeavesCache(level, uId, vCI);
        double deltaAppearance = vLL - uLL;
        int lengthToNEW = this.computeSingleBoundaryLength(level, uId, vCI);
        int lengthToOLD = this.computeSingleBoundaryLength(level, uId, uCI);
        double binaryOld = this.BEC.computeEnergy(lengthToNEW, uCI, vCI) + this.BEC.computeEnergy(lengthToOLD, uCI, uCI);
        double binaryNew = this.BEC.computeEnergy(lengthToNEW, vCI, vCI) + this.BEC.computeEnergy(lengthToOLD, vCI, uCI);
        double deltaBinary = binaryNew - binaryOld;
        return this.lambdaAppearance * deltaAppearance + this.lambdaSmooth * deltaBinary;
    }

    public int computeTopLevelBoundaryLength() {
        int d = 0;
        int lv = this.hierarchy.getNumberOfLayers() - 1;
        int n = this.tgHierarchy[lv].getNumberOfNodes();
        for (int i = 0; i < n; ++i) {
            d += this.computeTopLevelBoundaryLength(i);
        }
        return d;
    }

    public int computeTopLevelBoundaryLength(int nodeIndex) {
        int d = 0;
        int lv = this.hierarchy.getNumberOfLayers() - 1;
        int cl = this.tgHierarchy[lv].NDgetClassIndex(nodeIndex);
        int nc = this.tgHierarchy[lv].NDgetNumberOfChildren(nodeIndex);
        for (int ci = 0; ci < nc; ++ci) {
            int cid = this.tgHierarchy[lv].NDgetChild(nodeIndex, ci);
            int ncn = this.tgHierarchy[lv - 1].NDgetNumberOfNeighbors(cid);
            for (int cni = 0; cni < ncn; ++cni) {
                int cnid = this.tgHierarchy[lv - 1].NDgetNeighbor(cid, cni);
                if (this.tgHierarchy[lv - 1].NDgetClassIndex(cnid) == cl) continue;
                d += this.tgHierarchy[lv - 1].NDgetBoundaryLength(cid, cni);
            }
        }
        return d;
    }

    public int computeTotalBoundaryLength(int level, int nodeIndex) {
        int d = 0;
        int n = this.tgHierarchy[level].NDgetNumberOfNeighbors(nodeIndex);
        for (int i = 0; i < n; ++i) {
            d += this.tgHierarchy[level].NDgetBoundaryLength(nodeIndex, i);
        }
        return d;
    }

    public void doBadGraphShifts(double factor, long seed) {
        int hLevelNum = this.hierarchy.getNumberOfLayers();
        int shiftsTaken = 0;
        Random R = new Random(seed);
        double totalGradient = 0.0;
        double Estart = this.computeSegmentationLL();
        double Eneed = Estart * factor;
        while (totalGradient < Eneed) {
            double gradient;
            int sM;
            int nn;
            int rN;
            int rL = R.nextInt(hLevelNum - 1);
            ThinGraph G = this.tgHierarchy[rL];
            int sn = G.NDgetNumberOfNeighbors(rN = R.nextInt(nn = G.getNumberOfNodes()));
            if (sn <= 0) continue;
            int sni = R.nextInt(sn);
            int sN = G.NDgetNeighbor(rN, sni);
            int rM = G.NDgetClassIndex(rN);
            if (rM == (sM = G.NDgetClassIndex(sN)) || (gradient = this.computeShiftSingle(rL, rN, sni)) <= 0.0) continue;
            totalGradient += gradient;
            int rP = G.NDgetParent(rN);
            int sP = G.NDgetParent(sN);
            System.out.printf("perturbation %d, level %d from %d to %d (parents %d to %d) with gradient %f\n", shiftsTaken, rL, rN, sN, rP, sP, gradient);
            this.pushClassIndexDown(rL, rN, sM);
            this.tgHierarchy[rL].NDsetParent(rN, sP);
            this.tgHierarchy[rL + 1].NDaddChild(sP, rN);
            this.tgHierarchy[rL + 1].NDremoveChildId(rP, rN);
            if (rL < this.tgHierarchy.length - 2) {
                this.updateBoundaryLengthsUpSmart(rL, rN, rP, sP);
                this.updateLikelihoodCachesUp(rL, rN, rP, sP);
            }
            ++shiftsTaken;
        }
        System.out.printf("The total perturbation gradient is %f\n", totalGradient);
        double Eend = this.computeSegmentationLL();
        System.out.printf("Energy before perturbation %f and after %f\n", Estart, Eend);
    }

    public void doGraphShifts(int highLevel, int maxShiftNumber) {
        o.printf("%s Class:  computing the initial set of graph shifts\n", this.getClass().getSimpleName());
        int hLevelNum = this.hierarchy.getNumberOfLayers();
        int startLevel = highLevel == -1 ? hLevelNum - 2 : highLevel;
        int numPotentialShifts = 0;
        for (int level = startLevel; level >= 0; --level) {
            int ui;
            ThinGraph G = this.tgHierarchy[level];
            int uN = G.getNumberOfNodes();
            int n = ui = level >= minSpawnLevel ? 1 : 0;
            while (ui < uN) {
                int unN = G.NDgetNumberOfNeighbors(ui);
                numPotentialShifts += unN;
                int vi = this.computeShift(level, ui);
                if (vi >= 0) {
                    this.shifts.add(this.packShift(level, ui));
                }
                ++ui;
            }
        }
        o.printf("%s Class:  computed %d initial shifts (%.3f%%)\n", this.getClass().getSimpleName(), this.shifts.size(), Float.valueOf(100.0f * (float)this.shifts.size() / (float)numPotentialShifts));
        o.printf("the number of potential shifts (edges) is %d\n", numPotentialShifts);
        this.shiftsTouched = new TLongHashSet(this.shifts.size());
        int shiftCount = 0;
        PrintWriter pw = null;
        this.fireShiftBeginToObservers();
        while (shiftCount < maxShiftNumber) {
            float bestShiftWeight = Float.POSITIVE_INFINITY;
            long bestShift = -1L;
            for (long ln : this.shifts) {
                float w = this.tgHierarchy[(int)(ln >> 32 & 0xFFFFFFFFL)].NDgetGraphShiftWeight((int)(ln & 0xFFFFFFFFL));
                if (!(w < bestShiftWeight)) continue;
                bestShiftWeight = w;
                bestShift = ln;
            }
            if (bestShiftWeight >= 0.0f) {
                if (!this.verboseB) break;
                o.printf("not proceeding with the graph shift because the best shift will decrease likelihood\n", new Object[0]);
                break;
            }
            ++shiftCount;
            this.unpackShift(bestShift);
            int shiftLv = this.unpackedLevel;
            int shiftLi = this.unpackedNodeId;
            int shiftToId = this.tgHierarchy[shiftLv].NDgetGraphShiftIndex(shiftLi);
            boolean isSpawn = false;
            if (shiftLv >= minSpawnLevel && shiftToId == 0) {
                int spawnP;
                isSpawn = true;
                byte shiftNewClass = this.spawnShifts.get(bestShift);
                int shiftFromClass = this.tgHierarchy[shiftLv].NDgetClassIndex(shiftLi);
                int shiftFromParentId = this.tgHierarchy[shiftLv].NDgetParent(shiftLi);
                if (this.verboseB && shiftCount % this.verboseF == 0) {
                    o.printf("[%d] found the best shift (spawn) lv %d id %d with weight of %f class %d->%d\n", shiftCount, shiftLv, shiftLi, Float.valueOf(bestShiftWeight), shiftFromClass, (int)shiftNewClass);
                }
                this.pushClassIndexDown(shiftLv, shiftLi, shiftNewClass);
                this.tgHierarchy[shiftLv + 1].NDremoveChildId(shiftFromParentId, shiftLi);
                int spawnC = shiftLi;
                int mass = this.tgHierarchy[shiftLv].NDgetMass(shiftLi);
                byte intensity = this.tgHierarchy[shiftLv].NDgetIntensity(shiftLi);
                for (int spawnLevel = shiftLv + 1; spawnLevel < this.tgHierarchy.length; ++spawnLevel) {
                    ThinGraph.ThinGraphNode n = this.tgHierarchy[spawnLevel].addNewNode();
                    spawnP = n.getId();
                    this.tgHierarchy[spawnLevel].NDaddChild(spawnP, spawnC);
                    this.tgHierarchy[spawnLevel - 1].NDsetParent(spawnC, spawnP);
                    this.tgHierarchy[spawnLevel].NDsetMass(spawnP, mass);
                    this.tgHierarchy[spawnLevel].NDsetIntensity(spawnP, intensity);
                    this.tgHierarchy[spawnLevel].NDsetClassIndex(spawnP, shiftNewClass);
                    if (this.verboseB) {
                        o.printf("spawning new node at level %d id %d\n", spawnLevel, spawnP);
                    }
                    if (spawnLevel < this.tgHierarchy.length - 1) {
                        this.tempIIHM.clear();
                        this.tempIIHM.put(spawnP, 0);
                        for (int ci = 0; ci < n.getNumberOfChildren(); ++ci) {
                            int cinn = this.tgHierarchy[spawnLevel - 1].NDgetNumberOfNeighbors(spawnC);
                            for (int cin = 0; cin < cinn; ++cin) {
                                int cinid = this.tgHierarchy[spawnLevel - 1].NDgetNeighbor(spawnC, cin);
                                int len = this.tgHierarchy[spawnLevel - 1].NDgetBoundaryLength(spawnC, cin);
                                int cip = this.tgHierarchy[spawnLevel - 1].NDgetParent(cinid);
                                if (this.tempIIHM.adjustValue(cip, len)) continue;
                                this.tempIIHM.put(cip, len);
                            }
                        }
                        TIntIntIterator iii = this.tempIIHM.iterator();
                        int i = this.tempIIHM.size();
                        while (i-- > 0) {
                            iii.advance();
                            int pid = iii.key();
                            int len = iii.value();
                            if (pid == spawnP) continue;
                            this.tgHierarchy[spawnLevel].addEdge(spawnP, pid, len);
                            if (spawnLevel != shiftLv + 1) continue;
                            int t = this.tgHierarchy[spawnLevel].NDlookupNeighborIndex(shiftFromParentId, pid);
                            if (t != -1) {
                                this.tgHierarchy[spawnLevel].NDsubtractFromBoundaryLength(shiftFromParentId, t, len);
                            }
                            if ((t = this.tgHierarchy[spawnLevel].NDlookupNeighborIndex(pid, shiftFromParentId)) != -1) {
                                this.tgHierarchy[spawnLevel].NDsubtractFromBoundaryLength(pid, t, len);
                            }
                            this.updateSubtractToTop(spawnLevel, shiftFromParentId, pid, len);
                        }
                    }
                    spawnC = spawnP;
                }
                spawnP = this.tgHierarchy[shiftLv].NDgetParent(shiftLi);
                this.updateLikelihoodCachesUp(shiftLv, shiftLi, shiftFromParentId, spawnP);
                this.computeShiftCounter = 0;
                this.shiftsTouched.clear();
                if (shiftLv < startLevel) {
                    this.updateShiftsUp(shiftLv + 1, spawnP, startLevel);
                    this.updateShiftsUp(shiftLv + 1, shiftFromParentId, startLevel);
                }
            } else {
                int shiftToClass;
                int shiftFromParentId = this.tgHierarchy[shiftLv].NDgetParent(shiftLi);
                int shiftToParentId = this.tgHierarchy[shiftLv].NDgetParent(shiftToId);
                int shiftFromClass = this.tgHierarchy[shiftLv].NDgetClassIndex(shiftLi);
                if (shiftFromClass == (shiftToClass = this.tgHierarchy[shiftLv].NDgetClassIndex(shiftToId))) {
                    this.shifts.remove(bestShift);
                    continue;
                }
                if (this.verboseB && shiftCount % this.verboseF == 0) {
                    o.printf("[%d] found the best shift lv %d id %d->%d parent %d->%d with weight of %f class %d->%d\n", shiftCount, shiftLv, shiftLi, shiftToId, shiftFromParentId, shiftToParentId, Float.valueOf(bestShiftWeight), shiftFromClass, shiftToClass);
                }
                this.pushClassIndexDown(shiftLv, shiftLi, shiftToClass);
                this.tgHierarchy[shiftLv].NDsetParent(shiftLi, this.tgHierarchy[shiftLv].NDgetParent(shiftToId));
                this.tgHierarchy[shiftLv + 1].NDaddChild(shiftToParentId, shiftLi);
                this.tgHierarchy[shiftLv + 1].NDremoveChildId(shiftFromParentId, shiftLi);
                this.computeShiftCounter = 0;
                this.shiftsTouched.clear();
                if (shiftLv < this.tgHierarchy.length - 2) {
                    this.updateBoundaryLengthsUpSmart(shiftLv, shiftLi, shiftFromParentId, shiftToParentId);
                    this.updateLikelihoodCachesUp(shiftLv, shiftLi, shiftFromParentId, shiftToParentId);
                }
                if (shiftLv < startLevel) {
                    this.updateShiftsUp(shiftLv + 1, shiftFromParentId, startLevel);
                    this.updateShiftsUp(shiftLv + 1, shiftToParentId, startLevel);
                }
            }
            this.updateShiftsDownCount = 0;
            this.updateShiftsDown(shiftLv, shiftLi);
            int safety1 = this.tgHierarchy[shiftLv].NDgetGraphShiftIndex(shiftLi);
            if (safety1 < 0) {
                this.shifts.remove(bestShift);
            }
            if (this.verboseB && shiftCount % this.verboseF == 0) {
                o.printf("%s Class:  updated shifts set: %d remain (%.3f%%)\t%d attempts\n", this.getClass().getSimpleName(), this.shifts.size(), Float.valueOf(100.0f * (float)this.shifts.size() / (float)numPotentialShifts), this.updateShiftsDownCount);
            }
            if (!this.haveObservers) continue;
            this.fireShiftToObservers(shiftCount, shiftLv, shiftLi, shiftToId, bestShiftWeight);
        }
        this.fireShiftEndToObservers();
        if (pw != null) {
            pw.close();
        }
    }

    public void fireShiftBeginToObservers() {
        for (GraphShiftsObserver O : this.observers) {
            O.shiftBegin();
        }
    }

    public void fireShiftEndToObservers() {
        for (GraphShiftsObserver O : this.observers) {
            O.shiftEnd();
        }
    }

    public void fireShiftToObservers(int shiftNumber, int shiftLevel, int shiftFrom, int shiftTo, float shiftWeight) {
        for (GraphShiftsObserver O : this.observers) {
            O.shiftTaken(shiftNumber, shiftLevel, shiftFrom, shiftTo, shiftWeight, this.hierarchy, this);
        }
    }

    public byte[] getClassIndexArray() {
        return this.tgHierarchy[0].getClassIndexBuffer().toNativeArray();
    }

    public ScalarImageB3 getFinalLabels() {
        ScalarImageB3 I = new ScalarImageB3(this.w, this.h, this.d);
        byte[] Fdat = this.tgHierarchy[0].getClassIndexBuffer().toNativeArray();
        byte[] Ibuf = I.getBuffer().getData();
        System.arraycopy(Fdat, 0, Ibuf, 0, Ibuf.length);
        return I;
    }

    public void initializeGraph(GraphShiftsInitializer I, boolean makeSpawn, double pruneSpawn) {
        int i;
        o.printf("%s Class:  initializing the hierarchy\n", this.getClass().getSimpleName());
        this.hierarchy = I.initializeGraph(this.image);
        o.printf("%s Class:  initialized with %d levels\n", this.getClass().getSimpleName(), this.hierarchy.getNumberOfLevels());
        o.printf("%s Class:  creating levels array of ThinGraph\n", this.getClass().getSimpleName());
        this.tgHierarchy = new ThinGraph[this.hierarchy.getNumberOfLayers()];
        for (i = 0; i < this.tgHierarchy.length; ++i) {
            this.tgHierarchy[i] = (ThinGraph)this.hierarchy.getLayer(i);
        }
        o.printf("%s Class:  done initialization\n", this.getClass().getSimpleName());
        for (i = 1; i < this.tgHierarchy.length; ++i) {
            int j;
            ThinGraph gi = this.tgHierarchy[i];
            o.printf("initializing likelihood cache at level %d\n", i);
            int N = gi.getNumberOfNodes();
            int n = j = i >= minSpawnLevel ? 1 : 0;
            while (j < N) {
                for (int c = 0; c < numClasses; ++c) {
                    double L = this.computeLLAtLeavesCache(i, j, c);
                    gi.NDsetLikelihood(j, c, (float)L);
                }
                ++j;
            }
        }
        if (makeSpawn) {
            double ltau = Math.log(pruneSpawn);
            for (int i2 = minSpawnLevel; i2 < this.tgHierarchy.length - 1; ++i2) {
                int numrm = 0;
                int numad = 0;
                ThinGraph gi = this.tgHierarchy[i2];
                int n = gi.getNumberOfNodes();
                for (int ni = 1; ni < n; ++ni) {
                    int clid = gi.NDgetClassIndex(ni);
                    double L = gi.NDgetLikelihood(ni, clid);
                    if (L / (double)gi.NDgetMass(ni) > ltau) {
                        ++numrm;
                        continue;
                    }
                    gi.addEdge(0, ni, 0);
                    ++numad;
                }
                System.out.printf("Level %d, %d of %d Spawn Connections Added (%d not)\n", i2, numad, n, numrm);
            }
        }
    }

    private final long packShift(int level, int nodeId) {
        return (long)level << 32 & 0xFFFFFFFF00000000L | (long)nodeId & 0xFFFFFFFFL;
    }

    private void pushClassIndexDown(int level, int nodeId, int classIdx) {
        this.tgHierarchy[level].NDsetClassIndex(nodeId, classIdx);
        if (level == 0) {
            return;
        }
        int clen = this.tgHierarchy[level].NDgetNumberOfChildren(nodeId);
        for (int i = 0; i < clen; ++i) {
            int ci = this.tgHierarchy[level].NDgetChild(nodeId, i);
            this.pushClassIndexDown(level - 1, ci, classIdx);
        }
    }

    public void removeObserver(GraphShiftsObserver O) {
        this.observers.remove(O);
        if (this.observers.size() == 0) {
            this.haveObservers = false;
        }
    }

    private final void unpackShift(long shift) {
        this.unpackedLevel = (int)(shift >> 32 & 0xFFFFFFFFL);
        this.unpackedNodeId = (int)(shift & 0xFFFFFFFFL);
    }

    private final void updateAddToTop(int level, int uid, int vid, int len) {
        int vpid;
        int upid;
        if (level < this.tgHierarchy.length - 2 && (upid = this.tgHierarchy[level].NDgetParent(uid)) != (vpid = this.tgHierarchy[level].NDgetParent(vid))) {
            int u = this.tgHierarchy[level + 1].NDlookupNeighborIndex(upid, vpid);
            if (u == -1) {
                this.tgHierarchy[level + 1].addEdge(upid, vpid, len);
            } else {
                int v = this.tgHierarchy[level + 1].NDlookupNeighborIndex(vpid, upid);
                this.tgHierarchy[level + 1].NDaddToBoundaryLength(upid, u, len);
                this.tgHierarchy[level + 1].NDaddToBoundaryLength(vpid, v, len);
            }
            this.updateAddToTop(level + 1, upid, vpid, len);
        }
    }

    private void updateBoundaryLengthsUp(int level, int uid) {
        ThinGraph gi = this.tgHierarchy[level];
        ThinGraph gi_ = this.tgHierarchy[level - 1];
        int cn = gi.NDgetNumberOfChildren(uid);
        this.boundaryLengthIIHM.clear();
        for (int cid = 0; cid < cn; ++cid) {
            int ci = gi.NDgetChild(uid, cid);
            int cin = gi_.NDgetNumberOfNeighbors(ci);
            for (int cini = 0; cini < cin; ++cini) {
                int len;
                int nid = gi_.NDgetNeighbor(ci, cini);
                int pid = gi_.NDgetParent(nid);
                if (pid == uid || this.boundaryLengthIIHM.adjustValue(pid, len = gi_.NDgetBoundaryLength(ci, cini))) continue;
                this.boundaryLengthIIHM.put(pid, len);
            }
        }
        int nn = gi.NDgetNumberOfNeighbors(uid);
        for (int ni = 0; ni < nn; ++ni) {
            int nid = gi.NDgetNeighbor(uid, ni);
            int len = this.boundaryLengthIIHM.get(nid);
            gi.NDsetBoundaryLength(uid, ni, len);
            int u = gi.NDlookupNeighborIndex(nid, uid);
            gi.NDsetBoundaryLength(nid, u, len);
        }
        if (level < this.tgHierarchy.length - 2) {
            this.updateBoundaryLengthsUp(level + 1, this.tgHierarchy[level].NDgetParent(uid));
        }
    }

    private void updateBoundaryLengthsUpOLD(int level, int uid, int vid) {
        boolean hitVid = false;
        int total = 0;
        int n = this.tgHierarchy[level].NDgetNumberOfNeighbors(uid);
        for (int i = 0; i < n; ++i) {
            int nid = this.tgHierarchy[level].NDgetNeighbor(uid, i);
            if (nid == vid) {
                hitVid = true;
            }
            int oldlen = this.tgHierarchy[level].NDgetBoundaryLength(uid, i);
            int len = this.computeBoundaryLengthToNeighborViaChildren(level, uid, nid);
            this.tgHierarchy[level].NDsetBoundaryLength(uid, i, len);
            int u = this.tgHierarchy[level].NDlookupNeighborIndex(nid, uid);
            this.tgHierarchy[level].NDsetBoundaryLength(nid, u, len);
            total += len;
        }
        if (!hitVid) {
            int len = this.computeBoundaryLengthToNeighborViaChildren(level, uid, vid);
            total += len;
            this.tgHierarchy[level].addEdge(uid, vid, len);
        }
        if (level < this.tgHierarchy.length - 2) {
            this.updateBoundaryLengthsUpOLD(level + 1, this.tgHierarchy[level].NDgetParent(uid), this.tgHierarchy[level].NDgetParent(vid));
        }
    }

    public void updateBoundaryLengthsUpSmart(int level, int uid, int fpid, int tpid) {
        ThinGraph g = this.tgHierarchy[level];
        ThinGraph gg = this.tgHierarchy[level + 1];
        int lenToRemoveFromTPID = 0;
        this.boundaryLengthIIHM.clear();
        int n = g.NDgetNumberOfNeighbors(uid);
        for (int ni = 0; ni < n; ++ni) {
            int nid = g.NDgetNeighbor(uid, ni);
            int npid = g.NDgetParent(nid);
            if (npid == tpid) {
                lenToRemoveFromTPID += g.NDgetBoundaryLength(uid, ni);
                continue;
            }
            int len = g.NDgetBoundaryLength(uid, ni);
            if (this.boundaryLengthIIHM.adjustValue(npid, len)) continue;
            this.boundaryLengthIIHM.put(npid, len);
        }
        int tnid = gg.NDlookupNeighborIndex(fpid, tpid);
        int fnid = gg.NDlookupNeighborIndex(tpid, fpid);
        gg.NDsubtractFromBoundaryLength(tpid, fnid, lenToRemoveFromTPID);
        gg.NDsubtractFromBoundaryLength(fpid, tnid, lenToRemoveFromTPID);
        this.updateSubtractToTop(level + 1, tpid, fpid, lenToRemoveFromTPID);
        TIntIntIterator iii = this.boundaryLengthIIHM.iterator();
        int i = this.boundaryLengthIIHM.size();
        while (i-- > 0) {
            int f;
            iii.advance();
            int pid = iii.key();
            int len = iii.value();
            int pnid = gg.NDlookupNeighborIndex(tpid, pid);
            if (pnid == -1) {
                gg.addEdge(tpid, pid, len);
            } else {
                gg.NDaddToBoundaryLength(tpid, pnid, len);
                int t = gg.NDlookupNeighborIndex(pid, tpid);
                gg.NDaddToBoundaryLength(pid, t, len);
            }
            this.updateAddToTop(level + 1, tpid, pid, len);
            if (fpid == pid || (f = gg.NDlookupNeighborIndex(fpid, pid)) == -1) continue;
            gg.NDsubtractFromBoundaryLength(fpid, f, len);
            f = gg.NDlookupNeighborIndex(pid, fpid);
            if (f == -1) continue;
            gg.NDsubtractFromBoundaryLength(pid, f, len);
            this.updateSubtractToTop(level + 1, fpid, pid, len);
        }
    }

    private void updateFindNewNeighborsViaChild(int level, int uid, int cgid) {
        int total = 0;
        this.newNgbFromChildIHS.clear();
        int ncn = this.tgHierarchy[level - 1].NDgetNumberOfNeighbors(cgid);
        for (int ncni = 0; ncni < ncn; ++ncni) {
            int ncnid = this.tgHierarchy[level - 1].NDgetNeighbor(cgid, ncni);
            int ncnip = this.tgHierarchy[level - 1].NDgetParent(ncnid);
            if (ncnip == uid || this.newNgbFromChildIHS.contains(ncnip)) continue;
            int nid = this.tgHierarchy[level].NDlookupNeighborIndex(uid, ncnip);
            if (nid == -1) {
                int len = 1;
                total += len;
                this.tgHierarchy[level].addEdge(uid, ncnip, len);
            }
            this.newNgbFromChildIHS.add(ncnip);
        }
    }

    protected void updateLikelihoodCachesUp(int shiftLv, int shiftLi, int shiftFromParentId, int shiftToParentId) {
        int c;
        if (shiftLv == 0) {
            for (c = 0; c < numClasses; ++c) {
                this.LBUF[c] = (float)this.computeLLAtLeavesCache(0, shiftLi, c);
                this.tgHierarchy[shiftLv + 1].NDsubtractFromLikelihood(shiftFromParentId, c, this.LBUF[c]);
                this.tgHierarchy[shiftLv + 1].NDaddToLikelihood(shiftToParentId, c, this.LBUF[c]);
            }
        } else {
            for (c = 0; c < numClasses; ++c) {
                this.LBUF[c] = this.tgHierarchy[shiftLv].NDgetLikelihood(shiftLi, c);
                this.tgHierarchy[shiftLv + 1].NDsubtractFromLikelihood(shiftFromParentId, c, this.LBUF[c]);
                this.tgHierarchy[shiftLv + 1].NDaddToLikelihood(shiftToParentId, c, this.LBUF[c]);
            }
        }
        int lvl = shiftLv + 1;
        int fp = shiftFromParentId;
        int tp = shiftToParentId;
        while (lvl < this.tgHierarchy.length - 2 && (fp = this.tgHierarchy[lvl].NDgetParent(fp)) != (tp = this.tgHierarchy[lvl].NDgetParent(tp))) {
            ++lvl;
            for (int c2 = 0; c2 < numClasses; ++c2) {
                this.tgHierarchy[lvl].NDsubtractFromLikelihood(fp, c2, this.LBUF[c2]);
                this.tgHierarchy[lvl].NDaddToLikelihood(tp, c2, this.LBUF[c2]);
            }
        }
    }

    private void updateShiftsDown(int level, int nodeId) {
        long shift = this.packShift(level, nodeId);
        this.shiftsTouched.add(shift);
        ++this.updateShiftsDownCount;
        int shiftTo = this.computeShift(level, nodeId);
        if (shiftTo >= 0) {
            this.shifts.add(shift);
        } else {
            this.shifts.remove(shift);
        }
        int uCI = this.tgHierarchy[level].NDgetClassIndex(nodeId);
        int unN = this.tgHierarchy[level].NDgetNumberOfNeighbors(nodeId);
        for (int uni = 0; uni < unN; ++uni) {
            int neighborId = this.tgHierarchy[level].NDgetNeighbor(nodeId, uni);
            if (level >= minSpawnLevel && neighborId == 0) continue;
            if (uCI == this.tgHierarchy[level].NDgetClassIndex(neighborId)) {
                this.shifts.remove(this.packShift(level, neighborId));
                continue;
            }
            shift = this.packShift(level, neighborId);
            if (this.shiftsTouched.contains(shift)) continue;
            shiftTo = this.computeShift(level, neighborId);
            shift = this.packShift(level, neighborId);
            if (shiftTo >= 0) {
                this.shifts.add(shift);
                continue;
            }
            this.shifts.remove(shift);
        }
        int clen = this.tgHierarchy[level].NDgetNumberOfChildren(nodeId);
        for (int i = 0; i < clen; ++i) {
            int ci = this.tgHierarchy[level].NDgetChild(nodeId, i);
            this.updateShiftsDown(level - 1, ci);
        }
    }

    private void updateShiftsUp(int level, int nodeId, int stopLevel) {
        int p;
        long shift = this.packShift(level, nodeId);
        this.shiftsTouched.add(shift);
        int shiftTo = this.computeShift(level, nodeId);
        if (shiftTo == -1) {
            this.shifts.remove(shift);
        } else {
            this.shifts.add(shift);
        }
        if (level < stopLevel && !this.shiftsTouched.contains(this.packShift(level + 1, p = this.tgHierarchy[level].NDgetParent(nodeId)))) {
            this.updateShiftsUp(level + 1, p, stopLevel);
        }
    }

    private void updateShiftsUpOLD(int level, int uid, int vid, int deltaLength) {
        float deltaWeight = (float)((double)deltaLength * this.lambdaSmooth);
        int vin = this.tgHierarchy[level].NDlookupNeighborIndex(uid, vid);
        if (vin == -1) {
            this.tgHierarchy[level].addEdge(uid, vid, deltaLength);
        } else {
            int len = this.tgHierarchy[level].NDgetBoundaryLength(uid, vin);
            this.tgHierarchy[level].NDsetBoundaryLength(uid, vin, len + deltaLength);
            int sid = this.tgHierarchy[level].NDgetGraphShiftIndex(uid);
            if (sid == vid) {
                float w = this.tgHierarchy[level].NDgetGraphShiftWeight(uid);
                this.tgHierarchy[level].NDsetGraphShiftWeight(uid, w + deltaWeight);
            }
            int uin = this.tgHierarchy[level].NDlookupNeighborIndex(vid, uid);
            if (uin != -1) {
                int len2 = this.tgHierarchy[level].NDgetBoundaryLength(vid, uin);
                this.tgHierarchy[level].NDsetBoundaryLength(vid, uin, len2 + deltaLength);
                int sid2 = this.tgHierarchy[level].NDgetGraphShiftIndex(vid);
                if (sid2 == uid) {
                    float w = this.tgHierarchy[level].NDgetGraphShiftWeight(vid);
                    this.tgHierarchy[level].NDsetGraphShiftWeight(vid, w + deltaWeight);
                }
            } else {
                o.printf("ERROR #2\n", new Object[0]);
            }
        }
        if (level < this.tgHierarchy.length - 2) {
            this.updateShiftsUpOLD(level + 1, this.tgHierarchy[level].NDgetParent(uid), this.tgHierarchy[level].NDgetParent(vid), deltaLength);
        }
    }

    private final void updateSubtractToTop(int level, int uid, int vid, int len) {
        int vpid;
        int upid;
        if (level < this.tgHierarchy.length - 2 && (upid = this.tgHierarchy[level].NDgetParent(uid)) != (vpid = this.tgHierarchy[level].NDgetParent(vid))) {
            int u = this.tgHierarchy[level + 1].NDlookupNeighborIndex(upid, vpid);
            int v = this.tgHierarchy[level + 1].NDlookupNeighborIndex(vpid, upid);
            if (u != -1) {
                this.tgHierarchy[level + 1].NDsubtractFromBoundaryLength(upid, u, len);
            }
            if (v != -1) {
                this.tgHierarchy[level + 1].NDsubtractFromBoundaryLength(vpid, v, len);
            }
            this.updateSubtractToTop(level + 1, upid, vpid, len);
        }
    }

    public static class LikelihoodMapSet {
        Image3PixelAccess[] maps;
        int classNum = 2;
        String fileString;

        private static ARGTYPE checkArgType(String a) {
            int lio = a.lastIndexOf("%");
            if (lio == -1) {
                return ARGTYPE.MULTILINE;
            }
            return ARGTYPE.STRINGFMT;
        }

        public LikelihoodMapSet(String mapfmt, int classNum, int dim) {
            if (dim != 2 && dim != 3) {
                throw new AssertionError((Object)("LikelihoodMapSet cannot initalization from dim " + dim));
            }
            this.fileString = mapfmt;
            this.classNum = classNum;
            System.out.printf("loading likelihood maps for appearance from disk\n", new Object[0]);
            this.maps = new Image3PixelAccess[classNum];
            ARGTYPE atype = LikelihoodMapSet.checkArgType(mapfmt);
            if (LikelihoodMapSet.checkArgType(mapfmt) == ARGTYPE.MULTILINE) {
                try {
                    int i = 0;
                    BufferedReader in = new BufferedReader(new FileReader(mapfmt));
                    String line = in.readLine();
                    while (line != null) {
                        this.maps[i++] = this.load(line, dim);
                        line = in.readLine();
                    }
                    in.close();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                for (int i = 0; i < classNum; ++i) {
                    this.maps[i] = this.load(String.format(this.fileString, i), dim);
                }
            }
            System.out.printf("loading likelihood maps done\n", new Object[0]);
        }

        private Image3PixelAccess load(String fn, int dim) {
            Image3PixelAccess loadedMap = null;
            if (dim == 3) {
                AnalyzeHeader hdr = new AnalyzeHeader(fn);
                loadedMap = hdr.loadFromDisk();
            } else {
                try {
                    PixelImage pi = ImageLoader.load((String)fn);
                    if (!(pi instanceof IntegerImage)) {
                        throw new AssertionError((Object)"Loaded LMS image is not IntegerImage??? FATAL\n");
                    }
                    loadedMap = new JIUIntegerImage_Image3PixelAccess_Adaptor((IntegerImage)pi);
                }
                catch (Exception e) {
                    System.out.println("Exception when reading " + fn);
                    e.printStackTrace();
                }
            }
            return loadedMap;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum ARGTYPE {
            STRINGFMT,
            MULTILINE;

        }
    }

    static class ImageData {
        String[] imagePaths;
        Image3PixelAccess[] images;
        boolean loaded = false;
        float IRangeMin = 0.0f;
        float IRangeMax = 1.0f;
        float IRangeScale = 1.0f;
        int dim;
        int w = -1;
        int h;
        int d;
        float weight;
        int datadim = 3;

        public static ImageData createFromCSFile(String path, int dim) {
            String[] typespecifier = new String[1];
            ArrayList<String> names = new ArrayList<String>();
            ImageData lidata = null;
            int w = -1;
            int h = -1;
            int d = -1;
            try {
                BufferedReader in = new BufferedReader(new FileReader(path));
                String line = in.readLine();
                in.close();
                String[] args = line.split(",");
                for (int i = 1; i < args.length; ++i) {
                    names.add(args[i]);
                }
                lidata = new ImageData(names.toArray(typespecifier));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            lidata.datadim = dim;
            return lidata;
        }

        public static ImageData createFromImage(String path, int dim) {
            String[] dummy = new String[]{path};
            ImageData lidata = new ImageData(dummy);
            lidata.datadim = dim;
            return lidata;
        }

        public static ImageData createFromMLFile(String path, int dim) {
            String[] typespecifier = new String[1];
            ArrayList<String> names = new ArrayList<String>();
            ImageData lidata = null;
            int w = -1;
            int h = -1;
            int d = -1;
            try {
                BufferedReader in = new BufferedReader(new FileReader(path));
                String line = in.readLine();
                line = in.readLine();
                while (line != null) {
                    names.add(line);
                    line = in.readLine();
                }
                in.close();
                lidata = new ImageData(names.toArray(typespecifier));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            lidata.datadim = dim;
            return lidata;
        }

        public ImageData(String[] p) {
            this.imagePaths = p;
            this.images = new Image3PixelAccess[this.imagePaths.length];
            this.dim = this.imagePaths.length;
            this.weight = 1 / this.dim;
        }

        public ImageData(String[] p, float Imin, float Imax) {
            this.imagePaths = p;
            this.images = new Image3PixelAccess[this.imagePaths.length];
            this.dim = this.imagePaths.length;
            this.weight = 1 / this.dim;
            this.IRangeMin = Imin;
            this.IRangeMax = Imax;
            this.IRangeScale = 1.0f / (this.IRangeMax - this.IRangeMin);
        }

        public int getDepth() {
            return this.d;
        }

        public int getDim() {
            return this.dim;
        }

        public int getHeight() {
            return this.h;
        }

        public Image3PixelAccess getImage(int i) {
            return this.images[i];
        }

        public int getWidth() {
            return this.w;
        }

        public boolean isDataLoaded() {
            return this.loaded;
        }

        public void loadData() {
            if (!this.loaded) {
                for (int i = 0; i < this.images.length; ++i) {
                    block10: {
                        System.out.printf("loading image %s\n", this.imagePaths[i]);
                        if (this.datadim == 3) {
                            AnalyzeHeader hdr = new AnalyzeHeader(this.imagePaths[i]);
                            this.images[i] = hdr.loadFromDisk();
                        } else if (this.datadim == 2) {
                            try {
                                PixelImage pi = ImageLoader.load((String)this.imagePaths[i]);
                                if (pi instanceof RGB24Image) {
                                    RGBToGrayConversion rgbtogray = new RGBToGrayConversion();
                                    rgbtogray.setOutputImage(null);
                                    rgbtogray.setInputImage(pi);
                                    rgbtogray.process();
                                    this.images[i] = new JIUIntegerImage_Image3PixelAccess_Adaptor((IntegerImage)rgbtogray.getOutputImage());
                                    break block10;
                                }
                                if (pi instanceof IntegerImage) {
                                    this.images[i] = new JIUIntegerImage_Image3PixelAccess_Adaptor((IntegerImage)pi);
                                    break block10;
                                }
                                throw new AssertionError((Object)"Loaded image is not IntegerImage??? FATAL\n");
                            }
                            catch (Exception e) {
                                System.out.println("Exception when reading " + this.imagePaths[i]);
                                e.printStackTrace();
                            }
                        } else {
                            throw new AssertionError((Object)String.format("Unable to load with data dimension of %d\n", this.datadim));
                        }
                    }
                    if (this.w == -1 || this.images[i].getWidth() == this.w && this.images[i].getHeight() == this.h && this.images[i].getDepth() == this.d) continue;
                    System.err.printf("band image %s of different dimensions than labels image??? %d,%d,%d  %d,%d,%d\n", this.imagePaths[i], this.images[i].getWidth(), this.images[i].getHeight(), this.images[i].getDepth(), this.w, this.h, this.d);
                }
                this.w = this.images[0].getWidth();
                this.h = this.images[0].getHeight();
                this.d = this.images[0].getDepth();
            }
        }

        public void setRange(float imin, float imax) {
            this.IRangeMin = imin;
            this.IRangeMax = imax;
            this.IRangeScale = 1.0f / (this.IRangeMax - this.IRangeMin);
        }

        public void unloadData() {
            this.loaded = false;
            for (int i = 0; i < this.images.length; ++i) {
                this.images[i] = null;
            }
        }
    }

    public static interface GraphShiftsInitializer {
        public HardGraphHierarchy initializeGraph(ImageData var1);
    }

    public static class EdgeSampleInitializer
    implements GraphShiftsInitializer {
        static final double kAlpha = -0.09;
        double cTau;
        ImageData image;
        int w;
        int h;
        int d;
        int wh;
        HardGraphHierarchy H;
        LikelihoodMapSet lms;
        int levelMax;
        double reductionFactor = 0.15;
        double lambda = 0.1;
        int minSpawnLevel = -1;

        public EdgeSampleInitializer(LikelihoodMapSet lms, int levelMax, double reductionFactor, double lambda, int minSpawnLevel) {
            this.lms = lms;
            this.levelMax = levelMax;
            this.reductionFactor = reductionFactor;
            this.lambda = lambda;
            this.minSpawnLevel = minSpawnLevel;
        }

        private ThinGraph coarsen(ThinGraph Gin, int level) {
            int num = Gin.getNumberOfNodes();
            if (num == 0) {
                return null;
            }
            ThinGraph Gout = new ThinGraph(Math.min(10000, num), 1, 1, numClasses);
            Random R = new Random(100L);
            if (level >= this.minSpawnLevel) {
                Gout.addNewNode();
            }
            TIntArrayList lookOnceFixer = new TIntArrayList(100);
            int maxNodeSize = (int)(1.0 / this.reductionFactor);
            TIntArrayList S = new TIntArrayList(maxNodeSize);
            for (int i = 0; i < num; ++i) {
                int j;
                if (Gin.NDgetParent(i) != -1) continue;
                ThinGraph.ThinGraphNode C = Gout.addNewNode();
                int Cid = C.getId();
                lookOnceFixer.clear();
                int intensity = 0;
                int mass = 0;
                int size = 0;
                S.reset();
                S.add(i);
                while (!S.isEmpty()) {
                    int iv = S.remove(0);
                    Gin.NDsetParent(iv, Cid);
                    Gout.NDaddChild(Cid, iv);
                    intensity += Gin.NDgetIntensityUnsigned(iv);
                    mass += Gin.NDgetMass(iv);
                    if (++size >= maxNodeSize) break;
                    int mum = Gin.NDgetNumberOfNeighbors(iv);
                    for (j = 0; j < mum; ++j) {
                        int iw = Gin.NDgetNeighbor(iv, j);
                        if (Gin.NDgetParent(iw) != -1) continue;
                        double data = Math.exp(-0.09 * Math.abs((double)Gin.NDgetIntensityUnsigned(iv) - (double)Gin.NDgetIntensityUnsigned(iw)));
                        data = this.lambda * 0.5 + (1.0 - this.lambda) * data;
                        if (R.nextDouble() < data) {
                            Gin.NDsetParent(iw, -2);
                            S.add(iw);
                            continue;
                        }
                        Gin.NDsetParent(iw, -3);
                        lookOnceFixer.add(iw);
                    }
                }
                int Sremaining = S.size();
                for (int iv = 0; iv < Sremaining; ++iv) {
                    Gin.NDsetParent(S.getQuick(iv), -1);
                }
                C.setIntensity((byte)(intensity / size));
                C.setMass(mass);
                int lOnceLen = lookOnceFixer.size();
                for (j = 0; j < lOnceLen; ++j) {
                    Gin.NDsetParent(lookOnceFixer.get(j), -1);
                }
            }
            TIntHashSet hash = new TIntHashSet();
            int Goutn = Gout.getNumberOfNodes();
            for (int i = 0; i < Goutn; ++i) {
                int inn = Gout.NDgetNumberOfNeighbors(i);
                hash.clear();
                hash.add(i);
                for (int cn = 0; cn < inn; ++cn) {
                    hash.add(Gout.NDgetNeighbor(i, cn));
                }
                int inc = Gout.NDgetNumberOfChildren(i);
                for (int ci = 0; ci < inc; ++ci) {
                    int cid = Gout.NDgetChild(i, ci);
                    int cidnn = Gin.NDgetNumberOfNeighbors(cid);
                    for (int cin = 0; cin < cidnn; ++cin) {
                        int cidni = Gin.NDgetNeighbor(cid, cin);
                        int parent = Gin.NDgetParent(cidni);
                        if (hash.contains(parent)) continue;
                        Gout.addEdge(i, parent);
                        hash.add(parent);
                    }
                }
            }
            return Gout;
        }

        private void computeNodeClassHistogram_A(HardGraphHierarchy H, int level, int[] clbuf, int node) {
            if (level == 0) {
                int z = (int)Math.floor((double)node / (double)this.wh);
                int y = (int)Math.floor((double)(node - z * this.wh) / (double)this.w);
                int x = (node - z * this.wh) % this.w;
                int n = this.lms.classNum;
                int besti = 0;
                int bestv = this.lms.maps[0].getPixelInt(x, y, z);
                for (int i = 1; i < n; ++i) {
                    int v = this.lms.maps[i].getPixelInt(x, y, z);
                    if (v <= bestv) continue;
                    bestv = v;
                    besti = i;
                }
                int n2 = besti;
                clbuf[n2] = clbuf[n2] + 1;
                return;
            }
            ThinGraph G = (ThinGraph)H.getLayer(level);
            int cn = G.NDgetNumberOfChildren(node);
            for (int i = 0; i < cn; ++i) {
                this.computeNodeClassHistogram_A(H, level - 1, clbuf, G.NDgetChild(node, i));
            }
        }

        private ThinGraph createTopLevelFull(HardGraphHierarchy H, ThinGraph g1) {
            int i;
            int gTopNum = numClasses;
            ThinGraph gTop = new ThinGraph(gTopNum, gTopNum, 1, numClasses);
            H.addGraph(gTop);
            for (int i2 = 0; i2 < gTopNum; ++i2) {
                ThinGraph.ThinGraphNode n = gTop.addNewNode();
                n.setClassIndex(i2);
            }
            SingleFloatArrayDataItem fadi = new SingleFloatArrayDataItem();
            int[] count = new int[gTopNum];
            int[] clbuf = new int[numClasses];
            for (i = 0; i < g1.getNumberOfNodes(); ++i) {
                Arrays.fill(clbuf, 0);
                this.computeNodeClassHistogram_A(H, H.getNumberOfLayers() - 2, clbuf, i);
                int idx = 0;
                for (int j = 1; j < gTopNum; ++j) {
                    idx = clbuf[j] > clbuf[idx] ? j : idx;
                }
                g1.NDsetClassIndex(i, idx);
                int n = idx;
                count[n] = count[n] + 1;
            }
            o.printf("checking if each top-level node has a child\n", new Object[0]);
            for (i = 0; i < gTopNum; ++i) {
                if (count[i] == 0) {
                    o.printf("need to fix for index %d\n", i);
                }
                o.printf("top layer %d has %d children\n", i, count[i]);
            }
            o.printf("linking the top layers and pushing class labels down\n", new Object[0]);
            for (i = 0; i < g1.getNumberOfNodes(); ++i) {
                int topi = g1.NDgetClassIndex(i);
                g1.NDsetParent(i, topi);
                gTop.NDaddChild(topi, i);
                this.pushClassIndexDown(i, topi, H.getNumberOfLayers() - 2);
            }
            return gTop;
        }

        public HardGraphHierarchy initializeGraph(ImageData image) {
            this.image = image;
            this.w = image.getWidth();
            this.h = image.getHeight();
            this.d = image.getDepth();
            this.wh = this.w * this.h;
            o.printf("EdgeSampleInitializer Class:  creating lattice graph\n", new Object[0]);
            ThinGraph voxelGraph = ThinGraph.createFromVolume(image.getImage(0));
            o.printf("EdgeSampleInitializer Class:  done creating lattice graph\n", new Object[0]);
            this.H = new HardGraphHierarchy();
            ThinGraph g1 = voxelGraph;
            this.H.addGraph(g1);
            int level = 1;
            System.out.printf("coarsening graph (%d nodes)\n", g1.getNumberOfNodes());
            if (this.levelMax != 0) {
                while (g1.getNumberOfNodes() > 6 * numClasses) {
                    g1 = this.coarsen(g1, level++);
                    this.H.addGraph(g1);
                    System.out.printf("coarsening graph (%d nodes)\n", g1.getNumberOfNodes());
                    if (this.H.getNumberOfLayers() <= this.levelMax) continue;
                }
            }
            ThinGraph gTop = this.createTopLevelFull(this.H, g1);
            int gTopNum = gTop.getNumberOfNodes();
            for (int i = 0; i < gTopNum; ++i) {
                int mass = 0;
                int nc = gTop.NDgetNumberOfChildren(i);
                for (int j = 0; j < nc; ++j) {
                    int ci = gTop.NDgetChild(i, j);
                    mass += g1.NDgetMass(ci);
                }
                gTop.NDsetMass(i, mass);
            }
            TIntIntHashMap iihm = new TIntIntHashMap(20);
            for (int i = 1; i < this.H.getNumberOfLayers(); ++i) {
                ThinGraph gi = (ThinGraph)this.H.getLayer(i);
                ThinGraph gi_ = (ThinGraph)this.H.getLayer(i - 1);
                int gin = gi.getNumberOfNodes();
                for (int gid = 0; gid < gin; ++gid) {
                    int cn = gi.NDgetNumberOfChildren(gid);
                    iihm.clear();
                    for (int cid = 0; cid < cn; ++cid) {
                        int ci = gi.NDgetChild(gid, cid);
                        int cin = gi_.NDgetNumberOfNeighbors(ci);
                        for (int cini = 0; cini < cin; ++cini) {
                            int len;
                            int nid = gi_.NDgetNeighbor(ci, cini);
                            int pid = gi_.NDgetParent(nid);
                            if (pid == gid || iihm.adjustValue(pid, len = gi_.NDgetBoundaryLength(ci, cini))) continue;
                            iihm.put(pid, len);
                        }
                    }
                    int nn = gi.NDgetNumberOfNeighbors(gid);
                    for (int ni = 0; ni < nn; ++ni) {
                        gi.NDsetBoundaryLength(gid, ni, iihm.get(gi.NDgetNeighbor(gid, ni)));
                    }
                }
            }
            iihm = null;
            return this.H;
        }

        private void pushClassIndexDown(int nodeIdx, int classIdx, int level) {
            ThinGraph G = (ThinGraph)this.H.getLayer(level);
            G.NDsetClassIndex(nodeIdx, classIdx);
            if (level == 0) {
                return;
            }
            int nc = G.NDgetNumberOfChildren(nodeIdx);
            for (int c = 0; c < nc; ++c) {
                int ci = G.NDgetChild(nodeIdx, c);
                this.pushClassIndexDown(ci, classIdx, level - 1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ARG0TYPE {
        JUSTIMAGE,
        MULTILINE,
        COMMASEP;

    }

    public static class BECContext
    implements FixedModelBinaryEnergyComputer {
        double[][] energy;

        public BECContext(double[][] energy) {
            this.energy = energy;
        }

        public BECContext(BufferedReader br) {
            try {
                String line = br.readLine();
                int dim = Integer.parseInt(line);
                this.energy = new double[dim][dim];
                for (int i = 0; i < dim; ++i) {
                    line = br.readLine();
                    String[] vals = line.split("\\s");
                    for (int j = 0; j < dim; ++j) {
                        this.energy[i][j] = Double.parseDouble(vals[j]);
                    }
                }
            }
            catch (IOException e) {
                System.err.println("IOException while reading the BEC context energy matrix");
                e.printStackTrace();
            }
        }

        public double computeEnergy(int length, int modelA, int modelB) {
            return (double)length * this.energy[modelA][modelB];
        }
    }

    public static class BECSmoothness
    implements FixedModelBinaryEnergyComputer {
        public double computeEnergy(int length, int modelA, int modelB) {
            return length * (1 - (modelA == modelB ? 1 : 0));
        }
    }

    public static interface FixedModelBinaryEnergyComputer {
        public double computeEnergy(int var1, int var2, int var3);
    }
}

