/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.ccb.graphshifts.image;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class Colormap {
    int[] map;

    protected Colormap() {
    }

    protected Colormap(int n) {
        this.map = new int[n];
    }

    public int getLength() {
        return this.map.length;
    }

    public int getColorAsIntARGB(int i) {
        return this.map[i];
    }

    public Color getColor(int i) {
        return new Color(this.map[i]);
    }

    public JMenuItem createInspectorMenuItem(String name) {
        JMenuItem item = new JMenuItem(name);
        item.addActionListener(new ColormapInspectorMenuItemActionListener(this));
        return item;
    }

    public JDialog showInspector() {
        return new DefaultColormapInspector(this);
    }

    public static Colormap createFromFile(String fn) {
        Colormap C = new Colormap(256);
        try {
            BufferedReader rdr = new BufferedReader(new FileReader(fn));
            int i = 0;
            int alpha = 255;
            while (i < 256 && rdr.ready()) {
                String L = rdr.readLine();
                String[] A = L.split("\\s");
                int r = Integer.parseInt(A[1]);
                int g = Integer.parseInt(A[2]);
                int b = Integer.parseInt(A[3]);
                C.map[i++] = alpha << 24 | r << 16 | g << 8 | b;
            }
            rdr.close();
        }
        catch (IOException e) {
            System.err.println("Could not read the colormap in " + fn + ", generating a random one instead\n");
            return Colormap.createRandom(256);
        }
        return C;
    }

    public static Colormap createFromMap(int[] map) {
        Colormap C = new Colormap();
        C.map = map;
        return C;
    }

    public static Colormap createLinear(int n, int startColor, int endColor, int alpha) {
        return Colormap.createLinear(n, new Color(startColor), new Color(endColor), alpha);
    }

    public static Colormap createLinear(int n, Color startColor, Color endColor, int alpha) {
        Colormap C = new Colormap(n);
        float[] A = new float[]{startColor.getRed(), startColor.getGreen(), startColor.getBlue()};
        float[] B = new float[]{endColor.getRed(), endColor.getGreen(), endColor.getBlue()};
        float[] D = new float[3];
        for (int i = 0; i < 3; ++i) {
            D[i] = B[i] - A[i];
        }
        float del = 1.0f / (float)n;
        for (int i = 0; i < n; ++i) {
            int r = (int)(A[0] + D[0] * (float)i * del);
            int g = (int)(A[1] + D[1] * (float)i * del);
            int b = (int)(A[2] + D[2] * (float)i * del);
            C.map[i] = alpha << 24 | r << 16 | g << 8 | b;
        }
        return C;
    }

    public static Colormap createRandom(int n) {
        return Colormap.createRandom(n, 255);
    }

    public static Colormap createRandom(int n, int alpha) {
        Colormap C = new Colormap(n);
        Random rand = new Random();
        for (int i = 0; i < n; ++i) {
            int r = rand.nextInt(255);
            int g = rand.nextInt(255);
            int b = rand.nextInt(255);
            C.map[i] = alpha << 24 | r << 16 | g << 8 | b;
        }
        return C;
    }

    private class DefaultColormapInspector
    extends JDialog {
        Colormap map;

        public DefaultColormapInspector(Colormap map) {
            this.map = map;
            this.setDefaultCloseOperation(2);
            this.setPreferredSize(new Dimension(320, 240));
            this.buildDialog();
            this.setTitle("Colormap Inspector");
            this.pack();
            this.setVisible(true);
        }

        private void buildDialog() {
            this.setLayout(new BorderLayout());
            JPanel colorPanel = new JPanel();
            colorPanel.setPreferredSize(new Dimension(300, 60));
            colorPanel.setLayout(new BoxLayout(colorPanel, 0));
            colorPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            Dimension wellD = new Dimension(300 / this.map.getLength(), 60);
            Font f = new Font("Sans Serif", 0, 8);
            for (int i = 0; i < this.map.getLength(); ++i) {
                JPanel well = new JPanel();
                well.setPreferredSize(wellD);
                well.setBackground(this.map.getColor(i));
                JLabel wellLabel = new JLabel(Integer.toString(i));
                wellLabel.setFont(f);
                well.add(wellLabel);
                colorPanel.add(well);
            }
            this.add((Component)colorPanel, "North");
        }
    }

    private class ColormapInspectorMenuItemActionListener
    implements ActionListener {
        Colormap map;

        public ColormapInspectorMenuItemActionListener(Colormap map) {
            this.map = map;
        }

        public void actionPerformed(ActionEvent e) {
            System.out.println("inspecting colormap");
            this.map.showInspector();
        }
    }
}

