/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.ccb.graphshifts.image;

import edu.ucla.ccb.graphshifts.data.Point3I;
import edu.ucla.ccb.graphshifts.image.Image3PixelAccess;
import edu.ucla.ccb.graphshifts.image.Image3Protocol;
import edu.ucla.ccb.graphshifts.image.JIUIntegerImage_Image3PixelAccess_Adaptor;
import edu.ucla.ccb.graphshifts.image.MemoryGray32Image;
import edu.ucla.ccb.graphshifts.image.ScalarImageB3;
import edu.ucla.ccb.graphshifts.image.ScalarImageF3;
import edu.ucla.ccb.graphshifts.image.ScalarImageI3;
import gnu.trove.TIntIntHashMap;
import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import net.sourceforge.jiu.codecs.CodecMode;
import net.sourceforge.jiu.codecs.ImageLoader;
import net.sourceforge.jiu.codecs.PNGCodec;
import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.MemoryGray8Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageUtilities {
    public static boolean check2D3DFilename(String fn) {
        int lio = fn.lastIndexOf(46);
        boolean useAnalyze = false;
        if (lio == -1) {
            useAnalyze = true;
        } else {
            String suffix = fn.substring(lio + 1, fn.length());
            if (suffix.equalsIgnoreCase("HDR") || suffix.equalsIgnoreCase("IMG")) {
                useAnalyze = true;
            }
        }
        if (!useAnalyze) {
            File f = new File(fn + ".hdr");
            File f2 = new File(fn + ".img");
            if (f.exists() || f2.exists()) {
                useAnalyze = true;
            }
        }
        return useAnalyze;
    }

    public static ScalarImageI3 applyIntegerMap(Image3PixelAccess I, HashMap<Integer, Integer> map) {
        ScalarImageI3 J = new ScalarImageI3(I.getWidth(), I.getHeight(), I.getDepth());
        for (int z = 0; z < I.getDepth(); ++z) {
            for (int y = 0; y < I.getHeight(); ++y) {
                for (int x = 0; x < I.getWidth(); ++x) {
                    int v = I.getPixelInt(x, y, z);
                    J.setPixelAt(x, y, z, map.get(v));
                }
            }
        }
        return J;
    }

    public static ScalarImageB3 applyIntegerMapByte(Image3PixelAccess I, HashMap<Integer, Integer> map) {
        ScalarImageB3 J = new ScalarImageB3(I.getWidth(), I.getHeight(), I.getDepth());
        for (int z = 0; z < I.getDepth(); ++z) {
            for (int y = 0; y < I.getHeight(); ++y) {
                for (int x = 0; x < I.getWidth(); ++x) {
                    int v = I.getPixelInt(x, y, z);
                    J.setPixelAt(x, y, z, map.get(v));
                }
            }
        }
        return J;
    }

    public static void applyMask(Image3PixelAccess I, Image3PixelAccess M, ScalarImageI3 O, int v) {
        int w = I.getWidth();
        int h = I.getHeight();
        int d = I.getDepth();
        for (int z = 0; z < d; ++z) {
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    O.setPixelAt(x, y, z, M.getPixelInt(x, y, z) == 0 ? v : I.getPixelInt(x, y, z));
                }
            }
        }
    }

    public static void clampI3toB3(ScalarImageI3 I, ScalarImageB3 B) {
        int w = I.getWidth();
        int h = I.getHeight();
        int d = I.getDepth();
        for (int z = 0; z < d; ++z) {
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    B.setPixelAt(x, y, z, I.getPixelInt(x, y, z));
                }
            }
        }
    }

    public static ScalarImageI3 convertF3toI3(ScalarImageF3 F) {
        ScalarImageI3 I = new ScalarImageI3(F.getWidth(), F.getHeight(), F.getDepth());
        for (int z = 0; z < F.getDepth(); ++z) {
            for (int y = 0; y < F.getHeight(); ++y) {
                for (int x = 0; x < F.getWidth(); ++x) {
                    I.setPixelAt(x, y, z, (int)F.getPixelValueAt(x, y, z));
                }
            }
        }
        return I;
    }

    public static BufferedImage createRedGreenChecks(int w, int h, float a) {
        int[] buf = new int[w * h];
        int s = 10;
        int aa = (int)(a * 255.0f);
        int red = aa << 24 | 0xFF0000;
        int green = aa << 24 | 0xFF00;
        for (int y = 0; y < h; ++y) {
            int yt = y / 10 & 1;
            for (int x = 0; x < w; ++x) {
                buf[y * w + x] = (yt ^ x / 10 & 1) == 1 ? red : green;
            }
        }
        DataBufferInt dbi = new DataBufferInt(buf, w * h);
        SinglePixelPackedSampleModel sppsm = new SinglePixelPackedSampleModel(3, w, h, w, new int[]{0xFF0000, 65280, 255, -16777216});
        Raster r = Raster.createRaster(sppsm, dbi, new Point(0, 0));
        BufferedImage I = new BufferedImage(w, h, 2);
        I.setData(r);
        return I;
    }

    public static Image3PixelAccess createMaskFromSet(Image3PixelAccess[] I, int value) {
        ScalarImageB3 mask = new ScalarImageB3(I[0].getWidth(), I[0].getHeight(), I[0].getDepth());
        for (int z = 0; z < I[0].getDepth(); ++z) {
            for (int y = 0; y < I[0].getHeight(); ++y) {
                for (int x = 0; x < I[0].getWidth(); ++x) {
                    int v = I[0].getPixelInt(x, y, z);
                    boolean maskIn = true;
                    for (int i = 0; i < I.length && maskIn; ++i) {
                        if (v != value) continue;
                        maskIn = false;
                    }
                    if (maskIn) {
                        mask.setPixelAt(x, y, z, 1);
                        continue;
                    }
                    mask.setPixelAt(x, y, z, 0);
                }
            }
        }
        return mask;
    }

    public static Image3PixelAccess crop_B3(Image3PixelAccess I, int xc, int yc, int zc) {
        int w = I.getWidth();
        int h = I.getHeight();
        int d = I.getDepth();
        int ww = w - 2 * xc;
        int hh = h - 2 * yc;
        int dd = d - 2 * zc;
        ScalarImageB3 O = new ScalarImageB3(ww, hh, dd);
        int z = zc;
        for (int zz = 0; zz < dd; ++zz) {
            int y = yc;
            for (int yy = 0; yy < hh; ++yy) {
                int x = xc;
                for (int xx = 0; xx < ww; ++xx) {
                    O.setPixelAt(xx, yy, zz, I.getPixelByte(x, y, z));
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        return O;
    }

    public static IntegerImage crop_2D_Gray(IntegerImage I, int xc, int yc) {
        int w = I.getWidth();
        int h = I.getHeight();
        int ww = w - 2 * xc;
        int hh = h - 2 * yc;
        MemoryGray8Image O = new MemoryGray8Image(ww, hh);
        int y = yc;
        for (int yy = 0; yy < hh; ++yy) {
            int x = xc;
            for (int xx = 0; xx < ww; ++xx) {
                O.putSample(xx, yy, I.getSample(x, y));
                ++x;
            }
            ++y;
        }
        return O;
    }

    public static Point3I getVoxelCoordsForIndex(int i, Image3Protocol I) {
        Point3I P = new Point3I();
        P.setZ((int)Math.floor((double)i / (double)(I.getWidth() * I.getHeight())));
        P.setY((int)Math.floor((double)(i - P.getZ() * I.getWidth() * I.getHeight()) / (double)I.getWidth()));
        P.setX((i - P.getZ() * I.getWidth() * I.getHeight()) % I.getWidth());
        return P;
    }

    public static ScalarImageB3 filterMedian5(ScalarImageB3 I) {
        int w = I.getWidth();
        int h = I.getHeight();
        int d = I.getDepth();
        ScalarImageB3 O = new ScalarImageB3(w, h, d);
        int[] vals = new int[125];
        for (int z = 2; z < d - 2; ++z) {
            for (int y = 2; y < h - 2; ++y) {
                for (int x = 2; x < w - 2; ++x) {
                    int i = 0;
                    for (int zz = z - 2; zz <= z + 2; ++zz) {
                        for (int yy = y - 2; yy <= y + 2; ++yy) {
                            int xx = x - 2;
                            while (xx <= x + 2) {
                                vals[i] = I.getPixelInt(xx, yy, zz);
                                ++xx;
                                ++i;
                            }
                        }
                    }
                    Arrays.sort(vals);
                    O.setPixelAt(x, y, z, vals[63]);
                }
            }
        }
        return O;
    }

    public static ScalarImageB3 filterMin(ScalarImageB3 I, int hw) {
        int w = I.getWidth();
        int h = I.getHeight();
        int d = I.getDepth();
        ScalarImageB3 O = new ScalarImageB3(w, h, d);
        for (int z = hw; z < d - hw; ++z) {
            for (int y = hw; y < h - hw; ++y) {
                for (int x = hw; x < w - hw; ++x) {
                    int i = 0;
                    int minv = 256;
                    for (int zz = z - hw; zz <= z + hw; ++zz) {
                        for (int yy = y - hw; yy <= y + hw; ++yy) {
                            int xx = x - hw;
                            while (xx <= x + hw) {
                                int v = I.getPixelInt(xx, yy, zz);
                                minv = v < minv ? v : minv;
                                ++xx;
                                ++i;
                            }
                        }
                    }
                    O.setPixelAt(x, y, z, minv);
                }
            }
        }
        return O;
    }

    public static ScalarImageB3 filterMin5(ScalarImageB3 I) {
        int w = I.getWidth();
        int h = I.getHeight();
        int d = I.getDepth();
        ScalarImageB3 O = new ScalarImageB3(w, h, d);
        for (int z = 2; z < d - 2; ++z) {
            for (int y = 2; y < h - 2; ++y) {
                for (int x = 2; x < w - 2; ++x) {
                    int i = 0;
                    int minv = 256;
                    for (int zz = z - 2; zz <= z + 2; ++zz) {
                        for (int yy = y - 2; yy <= y + 2; ++yy) {
                            int xx = x - 2;
                            while (xx <= x + 2) {
                                int v = I.getPixelInt(xx, yy, zz);
                                minv = v < minv ? v : minv;
                                ++xx;
                                ++i;
                            }
                        }
                    }
                    O.setPixelAt(x, y, z, minv);
                }
            }
        }
        return O;
    }

    public static ScalarImageB3 filterMin3(ScalarImageB3 I) {
        int w = I.getWidth();
        int h = I.getHeight();
        int d = I.getDepth();
        ScalarImageB3 O = new ScalarImageB3(w, h, d);
        for (int z = 1; z < d - 1; ++z) {
            for (int y = 1; y < h - 1; ++y) {
                for (int x = 1; x < w - 1; ++x) {
                    int i = 0;
                    int minv = 256;
                    for (int zz = z - 1; zz <= z + 1; ++zz) {
                        for (int yy = y - 1; yy <= y + 1; ++yy) {
                            int xx = x - 1;
                            while (xx <= x + 1) {
                                int v = I.getPixelInt(xx, yy, zz);
                                minv = v < minv ? v : minv;
                                ++xx;
                                ++i;
                            }
                        }
                    }
                    O.setPixelAt(x, y, z, minv);
                }
            }
        }
        return O;
    }

    public static Color intToColor(int clr) {
        float r = (float)((clr & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((clr & 0xFF00) >> 8) / 255.0f;
        float b = (float)(clr & 0xFF) / 255.0f;
        float a = (float)((clr & 0xFF000000) >> 24) / 255.0f;
        return new Color(r, g, b, a);
    }

    public static ScalarImageI3 makeCumulativeImageI(Image3PixelAccess I) {
        int x;
        int last;
        int z;
        int w = I.getWidth();
        int h = I.getHeight();
        int d = I.getDepth();
        ScalarImageI3 O = new ScalarImageI3(w + 1, h + 1, d + 1);
        Arrays.fill(O.getBuffer().getData(), 0);
        for (z = 0; z < d; ++z) {
            for (int y = 0; y < h; ++y) {
                last = 0;
                for (int x2 = 0; x2 < w; ++x2) {
                    O.setPixelAt(x2 + 1, y + 1, z + 1, last += I.getPixelInt(x2, y, z));
                }
            }
        }
        for (z = 1; z <= d; ++z) {
            for (x = 1; x <= w; ++x) {
                last = 0;
                for (int y = 1; y <= h; ++y) {
                    O.setPixelAt(x, y, z, last += O.getPixelInt(x, y, z));
                }
            }
        }
        for (int y = 1; y <= h; ++y) {
            for (x = 1; x <= w; ++x) {
                last = 0;
                for (int z2 = 1; z2 <= d; ++z2) {
                    O.setPixelAt(x, y, z2, last += O.getPixelInt(x, y, z2));
                }
            }
        }
        return O;
    }

    public static IntegerImage makeCumulativeImage(IntegerImage I) {
        int last;
        int w = I.getWidth();
        int h = I.getHeight();
        MemoryGray32Image O = new MemoryGray32Image(w + 1, h + 1);
        O.clear(0);
        for (int y = 0; y < h; ++y) {
            last = 0;
            for (int x = 0; x < w; ++x) {
                O.putSample(x + 1, y + 1, last += I.getSample(x, y));
            }
        }
        for (int x = 1; x <= w; ++x) {
            last = 0;
            for (int y = 1; y <= h; ++y) {
                O.putSample(x, y, last += O.getSample(x, y));
            }
        }
        return O;
    }

    public static IntegerImage[] makeCumulativeImage(RGB24Image I) {
        int lastb;
        int lastg;
        int lastr;
        int w = I.getWidth();
        int h = I.getHeight();
        IntegerImage[] out = new IntegerImage[3];
        MemoryGray32Image Or = new MemoryGray32Image(w + 1, h + 1);
        MemoryGray32Image Og = new MemoryGray32Image(w + 1, h + 1);
        MemoryGray32Image Ob = new MemoryGray32Image(w + 1, h + 1);
        Or.clear(0);
        Og.clear(0);
        Ob.clear(0);
        for (int y = 0; y < h; ++y) {
            lastr = 0;
            lastg = 0;
            lastb = 0;
            for (int x = 0; x < w; ++x) {
                Or.putSample(x + 1, y + 1, lastr += I.getSample(0, x, y));
                Og.putSample(x + 1, y + 1, lastg += I.getSample(1, x, y));
                Ob.putSample(x + 1, y + 1, lastb += I.getSample(2, x, y));
            }
        }
        for (int x = 1; x <= w; ++x) {
            lastr = 0;
            lastg = 0;
            lastb = 0;
            for (int y = 1; y <= h; ++y) {
                Or.putSample(x, y, lastr += Or.getSample(x, y));
                Og.putSample(x, y, lastg += Og.getSample(x, y));
                Ob.putSample(x, y, lastb += Ob.getSample(x, y));
            }
        }
        out[0] = Or;
        out[1] = Og;
        out[2] = Ob;
        return out;
    }

    public static int[] makeRandomizedColorMap(int n, int alpha) {
        Random rand = new Random();
        int[] colormap = new int[n];
        for (int i = 0; i < n; ++i) {
            int r = rand.nextInt(255);
            int g = rand.nextInt(255);
            int b = rand.nextInt(255);
            colormap[i] = alpha << 24 | r << 16 | g << 8 | b;
        }
        return colormap;
    }

    public static Image3PixelAccess readViaJIUTo3D(String filename) {
        try {
            System.out.println(filename);
            PixelImage pi = ImageLoader.load((String)filename);
            if (pi instanceof IntegerImage) {
                return new JIUIntegerImage_Image3PixelAccess_Adaptor((IntegerImage)pi);
            }
            throw new AssertionError((Object)"Loaded image is not IntegerImage??? FATAL\n");
        }
        catch (Exception e) {
            System.out.println("Exception when reading " + filename);
            e.printStackTrace();
            return null;
        }
    }

    public static ScalarImageF3 readViaImageIO(String filename) {
        try {
            File srcFile = new File(filename);
            if (!(srcFile.exists() && srcFile.isFile() && srcFile.canRead())) {
                System.out.println("Cannot read \"" + filename + "\"");
                System.exit(1);
            }
            return ImageUtilities.readViaImageIO(srcFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    public static ScalarImageF3 readViaImageIO(File srcFile) {
        ScalarImageF3 I = null;
        try {
            ImageReader imageReader;
            if (!(srcFile.exists() && srcFile.isFile() && srcFile.canRead())) {
                System.out.println("Cannot read \"" + srcFile.getPath() + "\"");
                System.exit(1);
            }
            if ((imageReader = ImageUtilities._getImageReader(srcFile)) == null) {
                System.out.println("Cannot decode \"" + srcFile.getPath() + "\"");
                System.exit(1);
            }
            int w = imageReader.getWidth(0);
            int h = imageReader.getHeight(0);
            int d = imageReader.getNumImages(true);
            System.out.println(w + "," + h + "," + d);
            I = new ScalarImageF3(w, h, d);
            float[] Idata = I.getBuffer();
            float[] Ibuf = new float[w * h];
            for (int i = 0; i < d; ++i) {
                BufferedImage srcImage = imageReader.read(i);
                Raster r = srcImage.getData();
                r.getSamples(0, 0, w, h, 0, Ibuf);
                System.arraycopy(Ibuf, 0, Idata, i * w * h, w * h);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        return I;
    }

    public static ScalarImageB3 readViaImageIO_B3(String filename) {
        try {
            File srcFile = new File(filename);
            if (!(srcFile.exists() && srcFile.isFile() && srcFile.canRead())) {
                System.out.println("Cannot read \"" + filename + "\"");
                System.exit(1);
            }
            return ImageUtilities.readViaImageIO_B3(srcFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    public static ScalarImageB3 readViaImageIO_B3(File srcFile) {
        ScalarImageF3 F = ImageUtilities.readViaImageIO(srcFile);
        ScalarImageB3 I = new ScalarImageB3(F.getWidth(), F.getHeight(), F.getDepth());
        for (int z = 0; z < F.getDepth(); ++z) {
            for (int y = 0; y < F.getHeight(); ++y) {
                for (int x = 0; x < F.getWidth(); ++x) {
                    I.setPixelAt(x, y, z, (byte)(255.0f * F.getPixelFloat(x, y, z)));
                }
            }
        }
        return I;
    }

    public static void remapBytes(Image3PixelAccess image, String str) {
        if (!(image instanceof ScalarImageB3)) {
            throw new AssertionError((Object)"image must be uchar\n");
        }
        ScalarImageB3 I = (ScalarImageB3)image;
        if (str.equals("0")) {
            return;
        }
        TIntIntHashMap map = new TIntIntHashMap();
        String[] vals = str.split(",");
        for (int i = 0; i < vals.length; ++i) {
            String[] m = vals[i].split("-");
            int a = Integer.parseInt(m[0]);
            int b = Integer.parseInt(m[1]);
            map.put(a, b);
        }
        int w = image.getWidth();
        int h = image.getHeight();
        int d = image.getDepth();
        for (int z = 0; z < d; ++z) {
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    int v = I.getPixelInt(x, y, z);
                    if (!map.contains(v)) continue;
                    I.setPixelAt(x, y, z, map.get(v));
                }
            }
        }
    }

    public static void writeGrayViaImageIO(byte[] buf, int w, int h, String fn, String ftype) {
        DataBufferByte dbi = new DataBufferByte(buf, w * h);
        SinglePixelPackedSampleModel sppsm = new SinglePixelPackedSampleModel(0, w, h, w, new int[]{255});
        Raster r = Raster.createRaster(sppsm, dbi, new Point(0, 0));
        BufferedImage I = new BufferedImage(w, h, 10);
        I.setData(r);
        try {
            ImageIO.write((RenderedImage)I, ftype, new File(fn));
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public static void writePGM(byte[] buf, int w, int h, String fn) {
        try {
            FileOutputStream fos = new FileOutputStream(fn);
            FileWriter fw = new FileWriter(fos.getFD());
            DataOutputStream dos = new DataOutputStream(fos);
            PrintWriter pw = new PrintWriter(fw);
            pw.printf("P5\n%d %d\n255\n", w, h);
            dos.write(buf, 0, w * h);
            fos.close();
        }
        catch (IOException e) {
            System.err.println("IOException while trying to writePGM");
        }
    }

    public static void writeDelIDataForLabel_F(Image3PixelAccess I, Image3PixelAccess L, Image3PixelAccess M, int l, String fn) {
        PrintStream out = null;
        try {
            out = new PrintStream(new BufferedOutputStream(new FileOutputStream(fn)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        for (int z = 0; z < I.getDepth(); ++z) {
            for (int y = 0; y < I.getHeight(); ++y) {
                for (int x = 0; x < I.getWidth(); ++x) {
                    if (M.getPixelInt(x, y, z) == 0 || L.getPixelInt(x, y, z) != l) continue;
                    int xx = x - 1;
                    int yy = y;
                    int zz = z;
                    if (xx > 0 && M.getPixelInt(xx, yy, zz) != 0 && L.getPixelInt(xx, yy, zz) == l) {
                        out.printf("%f\n", Float.valueOf(I.getPixelFloat(x, y, z) - I.getPixelFloat(xx, yy, zz)));
                    }
                    xx = x + 1;
                    yy = y;
                    zz = z;
                    if (xx < I.getWidth() && M.getPixelInt(xx, yy, zz) != 0 && L.getPixelInt(xx, yy, zz) == l) {
                        out.printf("%f\n", Float.valueOf(I.getPixelFloat(x, y, z) - I.getPixelFloat(xx, yy, zz)));
                    }
                    xx = x;
                    yy = y - 1;
                    zz = z;
                    if (yy > 0 && M.getPixelInt(xx, yy, zz) != 0 && L.getPixelInt(xx, yy, zz) == l) {
                        out.printf("%f\n", Float.valueOf(I.getPixelFloat(x, y, z) - I.getPixelFloat(xx, yy, zz)));
                    }
                    xx = x;
                    yy = y + 1;
                    zz = z;
                    if (yy < I.getHeight() && M.getPixelInt(xx, yy, zz) != 0 && L.getPixelInt(xx, yy, zz) == l) {
                        out.printf("%f\n", Float.valueOf(I.getPixelFloat(x, y, z) - I.getPixelFloat(xx, yy, zz)));
                    }
                    xx = x;
                    yy = y;
                    zz = z - 1;
                    if (zz > 0 && M.getPixelInt(xx, yy, zz) != 0 && L.getPixelInt(xx, yy, zz) == l) {
                        out.printf("%f\n", Float.valueOf(I.getPixelFloat(x, y, z) - I.getPixelFloat(xx, yy, zz)));
                    }
                    xx = x;
                    yy = y;
                    zz = z + 1;
                    if (zz >= I.getDepth() || M.getPixelInt(xx, yy, zz) == 0 || L.getPixelInt(xx, yy, zz) != l) continue;
                    out.printf("%f\n", Float.valueOf(I.getPixelFloat(x, y, z) - I.getPixelFloat(xx, yy, zz)));
                }
            }
        }
        out.close();
    }

    public static void writePixelDataForLabel_F(Image3PixelAccess I, Image3PixelAccess L, int l, String fn) {
        PrintStream out = null;
        try {
            out = new PrintStream(new BufferedOutputStream(new FileOutputStream(fn)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        for (int z = 0; z < I.getDepth(); ++z) {
            for (int y = 0; y < I.getHeight(); ++y) {
                for (int x = 0; x < I.getWidth(); ++x) {
                    if (L.getPixelInt(x, y, z) != l) continue;
                    out.printf("%f\n", Float.valueOf(I.getPixelFloat(x, y, z)));
                }
            }
        }
        out.close();
    }

    public static void writePixelDataForLabel_F(Image3PixelAccess I, Image3PixelAccess L, Image3PixelAccess M, int l, String fn) {
        PrintStream out = null;
        try {
            out = new PrintStream(new BufferedOutputStream(new FileOutputStream(fn)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        for (int z = 0; z < I.getDepth(); ++z) {
            for (int y = 0; y < I.getHeight(); ++y) {
                for (int x = 0; x < I.getWidth(); ++x) {
                    if (M.getPixelInt(x, y, z) == 0 || L.getPixelInt(x, y, z) != l) continue;
                    out.printf("%f\n", Float.valueOf(I.getPixelFloat(x, y, z)));
                }
            }
        }
        out.close();
    }

    public static void writeTwoClassDelIDataForLabel_F(Image3PixelAccess I, Image3PixelAccess L, Image3PixelAccess M, int l1, int l2, String fn) {
        PrintStream out = null;
        try {
            out = new PrintStream(new BufferedOutputStream(new FileOutputStream(fn)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        for (int z = 0; z < I.getDepth(); ++z) {
            for (int y = 0; y < I.getHeight(); ++y) {
                for (int x = 0; x < I.getWidth(); ++x) {
                    int lB;
                    if (M.getPixelInt(x, y, z) == 0) continue;
                    if (L.getPixelInt(x, y, z) == l1) {
                        lB = l2;
                    } else {
                        if (L.getPixelInt(x, y, z) != l2) continue;
                        lB = l1;
                    }
                    int xx = x + 1;
                    int yy = y;
                    int zz = z;
                    if (xx < I.getWidth() && M.getPixelInt(xx, yy, zz) != 0 && L.getPixelInt(xx, yy, zz) == lB) {
                        out.printf("%f\n", Float.valueOf(I.getPixelFloat(x, y, z) - I.getPixelFloat(xx, yy, zz)));
                    }
                    xx = x;
                    yy = y + 1;
                    zz = z;
                    if (yy < I.getHeight() && M.getPixelInt(xx, yy, zz) != 0 && L.getPixelInt(xx, yy, zz) == lB) {
                        out.printf("%f\n", Float.valueOf(I.getPixelFloat(x, y, z) - I.getPixelFloat(xx, yy, zz)));
                    }
                    xx = x;
                    yy = y;
                    zz = z + 1;
                    if (zz >= I.getDepth() || M.getPixelInt(xx, yy, zz) == 0 || L.getPixelInt(xx, yy, zz) != lB) continue;
                    out.printf("%f\n", Float.valueOf(I.getPixelFloat(x, y, z) - I.getPixelFloat(xx, yy, zz)));
                }
            }
        }
        out.close();
    }

    public static void writeViaImageIO_GraytoGenRandomLUT(byte[] buf, int w, int h, String fn, String ftype) {
        int[] ibuf = new int[w * h];
        byte n = 0;
        for (int i = 0; i < w * h; ++i) {
            if (buf[i] <= n) continue;
            n = buf[i];
        }
        int[] LUT = ImageUtilities.makeRandomizedColorMap(++n, 255);
        for (int i = 0; i < w * h; ++i) {
            ibuf[i] = LUT[buf[i]];
        }
        DataBufferInt dbi = new DataBufferInt(ibuf, w * h);
        SinglePixelPackedSampleModel sppsm = new SinglePixelPackedSampleModel(3, w, h, w, new int[]{0xFF0000, 65280, 255, -16777216});
        Raster r = Raster.createRaster(sppsm, dbi, new Point(0, 0));
        BufferedImage I = new BufferedImage(w, h, 2);
        I.setData(r);
        try {
            ImageIO.write((RenderedImage)I, ftype, new File(fn));
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public static void writeViaImageIO_GraytoGenRandomLUT(int[] buf, int w, int h, String fn, String ftype) {
        int[] ibuf = new int[w * h];
        int n = 0;
        for (int i = 0; i < w * h; ++i) {
            if (buf[i] <= n) continue;
            n = buf[i];
        }
        int[] LUT = ImageUtilities.makeRandomizedColorMap(++n, 255);
        for (int i = 0; i < w * h; ++i) {
            ibuf[i] = LUT[buf[i]];
        }
        DataBufferInt dbi = new DataBufferInt(ibuf, w * h);
        SinglePixelPackedSampleModel sppsm = new SinglePixelPackedSampleModel(3, w, h, w, new int[]{0xFF0000, 65280, 255, -16777216});
        Raster r = Raster.createRaster(sppsm, dbi, new Point(0, 0));
        BufferedImage I = new BufferedImage(w, h, 2);
        I.setData(r);
        try {
            ImageIO.write((RenderedImage)I, ftype, new File(fn));
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public static void writeViaImageIO_Gray2D(ScalarImageF3 I, float scale, String fileprefix, String filetype) {
        byte[] buf = new byte[I.getWidth() * I.getHeight()];
        for (int y = 0; y < I.getHeight(); ++y) {
            for (int x = 0; x < I.getWidth(); ++x) {
                buf[y * I.getWidth() + x] = (byte)(I.getPixelValueAt(x, y, 0) * scale);
            }
        }
        DataBufferByte dbi = new DataBufferByte(buf, I.getWidth() * I.getHeight());
        SinglePixelPackedSampleModel sppsm = new SinglePixelPackedSampleModel(0, I.getWidth(), I.getHeight(), I.getWidth(), new int[]{255});
        Raster r = Raster.createRaster(sppsm, dbi, new Point(0, 0));
        BufferedImage IB = new BufferedImage(I.getWidth(), I.getHeight(), 10);
        IB.setData(r);
        try {
            ImageIO.write((RenderedImage)IB, filetype, new File(fileprefix + "." + filetype));
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public static void writeViaImageIO_GraytoColor(byte[] buf, int w, int h, String fn, String ftype, int[] LUT) {
        int[] ibuf = new int[w * h];
        for (int i = 0; i < w * h; ++i) {
            ibuf[i] = LUT[buf[i]];
        }
        DataBufferInt dbi = new DataBufferInt(ibuf, w * h);
        SinglePixelPackedSampleModel sppsm = new SinglePixelPackedSampleModel(3, w, h, w, new int[]{0xFF0000, 65280, 255, -16777216});
        Raster r = Raster.createRaster(sppsm, dbi, new Point(0, 0));
        BufferedImage I = new BufferedImage(w, h, 2);
        I.setData(r);
        try {
            ImageIO.write((RenderedImage)I, ftype, new File(fn));
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public static void writeViaImageIO_GraytoColor(int[] buf, int w, int h, String fn, String ftype, int[] LUT) {
        int[] ibuf = new int[w * h];
        for (int i = 0; i < w * h; ++i) {
            ibuf[i] = LUT[buf[i]];
        }
        DataBufferInt dbi = new DataBufferInt(ibuf, w * h);
        SinglePixelPackedSampleModel sppsm = new SinglePixelPackedSampleModel(3, w, h, w, new int[]{0xFF0000, 65280, 255, -16777216});
        Raster r = Raster.createRaster(sppsm, dbi, new Point(0, 0));
        BufferedImage I = new BufferedImage(w, h, 2);
        I.setData(r);
        try {
            ImageIO.write((RenderedImage)I, ftype, new File(fn));
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public static void writeViaJIU(IntegerImage I, String fn) {
        PNGCodec codec = new PNGCodec();
        try {
            codec.setFile(fn, CodecMode.SAVE);
            codec.setImage((PixelImage)I);
            codec.process();
            codec.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeViaJIU(JIUIntegerImage_Image3PixelAccess_Adaptor I, String fn) {
        IntegerImage II = I.getUnderlyingImage();
        PNGCodec codec = new PNGCodec();
        try {
            codec.setFile(fn, CodecMode.SAVE);
            codec.setImage((PixelImage)II);
            codec.process();
            codec.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeViaJIU(Image3PixelAccess I, String fn, int axis, int slice) {
        int x;
        int y;
        MemoryGray8Image G;
        int w = I.getWidth();
        int h = I.getHeight();
        int d = I.getDepth();
        if (axis == 0) {
            int ww = w;
            int hh = h;
            G = new MemoryGray8Image(ww, hh);
            for (y = 0; y < hh; ++y) {
                for (x = 0; x < ww; ++x) {
                    int v = I.getPixelInt(x, y, slice);
                    G.putSample(x, y, v);
                }
            }
        } else if (axis == 1) {
            int ww = d;
            int hh = h;
            G = new MemoryGray8Image(ww, hh);
            for (y = 0; y < hh; ++y) {
                for (x = 0; x < ww; ++x) {
                    int v = I.getPixelInt(slice, y, x);
                    G.putSample(x, y, v);
                }
            }
        } else {
            int ww = w;
            int hh = d;
            G = new MemoryGray8Image(ww, hh);
            for (y = 0; y < hh; ++y) {
                for (x = 0; x < ww; ++x) {
                    int v = I.getPixelInt(x, slice, y);
                    G.putSample(x, y, v);
                }
            }
        }
        PNGCodec codec = new PNGCodec();
        try {
            codec.setFile(fn, CodecMode.SAVE);
            codec.setImage((PixelImage)G);
            codec.process();
            codec.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeRaw(ScalarImageF3 I, String FN) {
        try {
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(FN)));
            float[] buf = I.getBuffer();
            for (int i = 0; i < buf.length; ++i) {
                dos.writeFloat(buf[i]);
            }
            dos.close();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static ImageReader _getImageReader(File file) throws IOException {
        Object input = new FileImageInputStream(file);
        FileImageInputStream origInput = input;
        Iterator<ImageReader> iter = ImageIO.getImageReaders(input);
        if (!iter.hasNext() && !(iter = ImageIO.getImageReaders(input = file)).hasNext()) {
            input = origInput;
            String temp = file.getName();
            String[] strings = temp.split("\\.");
            if (strings.length > 1) {
                iter = ImageIO.getImageReadersBySuffix(strings[strings.length - 1]);
            }
            if (!iter.hasNext()) {
                return null;
            }
        }
        ImageReader imageReader = iter.next();
        imageReader.setInput(input);
        return imageReader;
    }

    private static ImageWriter _getImageWriter(ImageReader imageReader, String baseFileName) throws IOException {
        ImageWriter imageWriter = ImageIO.getImageWriter(imageReader);
        if (imageWriter == null) {
            return null;
        }
        ImageWriterSpi writerSpi = imageWriter.getOriginatingProvider();
        Class<?>[] outputTypes = writerSpi.getOutputTypes();
        for (int i = 0; i < outputTypes.length; ++i) {
            if (outputTypes[i] == ImageOutputStream.class) {
                File outputFile = new File(baseFileName);
                imageWriter.setOutput(new FileImageOutputStream(outputFile));
                return imageWriter;
            }
            if (outputTypes[i] != Vector.class) continue;
            Vector<FileImageOutputStream> outputStreams = new Vector<FileImageOutputStream>();
            File hdrFile = new File(baseFileName + ".hdr");
            File imgFile = new File(baseFileName + ".img");
            outputStreams.add(new FileImageOutputStream(hdrFile));
            outputStreams.add(new FileImageOutputStream(imgFile));
            imageWriter.setOutput(outputStreams);
            return imageWriter;
        }
        return null;
    }

    private static ImageWriter _getAnalyzeImageWriter(String baseFileName) throws IOException {
        Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName("analyze");
        if (!it.hasNext()) {
            System.err.println("Could not find the Analyze PLUGIN for writing...");
            return null;
        }
        ImageWriter imageWriter = it.next();
        if (imageWriter == null) {
            return null;
        }
        ImageWriterSpi writerSpi = imageWriter.getOriginatingProvider();
        Class<?>[] outputTypes = writerSpi.getOutputTypes();
        for (int i = 0; i < outputTypes.length; ++i) {
            if (outputTypes[i] == ImageOutputStream.class) {
                File outputFile = new File(baseFileName);
                imageWriter.setOutput(new FileImageOutputStream(outputFile));
                return imageWriter;
            }
            if (outputTypes[i] != Vector.class) continue;
            Vector<FileImageOutputStream> outputStreams = new Vector<FileImageOutputStream>();
            File hdrFile = new File(baseFileName + ".hdr");
            File imgFile = new File(baseFileName + ".img");
            outputStreams.add(new FileImageOutputStream(hdrFile));
            outputStreams.add(new FileImageOutputStream(imgFile));
            imageWriter.setOutput(outputStreams);
            return imageWriter;
        }
        return null;
    }

    public static void displayMetadata(Node root) {
        ImageUtilities.displayMetadata(root, 0);
    }

    static void indent(int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("  ");
        }
    }

    static void displayMetadata(Node node, int level) {
        Node child;
        ImageUtilities.indent(level);
        System.out.print("<" + node.getNodeName());
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            int length = map.getLength();
            for (int i = 0; i < length; ++i) {
                Node attr = map.item(i);
                System.out.print(" " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
            }
        }
        if ((child = node.getFirstChild()) != null) {
            System.out.println(">");
            while (child != null) {
                ImageUtilities.displayMetadata(child, level + 1);
                child = child.getNextSibling();
            }
            ImageUtilities.indent(level);
            System.out.println("</" + node.getNodeName() + ">");
        } else {
            System.out.println("/>");
        }
    }
}

