/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.ccb.graphshifts.image;

import edu.ucla.ccb.graphshifts.data.Point3D;
import edu.ucla.ccb.graphshifts.image.Colormap;
import edu.ucla.ccb.graphshifts.image.Image3PixelAccess;
import edu.ucla.ccb.graphshifts.image.Image3Protocol;
import edu.ucla.ccb.graphshifts.image.ImageLabelSet;
import edu.ucla.ccb.graphshifts.image.ImageUtilities;
import edu.ucla.ccb.graphshifts.image.ScalarImageF3;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ScalarImageB3
implements Image3Protocol,
Image3PixelAccess {
    protected int width;
    protected int height;
    protected int depth;
    protected int wh;
    protected int minVal = 0;
    protected int maxVal = 255;
    protected float scaledMinVal = 0.0f;
    protected float scaledMaxVal = 255.0f;
    protected DataBufferByte buffer;
    protected ComponentSampleModel sampleModelXY;
    protected ComponentSampleModel sampleModelXZ;
    protected ComponentSampleModel sampleModelZY;
    protected SampleModel[] sampleModelsXY;
    protected SampleModel[] sampleModelsXZ;
    protected SampleModel[] sampleModelsZY;
    protected WritableRaster[] rastersXY;
    protected WritableRaster[] rastersXZ;
    protected WritableRaster[] rastersZY;
    protected BufferedImage imageXY;
    protected BufferedImage imageXZ;
    protected BufferedImage imageZY;
    protected WritableRaster imageXYRaster;
    protected WritableRaster imageXZRaster;
    protected WritableRaster imageZYRaster;
    protected ImageLabelSet labels = null;
    protected int lastXYSlice = -1;
    protected int lastXZSlice = -1;
    protected int lastZYSlice = -1;
    private int sliceOrientation = 0;
    protected boolean scaleBySlice = true;

    public static ScalarImageB3 readFromFilePath(String path) {
        ScalarImageF3 image = ImageUtilities.readViaImageIO(path);
        ScalarImageB3 label = new ScalarImageB3(image.getWidth(), image.getHeight(), image.getDepth());
        for (int z = 0; z < image.getDepth(); ++z) {
            for (int y = 0; y < image.getHeight(); ++y) {
                for (int x = 0; x < image.getWidth(); ++x) {
                    label.setPixelAt(x, y, z, (int)image.getPixelValueAt(x, y, z));
                }
            }
        }
        return label;
    }

    public ScalarImageB3(int w, int h, int d) {
        this.width = w;
        this.height = h;
        this.depth = d;
        this.wh = this.width * this.height;
        this.buffer = new DataBufferByte(w * h * d);
        this.initializeBuffers(w, h, d);
    }

    public ScalarImageB3(int w, int h, int d, byte[] buffer) {
        this.width = w;
        this.height = h;
        this.depth = d;
        this.wh = this.width * this.height;
        this.buffer = new DataBufferByte(buffer, w * h * d);
        this.initializeBuffers(w, h, d);
    }

    public void computeMinMax() {
        this.minVal = Integer.MAX_VALUE;
        this.maxVal = Integer.MIN_VALUE;
        for (int z = 0; z < this.depth; ++z) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int val = this.getPixelInt(x, y, z);
                    if (val < this.minVal) {
                        this.minVal = val;
                    }
                    if (val <= this.maxVal) continue;
                    this.maxVal = val;
                }
            }
        }
    }

    public void debugCheckSample(int x, int y, int z) {
        System.out.println("checking the pixel in raster XY " + this.rastersXY[z].getSample(x, y, 0));
        System.out.println("checking the pixel in raster XZ " + this.rastersXZ[y].getSample(x, z, 0));
        System.out.println("checking the pixel in raster YZ " + this.rastersZY[x].getSample(z, y, 0));
        System.out.println("checking pixel in csmXY + buffer " + this.sampleModelXY.getSample(x, y, z, this.buffer));
        System.out.println("checking pixel in csmXZ + buffer " + this.sampleModelXZ.getSample(x, z, y, this.buffer));
        System.out.println("checking pixel in csmYZ + buffer " + this.sampleModelZY.getSample(z, y, x, this.buffer));
    }

    public final short getBitsPerPixel() {
        return 8;
    }

    public DataBufferByte getBuffer() {
        return this.buffer;
    }

    public Colormap getColormap() {
        return null;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getHeight() {
        return this.height;
    }

    public float getMaxValue() {
        return this.maxVal;
    }

    public float getMinValue() {
        return this.minVal;
    }

    public int getNumberOfSlices() {
        if (this.sliceOrientation == 0) {
            return this.depth;
        }
        if (this.sliceOrientation == 1) {
            return this.width;
        }
        return this.height;
    }

    public final Object getPixel(int x, int y, int z) {
        return this.buffer.getElem(z * this.wh + y * this.width + x);
    }

    public final byte getPixelByte(int x, int y, int z) {
        return (byte)this.buffer.getElem(z * this.wh + y * this.width + x);
    }

    public final float getPixelFloat(int x, int y, int z) {
        return 0xFF & this.buffer.getElem(z * this.wh + y * this.width + x);
    }

    public final int getPixelInt(int x, int y, int z) {
        return 0xFF & this.buffer.getElem(z * this.wh + y * this.width + x);
    }

    public final short getPixelShort(int x, int y, int z) {
        return (short)(0xFF & this.buffer.getElem(z * this.wh + y * this.width + x));
    }

    public int getPixelValueAt(int x, int y, int z) {
        return 0xFF & this.buffer.getElem(z * this.wh + y * this.width + x);
    }

    public int getPixelValueAt(Point3D P) {
        return this.getPixelValueAt((int)P.getX(), (int)P.getY(), (int)P.getZ());
    }

    public BufferedImage getSlice(int i) {
        if (this.sliceOrientation == 0) {
            this.lastXYSlice = i;
            if (!this.scaleBySlice) {
                this.imageXY.setData(this.rastersXY[i]);
            } else {
                int smi = 256;
                int sma = -1;
                for (int y = 0; y < this.height; ++y) {
                    for (int x = 0; x < this.width; ++x) {
                        int f = this.getPixelInt(x, y, i);
                        sma = f > sma ? f : sma;
                        smi = f < smi && f > 0 ? f : smi;
                    }
                }
                float scale = 255.0f / (float)(sma - smi);
                for (int y = 0; y < this.height; ++y) {
                    for (int x = 0; x < this.width; ++x) {
                        byte b = (byte)Math.floor((this.getPixelFloat(x, y, i) - (float)smi) * scale);
                        this.imageXYRaster.setSample(x, y, 0, b);
                    }
                }
            }
            return this.imageXY;
        }
        if (this.sliceOrientation == 2) {
            this.lastXZSlice = i;
            this.imageXZ.setData(this.rastersXZ[i]);
            return this.imageXZ;
        }
        this.lastZYSlice = i;
        this.imageZY.setData(this.rastersZY[i]);
        return this.imageZY;
    }

    public int getSliceOrientation() {
        return this.sliceOrientation;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean hasColormap() {
        return false;
    }

    private void initializeBuffers(int w, int h, int d) {
        int i;
        int i2;
        int[] bandOffsets = new int[d];
        for (i2 = 0; i2 < d; ++i2) {
            bandOffsets[i2] = i2 * this.wh;
        }
        this.sampleModelXY = new ComponentSampleModel(0, w, h, 1, w, bandOffsets);
        bandOffsets = new int[h];
        for (i2 = 0; i2 < h; ++i2) {
            bandOffsets[i2] = i2 * w;
        }
        this.sampleModelXZ = new ComponentSampleModel(0, w, d, 1, this.wh, bandOffsets);
        bandOffsets = new int[w];
        for (i2 = 0; i2 < w; ++i2) {
            bandOffsets[i2] = i2;
        }
        this.sampleModelZY = new ComponentSampleModel(0, d, h, this.wh, w, bandOffsets);
        int[] band = new int[1];
        this.sampleModelsXY = new ComponentSampleModel[d];
        for (i = 0; i < d; ++i) {
            band[0] = i;
            this.sampleModelsXY[i] = this.sampleModelXY.createSubsetSampleModel(band);
        }
        this.sampleModelsXZ = new ComponentSampleModel[h];
        for (i = 0; i < h; ++i) {
            band[0] = i;
            this.sampleModelsXZ[i] = this.sampleModelXZ.createSubsetSampleModel(band);
        }
        this.sampleModelsZY = new ComponentSampleModel[w];
        for (i = 0; i < w; ++i) {
            band[0] = i;
            this.sampleModelsZY[i] = this.sampleModelZY.createSubsetSampleModel(band);
        }
        this.rastersXY = new WritableRaster[d];
        for (i = 0; i < d; ++i) {
            this.rastersXY[i] = Raster.createWritableRaster(this.sampleModelsXY[i], this.buffer, null);
        }
        this.rastersXZ = new WritableRaster[h];
        for (i = 0; i < h; ++i) {
            this.rastersXZ[i] = Raster.createWritableRaster(this.sampleModelsXZ[i], this.buffer, null);
        }
        this.rastersZY = new WritableRaster[w];
        for (i = 0; i < w; ++i) {
            this.rastersZY[i] = Raster.createWritableRaster(this.sampleModelsZY[i], this.buffer, null);
        }
        this.imageXY = new BufferedImage(w, h, 10);
        this.imageXZ = new BufferedImage(w, d, 10);
        this.imageZY = new BufferedImage(d, h, 10);
        this.imageXYRaster = this.imageXY.getRaster();
        this.imageXZRaster = this.imageXZ.getRaster();
        this.imageZYRaster = this.imageZY.getRaster();
    }

    public final boolean isValidVoxel(int x, int y, int z) {
        return x >= 0 && x < this.width && y >= 0 && y < this.height && z >= 0 && z < this.depth;
    }

    public final boolean isValidVoxel(Point3D P) {
        return this.isValidVoxel((int)P.getX(), (int)P.getY(), (int)P.getZ());
    }

    public void setMaxValue(int M) {
        this.maxVal = M;
    }

    public void setMinValue(int M) {
        this.minVal = M;
    }

    public void setPixelAt(int x, int y, int z, byte b) {
        this.buffer.setElem(z * this.wh + y * this.width + x, b);
        if (this.lastXYSlice == z) {
            this.imageXYRaster.setSample(x, y, 0, b);
        }
        if (this.lastXZSlice == y) {
            this.imageXZRaster.setSample(x, z, 0, b);
        }
        if (this.lastZYSlice == x) {
            this.imageZYRaster.setSample(z, y, 0, b);
        }
    }

    public void setPixelAt(int x, int y, int z, int b) {
        this.setPixelAt(x, y, z, (byte)b);
    }

    public void setScaledIntensity(float a, float b) {
        this.scaledMinVal = a;
        this.scaledMaxVal = b;
    }

    public void setSliceOrientation(int O) {
        this.sliceOrientation = O;
    }

    public void writeToGzipMatrix(String fn) {
        try {
            ObjectOutputStream s = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(fn)));
            s.writeByte(3);
            s.writeShort(this.width);
            s.writeShort(this.height);
            s.writeShort(this.depth);
            s.writeObject(this.buffer.getData());
            s.close();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ScalarImageB3 readGzipMatrix(String fn) {
        byte[] buf;
        short d;
        short h;
        short w;
        try {
            ObjectInputStream s = new ObjectInputStream(new GZIPInputStream(new FileInputStream(fn)));
            byte dim = s.readByte();
            if (dim != 3) {
                throw new AssertionError((Object)"Cannot read gzip matrices of dimension other than 3");
            }
            w = s.readShort();
            h = s.readShort();
            d = s.readShort();
            buf = (byte[])s.readObject();
            s.close();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        return new ScalarImageB3(w, h, d, buf);
    }
}

