/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.ccb.graphshifts.image;

import edu.ucla.ccb.graphshifts.Segmentation;
import edu.ucla.ccb.graphshifts.data.Point3D;
import edu.ucla.ccb.graphshifts.image.Colormap;
import edu.ucla.ccb.graphshifts.image.Image3PixelAccess;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public class ScalarImageI3
implements Image3PixelAccess,
Cloneable,
Segmentation {
    protected int width;
    protected int height;
    protected int depth;
    protected int wh;
    private int minVal_ = Integer.MAX_VALUE;
    private int maxVal_ = Integer.MIN_VALUE;
    protected DataBufferInt buffer;
    protected ComponentSampleModel sampleModelXY;
    protected ComponentSampleModel sampleModelXZ;
    protected ComponentSampleModel sampleModelZY;
    protected SampleModel[] sampleModelsXY;
    protected SampleModel[] sampleModelsXZ;
    protected SampleModel[] sampleModelsZY;
    protected WritableRaster[] rastersXY;
    protected WritableRaster[] rastersXZ;
    protected WritableRaster[] rastersZY;
    protected BufferedImage imageXY;
    protected BufferedImage imageXZ;
    protected BufferedImage imageZY;
    protected WritableRaster imageXYRaster;
    protected WritableRaster imageXZRaster;
    protected WritableRaster imageZYRaster;
    protected DataBufferInt imageXYbuffer;
    protected DataBufferInt imageXZbuffer;
    protected DataBufferInt imageZYbuffer;
    protected IndexColorModel colorModel = null;
    protected int lastXYSlice = -1;
    protected int lastXZSlice = -1;
    protected int lastZYSlice = -1;
    private boolean imageIsStaticBool = false;
    private boolean imageIsARGBPacked = false;
    private int sliceOrientation = 0;
    protected boolean hasColormap = false;
    protected Colormap theColormap = null;
    protected boolean scaleBySlice = true;

    public ScalarImageI3(int w, int h, int d, int[] data) {
        this.width = w;
        this.height = h;
        this.depth = d;
        this.wh = this.width * this.height;
        this.buffer = new DataBufferInt(data, w * h * d);
        this.initializeBuffers(w, h, d);
    }

    public ScalarImageI3(int w, int h, int d) {
        this.width = w;
        this.height = h;
        this.depth = d;
        this.wh = this.width * this.height;
        this.buffer = new DataBufferInt(w * h * d);
        this.initializeBuffers(w, h, d);
    }

    private void initializeBuffers(int w, int h, int d) {
        int i;
        int i2;
        int[] bandOffsets = new int[d];
        for (i2 = 0; i2 < d; ++i2) {
            bandOffsets[i2] = i2 * this.wh;
        }
        this.sampleModelXY = new ComponentSampleModel(3, w, h, 1, w, bandOffsets);
        bandOffsets = new int[h];
        for (i2 = 0; i2 < h; ++i2) {
            bandOffsets[i2] = i2 * w;
        }
        this.sampleModelXZ = new ComponentSampleModel(3, w, d, 1, this.wh, bandOffsets);
        bandOffsets = new int[w];
        for (i2 = 0; i2 < w; ++i2) {
            bandOffsets[i2] = i2;
        }
        this.sampleModelZY = new ComponentSampleModel(3, d, h, this.wh, w, bandOffsets);
        int[] band = new int[1];
        this.sampleModelsXY = new ComponentSampleModel[d];
        for (i = 0; i < d; ++i) {
            band[0] = i;
            this.sampleModelsXY[i] = this.sampleModelXY.createSubsetSampleModel(band);
        }
        this.sampleModelsXZ = new ComponentSampleModel[h];
        for (i = 0; i < h; ++i) {
            band[0] = i;
            this.sampleModelsXZ[i] = this.sampleModelXZ.createSubsetSampleModel(band);
        }
        this.sampleModelsZY = new ComponentSampleModel[w];
        for (i = 0; i < w; ++i) {
            band[0] = i;
            this.sampleModelsZY[i] = this.sampleModelZY.createSubsetSampleModel(band);
        }
        this.rastersXY = new WritableRaster[d];
        for (i = 0; i < d; ++i) {
            this.rastersXY[i] = Raster.createWritableRaster(this.sampleModelsXY[i], this.buffer, null);
        }
        this.rastersXZ = new WritableRaster[h];
        for (i = 0; i < h; ++i) {
            this.rastersXZ[i] = Raster.createWritableRaster(this.sampleModelsXZ[i], this.buffer, null);
        }
        this.rastersZY = new WritableRaster[w];
        for (i = 0; i < w; ++i) {
            this.rastersZY[i] = Raster.createWritableRaster(this.sampleModelsZY[i], this.buffer, null);
        }
        this.imageXY = new BufferedImage(w, h, 10);
        this.imageXZ = new BufferedImage(w, d, 10);
        this.imageZY = new BufferedImage(d, h, 10);
        this.imageXYRaster = this.imageXY.getRaster();
        this.imageXZRaster = this.imageXZ.getRaster();
        this.imageZYRaster = this.imageZY.getRaster();
    }

    private void initializePackedARGBBuffers() {
        int[] bandLUT = new int[]{0xFF0000, 65280, 255, -16777216};
        ColorModel cm = ColorModel.getRGBdefault();
        Hashtable ht = new Hashtable();
        this.imageXYbuffer = new DataBufferInt(this.width * this.height);
        SinglePixelPackedSampleModel sppsm = new SinglePixelPackedSampleModel(3, this.width, this.height, bandLUT);
        WritableRaster r = Raster.createWritableRaster(sppsm, this.imageXYbuffer, new Point(0, 0));
        this.imageXY = new BufferedImage(cm, r, false, ht);
        this.imageXZbuffer = new DataBufferInt(this.width * this.depth);
        sppsm = new SinglePixelPackedSampleModel(3, this.width, this.depth, bandLUT);
        r = Raster.createWritableRaster(sppsm, this.imageXZbuffer, new Point(0, 0));
        this.imageXZ = new BufferedImage(cm, r, false, ht);
        this.imageZYbuffer = new DataBufferInt(this.depth * this.height);
        sppsm = new SinglePixelPackedSampleModel(3, this.depth, this.height, bandLUT);
        r = Raster.createWritableRaster(sppsm, this.imageZYbuffer, new Point(0, 0));
        this.imageZY = new BufferedImage(cm, r, false, ht);
        this.imageXYRaster = null;
        this.imageXZRaster = null;
        this.imageZYRaster = null;
    }

    public void applyColormap(Colormap colormap) {
        this.imageIsARGBPacked = true;
        this.initializePackedARGBBuffers();
        this.theColormap = colormap;
        this.hasColormap = true;
        int gray = colormap.getColorAsIntARGB(0) >>> 24 << 24 | 0xCCCCCC;
        for (int z = 0; z < this.depth; ++z) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int idx = this.getPixelValueAt(x, y, z);
                    if (idx < 0) {
                        this.setPixelAt(x, y, z, gray);
                        continue;
                    }
                    this.setPixelAt(x, y, z, colormap.getColorAsIntARGB(idx));
                }
            }
        }
    }

    public void applyColormapARGB(int[] colormap) {
        this.applyColormap(Colormap.createFromMap(colormap));
    }

    public Object clone() {
        ScalarImageI3 I3 = new ScalarImageI3(this.width, this.height, this.depth);
        I3.minVal_ = this.minVal_;
        I3.maxVal_ = this.maxVal_;
        I3.imageIsARGBPacked = this.imageIsARGBPacked;
        if (this.imageIsARGBPacked) {
            I3.initializePackedARGBBuffers();
        }
        I3.imageIsStaticBool = this.imageIsStaticBool;
        I3.sliceOrientation = this.sliceOrientation;
        for (int z = 0; z < this.depth; ++z) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    I3.setPixelAt(x, y, z, this.getPixelValueAt(x, y, z));
                }
            }
        }
        return I3;
    }

    public void computeMinMax() {
        this.minVal_ = Integer.MAX_VALUE;
        this.maxVal_ = Integer.MIN_VALUE;
        for (int z = 0; z < this.depth; ++z) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int val = this.getPixelInt(x, y, z);
                    if (val < this.minVal_) {
                        this.minVal_ = val;
                    }
                    if (val <= this.maxVal_) continue;
                    this.maxVal_ = val;
                }
            }
        }
    }

    public void copyFrom(ScalarImageI3 I) {
        System.arraycopy(I.buffer.getData(), 0, this.buffer.getData(), 0, this.buffer.getSize());
    }

    public void debugCheckSample(int x, int y, int z) {
        System.out.println("checking the pixel in raster XY " + this.rastersXY[z].getSample(x, y, 0));
        System.out.println("checking the pixel in raster XZ " + this.rastersXZ[y].getSample(x, z, 0));
        System.out.println("checking the pixel in raster YZ " + this.rastersZY[x].getSample(z, y, 0));
        System.out.println("checking pixel in csmXY + buffer " + this.sampleModelXY.getSample(x, y, z, this.buffer));
        System.out.println("checking pixel in csmXZ + buffer " + this.sampleModelXZ.getSample(x, z, y, this.buffer));
        System.out.println("checking pixel in csmYZ + buffer " + this.sampleModelZY.getSample(z, y, x, this.buffer));
    }

    public final short getBitsPerPixel() {
        return 32;
    }

    public DataBufferInt getBuffer() {
        return this.buffer;
    }

    public Colormap getColormap() {
        return this.theColormap;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getHeight() {
        return this.height;
    }

    public float getMaxValue() {
        if (this.maxVal_ == Integer.MIN_VALUE) {
            this.computeMinMax();
        }
        return this.maxVal_;
    }

    public float getMinValue() {
        if (this.minVal_ == Integer.MAX_VALUE) {
            this.computeMinMax();
        }
        return this.minVal_;
    }

    public int getNumberOfSlices() {
        if (this.sliceOrientation == 0) {
            return this.depth;
        }
        if (this.sliceOrientation == 1) {
            return this.width;
        }
        return this.height;
    }

    public Object getPixel(int x, int y, int z) {
        return this.buffer.getElem(z * this.wh + y * this.width + x);
    }

    public byte getPixelByte(int x, int y, int z) {
        return (byte)this.buffer.getElem(z * this.wh + y * this.width + x);
    }

    public float getPixelFloat(int x, int y, int z) {
        return this.buffer.getElem(z * this.wh + y * this.width + x);
    }

    public int getPixelInt(int x, int y, int z) {
        return this.buffer.getElem(z * this.wh + y * this.width + x);
    }

    public short getPixelShort(int x, int y, int z) {
        return (short)this.buffer.getElem(z * this.wh + y * this.width + x);
    }

    public int getPixelValueAt(int x, int y, int z) {
        return this.buffer.getElem(z * this.wh + y * this.width + x);
    }

    public int getPixelValueAt(Point3D P) {
        return this.getPixelValueAt((int)P.getX(), (int)P.getY(), (int)P.getZ());
    }

    public BufferedImage getSlice(int i) {
        if (this.imageIsARGBPacked) {
            if (this.sliceOrientation == 0) {
                this.lastXYSlice = i;
                for (int x = 0; x < this.width; ++x) {
                    for (int y = 0; y < this.height; ++y) {
                        this.imageXYbuffer.setElem(y * this.width + x, this.rastersXY[i].getSample(x, y, 0));
                    }
                }
                return this.imageXY;
            }
            if (this.sliceOrientation == 2) {
                this.lastXZSlice = i;
                for (int x = 0; x < this.width; ++x) {
                    for (int z = 0; z < this.depth; ++z) {
                        this.imageXZbuffer.setElem(z * this.width + x, this.rastersXZ[i].getSample(x, z, 0));
                    }
                }
                return this.imageXZ;
            }
            this.lastZYSlice = i;
            for (int z = 0; z < this.depth; ++z) {
                for (int y = 0; y < this.height; ++y) {
                    this.imageZYbuffer.setElem(y * this.depth + z, this.rastersZY[i].getSample(z, y, 0));
                }
            }
            return this.imageZY;
        }
        if (this.sliceOrientation == 0) {
            this.lastXYSlice = i;
            if (!this.scaleBySlice) {
                for (int x = 0; x < this.width; ++x) {
                    for (int y = 0; y < this.height; ++y) {
                        this.imageXYRaster.setSample(x, y, 0, (byte)(255 * (this.rastersXY[i].getSample(x, y, 0) - this.minVal_) / this.maxVal_));
                    }
                }
            } else {
                int smi = Integer.MAX_VALUE;
                int sma = Integer.MIN_VALUE;
                for (int y = 0; y < this.height; ++y) {
                    for (int x = 0; x < this.width; ++x) {
                        int f = this.getPixelInt(x, y, i);
                        sma = f > sma ? f : sma;
                        smi = f < smi && f > 0 ? f : smi;
                    }
                }
                int denom = sma - smi;
                float scale = denom == 0 ? 0.0f : 255.0f / (float)(sma - smi);
                for (int y = 0; y < this.height; ++y) {
                    for (int x = 0; x < this.width; ++x) {
                        float f = this.getPixelFloat(x, y, i);
                        if (f == 0.0f) {
                            this.imageXYRaster.setSample(x, y, 0, 0);
                            continue;
                        }
                        byte b = (byte)Math.floor((this.getPixelFloat(x, y, i) - (float)smi) * scale);
                        this.imageXYRaster.setSample(x, y, 0, b);
                    }
                }
            }
            return this.imageXY;
        }
        if (this.sliceOrientation == 2) {
            this.lastXZSlice = i;
            for (int x = 0; x < this.width; ++x) {
                for (int z = 0; z < this.depth; ++z) {
                    this.imageXZRaster.setSample(x, z, 0, (byte)(255 * (this.rastersXZ[i].getSample(x, z, 0) - this.minVal_) / this.maxVal_));
                }
            }
            return this.imageXZ;
        }
        this.lastZYSlice = i;
        for (int z = 0; z < this.depth; ++z) {
            for (int y = 0; y < this.height; ++y) {
                this.imageZYRaster.setSample(z, y, 0, (byte)(255 * (this.rastersZY[i].getSample(z, y, 0) - this.minVal_) / this.maxVal_));
            }
        }
        return this.imageZY;
    }

    public byte[] getSliceClamp(int z) {
        byte[] buf = new byte[this.width * this.height];
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                buf[y * this.width + x] = (byte)this.getPixelValueAt(x, y, z);
            }
        }
        return buf;
    }

    public int getSliceOrientation() {
        return this.sliceOrientation;
    }

    public byte[] getSliceToBuffer(int z) {
        byte[] buf = new byte[this.width * this.height];
        float scale = 255.0f / ((float)this.maxVal_ - (float)this.minVal_);
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                buf[y * this.width + x] = (byte)(((float)this.getPixelValueAt(x, y, z) - (float)this.minVal_) * scale);
            }
        }
        return buf;
    }

    public byte[] getSliceToBufferSliceNorm(int z) {
        byte[] buf = new byte[this.width * this.height];
        int minVal = Integer.MAX_VALUE;
        int maxVal = Integer.MIN_VALUE;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int val = this.getPixelValueAt(x, y, z);
                if (val < minVal) {
                    minVal = val;
                }
                if (val <= maxVal) continue;
                maxVal = val;
            }
        }
        float scale = 255.0f / ((float)maxVal - (float)minVal);
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                buf[y * this.width + x] = (byte)(((float)this.getPixelValueAt(x, y, z) - (float)minVal) * scale);
            }
        }
        return buf;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean hasColormap() {
        return this.hasColormap;
    }

    public final boolean isValidVoxel(int x, int y, int z) {
        return x >= 0 && x < this.getWidth() && y >= 0 && y < this.getHeight() && z >= 0 && z < this.getDepth();
    }

    public final boolean isValidVoxel(Point3D P) {
        return this.isValidVoxel((int)P.getX(), (int)P.getY(), (int)P.getZ());
    }

    public void makeImageStatic() {
        this.imageIsStaticBool = true;
        this.computeMinMax();
    }

    public void setData(int[] D) {
        if (!this.imageIsStaticBool) {
            int d = 0;
            for (int z = 0; z < this.depth; ++z) {
                for (int y = 0; y < this.height; ++y) {
                    for (int x = 0; x < this.width; ++x) {
                        this.buffer.setElem(z * this.wh + y * this.width + x, D[d++]);
                    }
                }
            }
        }
    }

    public void setPixelAt(int x, int y, int z, int v) {
        if (!this.imageIsStaticBool) {
            this.buffer.setElem(z * this.wh + y * this.width + x, v);
        }
    }

    public void setRange(int minv, int maxv) {
        this.maxVal_ = maxv;
        this.minVal_ = minv;
    }

    public void setSliceOrientation(int O) {
        this.sliceOrientation = O;
    }
}

