/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.ccb.graphshifts.observers;

import edu.ucla.ccb.graphshifts.GraphShifts;
import edu.ucla.ccb.graphshifts.graphs.HardGraphHierarchy;
import edu.ucla.ccb.graphshifts.image.Colormap;
import edu.ucla.ccb.graphshifts.image.Image3PixelAccess;
import edu.ucla.ccb.graphshifts.image.ImageOutliner;
import edu.ucla.ccb.graphshifts.image.ScalarImageB3;
import edu.ucla.ccb.graphshifts.observers.GraphShiftsObserver;
import java.util.ArrayList;

public class ShiftProcessVoyeur
implements GraphShiftsObserver {
    Image3PixelAccess raw;
    String path;
    Colormap cmap;
    int[] shifts;
    int shiftOn = 0;
    ImageOutliner io;
    int[] labelList;
    ArrayList<WhatToGrab> wtg;

    public ShiftProcessVoyeur(Image3PixelAccess image, String cmapPath, String outputPath, String shiftsToGrab, String whatToGrab, String labelsToGrab) {
        this.raw = image;
        this.cmap = Colormap.createFromFile(cmapPath);
        this.path = outputPath;
        this.io = new ImageOutliner(this.raw, this.cmap);
        this.buildShiftsToGrab(shiftsToGrab);
        this.buildWhatToGrab(whatToGrab);
        this.buildLabelList(labelsToGrab);
    }

    private void buildLabelList(String S) {
        String[] A = S.split(",");
        this.labelList = new int[A.length];
        for (int i = 0; i < A.length; ++i) {
            this.labelList[i] = Integer.parseInt(A[i]);
        }
    }

    private void buildShiftsToGrab(String S) {
        String[] A = S.split(",");
        this.shifts = new int[A.length];
        for (int i = 0; i < A.length; ++i) {
            this.shifts[i] = Integer.parseInt(A[i]);
        }
    }

    private void buildWhatToGrab(String S) {
        String[] A = S.split(",");
        this.wtg = new ArrayList();
        int i = 0;
        while (i < A.length) {
            WhatToGrab w = new WhatToGrab(A[i++]);
            if (w.tog == TypeOfGrab.OUTLINE || w.tog == TypeOfGrab.FILL) {
                w.slice = Integer.parseInt(A[i++]);
            }
            this.wtg.add(w);
        }
    }

    public void shiftBegin() {
    }

    public void shiftEnd() {
    }

    public void shiftTaken(int shiftNumber, int shiftLevel, int shiftFrom, int shiftTo, float shiftWeight, HardGraphHierarchy hierarchy, Object shifter) {
        if (shifter instanceof GraphShifts && (this.shiftOn < this.shifts.length && this.shifts[this.shiftOn] == shiftNumber || this.shifts[0] == -1)) {
            GraphShifts sc = (GraphShifts)shifter;
            ScalarImageB3 L = sc.getFinalLabels();
            for (WhatToGrab W : this.wtg) {
                W.tog.work(L, W, this.io, this.labelList, this.path, shiftNumber);
            }
            ++this.shiftOn;
        }
    }

    class WhatToGrab {
        public int slice;
        public String ostr;
        public TypeOfGrab tog;
        public ImageOutliner.Orientation orientation;

        public WhatToGrab(String ostr) {
            this.ostr = ostr;
            if (ostr.equals("xy")) {
                this.tog = TypeOfGrab.OUTLINE;
                this.orientation = ImageOutliner.Orientation.XY;
            } else if (ostr.equals("xz")) {
                this.tog = TypeOfGrab.OUTLINE;
                this.orientation = ImageOutliner.Orientation.XZ;
            } else if (ostr.equals("zy")) {
                this.tog = TypeOfGrab.OUTLINE;
                this.orientation = ImageOutliner.Orientation.ZY;
            } else if (ostr.equals("zv")) {
                this.tog = TypeOfGrab.GZIPVOLUME;
            } else if (ostr.equals("fxy")) {
                this.tog = TypeOfGrab.FILL;
                this.orientation = ImageOutliner.Orientation.XY;
            } else if (ostr.equals("fxz")) {
                this.tog = TypeOfGrab.FILL;
                this.orientation = ImageOutliner.Orientation.XZ;
            } else if (ostr.equals("fzy")) {
                this.tog = TypeOfGrab.FILL;
                this.orientation = ImageOutliner.Orientation.ZY;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TypeOfGrab {
        OUTLINE{

            void work(ScalarImageB3 L, WhatToGrab wtg, ImageOutliner io, int[] labelList, String path, int shiftNumber) {
                io.setLabels(L);
                io.outline(wtg.slice, wtg.orientation, labelList);
                io.writeLastOutlineImage(String.format("%s-s%06d-%d-%s.png", path, shiftNumber, wtg.slice, wtg.ostr));
            }
        }
        ,
        FILL{

            void work(ScalarImageB3 L, WhatToGrab wtg, ImageOutliner io, int[] labelList, String path, int shiftNumber) {
                io.setLabels(L);
                io.fill(wtg.slice, wtg.orientation, labelList);
                io.writeLastOutlineImage(String.format("%s-s%06d-%d-%s.png", path, shiftNumber, wtg.slice, wtg.ostr));
            }
        }
        ,
        GZIPVOLUME{

            void work(ScalarImageB3 L, WhatToGrab wtg, ImageOutliner io, int[] labelList, String path, int shiftNumber) {
                String name = String.format("%s-s%06d.gzm", path, shiftNumber);
                L.writeToGzipMatrix(name);
            }
        };


        abstract void work(ScalarImageB3 var1, WhatToGrab var2, ImageOutliner var3, int[] var4, String var5, int var6);
    }
}

