/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.ccb.graphshifts.observers;

import edu.ucla.ccb.graphshifts.graphs.HardGraphHierarchy;
import edu.ucla.ccb.graphshifts.graphs.ThinGraph;
import edu.ucla.ccb.graphshifts.observers.GraphShiftsObserver;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class ShiftStatistician
implements GraphShiftsObserver {
    String path;
    PrintWriter pw = null;

    public ShiftStatistician(String path) {
        this.path = path;
    }

    public void shiftBegin() {
        try {
            this.pw = new PrintWriter(new BufferedWriter(new FileWriter(this.path)));
        }
        catch (IOException e) {
            System.err.println("non-fatal: Could not open stats file for writing.");
            this.pw = null;
            e.printStackTrace();
        }
    }

    public void shiftEnd() {
        if (this.pw != null) {
            this.pw.close();
        }
    }

    public void shiftTaken(int shiftNumber, int shiftLevel, int shiftFrom, int shiftTo, float shiftWeight, HardGraphHierarchy graphHierarchy, Object shifter) {
        if (this.pw != null) {
            ThinGraph g = (ThinGraph)graphHierarchy.getLayer(shiftLevel);
            int mass = g.NDgetMass(shiftFrom);
            this.pw.printf("%d\t%d\t%d\t%f\n", shiftNumber, shiftLevel, mass, Float.valueOf(shiftWeight));
        }
    }
}

