/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.ccb.graphshifts.graphs;

import edu.ucla.ccb.graphshifts.MultilevelSegmentation;
import edu.ucla.ccb.graphshifts.graphs.GraphHierarchy;
import edu.ucla.ccb.graphshifts.graphs.GraphModel;
import edu.ucla.ccb.graphshifts.graphs.SingleParentProtocol;
import java.io.Serializable;
import java.util.Arrays;

public class HardGraphHierarchy
extends GraphHierarchy
implements MultilevelSegmentation,
Serializable {
    public static final long serialVersionUID = 1L;

    public int[] getLabelingFromLevel(int level) {
        int[] labels = new int[((GraphModel)this.graphs.get(0)).getNumberOfNodes()];
        try {
            for (int i = 0; i < labels.length; ++i) {
                int index = i;
                for (int L = 0; L < level; ++L) {
                    SingleParentProtocol n = (SingleParentProtocol)((Object)this.getLayer(L).getNode(index));
                    index = n.getParentIndex();
                }
                labels[i] = index;
            }
        }
        catch (ClassCastException exc) {
            System.err.println("A node in the graph hierarchy does not implement the SingleParentProtocol.");
            System.err.println("Could not get labeling from level, but not FATAL.");
            Arrays.fill(labels, -1);
        }
        return labels;
    }

    public Object getLevel(int level) {
        return this.getLayer(level);
    }

    public final int getNumberOfLevels() {
        return this.getNumberOfLayers();
    }
}

