/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.ccb.graphshifts.graphs;

import edu.ucla.ccb.graphshifts.graphs.GraphEdgeModel;
import edu.ucla.ccb.graphshifts.graphs.GraphNodeDebuggable;
import edu.ucla.ccb.graphshifts.graphs.GraphNodeModel;
import edu.ucla.ccb.graphshifts.graphs.MutableGraphModel;
import edu.ucla.ccb.graphshifts.graphs.SingleParentProtocol;
import edu.ucla.ccb.graphshifts.image.Image3PixelAccess;
import gnu.trove.TByteArrayList;
import gnu.trove.TFloatArrayList;
import gnu.trove.TIntArrayList;
import gnu.trove.TLongArrayList;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThinGraph
implements MutableGraphModel,
Serializable {
    static int unpackedLength;
    static int unpackedNeighbor;
    private static final long HIWORD = -4294967296L;
    private static final long LOWORD = 0xFFFFFFFFL;
    TIntArrayList parents;
    TByteArrayList intensity;
    TByteArrayList classIndex;
    TIntArrayList mass;
    ArrayList<TIntArrayList> children;
    ArrayList<TLongArrayList> neighbors;
    int numberOfNodes = 0;
    TIntArrayList graphShiftIndex;
    TFloatArrayList graphShiftWeight;
    TFloatArrayList likelihoodValues = null;
    int classNum = 9;
    float[] lvfiller = new float[9];

    public static ThinGraph createFromVolume(Image3PixelAccess I) {
        return ThinGraph.createFromVolume(I, 9);
    }

    public static ThinGraph createFromVolume(Image3PixelAccess I, int classNum) {
        int x;
        int y;
        int z;
        int w = I.getWidth();
        int h = I.getHeight();
        int d = I.getDepth();
        int wh = w * h;
        Runtime rt = Runtime.getRuntime();
        System.out.printf("\t totalmem %d  freemem %d  allocd %012d\n", rt.totalMemory(), rt.freeMemory(), rt.totalMemory() - rt.freeMemory());
        ThinGraph G = new ThinGraph();
        G.allocateMembers(w * h * d, 6, 0);
        G.numberOfNodes = w * h * d;
        G.classNum = classNum;
        G.lvfiller = new float[classNum];
        System.out.printf("\t totalmem %d  freemem %d  allocd %012d\n", rt.totalMemory(), rt.freeMemory(), rt.totalMemory() - rt.freeMemory());
        G.populateWithDefault(w * h * d);
        int i = 0;
        for (z = 0; z < d; ++z) {
            for (y = 0; y < h; ++y) {
                for (x = 0; x < w; ++x) {
                    G.intensity.set(i++, I.getPixelByte(x, y, z));
                }
            }
        }
        i = 0;
        for (z = 0; z < d; ++z) {
            for (y = 0; y < h; ++y) {
                x = 0;
                while (x < w) {
                    TLongArrayList tn;
                    int ii;
                    int zz;
                    int yy;
                    int xx;
                    TLongArrayList sn = G.neighbors.get(i);
                    if (x < w - 1) {
                        xx = x + 1;
                        yy = y;
                        zz = z;
                        ii = zz * wh + yy * w + xx;
                        tn = G.neighbors.get(ii);
                        sn.add(ThinGraph.packNeighbor(1, ii));
                        tn.add(ThinGraph.packNeighbor(1, i));
                    }
                    if (y < h - 1) {
                        xx = x;
                        yy = y + 1;
                        zz = z;
                        ii = zz * wh + yy * w + xx;
                        tn = G.neighbors.get(ii);
                        sn.add(ThinGraph.packNeighbor(1, ii));
                        tn.add(ThinGraph.packNeighbor(1, i));
                    }
                    if (z < d - 1) {
                        xx = x;
                        yy = y;
                        zz = z + 1;
                        ii = zz * wh + yy * w + xx;
                        tn = G.neighbors.get(ii);
                        sn.add(ThinGraph.packNeighbor(1, ii));
                        tn.add(ThinGraph.packNeighbor(1, i));
                    }
                    ++x;
                    ++i;
                }
            }
        }
        return G;
    }

    private static final long packNeighbor(int length, int neighbor) {
        return (long)length << 32 & 0xFFFFFFFF00000000L | (long)neighbor & 0xFFFFFFFFL;
    }

    private static final void unpackNeighbor(long edge) {
        unpackedLength = (int)(edge >> 32 & 0xFFFFFFFFL);
        unpackedNeighbor = (int)(edge & 0xFFFFFFFFL);
    }

    public ThinGraph() {
    }

    public ThinGraph(int n, int m, int c) {
        this.allocateMembers(n, m, c);
    }

    public ThinGraph(int n, int m, int c, int classNum) {
        this.allocateMembers(n, m, c);
        this.classNum = classNum;
        this.lvfiller = new float[classNum];
    }

    public void addEdge(int s, int t) {
        this.neighbors.get(s).add((long)t);
        this.neighbors.get(t).add((long)s);
    }

    public void addEdge(int s, int t, int len) {
        this.neighbors.get(s).add(ThinGraph.packNeighbor(len, t));
        this.neighbors.get(t).add(ThinGraph.packNeighbor(len, s));
    }

    public ThinGraphNode addNewNode() {
        ThinGraphNode TGN = new ThinGraphNode(this, -1);
        this.addNode(TGN);
        return TGN;
    }

    @Override
    public void addNode(GraphNodeModel node) {
        try {
            ThinGraphNode TGN = (ThinGraphNode)ThinGraphNode.class.cast(node);
            TGN.setId(this.numberOfNodes++);
            this.parents.add(-1);
            this.mass.add(1);
            this.intensity.add((byte)0);
            this.classIndex.add((byte)-1);
            this.neighbors.add(new TLongArrayList(2));
            if (this.children != null) {
                this.children.add(new TIntArrayList(2));
            }
            if (this.likelihoodValues != null) {
                this.likelihoodValues.add(this.lvfiller);
            }
            this.graphShiftIndex.add(-1);
            this.graphShiftWeight.add(0.0f);
        }
        catch (ClassCastException e) {
            System.out.println("ERR: ThinGraph expects ThinGraphNodes to be added. Added a node, and disregarded the input.");
        }
    }

    public void allocateMembers(int n, int m, int c) {
        TLongArrayList T;
        int i;
        this.parents = new TIntArrayList(n);
        this.mass = new TIntArrayList(n);
        this.intensity = new TByteArrayList(n);
        this.classIndex = new TByteArrayList(n);
        this.neighbors = new ArrayList(n);
        for (i = 0; i < n; ++i) {
            T = new TLongArrayList(m);
            this.neighbors.add(T);
        }
        if (c > 0) {
            this.likelihoodValues = new TFloatArrayList(n * this.classNum);
            this.children = new ArrayList(n);
            for (i = 0; i < n; ++i) {
                T = new TIntArrayList(c);
                this.children.add((TIntArrayList)T);
            }
        }
        this.graphShiftIndex = new TIntArrayList(n);
        this.graphShiftWeight = new TFloatArrayList(n);
    }

    public TByteArrayList getClassIndexBuffer() {
        return this.classIndex;
    }

    public GraphEdgeModel getEdge(int i) {
        throw new AssertionError((Object)"Rethink whether you actually need the edge (if so, then rewrite this class).");
    }

    public Iterator<GraphEdgeModel> getEdgeIterator() {
        throw new AssertionError((Object)"Rethink whether or not you actually need the edge iterator");
    }

    @Override
    public GraphNodeModel getNode(int i) {
        return new ThinGraphNode(this, i);
    }

    @Override
    public Iterator<GraphNodeModel> getNodeIterator() {
        return new ThinGraphNodeIterator(this);
    }

    public int getNumberOfEdges() {
        return -1;
    }

    @Override
    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public void NDaddChild(int id, int cid) {
        if (this.children != null) {
            this.children.get(id).add(cid);
        }
    }

    public void NDaddToBoundaryLength(int id, int nid, int len) {
        long mod = ThinGraph.packNeighbor(len, 0);
        this.neighbors.get(id).set(nid, this.neighbors.get(id).get(nid) + mod);
    }

    public void NDaddToLikelihood(int id, int c, float v) {
        int i = id * this.classNum + c;
        this.likelihoodValues.set(i, this.likelihoodValues.get(i) + v);
    }

    public final int NDgetBoundaryLength(int id, int nid) {
        return (int)(this.neighbors.get(id).get(nid) >> 32 & 0xFFFFFFFFL);
    }

    public int NDgetChild(int id, int cid) {
        if (this.children != null) {
            return this.children.get(id).get(cid);
        }
        return -1;
    }

    public int NDgetClassIndex(int id) {
        return this.classIndex.get(id) & 0xFF;
    }

    public int NDgetGraphShiftIndex(int id) {
        return this.graphShiftIndex.get(id);
    }

    public float NDgetGraphShiftWeight(int id) {
        return this.graphShiftWeight.get(id);
    }

    public byte NDgetIntensity(int id) {
        return this.intensity.get(id);
    }

    public int NDgetIntensityUnsigned(int id) {
        return 0xFF & this.intensity.get(id);
    }

    public float NDgetLikelihood(int id, int c) {
        return this.likelihoodValues.get(id * this.classNum + c);
    }

    public int NDgetMass(int id) {
        return this.mass.get(id);
    }

    public int NDgetNeighbor(int id, int nid) {
        return (int)(this.neighbors.get(id).get(nid) & 0xFFFFFFFFL);
    }

    public GraphNodeModel NDgetNeighborNode(int id, int nid) {
        return this.getNode((int)(this.neighbors.get(id).get(nid) & 0xFFFFFFFFL));
    }

    public int NDgetNumberOfChildren(int id) {
        if (this.children != null) {
            return this.children.get(id).size();
        }
        return 0;
    }

    public int NDgetNumberOfNeighbors(int id) {
        return this.neighbors.get(id).size();
    }

    public int NDgetParent(int id) {
        return this.parents.get(id);
    }

    public int NDlookupNeighborIndex(int id, int nid) {
        int v = -1;
        int n = this.neighbors.get(id).size();
        for (int i = 0; i < n; ++i) {
            if (nid != (int)(this.neighbors.get(id).get(i) & 0xFFFFFFFFL)) continue;
            v = i;
            break;
        }
        return v;
    }

    public void NDremoveChild(int id, int childId) {
        this.children.get(id).remove(childId);
    }

    public void NDremoveChildId(int id, int childId) {
        int cidx = this.children.get(id).indexOf(childId);
        if (id != -1) {
            this.children.get(id).remove(cidx);
        }
    }

    public final void NDsetBoundaryLength(int id, int nid, int len) {
        long current = this.neighbors.get(id).get(nid);
        long updated = (long)len << 32 & 0xFFFFFFFF00000000L | current & 0xFFFFFFFFL;
        this.neighbors.get(id).set(nid, updated);
    }

    public void NDsetClassIndex(int id, int cidx) {
        this.classIndex.set(id, (byte)cidx);
    }

    public void NDsetGraphShift(int id, int sid, float weight) {
        this.graphShiftIndex.set(id, sid);
        this.graphShiftWeight.set(id, weight);
    }

    public void NDsetGraphShiftIndex(int id, int sid) {
        this.graphShiftIndex.set(id, sid);
    }

    public void NDsetGraphShiftWeight(int id, float weight) {
        this.graphShiftWeight.set(id, weight);
    }

    public void NDsetIntensity(int id, byte v) {
        this.intensity.set(id, v);
    }

    public void NDsetLikelihood(int id, int c, float v) {
        this.likelihoodValues.set(id * this.classNum + c, v);
    }

    public void NDsetMass(int id, int v) {
        this.mass.set(id, v);
    }

    public void NDsetParent(int id, int v) {
        this.parents.set(id, v);
    }

    public final void NDsubtractFromBoundaryLength(int id, int nid, int len) {
        long mod = ThinGraph.packNeighbor(len, 0);
        this.neighbors.get(id).set(nid, this.neighbors.get(id).get(nid) - mod);
    }

    public void NDsubtractFromLikelihood(int id, int c, float v) {
        int i = id * this.classNum + c;
        this.likelihoodValues.set(i, this.likelihoodValues.get(i) - v);
    }

    protected void populateWithDefault(int n) {
        this.classIndex.fill(0, n, (byte)-1);
        this.mass.fill(0, n, 1);
        this.parents.fill(0, n, -1);
        this.intensity.fill(0, n, (byte)0);
        this.graphShiftIndex.fill(0, n, -1);
        this.graphShiftWeight.fill(0, n, 0.0f);
        if (this.likelihoodValues != null) {
            this.likelihoodValues.fill(0, n * this.classNum, 0.0f);
        }
    }

    public void printDebugInformation() {
        System.out.printf("ThinGraph Printing Debug Information\n", new Object[0]);
        System.out.printf("Node Number is %d\n", this.numberOfNodes);
        System.out.printf("length of parents is %d\n", this.parents.size());
        System.out.printf("length of intensity is %d\n", this.intensity.size());
        System.out.printf("length of mass %d\n", this.mass.size());
        System.out.printf("length of classIndex %d\n", this.classIndex.size());
        System.out.printf("length of neighbors %d\n", this.neighbors.size());
        if (this.children == null) {
            System.out.printf("children is null\n", new Object[0]);
        } else {
            System.out.printf("length of children is %d\n", this.children.size());
        }
    }

    public int printNeighbors(int id) {
        int v = -1;
        int n = this.neighbors.get(id).size();
        System.out.printf("Node %d has %d neighbors: ", id, n);
        for (int i = 0; i < n; ++i) {
            System.out.printf("%d(%d) ", (int)(this.neighbors.get(id).get(i) & 0xFFFFFFFFL), this.neighbors.get(id).get(i) >> 32 & 0xFFFFFFFFL);
        }
        System.out.printf("\n", new Object[0]);
        return v;
    }

    public void removeEdge(int s, int t) {
        int nid = this.NDlookupNeighborIndex(s, t);
        if (nid != -1) {
            this.neighbors.get(s).remove(nid);
        }
        if ((nid = this.NDlookupNeighborIndex(t, s)) != -1) {
            this.neighbors.get(t).remove(nid);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ThinGraphNodeIterator
    implements Iterator<GraphNodeModel> {
        ThinGraph owner;
        int idx = 0;

        public ThinGraphNodeIterator(ThinGraph owner) {
            this.owner = owner;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.owner.getNumberOfNodes();
        }

        @Override
        public GraphNodeModel next() {
            return this.owner.getNode(this.idx++);
        }

        @Override
        public void remove() {
        }
    }

    public static class ThinGraphNode
    implements GraphNodeModel,
    SingleParentProtocol,
    GraphNodeDebuggable {
        private ThinGraph owner;
        private int id;

        public ThinGraphNode(ThinGraph owner, int id) {
            this.owner = owner;
            this.id = id;
        }

        public void addChild(ThinGraphNode n) {
            this.owner.NDaddChild(this.id, n.id);
        }

        public void debugOut(PrintStream s) {
            s.printf("graph node %d debug information\n", this.id);
            int nn = this.getNumberOfNeighbors();
            s.printf("neighbor information (%d neighbors)\n", nn);
            for (int i = 0; i < nn; ++i) {
                s.printf("\t[n %d]  to %d  len %d\n", i, this.getNeighborId(i), this.getBoundaryLength(i));
            }
        }

        public int getBoundaryLength(int i) {
            return this.owner.NDgetBoundaryLength(this.id, i);
        }

        public int getChild(int i) {
            return this.owner.NDgetChild(this.id, i);
        }

        public int getClassIndex() {
            return this.owner.NDgetClassIndex(this.id);
        }

        public Object getData() {
            return null;
        }

        public int getGraphShiftIndex() {
            return this.owner.NDgetGraphShiftIndex(this.id);
        }

        public float getGraphShiftWeight() {
            return this.owner.NDgetGraphShiftWeight(this.id);
        }

        public int getId() {
            return this.id;
        }

        public byte getIntensity() {
            return this.owner.NDgetIntensity(this.id);
        }

        public float getIntensityScaled() {
            return (float)(0xFF & this.owner.NDgetIntensity(this.id)) / 255.0f;
        }

        public int getIntensityUnsigned() {
            return 0xFF & this.owner.NDgetIntensity(this.id);
        }

        public int getMass() {
            return this.owner.NDgetMass(this.id);
        }

        public GraphNodeModel getNeighbor(int i) {
            return this.owner.NDgetNeighborNode(this.id, i);
        }

        public int getNeighborId(int i) {
            return this.owner.NDgetNeighbor(this.id, i);
        }

        public int getNumberOfChildren() {
            return this.owner.NDgetNumberOfChildren(this.id);
        }

        public int getNumberOfNeighbors() {
            return this.owner.NDgetNumberOfNeighbors(this.id);
        }

        public int getParent() {
            return this.owner.NDgetParent(this.id);
        }

        public int getParentIndex() {
            return this.owner.NDgetParent(this.id);
        }

        public void setClassIndex(int classIndex) {
            this.owner.NDsetClassIndex(this.id, classIndex);
        }

        public void setGraphShift(int sid, float weight) {
            this.owner.NDsetGraphShift(this.id, sid, weight);
        }

        public void setGraphShiftIndex(int sid) {
            this.owner.NDsetGraphShiftIndex(this.id, sid);
        }

        public void setGraphShiftWeight(float weight) {
            this.owner.NDsetGraphShiftWeight(this.id, weight);
        }

        private void setId(int id) {
            this.id = id;
        }

        public void setIntensity(byte intensity) {
            this.owner.NDsetIntensity(this.id, intensity);
        }

        public void setMass(int mass) {
            this.owner.NDsetMass(this.id, mass);
        }

        public void setParent(GraphNodeModel node) {
            this.owner.NDsetParent(this.id, node.getId());
        }

        public void setParent(int parent) {
            this.owner.NDsetParent(this.id, parent);
        }
    }
}

