/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.ccb.graphshifts.image;

import edu.ucla.ccb.graphshifts.image.Image3PixelAccess;
import edu.ucla.ccb.graphshifts.image.ScalarImageB3;
import edu.ucla.ccb.graphshifts.image.ScalarImageF3;
import edu.ucla.ccb.graphshifts.image.ScalarImageI3;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class AnalyzeHeader {
    short type = 0;
    short bits = 0;
    short x_dim = 0;
    short y_dim = 0;
    short z_dim = 0;
    short t_dim = 1;
    float x_step = 1.0f;
    float y_step = 1.0f;
    float z_step = 1.0f;
    int glmax = 0;
    int glmin = 0;
    private byte[] fullheader = new byte[348];
    String HDR_file = null;
    String IMG_file = null;
    Image3PixelAccess image;
    boolean flipOrderOnRead = false;

    public AnalyzeHeader(String filename) {
        this.assignFilenames(filename);
    }

    public AnalyzeHeader(String filename, Image3PixelAccess image) {
        this.assignFilenames(filename);
        this.assignImage(image);
    }

    private void assignFilenames(String filename) {
        if (!(filename.endsWith(".hdr") || filename.endsWith(".img") || filename.endsWith(".LHD") || filename.endsWith(".lhd") || filename.endsWith(".header"))) {
            this.HDR_file = filename + ".hdr";
            this.IMG_file = filename + ".img";
        } else if (filename.endsWith(".img")) {
            this.IMG_file = filename;
            this.HDR_file = filename.substring(0, filename.length() - 4) + ".hdr";
        } else {
            this.HDR_file = filename;
            this.IMG_file = filename.substring(0, filename.length() - 4) + ".img";
        }
    }

    private void assignImage(Image3PixelAccess image) {
        this.image = image;
        this.setXdim((short)image.getWidth());
        this.setYdim((short)image.getHeight());
        this.setZdim((short)image.getDepth());
        this.setGLmax((int)image.getMaxValue());
        this.setGLmin((int)image.getMinValue());
        this.setBits(image.getBitsPerPixel());
        this.type = image instanceof ScalarImageF3 ? (short)16 : (this.bits == 8 ? (short)2 : (this.bits == 16 ? (short)4 : (this.bits == 32 ? (short)8 : (short)0)));
    }

    public void forceType(short type, short bits) {
        this.type = type;
        this.bits = bits;
    }

    public short getBits() {
        return this.bits;
    }

    public int getGLmax() {
        return this.glmax;
    }

    public int getGLmin() {
        return this.glmin;
    }

    public Image3PixelAccess getImage() {
        return this.image;
    }

    public short getTdim() {
        return this.t_dim;
    }

    public short getType() {
        return this.type;
    }

    public short getXdim() {
        return this.x_dim;
    }

    public float getXstep() {
        return this.x_step;
    }

    public short getYdim() {
        return this.y_dim;
    }

    public float getYstep() {
        return this.y_step;
    }

    public short getZdim() {
        return this.z_dim;
    }

    public float getZstep() {
        return this.z_step;
    }

    public Image3PixelAccess loadFromDisk() {
        if (this.HDR_file == null || this.IMG_file == null) {
            return null;
        }
        this.readHeader();
        try {
            if (this.type == 16) {
                this.readImageFloat();
            } else if (this.bits == 8) {
                this.readImage8Bit();
            } else if (this.bits == 16) {
                this.readImage16Bit();
            } else {
                this.readImage32Bit();
            }
        }
        catch (IOException e) {
            System.err.println("AnalyzeHeader: error while reading from image data");
        }
        return this.image;
    }

    private void readHeader() {
        this.readHeader(this.HDR_file);
    }

    private void readHeader(String filename) {
        try {
            FileInputStream fr = new FileInputStream(filename);
            fr.read(this.fullheader);
            fr.close();
            ByteBuffer hdrbuf = ByteBuffer.wrap(this.fullheader);
            int hdrsize = hdrbuf.getInt();
            if (hdrsize != 348) {
                this.flipOrderOnRead = true;
                hdrbuf.order(hdrbuf.order() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            }
            hdrbuf.position(hdrbuf.position() + 38);
            this.x_dim = hdrbuf.getShort();
            this.y_dim = hdrbuf.getShort();
            this.z_dim = hdrbuf.getShort();
            this.t_dim = hdrbuf.getShort();
            hdrbuf.position(hdrbuf.position() + 20);
            this.type = hdrbuf.getShort();
            this.bits = hdrbuf.getShort();
            hdrbuf.position(hdrbuf.position() + 6);
            this.x_step = hdrbuf.getFloat();
            this.y_step = hdrbuf.getFloat();
            this.z_step = hdrbuf.getFloat();
            hdrbuf.position(hdrbuf.position() + 48);
            this.glmax = hdrbuf.getInt();
            this.glmin = hdrbuf.getInt();
        }
        catch (IOException e) {
            System.out.println("Can't open for reading header LHD file:" + filename);
            e.printStackTrace();
        }
    }

    private void readImage16Bit() throws IOException {
        ByteBuffer buffer = this.readImageBuffer();
        ScalarImageI3 I = new ScalarImageI3(this.x_dim, this.y_dim, this.z_dim);
        I.setRange(this.glmin, this.glmax);
        for (int z = 0; z < this.z_dim; ++z) {
            for (int y = 0; y < this.y_dim; ++y) {
                for (int x = 0; x < this.x_dim; ++x) {
                    I.setPixelAt(x, y, z, 0xFFFF & buffer.getShort());
                }
            }
        }
        this.image = I;
    }

    private void readImage32Bit() throws IOException {
        ByteBuffer buffer = this.readImageBuffer();
        ScalarImageI3 I = new ScalarImageI3(this.x_dim, this.y_dim, this.z_dim);
        I.setRange(this.glmin, this.glmax);
        for (int z = 0; z < this.z_dim; ++z) {
            for (int y = 0; y < this.y_dim; ++y) {
                for (int x = 0; x < this.x_dim; ++x) {
                    I.setPixelAt(x, y, z, buffer.getInt());
                }
            }
        }
        this.image = I;
    }

    private void readImage8Bit() throws IOException {
        ByteBuffer bb = this.readImageBuffer();
        int size = this.x_dim * this.y_dim * this.z_dim * this.bits / 8;
        byte[] buffer = new byte[size];
        bb.get(buffer);
        ScalarImageB3 I = new ScalarImageB3(this.x_dim, this.y_dim, this.z_dim, buffer);
        I.setMaxValue(this.glmax);
        I.setMinValue(this.glmin);
        this.image = I;
    }

    private ByteBuffer readImageBuffer() throws IOException {
        File file = new File(this.IMG_file);
        FileInputStream fis = new FileInputStream(this.IMG_file);
        FileChannel chan = fis.getChannel();
        MappedByteBuffer buf = chan.map(FileChannel.MapMode.READ_ONLY, 0L, (int)file.length());
        if (this.flipOrderOnRead) {
            buf.order(buf.order() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        }
        return buf;
    }

    private void readImageFloat() throws IOException {
        ByteBuffer buffer = this.readImageBuffer();
        ScalarImageF3 I = new ScalarImageF3(this.x_dim, this.y_dim, this.z_dim);
        for (int z = 0; z < this.z_dim; ++z) {
            for (int y = 0; y < this.y_dim; ++y) {
                for (int x = 0; x < this.x_dim; ++x) {
                    I.setPixelAt(x, y, z, buffer.getFloat());
                }
            }
        }
        if (this.glmin == this.glmax) {
            I.computeMinMax();
        } else {
            I.setRange(this.glmin, this.glmax);
        }
        this.image = I;
    }

    private void saveHeader() {
        this.saveHeader(this.HDR_file);
    }

    private void saveHeader(String filename) {
        try {
            FileOutputStream fw = new FileOutputStream(filename);
            DataOutputStream fw2 = new DataOutputStream(fw);
            byte[] skip_bytes = new byte[200];
            for (int i = 0; i < 200; ++i) {
                skip_bytes[i] = 0;
            }
            fw2.writeInt(348);
            fw2.write(skip_bytes, 0, 28);
            fw2.writeInt(16384);
            fw2.write(skip_bytes, 0, 2);
            fw2.writeByte(114);
            fw2.write(skip_bytes, 0, 1);
            fw2.writeShort(4);
            fw2.writeShort(this.x_dim);
            fw2.writeShort(this.y_dim);
            fw2.writeShort(this.z_dim);
            fw2.writeShort(this.t_dim);
            fw2.write(skip_bytes, 0, 20);
            fw2.writeShort(this.type);
            fw2.writeShort(this.bits);
            fw2.write(skip_bytes, 0, 6);
            fw2.writeFloat(this.x_step);
            fw2.writeFloat(this.y_step);
            fw2.writeFloat(this.z_step);
            fw2.write(skip_bytes, 0, 48);
            fw2.writeInt(this.glmax);
            fw2.writeInt(this.glmin);
            fw2.write(skip_bytes, 0, 200);
            fw2.close();
            fw.close();
        }
        catch (IOException e) {
            System.out.println("(AnalyzeHeader)::Can't open for writing ANALYZE *.hdr file:" + filename);
        }
    }

    private void saveImage16Bit() throws IOException {
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.IMG_file)));
        for (int z = 0; z < this.z_dim; ++z) {
            for (int y = 0; y < this.y_dim; ++y) {
                for (int x = 0; x < this.x_dim; ++x) {
                    dos.writeShort(this.image.getPixelInt(x, y, z));
                }
            }
        }
        dos.close();
    }

    private void saveImage32Bit() throws IOException {
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.IMG_file)));
        for (int z = 0; z < this.z_dim; ++z) {
            for (int y = 0; y < this.y_dim; ++y) {
                for (int x = 0; x < this.x_dim; ++x) {
                    dos.writeInt(this.image.getPixelInt(x, y, z));
                }
            }
        }
        dos.close();
    }

    private void saveImage8Bit() throws IOException {
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.IMG_file)));
        if (this.image instanceof ScalarImageB3) {
            ScalarImageB3 B = (ScalarImageB3)this.image;
            dos.write(B.getBuffer().getData());
        } else {
            for (int z = 0; z < this.z_dim; ++z) {
                for (int y = 0; y < this.y_dim; ++y) {
                    for (int x = 0; x < this.x_dim; ++x) {
                        dos.writeByte(this.image.getPixelInt(x, y, z));
                    }
                }
            }
        }
        dos.close();
    }

    private void saveImageFloat() throws IOException {
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.IMG_file)));
        for (int z = 0; z < this.z_dim; ++z) {
            for (int y = 0; y < this.y_dim; ++y) {
                for (int x = 0; x < this.x_dim; ++x) {
                    dos.writeFloat(this.image.getPixelFloat(x, y, z));
                }
            }
        }
        dos.close();
    }

    public void saveToDisk() {
        if (this.image == null || this.HDR_file == null || this.IMG_file == null) {
            System.err.println("AnalyzeHeader:: not enough data to write");
            return;
        }
        this.saveHeader();
        try {
            if (this.type == 16) {
                this.saveImageFloat();
            } else if (this.bits == 8) {
                this.saveImage8Bit();
            } else if (this.bits == 16) {
                this.saveImage16Bit();
            } else if (this.bits == 32) {
                this.saveImage32Bit();
            }
        }
        catch (IOException e) {
            System.err.println("AnalyzeHeader:: error while writing image voxel data");
        }
    }

    public void setBits(short b) {
        this.bits = b;
    }

    public void setGLmax(int max) {
        this.glmax = max;
    }

    public void setGLmin(int min) {
        this.glmin = min;
    }

    public void setTdim(short t) {
        this.t_dim = t;
    }

    public void setType(short type) {
        this.type = type;
    }

    public void setXdim(short x) {
        this.x_dim = x;
    }

    public void setXstep(float x) {
        this.x_step = x;
    }

    public void setYdim(short y) {
        this.y_dim = y;
    }

    public void setYstep(float y) {
        this.y_step = y;
    }

    public void setZdim(short z) {
        this.z_dim = z;
    }

    public void setZstep(float z) {
        this.z_step = z;
    }
}

