/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.ccb.graphshifts.image;

import edu.ucla.ccb.graphshifts.image.Colormap;
import edu.ucla.ccb.graphshifts.image.ImageLabel;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageLabelSet
implements Serializable {
    HashMap<Integer, ImageLabel> labels = new HashMap();
    String xmlFilePath = null;

    public void add(ImageLabel L) {
        this.labels.put(L.getIndex(), L);
    }

    public ImageLabel get(int i) {
        return this.labels.get(i);
    }

    public int getSize() {
        return this.labels.size();
    }

    public Iterator<ImageLabel> getIterator() {
        return this.labels.values().iterator();
    }

    public int[] getColormap(int alpha) {
        int RGB_BITMASK = 0xFFFFFF;
        int maxNum = this.computeMaxIndex() + 1;
        if (maxNum < 1) {
            int[] colormap = new int[]{0};
            return colormap;
        }
        int[] colormap = new int[maxNum];
        for (int i = 0; i < maxNum; ++i) {
            ImageLabel L = this.labels.get(i);
            colormap[i] = L == null ? 0 : (L.isInvisible() ? 0 : alpha << 24 | 0xFFFFFF & L.getColor().getRGB());
        }
        return colormap;
    }

    public Colormap getColormap2(int alpha) {
        int[] map = this.getColormap(alpha);
        return Colormap.createFromMap(map);
    }

    public int computeMaxIndex() {
        int L = -1;
        Collection<ImageLabel> C = this.labels.values();
        for (ImageLabel il : C) {
            if (il.getIndex() <= L) continue;
            L = il.getIndex();
        }
        return L;
    }

    public static ImageLabelSet createFromXML(String XMLPath) {
        File f = new File(XMLPath);
        if (!f.canRead()) {
            return null;
        }
        ImageLabelSet S = new ImageLabelSet();
        S.xmlFilePath = XMLPath;
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(f);
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        NodeList list = document.getElementsByTagName("label");
        for (int i = 0; i < list.getLength(); ++i) {
            Node set = list.item(i);
            NamedNodeMap setAttr = set.getAttributes();
            ImageLabel lab = new ImageLabel();
            lab.setName(setAttr.getNamedItem("name").getTextContent());
            lab.setIndex(Integer.parseInt(setAttr.getNamedItem("index").getTextContent()));
            String str = setAttr.getNamedItem("color").getTextContent();
            String[] cols = str.split(",");
            if (cols.length != 3) {
                System.err.println("Error while parsing color of image label" + lab.getName());
            }
            lab.setColor(new Color(Integer.parseInt(cols[0]), Integer.parseInt(cols[1]), Integer.parseInt(cols[2])));
            Node inv = setAttr.getNamedItem("invisible");
            if (inv != null) {
                lab.setInvisible(Boolean.parseBoolean(inv.getTextContent()));
            }
            S.add(lab);
        }
        return S;
    }

    public void saveAsXML(String XMLPath) throws IOException {
        File f = new File(XMLPath);
        f.createNewFile();
        if (!f.canWrite()) {
            throw new IOException("Cannot open XML file for writing? " + f.getAbsolutePath());
        }
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(f)));
        out.println("<labelset>");
        Iterator<ImageLabel> it = this.getIterator();
        while (it.hasNext()) {
            it.next().writeAsXML(out);
        }
        out.println("</labelset>");
        out.close();
    }

    public static ImageLabelSet createInitialLabelSet() {
        ImageLabelSet S = new ImageLabelSet();
        ImageLabel L = new ImageLabel();
        L.setIndex(0);
        L.setColor(Color.BLACK);
        L.setName("Background");
        L.setInvisible(true);
        S.add(L);
        return S;
    }
}

