/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.ccb.graphshifts.image;

import edu.ucla.ccb.graphshifts.image.Colormap;
import edu.ucla.ccb.graphshifts.image.Image3PixelAccess;
import java.io.IOException;
import net.sourceforge.jiu.codecs.CodecMode;
import net.sourceforge.jiu.codecs.InvalidFileStructureException;
import net.sourceforge.jiu.codecs.PNGCodec;
import net.sourceforge.jiu.codecs.UnsupportedTypeException;
import net.sourceforge.jiu.codecs.WrongFileFormatException;
import net.sourceforge.jiu.data.MemoryBilevelImage;
import net.sourceforge.jiu.data.MemoryRGB24Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.OperationFailedException;

public class ImageOutliner {
    Image3PixelAccess raw;
    Image3PixelAccess labels = null;
    Colormap cmap;
    int w;
    int h;
    int d;
    MemoryBilevelImage lastEdgeImage = null;
    MemoryRGB24Image lastOutlineImage = null;

    public ImageOutliner(Image3PixelAccess raw, Colormap cmap) {
        this(raw, null, cmap);
    }

    public ImageOutliner(Image3PixelAccess raw, Image3PixelAccess labels, Colormap cmap) {
        this.raw = raw;
        this.labels = labels;
        this.cmap = cmap;
        this.w = raw.getWidth();
        this.h = raw.getHeight();
        this.d = raw.getDepth();
    }

    private boolean checkBorder2(Image3PixelAccess labels, int label, int x, int y, int z) {
        int w = labels.getWidth();
        int h = labels.getHeight();
        boolean isBorder = false;
        if (x > 0 && labels.getPixelInt(x - 1, y, z) != label) {
            isBorder = true;
        } else if (x > 1 && labels.getPixelInt(x - 2, y, z) != label) {
            isBorder = true;
        } else if (y > 0 && labels.getPixelInt(x, y - 1, z) != label) {
            isBorder = true;
        } else if (y > 1 && labels.getPixelInt(x, y - 2, z) != label) {
            isBorder = true;
        } else if (x < w - 1 && labels.getPixelInt(x + 1, y, z) != label) {
            isBorder = true;
        } else if (x < w - 2 && labels.getPixelInt(x + 2, y, z) != label) {
            isBorder = true;
        } else if (y < h - 1 && labels.getPixelInt(x, y + 1, z) != label) {
            isBorder = true;
        } else if (y < h - 2 && labels.getPixelInt(x, y + 2, z) != label) {
            isBorder = true;
        } else if (x > 0 && y > 0 && labels.getPixelInt(x - 1, y - 1, z) != label) {
            isBorder = true;
        } else if (x > 0 && y < h - 1 && labels.getPixelInt(x - 1, y + 1, z) != label) {
            isBorder = true;
        } else if (x < w - 1 && y > 0 && labels.getPixelInt(x + 1, y - 1, z) != label) {
            isBorder = true;
        } else if (x < w - 1 && y < h - 1 && labels.getPixelInt(x + 1, y + 1, z) != label) {
            isBorder = true;
        }
        return isBorder;
    }

    private boolean checkBorderXY_1(Image3PixelAccess labels, int label, int x, int y, int z) {
        int w = labels.getWidth();
        int h = labels.getHeight();
        boolean isBorder = false;
        if (x > 0 && labels.getPixelInt(x - 1, y, z) != label) {
            isBorder = true;
        } else if (y > 0 && labels.getPixelInt(x, y - 1, z) != label) {
            isBorder = true;
        } else if (x < w - 1 && labels.getPixelInt(x + 1, y, z) != label) {
            isBorder = true;
        } else if (y < h - 1 && labels.getPixelInt(x, y + 1, z) != label) {
            isBorder = true;
        } else if (x > 0 && y > 0 && labels.getPixelInt(x - 1, y - 1, z) != label) {
            isBorder = true;
        } else if (x > 0 && y < h - 1 && labels.getPixelInt(x - 1, y + 1, z) != label) {
            isBorder = true;
        } else if (x < w - 1 && y > 0 && labels.getPixelInt(x + 1, y - 1, z) != label) {
            isBorder = true;
        } else if (x < w - 1 && y < h - 1 && labels.getPixelInt(x + 1, y + 1, z) != label) {
            isBorder = true;
        }
        return isBorder;
    }

    private boolean checkBorderXZ_1(Image3PixelAccess labels, int label, int x, int y, int z) {
        int w = labels.getWidth();
        int d = labels.getDepth();
        boolean isBorder = false;
        if (x > 0 && labels.getPixelInt(x - 1, y, z) != label) {
            isBorder = true;
        } else if (z > 0 && labels.getPixelInt(x, y, z - 1) != label) {
            isBorder = true;
        } else if (x < w - 1 && labels.getPixelInt(x + 1, y, z) != label) {
            isBorder = true;
        } else if (z < d - 1 && labels.getPixelInt(x, y, z + 1) != label) {
            isBorder = true;
        } else if (x > 0 && z > 0 && labels.getPixelInt(x - 1, y, z - 1) != label) {
            isBorder = true;
        } else if (x > 0 && z < d - 1 && labels.getPixelInt(x - 1, y, z + 1) != label) {
            isBorder = true;
        } else if (x < w - 1 && z > 0 && labels.getPixelInt(x + 1, y, z - 1) != label) {
            isBorder = true;
        } else if (x < w - 1 && z < d - 1 && labels.getPixelInt(x + 1, y, z + 1) != label) {
            isBorder = true;
        }
        return isBorder;
    }

    private boolean checkBorderZY_1(Image3PixelAccess labels, int label, int x, int y, int z) {
        int h = labels.getHeight();
        int d = labels.getDepth();
        boolean isBorder = false;
        if (z > 0 && labels.getPixelInt(x, y, z - 1) != label) {
            isBorder = true;
        } else if (y > 0 && labels.getPixelInt(x, y - 1, z) != label) {
            isBorder = true;
        } else if (z < d - 1 && labels.getPixelInt(x, y, z + 1) != label) {
            isBorder = true;
        } else if (y < h - 1 && labels.getPixelInt(x, y + 1, z) != label) {
            isBorder = true;
        } else if (z > 0 && y > 0 && labels.getPixelInt(x, y - 1, z - 1) != label) {
            isBorder = true;
        } else if (z > 0 && y < h - 1 && labels.getPixelInt(x, y + 1, z - 1) != label) {
            isBorder = true;
        } else if (z < d - 1 && y > 0 && labels.getPixelInt(x, y - 1, z + 1) != label) {
            isBorder = true;
        } else if (z < d - 1 && y < h - 1 && labels.getPixelInt(x, y + 1, z + 1) != label) {
            isBorder = true;
        }
        return isBorder;
    }

    public Image3PixelAccess getLabels() {
        return this.labels;
    }

    public MemoryBilevelImage getLastEdgeImage() {
        return this.lastEdgeImage;
    }

    public MemoryRGB24Image getLastOutlineImage() {
        return this.lastOutlineImage;
    }

    public Image3PixelAccess getRaw() {
        return this.raw;
    }

    public PixelImage fill(int slice, Orientation orient, int[] labelList) {
        MemoryRGB24Image I;
        MemoryBilevelImage E;
        if (this.labels == null) {
            return null;
        }
        if (orient == Orientation.XZ) {
            E = new MemoryBilevelImage(this.w, this.d);
            I = new MemoryRGB24Image(this.w, this.d);
        } else if (orient == Orientation.ZY) {
            E = new MemoryBilevelImage(this.d, this.h);
            I = new MemoryRGB24Image(this.d, this.h);
        } else {
            E = new MemoryBilevelImage(this.w, this.h);
            I = new MemoryRGB24Image(this.w, this.h);
        }
        this.lastEdgeImage = E;
        this.lastOutlineImage = I;
        E.clear(0);
        this.setWhite(I);
        for (int i = 0; i < labelList.length; ++i) {
            int y;
            int x;
            int label = labelList[i];
            int color = this.cmap.getColorAsIntARGB(label);
            if (orient == Orientation.XZ) {
                int y2 = slice;
                for (int z = 0; z < this.d; ++z) {
                    for (x = 0; x < this.w; ++x) {
                        if (E.isWhite(x, z)) continue;
                        this.setGRAYRGBSample(this.raw.getPixelInt(x, y2, z), I, x, z);
                        if (this.labels.getPixelInt(x, y2, z) != label) continue;
                        this.setRGBSample(color, I, x, z);
                        E.putWhite(x, z);
                    }
                }
                continue;
            }
            if (orient == Orientation.ZY) {
                int x2 = slice;
                for (y = 0; y < this.h; ++y) {
                    for (int z = 0; z < this.d; ++z) {
                        if (E.isWhite(z, y)) continue;
                        this.setGRAYRGBSample(this.raw.getPixelInt(x2, y, z), I, z, y);
                        if (this.labels.getPixelInt(x2, y, z) != label) continue;
                        this.setRGBSample(color, I, z, y);
                        E.putWhite(z, y);
                    }
                }
                continue;
            }
            int z = slice;
            for (y = 0; y < this.h; ++y) {
                for (x = 0; x < this.w; ++x) {
                    if (E.isWhite(x, y)) continue;
                    this.setGRAYRGBSample(this.raw.getPixelInt(x, y, z), I, x, y);
                    if (this.labels.getPixelInt(x, y, z) != label) continue;
                    this.setRGBSample(color, I, x, y);
                    E.putWhite(x, y);
                }
            }
        }
        return I;
    }

    public PixelImage outline(int slice, Orientation orient, int[] labelList) {
        MemoryRGB24Image I;
        MemoryBilevelImage E;
        if (this.labels == null) {
            return null;
        }
        if (orient == Orientation.XZ) {
            E = new MemoryBilevelImage(this.w, this.d);
            I = new MemoryRGB24Image(this.w, this.d);
        } else if (orient == Orientation.ZY) {
            E = new MemoryBilevelImage(this.d, this.h);
            I = new MemoryRGB24Image(this.d, this.h);
        } else {
            E = new MemoryBilevelImage(this.w, this.h);
            I = new MemoryRGB24Image(this.w, this.h);
        }
        this.lastEdgeImage = E;
        this.lastOutlineImage = I;
        E.clear(0);
        this.setWhite(I);
        for (int i = 0; i < labelList.length; ++i) {
            int y;
            int x;
            int label = labelList[i];
            int color = this.cmap.getColorAsIntARGB(label);
            if (orient == Orientation.XZ) {
                int y2 = slice;
                for (int z = 0; z < this.d; ++z) {
                    for (x = 0; x < this.w; ++x) {
                        if (E.isWhite(x, z)) continue;
                        this.setGRAYRGBSample(this.raw.getPixelInt(x, y2, z), I, x, z);
                        if (this.labels.getPixelInt(x, y2, z) != label || !this.checkBorderXZ_1(this.labels, label, x, y2, z)) continue;
                        this.setRGBSample(color, I, x, z);
                        E.putWhite(x, z);
                    }
                }
                continue;
            }
            if (orient == Orientation.ZY) {
                int x2 = slice;
                for (y = 0; y < this.h; ++y) {
                    for (int z = 0; z < this.d; ++z) {
                        if (E.isWhite(z, y)) continue;
                        this.setGRAYRGBSample(this.raw.getPixelInt(x2, y, z), I, z, y);
                        if (this.labels.getPixelInt(x2, y, z) != label || !this.checkBorderZY_1(this.labels, label, x2, y, z)) continue;
                        this.setRGBSample(color, I, z, y);
                        E.putWhite(z, y);
                    }
                }
                continue;
            }
            int z = slice;
            for (y = 0; y < this.h; ++y) {
                for (x = 0; x < this.w; ++x) {
                    if (E.isWhite(x, y)) continue;
                    this.setGRAYRGBSample(this.raw.getPixelInt(x, y, z), I, x, y);
                    if (this.labels.getPixelInt(x, y, z) != label || !this.checkBorderXY_1(this.labels, label, x, y, z)) continue;
                    this.setRGBSample(color, I, x, y);
                    E.putWhite(x, y);
                }
            }
        }
        return I;
    }

    private void setGRAYRGBSample(int gray, MemoryRGB24Image RGB, int x, int y) {
        RGB.putSample(0, x, y, gray);
        RGB.putSample(1, x, y, gray);
        RGB.putSample(2, x, y, gray);
    }

    public void setLabels(Image3PixelAccess labels) {
        this.labels = labels;
    }

    public void setRaw(Image3PixelAccess raw) {
        this.raw = raw;
    }

    private void setRGBSample(int packed, MemoryRGB24Image RGB, int x, int y) {
        RGB.putSample(0, x, y, (0xFF0000 & packed) >> 16);
        RGB.putSample(1, x, y, (0xFF00 & packed) >> 8);
        RGB.putSample(2, x, y, 0xFF & packed);
    }

    private void setWhite(MemoryRGB24Image I) {
        for (int y = 0; y < I.getHeight(); ++y) {
            for (int x = 0; x < I.getWidth(); ++x) {
                this.setGRAYRGBSample(255, I, x, y);
            }
        }
    }

    private void writeImage(String path, PixelImage image) throws IOException, InvalidFileStructureException, MissingParameterException, UnsupportedTypeException, WrongFileFormatException, OperationFailedException {
        PNGCodec codec = new PNGCodec();
        codec.setFile(path, CodecMode.SAVE);
        codec.setImage(image);
        codec.process();
        codec.close();
    }

    public void writeLastEdgeImage(String path) {
        try {
            if (this.lastEdgeImage != null) {
                this.writeImage(path, (PixelImage)this.lastEdgeImage);
            }
        }
        catch (Exception e) {
            System.err.println("error while writing the edge image to " + path);
            e.printStackTrace();
        }
    }

    public void writeLastOutlineImage(String path) {
        try {
            if (this.lastOutlineImage != null) {
                this.writeImage(path, (PixelImage)this.lastOutlineImage);
            }
        }
        catch (Exception e) {
            System.err.println("error while writing the outline image to " + path);
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Orientation {
        XY,
        XZ,
        ZY;

    }
}

