/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.ccb.graphshifts.image;

import edu.ucla.ccb.graphshifts.data.Point3D;
import edu.ucla.ccb.graphshifts.image.Colormap;
import edu.ucla.ccb.graphshifts.image.Image3PixelAccess;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;

public class ScalarImageF3
implements Image3PixelAccess {
    private float[] data_;
    private int[] dim_;
    private int depthPlaneSize_;
    private int rowSize_;
    private float minVal_ = Float.POSITIVE_INFINITY;
    private float maxVal_ = Float.NEGATIVE_INFINITY;
    private boolean imageIsStaticBool = false;
    private int sliceOrientation_ = 0;
    private boolean scaleBySlice = true;

    public ScalarImageF3(int x, int y, int z) {
        this.dim_ = new int[3];
        this.dim_[0] = x;
        this.dim_[1] = y;
        this.dim_[2] = z;
        this.depthPlaneSize_ = this.dim_[0] * this.dim_[1];
        this.rowSize_ = this.dim_[0];
        this.data_ = new float[z * y * x];
    }

    public void computeMinMax() {
        this.minVal_ = Float.POSITIVE_INFINITY;
        this.maxVal_ = Float.NEGATIVE_INFINITY;
        for (int z = 0; z < this.dim_[2]; ++z) {
            for (int y = 0; y < this.dim_[1]; ++y) {
                for (int x = 0; x < this.dim_[0]; ++x) {
                    float val = this.getPixelValueAt(x, y, z);
                    if (val < this.minVal_) {
                        this.minVal_ = val;
                    }
                    if (!(val > this.maxVal_)) continue;
                    this.maxVal_ = val;
                }
            }
        }
    }

    public final short getBitsPerPixel() {
        return 32;
    }

    public float[] getBuffer() {
        return this.data_;
    }

    public Colormap getColormap() {
        return null;
    }

    public int getDepth() {
        return this.dim_[2];
    }

    public int getHeight() {
        return this.dim_[1];
    }

    public float getMaxValue() {
        if (this.maxVal_ == Float.NEGATIVE_INFINITY) {
            this.computeMinMax();
        }
        return this.maxVal_;
    }

    public float getMinValue() {
        if (this.minVal_ == Float.POSITIVE_INFINITY) {
            this.computeMinMax();
        }
        return this.minVal_;
    }

    public int getNumberOfSlices() {
        if (this.sliceOrientation_ == 0) {
            return this.dim_[2];
        }
        if (this.sliceOrientation_ == 1) {
            return this.dim_[0];
        }
        return this.dim_[1];
    }

    public Object getPixel(int x, int y, int z) {
        return Float.valueOf(this.data_[z * this.depthPlaneSize_ + y * this.rowSize_ + x]);
    }

    public byte getPixelByte(int x, int y, int z) {
        return (byte)this.data_[z * this.depthPlaneSize_ + y * this.rowSize_ + x];
    }

    public float getPixelFloat(int x, int y, int z) {
        return this.data_[z * this.depthPlaneSize_ + y * this.rowSize_ + x];
    }

    public int getPixelInt(int x, int y, int z) {
        return (int)this.data_[z * this.depthPlaneSize_ + y * this.rowSize_ + x];
    }

    public short getPixelShort(int x, int y, int z) {
        return (short)this.data_[z * this.depthPlaneSize_ + y * this.rowSize_ + x];
    }

    public float getPixelValueAt(int x, int y, int z) {
        return this.data_[z * this.depthPlaneSize_ + y * this.rowSize_ + x];
    }

    public BufferedImage getSlice(int S) {
        BufferedImage I;
        if (this.sliceOrientation_ == 0) {
            byte[] buf = new byte[this.dim_[0] * this.dim_[1]];
            if (!this.scaleBySlice) {
                float scale = 255.0f / (this.maxVal_ - this.minVal_);
                for (int y = 0; y < this.dim_[1]; ++y) {
                    for (int x = 0; x < this.dim_[0]; ++x) {
                        byte b;
                        buf[y * this.dim_[0] + x] = b = (byte)Math.floor((this.getPixelValueAt(x, y, S) - this.minVal_) * scale);
                    }
                }
            } else {
                float sma = Float.NEGATIVE_INFINITY;
                float smi = Float.POSITIVE_INFINITY;
                for (int y = 0; y < this.dim_[1]; ++y) {
                    for (int x = 0; x < this.dim_[0]; ++x) {
                        float f = this.getPixelFloat(x, y, S);
                        sma = f > sma ? f : sma;
                        smi = f < smi ? f : smi;
                    }
                }
                float scale = 255.0f / (sma - smi);
                for (int y = 0; y < this.dim_[1]; ++y) {
                    for (int x = 0; x < this.dim_[0]; ++x) {
                        byte b;
                        buf[y * this.dim_[0] + x] = b = (byte)Math.floor((this.getPixelValueAt(x, y, S) - smi) * scale);
                    }
                }
            }
            DataBufferByte dbb = new DataBufferByte(buf, this.dim_[0] * this.dim_[1]);
            ComponentSampleModel csm = new ComponentSampleModel(0, this.dim_[0], this.dim_[1], 1, this.dim_[0], new int[]{0});
            Point pt = new Point(0, 0);
            Raster r = Raster.createRaster(csm, dbb, pt);
            I = new BufferedImage(this.dim_[0], this.dim_[1], 10);
            I.setData(r);
        } else if (this.sliceOrientation_ == 1) {
            byte[] buf = new byte[this.dim_[1] * this.dim_[2]];
            if (!this.scaleBySlice) {
                float scale = 255.0f / (this.maxVal_ - this.minVal_);
                for (int yy = 0; yy < this.dim_[1]; ++yy) {
                    for (int xx = 0; xx < this.dim_[2]; ++xx) {
                        byte b;
                        buf[yy * this.dim_[2] + xx] = b = (byte)Math.floor((this.getPixelValueAt(S, yy, xx) - this.minVal_) * scale);
                    }
                }
            } else {
                float sma = Float.NEGATIVE_INFINITY;
                float smi = Float.POSITIVE_INFINITY;
                for (int yy = 0; yy < this.dim_[1]; ++yy) {
                    for (int xx = 0; xx < this.dim_[2]; ++xx) {
                        float f = this.getPixelFloat(S, yy, xx);
                        sma = f > sma ? f : sma;
                        smi = f < smi ? f : smi;
                    }
                }
                float scale = 255.0f / (sma - smi);
                for (int yy = 0; yy < this.dim_[1]; ++yy) {
                    for (int xx = 0; xx < this.dim_[2]; ++xx) {
                        byte b;
                        buf[yy * this.dim_[2] + xx] = b = (byte)Math.floor((this.getPixelValueAt(S, yy, xx) - smi) * scale);
                    }
                }
            }
            DataBufferByte dbb = new DataBufferByte(buf, this.dim_[2] * this.dim_[1]);
            ComponentSampleModel csm = new ComponentSampleModel(0, this.dim_[2], this.dim_[1], 1, this.dim_[2], new int[]{0});
            Point pt = new Point(0, 0);
            Raster r = Raster.createRaster(csm, dbb, pt);
            I = new BufferedImage(this.dim_[2], this.dim_[1], 10);
            I.setData(r);
        } else {
            byte[] buf = new byte[this.dim_[0] * this.dim_[2]];
            if (!this.scaleBySlice) {
                float scale = 255.0f / (this.maxVal_ - this.minVal_);
                for (int yy = 0; yy < this.dim_[2]; ++yy) {
                    for (int xx = 0; xx < this.dim_[0]; ++xx) {
                        byte b;
                        buf[yy * this.dim_[0] + xx] = b = (byte)Math.floor((this.getPixelValueAt(xx, S, yy) - this.minVal_) * scale);
                    }
                }
            } else {
                float sma = Float.NEGATIVE_INFINITY;
                float smi = Float.POSITIVE_INFINITY;
                for (int yy = 0; yy < this.dim_[2]; ++yy) {
                    for (int xx = 0; xx < this.dim_[0]; ++xx) {
                        float f = this.getPixelFloat(xx, S, yy);
                        sma = f > sma ? f : sma;
                        smi = f < smi ? f : smi;
                    }
                }
                float scale = 255.0f / (sma - smi);
                for (int yy = 0; yy < this.dim_[2]; ++yy) {
                    for (int xx = 0; xx < this.dim_[0]; ++xx) {
                        byte b;
                        buf[yy * this.dim_[0] + xx] = b = (byte)Math.floor((this.getPixelValueAt(xx, S, yy) - smi) * scale);
                    }
                }
            }
            DataBufferByte dbb = new DataBufferByte(buf, this.dim_[0] * this.dim_[2]);
            ComponentSampleModel csm = new ComponentSampleModel(0, this.dim_[0], this.dim_[2], 1, this.dim_[0], new int[]{0});
            Point pt = new Point(0, 0);
            Raster r = Raster.createRaster(csm, dbb, pt);
            I = new BufferedImage(this.dim_[0], this.dim_[2], 10);
            I.setData(r);
        }
        return I;
    }

    public final int getSliceOrientation() {
        return this.sliceOrientation_;
    }

    public int getWidth() {
        return this.dim_[0];
    }

    public boolean hasColormap() {
        return false;
    }

    public final boolean isValidVoxel(int x, int y, int z) {
        return x >= 0 && x < this.getWidth() && y >= 0 && y < this.getHeight() && z >= 0 && z < this.getDepth();
    }

    public final boolean isValidVoxel(Point3D P) {
        return this.isValidVoxel((int)P.getX(), (int)P.getY(), (int)P.getZ());
    }

    public void makeImageStatic() {
        this.imageIsStaticBool = true;
        this.computeMinMax();
    }

    public void setPixelAt(int x, int y, int z, float v) {
        if (!this.imageIsStaticBool) {
            this.data_[z * this.depthPlaneSize_ + y * this.rowSize_ + x] = v;
        }
    }

    public void setRange(float minv, float maxv) {
        this.maxVal_ = maxv;
        this.minVal_ = minv;
    }

    public void setSliceOrientation(int O) {
        this.sliceOrientation_ = O;
    }
}

