/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.ccb.graphshifts.observers;

import edu.ucla.ccb.graphshifts.graphs.HardGraphHierarchy;
import edu.ucla.ccb.graphshifts.image.Image3PixelAccess;
import edu.ucla.ccb.graphshifts.image.ImageUtilities;
import edu.ucla.ccb.graphshifts.observers.GraphShiftsObserver;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import net.sourceforge.jiu.codecs.CodecMode;
import net.sourceforge.jiu.codecs.InvalidFileStructureException;
import net.sourceforge.jiu.codecs.PNGCodec;
import net.sourceforge.jiu.codecs.UnsupportedCodecModeException;
import net.sourceforge.jiu.codecs.UnsupportedTypeException;
import net.sourceforge.jiu.codecs.WrongFileFormatException;
import net.sourceforge.jiu.data.MemoryRGB24Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.OperationFailedException;

public class ShiftSequenceMaker
implements GraphShiftsObserver {
    Image3PixelAccess image;
    float transparency;
    int slice;
    String path;
    MemoryRGB24Image RGB;
    int[] cmap;
    int interval = 50;

    public ShiftSequenceMaker(Image3PixelAccess image, float transparency, String path, int number) {
        this(image, 0, transparency, path, number, 50);
    }

    public ShiftSequenceMaker(Image3PixelAccess image, int slice, float transparency, String path, int number) {
        this(image, 0, transparency, path, number, 50);
    }

    public ShiftSequenceMaker(Image3PixelAccess image, int slice, float transparency, String path, int number, int interval) {
        this.image = image;
        this.slice = slice;
        this.transparency = transparency;
        this.path = path;
        this.interval = interval;
        this.RGB = new MemoryRGB24Image(image.getWidth(), image.getHeight());
        try {
            this.cmap = new int[number];
            BufferedReader re = new BufferedReader(new FileReader("/data/Tu-lonidata/labels/subcortical.lut"));
            int alpha = (int)(255.0f * transparency);
            for (int i = 0; i < number; ++i) {
                String line = re.readLine();
                String[] values = line.split("\\s");
                int r = Integer.parseInt(values[1]);
                int g = Integer.parseInt(values[2]);
                int b = Integer.parseInt(values[3]);
                this.cmap[i] = alpha << 24 | r << 16 | g << 8 | b;
            }
            re.close();
        }
        catch (Exception e) {
            System.err.println("non-fatal error in trying to load the subcortical lookup table.\n");
            System.err.println("generating a random one instead. Error info follows\n");
            e.printStackTrace();
            this.cmap = ImageUtilities.makeRandomizedColorMap(number, 255);
        }
    }

    public void setRGBSample(int packed, int voxel, float alpha, int x, int y) {
        int sample = (int)((1.0f - alpha) * (float)voxel + alpha * (float)((0xFF0000 & packed) >> 16));
        this.RGB.putSample(0, x, y, sample);
        sample = (int)((1.0f - alpha) * (float)voxel + alpha * (float)((0xFF00 & packed) >> 8));
        this.RGB.putSample(1, x, y, (0xFF00 & packed) >> 8);
        sample = (int)((1.0f - alpha) * (float)voxel + alpha * (float)(0xFF & packed));
        this.RGB.putSample(2, x, y, 0xFF & packed);
    }

    public void shiftBegin() {
    }

    public void shiftEnd() {
    }

    public void shiftTaken(int shiftNumber, int shiftLevel, int shiftFrom, int shiftTo, float shiftWeight, HardGraphHierarchy graphHierarchy, Object shifter) {
        if (shiftNumber % this.interval == 0) {
            int[] labels = graphHierarchy.getLabelingFromLevel(graphHierarchy.getNumberOfLayers() - 1);
            int w = this.image.getWidth();
            int h = this.image.getHeight();
            int wh = w * h;
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    int label = labels[this.slice * wh + y * w + x];
                    int voxel = this.image.getPixelInt(x, y, this.slice);
                    this.setRGBSample(this.cmap[label], voxel, this.transparency, x, y);
                }
            }
            this.writeImage(String.format(this.path, shiftNumber));
        }
    }

    public void writeImage(String path) {
        try {
            PNGCodec codec = new PNGCodec();
            codec.setFile(path, CodecMode.SAVE);
            codec.setImage((PixelImage)this.RGB);
            codec.process();
            codec.close();
        }
        catch (UnsupportedCodecModeException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidFileStructureException e) {
            e.printStackTrace();
        }
        catch (MissingParameterException e) {
            e.printStackTrace();
        }
        catch (UnsupportedTypeException e) {
            e.printStackTrace();
        }
        catch (WrongFileFormatException e) {
            e.printStackTrace();
        }
        catch (OperationFailedException e) {
            e.printStackTrace();
        }
    }
}

