/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.apps;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import net.sourceforge.jiu.apps.BMPSwitch;
import net.sourceforge.jiu.apps.DestinationDirectorySwitch;
import net.sourceforge.jiu.apps.JiuConvertSettings;
import net.sourceforge.jiu.apps.NoAwtLoadingSwitch;
import net.sourceforge.jiu.apps.OverwriteSwitch;
import net.sourceforge.jiu.apps.PNMSwitch;
import net.sourceforge.jiu.apps.PalmSwitch;
import net.sourceforge.jiu.apps.PrintHelpSwitch;
import net.sourceforge.jiu.apps.PrintVersionSwitch;
import net.sourceforge.jiu.apps.QuietSwitch;
import net.sourceforge.jiu.apps.Switch;
import net.sourceforge.jiu.apps.TestSwitch;
import net.sourceforge.jiu.apps.VerbositySwitch;
import net.sourceforge.jiu.codecs.BMPCodec;
import net.sourceforge.jiu.codecs.CodecMode;
import net.sourceforge.jiu.codecs.ImageCodec;
import net.sourceforge.jiu.codecs.ImageLoader;
import net.sourceforge.jiu.codecs.InvalidFileStructureException;
import net.sourceforge.jiu.codecs.InvalidImageIndexException;
import net.sourceforge.jiu.codecs.PNMCodec;
import net.sourceforge.jiu.codecs.PalmCodec;
import net.sourceforge.jiu.codecs.UnsupportedTypeException;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.ops.OperationFailedException;

public class jiuconvert {
    private jiuconvert() {
    }

    private static Vector createSwitches() {
        Vector<Switch> switches = new Vector<Switch>();
        switches.addElement(new BMPSwitch());
        switches.addElement(new PalmSwitch());
        switches.addElement(new PNMSwitch());
        switches.addElement(new TestSwitch());
        switches.addElement(new NoAwtLoadingSwitch());
        switches.addElement(new OverwriteSwitch());
        switches.addElement(new DestinationDirectorySwitch());
        switches.addElement(new QuietSwitch());
        switches.addElement(new VerbositySwitch());
        switches.addElement(new PrintHelpSwitch());
        switches.addElement(new PrintVersionSwitch());
        return switches;
    }

    private static void exit(JiuConvertSettings settings, int exitCode) {
        settings.time2 = System.currentTimeMillis();
        jiuconvert.println(1, settings, "Time: " + (settings.time2 - settings.time1) / 1000L + " s.");
        System.exit(exitCode);
    }

    private static JiuConvertSettings initFromArguments(String[] args) {
        Switch sw;
        Vector switches;
        PrintHelpSwitch.switches = switches = jiuconvert.createSwitches();
        JiuConvertSettings settings = new JiuConvertSettings();
        settings.time1 = System.currentTimeMillis();
        Hashtable<String, Switch> switchHash = new Hashtable<String, Switch>();
        int i = 0;
        while (i < switches.size()) {
            Switch sw2 = (Switch)switches.elementAt(i);
            sw2.setDefaults(settings);
            String[] values = sw2.getValues();
            int j = 0;
            while (j < values.length) {
                String value;
                if (switchHash.get(value = values[j++]) != null) {
                    System.err.println("FATAL INTERNAL ERROR: Switch " + value + " is used more than once.");
                    System.exit(1);
                }
                switchHash.put(value, sw2);
            }
            ++i;
        }
        int index = 0;
        while (index < args.length) {
            String arg;
            if ((sw = (Switch)switchHash.get(arg = args[index++])) == null) {
                File file;
                if (arg.charAt(0) == '-') {
                    System.err.println("Error: Unknown switch " + arg);
                    System.exit(1);
                }
                if (!(file = new File(arg)).exists() || !file.isFile()) {
                    System.err.println("Error: There is no file \"" + arg + "\".");
                    System.exit(1);
                }
                settings.inputFileNames.addElement(arg);
                continue;
            }
            int minParams = sw.getMinParameters();
            if (index + minParams > args.length) {
                System.err.println("Error: switch " + arg + " needs at least " + minParams + " parameter(s).");
                System.exit(1);
            }
            index = sw.init(args, index, settings);
        }
        int i2 = 0;
        while (i2 < switches.size()) {
            sw = (Switch)switches.elementAt(i2);
            sw.check(settings);
            ++i2;
        }
        if (settings.inputFileNames.size() < 1) {
            System.err.println("Error: You must provide at least one input file name.");
            System.exit(1);
        }
        return settings;
    }

    private static void print(int minVerbosityLevel, JiuConvertSettings settings, String message) {
        if (settings.verbosity >= minVerbosityLevel) {
            System.out.print(message);
        }
    }

    private static void println(int minVerbosityLevel, JiuConvertSettings settings, String message) {
        if (settings.verbosity >= minVerbosityLevel) {
            System.out.println(message);
        }
    }

    private static void run(JiuConvertSettings settings, String inputFileName) {
        String message = null;
        PixelImage image = null;
        try {
            image = ImageLoader.load(inputFileName, null);
        }
        catch (InvalidImageIndexException iiie) {
            message = "Failed: " + iiie.toString();
        }
        catch (InvalidFileStructureException ifse) {
            message = "Failed: " + ifse.toString();
        }
        catch (UnsupportedTypeException ute) {
            message = "Failed: " + ute.toString();
        }
        catch (IOException ioe) {
            message = "Failed: " + ioe.toString();
        }
        if (message == null && image == null) {
            message = "Failed.";
        }
        if (message != null) {
            jiuconvert.println(0, settings, "\"" + inputFileName + "\" " + message);
            return;
        }
        jiuconvert.print(1, settings, "\"" + inputFileName + "\" ");
        jiuconvert.print(1, settings, "Loaded ().");
        if (settings.testOnly) {
            jiuconvert.println(1, settings, "");
            return;
        }
        String outputFileName = inputFileName;
        String sep = System.getProperty("file.separator");
        int index = outputFileName.lastIndexOf(sep);
        if (index != -1) {
            outputFileName = outputFileName.substring(index + sep.length());
        }
        if ((index = outputFileName.lastIndexOf(".")) != -1) {
            outputFileName = outputFileName.substring(0, index);
        }
        ImageCodec codec = null;
        switch (settings.fileFormat) {
            case 0: {
                codec = new BMPCodec();
                break;
            }
            case 2: {
                codec = new PalmCodec();
                break;
            }
            case 1: {
                codec = new PNMCodec();
            }
        }
        String ext = codec.suggestFileExtension(image);
        if (ext != null) {
            outputFileName = String.valueOf(outputFileName) + ext;
        }
        File outputFile = new File(settings.destinationDirectory, outputFileName);
        outputFileName = outputFile.getAbsolutePath();
        if (outputFile.exists() && !settings.overwrite) {
            jiuconvert.println(1, settings, " File \"" + outputFileName + "\" already exists, skipping.");
        }
        codec.setImage(image);
        try {
            codec.setFile(outputFileName, CodecMode.SAVE);
            codec.process();
            codec.close();
            jiuconvert.println(1, settings, " Wrote \"" + outputFileName + "\".");
        }
        catch (IOException ioe) {
            jiuconvert.println(2, settings, " I/O error writing \"" + outputFileName + "\": " + ioe.toString());
        }
        catch (OperationFailedException ofe) {
            jiuconvert.println(2, settings, " Error writing \"" + outputFileName + "\": " + ofe.toString());
        }
    }

    private static void run(JiuConvertSettings settings) {
        int index = 0;
        while (index < settings.inputFileNames.size()) {
            String fileName = (String)settings.inputFileNames.elementAt(index++);
            jiuconvert.run(settings, fileName);
        }
        jiuconvert.exit(settings, 0);
    }

    public static void main(String[] args) {
        JiuConvertSettings settings = jiuconvert.initFromArguments(args);
        jiuconvert.run(settings);
    }
}

