/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.codecs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.sourceforge.jiu.codecs.CodecMode;
import net.sourceforge.jiu.codecs.ImageCodec;
import net.sourceforge.jiu.codecs.InvalidFileStructureException;
import net.sourceforge.jiu.codecs.UnsupportedCodecModeException;
import net.sourceforge.jiu.codecs.UnsupportedTypeException;
import net.sourceforge.jiu.codecs.WrongFileFormatException;
import net.sourceforge.jiu.data.BilevelImage;
import net.sourceforge.jiu.data.ByteChannelImage;
import net.sourceforge.jiu.data.Gray8Image;
import net.sourceforge.jiu.data.MemoryBilevelImage;
import net.sourceforge.jiu.data.MemoryGray8Image;
import net.sourceforge.jiu.data.MemoryPaletted8Image;
import net.sourceforge.jiu.data.MemoryRGB24Image;
import net.sourceforge.jiu.data.Palette;
import net.sourceforge.jiu.data.Paletted8Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.OperationFailedException;
import net.sourceforge.jiu.ops.WrongParameterException;
import net.sourceforge.jiu.util.ArrayConverter;
import net.sourceforge.jiu.util.SeekableByteArrayOutputStream;

public class PalmCodec
extends ImageCodec {
    public static final int COMPRESSION_NONE = 255;
    public static final int COMPRESSION_PACKBITS = 2;
    public static final int COMPRESSION_RLE = 1;
    public static final int COMPRESSION_SCANLINE = 0;
    private static final int FLAG_COMPRESSED = 32768;
    private static final int FLAG_COLOR_TABLE = 16384;
    private static final int FLAG_TRANSPARENCY = 8192;
    private static final int FLAG_INDIRECT = 4096;
    private static final int FLAG_FOR_SCREEN = 2048;
    private static final int FLAG_DIRECT_COLOR = 1024;
    private static final int FLAG_4_BYTE_FIELD = 512;
    private static final short[][] PALM_SYSTEM_PALETTE_4_GRAY = new short[][]{{255, 255, 255}, {192, 192, 192}, {128, 128, 128}, new short[3]};
    private static final short[][] PALM_SYSTEM_PALETTE_16_COLOR;
    private static final short[][] PALM_SYSTEM_PALETTE_16_GRAY;
    private static final short[][] PALM_SYSTEM_PALETTE_256;
    private int bitsPerPixel;
    private int blueBits;
    private int bytesPerRow;
    private byte[] compressedRow;
    private int compression;
    private long compressedDataOffset;
    private int compressedLength;
    private int flags;
    private int greenBits;
    private int height;
    private Palette palette;
    private int nextImageOffset;
    private int redBits;
    private byte[] rgb;
    private byte[] transColor;
    private int transparencyIndex = -1;
    private int version;
    private int width;

    static {
        short[][] sArrayArray = new short[16][];
        sArrayArray[0] = new short[]{255, 255, 255};
        sArrayArray[1] = new short[]{128, 128, 128};
        short[] sArray = new short[3];
        sArray[0] = 128;
        sArrayArray[2] = sArray;
        short[] sArray2 = new short[3];
        sArray2[0] = 128;
        sArray2[1] = 128;
        sArrayArray[3] = sArray2;
        short[] sArray3 = new short[3];
        sArray3[1] = 128;
        sArrayArray[4] = sArray3;
        short[] sArray4 = new short[3];
        sArray4[1] = 128;
        sArray4[2] = 128;
        sArrayArray[5] = sArray4;
        short[] sArray5 = new short[3];
        sArray5[2] = 128;
        sArrayArray[6] = sArray5;
        short[] sArray6 = new short[3];
        sArray6[0] = 128;
        sArray6[2] = 128;
        sArrayArray[7] = sArray6;
        short[] sArray7 = new short[3];
        sArray7[0] = 255;
        sArray7[2] = 255;
        sArrayArray[8] = sArray7;
        sArrayArray[9] = new short[]{192, 192, 192};
        short[] sArray8 = new short[3];
        sArray8[0] = 255;
        sArrayArray[10] = sArray8;
        short[] sArray9 = new short[3];
        sArray9[0] = 255;
        sArray9[1] = 255;
        sArrayArray[11] = sArray9;
        short[] sArray10 = new short[3];
        sArray10[1] = 255;
        sArrayArray[12] = sArray10;
        short[] sArray11 = new short[3];
        sArray11[1] = 255;
        sArray11[2] = 255;
        sArrayArray[13] = sArray11;
        short[] sArray12 = new short[3];
        sArray12[2] = 255;
        sArrayArray[14] = sArray12;
        sArrayArray[15] = new short[3];
        PALM_SYSTEM_PALETTE_16_COLOR = sArrayArray;
        PALM_SYSTEM_PALETTE_16_GRAY = new short[][]{{255, 255, 255}, {238, 238, 238}, {221, 221, 221}, {204, 204, 204}, {187, 187, 187}, {170, 170, 170}, {153, 153, 153}, {136, 136, 136}, {119, 119, 119}, {102, 102, 102}, {85, 85, 85}, {68, 68, 68}, {51, 51, 51}, {34, 34, 34}, {17, 17, 17}, new short[3]};
        short[][] sArrayArray2 = new short[256][];
        sArrayArray2[0] = new short[]{255, 255, 255};
        sArrayArray2[1] = new short[]{255, 204, 255};
        sArrayArray2[2] = new short[]{255, 153, 255};
        sArrayArray2[3] = new short[]{255, 102, 255};
        sArrayArray2[4] = new short[]{255, 51, 255};
        short[] sArray13 = new short[3];
        sArray13[0] = 255;
        sArray13[2] = 255;
        sArrayArray2[5] = sArray13;
        sArrayArray2[6] = new short[]{255, 255, 204};
        sArrayArray2[7] = new short[]{255, 204, 204};
        sArrayArray2[8] = new short[]{255, 153, 204};
        sArrayArray2[9] = new short[]{255, 102, 204};
        sArrayArray2[10] = new short[]{255, 51, 204};
        short[] sArray14 = new short[3];
        sArray14[0] = 255;
        sArray14[2] = 204;
        sArrayArray2[11] = sArray14;
        sArrayArray2[12] = new short[]{255, 255, 153};
        sArrayArray2[13] = new short[]{255, 204, 153};
        sArrayArray2[14] = new short[]{255, 153, 153};
        sArrayArray2[15] = new short[]{255, 102, 153};
        sArrayArray2[16] = new short[]{255, 51, 153};
        short[] sArray15 = new short[3];
        sArray15[0] = 255;
        sArray15[2] = 153;
        sArrayArray2[17] = sArray15;
        sArrayArray2[18] = new short[]{204, 255, 255};
        sArrayArray2[19] = new short[]{204, 204, 255};
        sArrayArray2[20] = new short[]{204, 153, 255};
        sArrayArray2[21] = new short[]{204, 102, 255};
        sArrayArray2[22] = new short[]{204, 51, 255};
        short[] sArray16 = new short[3];
        sArray16[0] = 204;
        sArray16[2] = 255;
        sArrayArray2[23] = sArray16;
        sArrayArray2[24] = new short[]{204, 255, 204};
        sArrayArray2[25] = new short[]{204, 204, 204};
        sArrayArray2[26] = new short[]{204, 153, 204};
        sArrayArray2[27] = new short[]{204, 102, 204};
        sArrayArray2[28] = new short[]{204, 51, 204};
        short[] sArray17 = new short[3];
        sArray17[0] = 204;
        sArray17[2] = 204;
        sArrayArray2[29] = sArray17;
        sArrayArray2[30] = new short[]{204, 255, 153};
        sArrayArray2[31] = new short[]{204, 204, 153};
        sArrayArray2[32] = new short[]{204, 153, 153};
        sArrayArray2[33] = new short[]{204, 102, 153};
        sArrayArray2[34] = new short[]{204, 51, 153};
        short[] sArray18 = new short[3];
        sArray18[0] = 204;
        sArray18[2] = 153;
        sArrayArray2[35] = sArray18;
        sArrayArray2[36] = new short[]{153, 255, 255};
        sArrayArray2[37] = new short[]{153, 204, 255};
        sArrayArray2[38] = new short[]{153, 153, 255};
        sArrayArray2[39] = new short[]{153, 102, 255};
        sArrayArray2[40] = new short[]{153, 51, 255};
        short[] sArray19 = new short[3];
        sArray19[0] = 153;
        sArray19[2] = 255;
        sArrayArray2[41] = sArray19;
        sArrayArray2[42] = new short[]{153, 255, 204};
        sArrayArray2[43] = new short[]{153, 204, 204};
        sArrayArray2[44] = new short[]{153, 153, 204};
        sArrayArray2[45] = new short[]{153, 102, 204};
        sArrayArray2[46] = new short[]{153, 51, 204};
        short[] sArray20 = new short[3];
        sArray20[0] = 153;
        sArray20[2] = 204;
        sArrayArray2[47] = sArray20;
        sArrayArray2[48] = new short[]{153, 255, 153};
        sArrayArray2[49] = new short[]{153, 204, 153};
        sArrayArray2[50] = new short[]{153, 153, 153};
        sArrayArray2[51] = new short[]{153, 102, 153};
        sArrayArray2[52] = new short[]{153, 51, 153};
        short[] sArray21 = new short[3];
        sArray21[0] = 153;
        sArray21[2] = 153;
        sArrayArray2[53] = sArray21;
        sArrayArray2[54] = new short[]{102, 255, 255};
        sArrayArray2[55] = new short[]{102, 204, 255};
        sArrayArray2[56] = new short[]{102, 153, 255};
        sArrayArray2[57] = new short[]{102, 102, 255};
        sArrayArray2[58] = new short[]{102, 51, 255};
        short[] sArray22 = new short[3];
        sArray22[0] = 102;
        sArray22[2] = 255;
        sArrayArray2[59] = sArray22;
        sArrayArray2[60] = new short[]{102, 255, 204};
        sArrayArray2[61] = new short[]{102, 204, 204};
        sArrayArray2[62] = new short[]{102, 153, 204};
        sArrayArray2[63] = new short[]{102, 102, 204};
        sArrayArray2[64] = new short[]{102, 51, 204};
        short[] sArray23 = new short[3];
        sArray23[0] = 102;
        sArray23[2] = 204;
        sArrayArray2[65] = sArray23;
        sArrayArray2[66] = new short[]{102, 255, 153};
        sArrayArray2[67] = new short[]{102, 204, 153};
        sArrayArray2[68] = new short[]{102, 153, 153};
        sArrayArray2[69] = new short[]{102, 102, 153};
        sArrayArray2[70] = new short[]{102, 51, 153};
        short[] sArray24 = new short[3];
        sArray24[0] = 102;
        sArray24[2] = 153;
        sArrayArray2[71] = sArray24;
        sArrayArray2[72] = new short[]{51, 255, 255};
        sArrayArray2[73] = new short[]{51, 204, 255};
        sArrayArray2[74] = new short[]{51, 153, 255};
        sArrayArray2[75] = new short[]{51, 102, 255};
        sArrayArray2[76] = new short[]{51, 51, 255};
        short[] sArray25 = new short[3];
        sArray25[0] = 51;
        sArray25[2] = 255;
        sArrayArray2[77] = sArray25;
        sArrayArray2[78] = new short[]{51, 255, 204};
        sArrayArray2[79] = new short[]{51, 204, 204};
        sArrayArray2[80] = new short[]{51, 153, 204};
        sArrayArray2[81] = new short[]{51, 102, 204};
        sArrayArray2[82] = new short[]{51, 51, 204};
        short[] sArray26 = new short[3];
        sArray26[0] = 51;
        sArray26[2] = 204;
        sArrayArray2[83] = sArray26;
        sArrayArray2[84] = new short[]{51, 255, 153};
        sArrayArray2[85] = new short[]{51, 204, 153};
        sArrayArray2[86] = new short[]{51, 153, 153};
        sArrayArray2[87] = new short[]{51, 102, 153};
        sArrayArray2[88] = new short[]{51, 51, 153};
        short[] sArray27 = new short[3];
        sArray27[0] = 51;
        sArray27[2] = 153;
        sArrayArray2[89] = sArray27;
        short[] sArray28 = new short[3];
        sArray28[1] = 255;
        sArray28[2] = 255;
        sArrayArray2[90] = sArray28;
        short[] sArray29 = new short[3];
        sArray29[1] = 204;
        sArray29[2] = 255;
        sArrayArray2[91] = sArray29;
        short[] sArray30 = new short[3];
        sArray30[1] = 153;
        sArray30[2] = 255;
        sArrayArray2[92] = sArray30;
        short[] sArray31 = new short[3];
        sArray31[1] = 102;
        sArray31[2] = 255;
        sArrayArray2[93] = sArray31;
        short[] sArray32 = new short[3];
        sArray32[1] = 51;
        sArray32[2] = 255;
        sArrayArray2[94] = sArray32;
        short[] sArray33 = new short[3];
        sArray33[2] = 255;
        sArrayArray2[95] = sArray33;
        short[] sArray34 = new short[3];
        sArray34[1] = 255;
        sArray34[2] = 204;
        sArrayArray2[96] = sArray34;
        short[] sArray35 = new short[3];
        sArray35[1] = 204;
        sArray35[2] = 204;
        sArrayArray2[97] = sArray35;
        short[] sArray36 = new short[3];
        sArray36[1] = 153;
        sArray36[2] = 204;
        sArrayArray2[98] = sArray36;
        short[] sArray37 = new short[3];
        sArray37[1] = 102;
        sArray37[2] = 204;
        sArrayArray2[99] = sArray37;
        short[] sArray38 = new short[3];
        sArray38[1] = 51;
        sArray38[2] = 204;
        sArrayArray2[100] = sArray38;
        short[] sArray39 = new short[3];
        sArray39[2] = 204;
        sArrayArray2[101] = sArray39;
        short[] sArray40 = new short[3];
        sArray40[1] = 255;
        sArray40[2] = 153;
        sArrayArray2[102] = sArray40;
        short[] sArray41 = new short[3];
        sArray41[1] = 204;
        sArray41[2] = 153;
        sArrayArray2[103] = sArray41;
        short[] sArray42 = new short[3];
        sArray42[1] = 153;
        sArray42[2] = 153;
        sArrayArray2[104] = sArray42;
        short[] sArray43 = new short[3];
        sArray43[1] = 102;
        sArray43[2] = 153;
        sArrayArray2[105] = sArray43;
        short[] sArray44 = new short[3];
        sArray44[1] = 51;
        sArray44[2] = 153;
        sArrayArray2[106] = sArray44;
        short[] sArray45 = new short[3];
        sArray45[2] = 153;
        sArrayArray2[107] = sArray45;
        sArrayArray2[108] = new short[]{255, 255, 102};
        sArrayArray2[109] = new short[]{255, 204, 102};
        sArrayArray2[110] = new short[]{255, 153, 102};
        sArrayArray2[111] = new short[]{255, 102, 102};
        sArrayArray2[112] = new short[]{255, 51, 102};
        short[] sArray46 = new short[3];
        sArray46[0] = 255;
        sArray46[2] = 102;
        sArrayArray2[113] = sArray46;
        sArrayArray2[114] = new short[]{255, 255, 51};
        sArrayArray2[115] = new short[]{255, 204, 51};
        sArrayArray2[116] = new short[]{255, 153, 51};
        sArrayArray2[117] = new short[]{255, 102, 51};
        sArrayArray2[118] = new short[]{255, 51, 51};
        short[] sArray47 = new short[3];
        sArray47[0] = 255;
        sArray47[2] = 51;
        sArrayArray2[119] = sArray47;
        short[] sArray48 = new short[3];
        sArray48[0] = 255;
        sArray48[1] = 255;
        sArrayArray2[120] = sArray48;
        short[] sArray49 = new short[3];
        sArray49[0] = 255;
        sArray49[1] = 204;
        sArrayArray2[121] = sArray49;
        short[] sArray50 = new short[3];
        sArray50[0] = 255;
        sArray50[1] = 153;
        sArrayArray2[122] = sArray50;
        short[] sArray51 = new short[3];
        sArray51[0] = 255;
        sArray51[1] = 102;
        sArrayArray2[123] = sArray51;
        short[] sArray52 = new short[3];
        sArray52[0] = 255;
        sArray52[1] = 51;
        sArrayArray2[124] = sArray52;
        short[] sArray53 = new short[3];
        sArray53[0] = 255;
        sArrayArray2[125] = sArray53;
        sArrayArray2[126] = new short[]{204, 255, 102};
        sArrayArray2[127] = new short[]{204, 204, 102};
        sArrayArray2[128] = new short[]{204, 153, 102};
        sArrayArray2[129] = new short[]{204, 102, 102};
        sArrayArray2[130] = new short[]{204, 51, 102};
        short[] sArray54 = new short[3];
        sArray54[0] = 204;
        sArray54[2] = 102;
        sArrayArray2[131] = sArray54;
        sArrayArray2[132] = new short[]{204, 255, 51};
        sArrayArray2[133] = new short[]{204, 204, 51};
        sArrayArray2[134] = new short[]{204, 153, 51};
        sArrayArray2[135] = new short[]{204, 102, 51};
        sArrayArray2[136] = new short[]{204, 51, 51};
        short[] sArray55 = new short[3];
        sArray55[0] = 204;
        sArray55[2] = 51;
        sArrayArray2[137] = sArray55;
        short[] sArray56 = new short[3];
        sArray56[0] = 204;
        sArray56[1] = 255;
        sArrayArray2[138] = sArray56;
        short[] sArray57 = new short[3];
        sArray57[0] = 204;
        sArray57[1] = 204;
        sArrayArray2[139] = sArray57;
        short[] sArray58 = new short[3];
        sArray58[0] = 204;
        sArray58[1] = 153;
        sArrayArray2[140] = sArray58;
        short[] sArray59 = new short[3];
        sArray59[0] = 204;
        sArray59[1] = 102;
        sArrayArray2[141] = sArray59;
        short[] sArray60 = new short[3];
        sArray60[0] = 204;
        sArray60[1] = 51;
        sArrayArray2[142] = sArray60;
        short[] sArray61 = new short[3];
        sArray61[0] = 204;
        sArrayArray2[143] = sArray61;
        sArrayArray2[144] = new short[]{153, 255, 102};
        sArrayArray2[145] = new short[]{153, 204, 102};
        sArrayArray2[146] = new short[]{153, 153, 102};
        sArrayArray2[147] = new short[]{153, 102, 102};
        sArrayArray2[148] = new short[]{153, 51, 102};
        short[] sArray62 = new short[3];
        sArray62[0] = 153;
        sArray62[2] = 102;
        sArrayArray2[149] = sArray62;
        sArrayArray2[150] = new short[]{153, 255, 51};
        sArrayArray2[151] = new short[]{153, 204, 51};
        sArrayArray2[152] = new short[]{153, 153, 51};
        sArrayArray2[153] = new short[]{153, 102, 51};
        sArrayArray2[154] = new short[]{153, 51, 51};
        short[] sArray63 = new short[3];
        sArray63[0] = 153;
        sArray63[2] = 51;
        sArrayArray2[155] = sArray63;
        short[] sArray64 = new short[3];
        sArray64[0] = 153;
        sArray64[1] = 255;
        sArrayArray2[156] = sArray64;
        short[] sArray65 = new short[3];
        sArray65[0] = 153;
        sArray65[1] = 204;
        sArrayArray2[157] = sArray65;
        short[] sArray66 = new short[3];
        sArray66[0] = 153;
        sArray66[1] = 153;
        sArrayArray2[158] = sArray66;
        short[] sArray67 = new short[3];
        sArray67[0] = 153;
        sArray67[1] = 102;
        sArrayArray2[159] = sArray67;
        short[] sArray68 = new short[3];
        sArray68[0] = 153;
        sArray68[1] = 51;
        sArrayArray2[160] = sArray68;
        short[] sArray69 = new short[3];
        sArray69[0] = 153;
        sArrayArray2[161] = sArray69;
        sArrayArray2[162] = new short[]{102, 255, 102};
        sArrayArray2[163] = new short[]{102, 204, 102};
        sArrayArray2[164] = new short[]{102, 153, 102};
        sArrayArray2[165] = new short[]{102, 102, 102};
        sArrayArray2[166] = new short[]{102, 51, 102};
        short[] sArray70 = new short[3];
        sArray70[0] = 102;
        sArray70[2] = 102;
        sArrayArray2[167] = sArray70;
        sArrayArray2[168] = new short[]{102, 255, 51};
        sArrayArray2[169] = new short[]{102, 204, 51};
        sArrayArray2[170] = new short[]{102, 153, 51};
        sArrayArray2[171] = new short[]{102, 102, 51};
        sArrayArray2[172] = new short[]{102, 51, 51};
        short[] sArray71 = new short[3];
        sArray71[0] = 102;
        sArray71[2] = 51;
        sArrayArray2[173] = sArray71;
        short[] sArray72 = new short[3];
        sArray72[0] = 102;
        sArray72[1] = 255;
        sArrayArray2[174] = sArray72;
        short[] sArray73 = new short[3];
        sArray73[0] = 102;
        sArray73[1] = 204;
        sArrayArray2[175] = sArray73;
        short[] sArray74 = new short[3];
        sArray74[0] = 102;
        sArray74[1] = 153;
        sArrayArray2[176] = sArray74;
        short[] sArray75 = new short[3];
        sArray75[0] = 102;
        sArray75[1] = 102;
        sArrayArray2[177] = sArray75;
        short[] sArray76 = new short[3];
        sArray76[0] = 102;
        sArray76[1] = 51;
        sArrayArray2[178] = sArray76;
        short[] sArray77 = new short[3];
        sArray77[0] = 102;
        sArrayArray2[179] = sArray77;
        sArrayArray2[180] = new short[]{51, 255, 102};
        sArrayArray2[181] = new short[]{51, 204, 102};
        sArrayArray2[182] = new short[]{51, 153, 102};
        sArrayArray2[183] = new short[]{51, 102, 102};
        sArrayArray2[184] = new short[]{51, 51, 102};
        short[] sArray78 = new short[3];
        sArray78[0] = 51;
        sArray78[2] = 102;
        sArrayArray2[185] = sArray78;
        sArrayArray2[186] = new short[]{51, 255, 51};
        sArrayArray2[187] = new short[]{51, 204, 51};
        sArrayArray2[188] = new short[]{51, 153, 51};
        sArrayArray2[189] = new short[]{51, 102, 51};
        sArrayArray2[190] = new short[]{51, 51, 51};
        short[] sArray79 = new short[3];
        sArray79[0] = 51;
        sArray79[2] = 51;
        sArrayArray2[191] = sArray79;
        short[] sArray80 = new short[3];
        sArray80[0] = 51;
        sArray80[1] = 255;
        sArrayArray2[192] = sArray80;
        short[] sArray81 = new short[3];
        sArray81[0] = 51;
        sArray81[1] = 204;
        sArrayArray2[193] = sArray81;
        short[] sArray82 = new short[3];
        sArray82[0] = 51;
        sArray82[1] = 153;
        sArrayArray2[194] = sArray82;
        short[] sArray83 = new short[3];
        sArray83[0] = 51;
        sArray83[1] = 102;
        sArrayArray2[195] = sArray83;
        short[] sArray84 = new short[3];
        sArray84[0] = 51;
        sArray84[1] = 51;
        sArrayArray2[196] = sArray84;
        short[] sArray85 = new short[3];
        sArray85[0] = 51;
        sArrayArray2[197] = sArray85;
        short[] sArray86 = new short[3];
        sArray86[1] = 255;
        sArray86[2] = 102;
        sArrayArray2[198] = sArray86;
        short[] sArray87 = new short[3];
        sArray87[1] = 204;
        sArray87[2] = 102;
        sArrayArray2[199] = sArray87;
        short[] sArray88 = new short[3];
        sArray88[1] = 153;
        sArray88[2] = 102;
        sArrayArray2[200] = sArray88;
        short[] sArray89 = new short[3];
        sArray89[1] = 102;
        sArray89[2] = 102;
        sArrayArray2[201] = sArray89;
        short[] sArray90 = new short[3];
        sArray90[1] = 51;
        sArray90[2] = 102;
        sArrayArray2[202] = sArray90;
        short[] sArray91 = new short[3];
        sArray91[2] = 102;
        sArrayArray2[203] = sArray91;
        short[] sArray92 = new short[3];
        sArray92[1] = 255;
        sArray92[2] = 51;
        sArrayArray2[204] = sArray92;
        short[] sArray93 = new short[3];
        sArray93[1] = 204;
        sArray93[2] = 51;
        sArrayArray2[205] = sArray93;
        short[] sArray94 = new short[3];
        sArray94[1] = 153;
        sArray94[2] = 51;
        sArrayArray2[206] = sArray94;
        short[] sArray95 = new short[3];
        sArray95[1] = 102;
        sArray95[2] = 51;
        sArrayArray2[207] = sArray95;
        short[] sArray96 = new short[3];
        sArray96[1] = 51;
        sArray96[2] = 51;
        sArrayArray2[208] = sArray96;
        short[] sArray97 = new short[3];
        sArray97[2] = 51;
        sArrayArray2[209] = sArray97;
        short[] sArray98 = new short[3];
        sArray98[1] = 255;
        sArrayArray2[210] = sArray98;
        short[] sArray99 = new short[3];
        sArray99[1] = 204;
        sArrayArray2[211] = sArray99;
        short[] sArray100 = new short[3];
        sArray100[1] = 153;
        sArrayArray2[212] = sArray100;
        short[] sArray101 = new short[3];
        sArray101[1] = 102;
        sArrayArray2[213] = sArray101;
        short[] sArray102 = new short[3];
        sArray102[1] = 51;
        sArrayArray2[214] = sArray102;
        sArrayArray2[215] = new short[]{17, 17, 17};
        sArrayArray2[216] = new short[]{34, 34, 34};
        sArrayArray2[217] = new short[]{68, 68, 68};
        sArrayArray2[218] = new short[]{85, 85, 85};
        sArrayArray2[219] = new short[]{119, 119, 119};
        sArrayArray2[220] = new short[]{136, 136, 136};
        sArrayArray2[221] = new short[]{170, 170, 170};
        sArrayArray2[222] = new short[]{187, 187, 187};
        sArrayArray2[223] = new short[]{221, 221, 221};
        sArrayArray2[224] = new short[]{238, 238, 238};
        sArrayArray2[225] = new short[]{192, 192, 192};
        short[] sArray103 = new short[3];
        sArray103[0] = 128;
        sArrayArray2[226] = sArray103;
        short[] sArray104 = new short[3];
        sArray104[0] = 128;
        sArray104[2] = 128;
        sArrayArray2[227] = sArray104;
        short[] sArray105 = new short[3];
        sArray105[1] = 128;
        sArrayArray2[228] = sArray105;
        short[] sArray106 = new short[3];
        sArray106[1] = 128;
        sArray106[2] = 128;
        sArrayArray2[229] = sArray106;
        sArrayArray2[230] = new short[3];
        sArrayArray2[231] = new short[3];
        sArrayArray2[232] = new short[3];
        sArrayArray2[233] = new short[3];
        sArrayArray2[234] = new short[3];
        sArrayArray2[235] = new short[3];
        sArrayArray2[236] = new short[3];
        sArrayArray2[237] = new short[3];
        sArrayArray2[238] = new short[3];
        sArrayArray2[239] = new short[3];
        sArrayArray2[240] = new short[3];
        sArrayArray2[241] = new short[3];
        sArrayArray2[242] = new short[3];
        sArrayArray2[243] = new short[3];
        sArrayArray2[244] = new short[3];
        sArrayArray2[245] = new short[3];
        sArrayArray2[246] = new short[3];
        sArrayArray2[247] = new short[3];
        sArrayArray2[248] = new short[3];
        sArrayArray2[249] = new short[3];
        sArrayArray2[250] = new short[3];
        sArrayArray2[251] = new short[3];
        sArrayArray2[252] = new short[3];
        sArrayArray2[253] = new short[3];
        sArrayArray2[254] = new short[3];
        sArrayArray2[255] = new short[3];
        PALM_SYSTEM_PALETTE_256 = sArrayArray2;
    }

    private static Palette createPalette(short[][] data) {
        Palette result = new Palette(data.length);
        int i = 0;
        while (i < data.length) {
            result.put(i, data[i][0], data[i][1], data[i][2]);
            ++i;
        }
        return result;
    }

    public static Palette createSystem2BitGrayscalePalette() {
        return PalmCodec.createPalette(PALM_SYSTEM_PALETTE_4_GRAY);
    }

    public static Palette createSystem4BitColorPalette() {
        return PalmCodec.createPalette(PALM_SYSTEM_PALETTE_16_COLOR);
    }

    public static Palette createSystem4BitGrayscalePalette() {
        return PalmCodec.createPalette(PALM_SYSTEM_PALETTE_16_GRAY);
    }

    public static Palette createSystem8BitPalette() {
        return PalmCodec.createPalette(PALM_SYSTEM_PALETTE_256);
    }

    public int getCompression() {
        return this.compression;
    }

    public String getFormatName() {
        return "Palm image file format";
    }

    public String[] getMimeTypes() {
        return null;
    }

    public int getTransparencyIndex() {
        return this.transparencyIndex;
    }

    public boolean hasTransparencyIndex() {
        return this.transparencyIndex >= 0;
    }

    private void invertBilevelData(byte[] row) {
        if (row != null) {
            int i = 0;
            while (i < row.length) {
                row[i] = ~row[i];
                ++i;
            }
        }
    }

    private static boolean isEqualPalette(Palette palette, short[][] data) {
        if (palette == null || data == null) {
            return false;
        }
        if (palette.getNumEntries() != data.length) {
            return false;
        }
        int i = 0;
        while (i < data.length) {
            int red = palette.getSample(0, i);
            int green = palette.getSample(1, i);
            int blue = palette.getSample(2, i);
            short[] color = data[i];
            if (color[0] != red || color[1] != green || color[2] != blue) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isLoadingSupported() {
        return true;
    }

    public static boolean isPalmSystemPaletteGray4(Palette palette) {
        return PalmCodec.isEqualPalette(palette, PALM_SYSTEM_PALETTE_4_GRAY);
    }

    public static boolean isPalmSystemPaletteGray16(Palette palette) {
        return PalmCodec.isEqualPalette(palette, PALM_SYSTEM_PALETTE_16_GRAY);
    }

    public static boolean isPalmSystemPaletteColor16(Palette palette) {
        return PalmCodec.isEqualPalette(palette, PALM_SYSTEM_PALETTE_16_COLOR);
    }

    public static boolean isPalmSystemPalette256(Palette palette) {
        return PalmCodec.isEqualPalette(palette, PALM_SYSTEM_PALETTE_256);
    }

    public boolean isSavingSupported() {
        return true;
    }

    private void load() throws InvalidFileStructureException, IOException, OperationFailedException, UnsupportedTypeException, WrongFileFormatException {
        DataInput in = this.getInputAsDataInput();
        this.loadHeader(in);
        this.loadPalette(in);
        this.loadImage(in);
    }

    private void loadHeader(DataInput in) throws InvalidFileStructureException, IOException, UnsupportedTypeException, WrongFileFormatException {
        this.width = in.readShort() & 0xFFFF;
        this.height = in.readShort() & 0xFFFF;
        this.bytesPerRow = in.readShort() & 0xFFFF;
        this.flags = in.readShort() & 0xFFFF;
        this.bitsPerPixel = in.readUnsignedByte();
        this.version = in.readUnsignedByte();
        this.nextImageOffset = in.readShort() & 0xFFFF;
        this.transparencyIndex = in.readUnsignedByte() & 0xFFFF;
        this.compression = in.readUnsignedByte() & 0xFFFF;
        in.skipBytes(2);
        if ((this.flags & 0x8000) == 0) {
            this.compression = 255;
        }
        boolean unsupportedDirectColor = false;
        if ((this.flags & 0x400) != 0) {
            this.redBits = in.readUnsignedByte();
            this.greenBits = in.readUnsignedByte();
            this.blueBits = in.readUnsignedByte();
            unsupportedDirectColor = this.redBits != 5 || this.greenBits != 6 || this.blueBits != 5;
            in.skipBytes(2);
            this.transColor = new byte[3];
            in.readFully(this.transColor);
        }
        if (this.width < 1 || this.height < 1 || unsupportedDirectColor || this.bitsPerPixel != 1 && this.bitsPerPixel != 2 && this.bitsPerPixel != 4 && this.bitsPerPixel != 8 && this.bitsPerPixel != 16 || this.compression != 255 && this.compression != 1 && this.compression != 0) {
            throw new WrongFileFormatException("Not a file in Palm image file format.");
        }
    }

    private void loadImage(DataInput in) throws InvalidFileStructureException, IOException, UnsupportedTypeException, WrongFileFormatException, WrongParameterException {
        this.setBoundsIfNecessary(this.width, this.height);
        this.checkBounds(this.width, this.height);
        PixelImage image = this.getImage();
        if (this.palette != null) {
            if (image == null) {
                image = new MemoryPaletted8Image(this.getBoundsWidth(), this.getBoundsHeight(), this.palette);
            } else {
                if (!(image instanceof Paletted8Image)) {
                    throw new WrongParameterException("Image to be used for loading must be paletted for this file.");
                }
                ((Paletted8Image)image).setPalette(this.palette);
            }
        } else {
            switch (this.bitsPerPixel) {
                case 1: {
                    if (image == null) {
                        image = new MemoryBilevelImage(this.getBoundsWidth(), this.getBoundsHeight());
                        break;
                    }
                    if (image instanceof BilevelImage) break;
                    throw new WrongParameterException("Image to be used for loading must implement BilevelImage for this file.");
                }
                case 16: {
                    if (image == null) {
                        image = new MemoryRGB24Image(this.getBoundsWidth(), this.getBoundsHeight());
                    } else if (!(image instanceof RGB24Image)) {
                        throw new WrongParameterException("Image to be used for loading must implement RGB24Image.");
                    }
                    this.rgb = new byte[this.width * 3];
                    break;
                }
                default: {
                    if (image == null) {
                        image = new MemoryGray8Image(this.getBoundsWidth(), this.getBoundsHeight());
                        break;
                    }
                    if (image instanceof Gray8Image) break;
                    throw new WrongParameterException("Image to be used for loading must implement Gray8Image for this file.");
                }
            }
        }
        this.setImage(image);
        if (image.getWidth() != this.getBoundsWidth() || image.getHeight() != this.getBoundsHeight()) {
            throw new WrongParameterException("Image to be reused has wrong resolution (must have " + this.getBoundsWidth() + " x " + this.getBoundsHeight() + " pixels).");
        }
        this.loadImageData(in);
    }

    private void loadImageData(DataInput in) throws InvalidFileStructureException, IOException {
        PixelImage image = this.getImage();
        if (this.compression != 255) {
            int n = in.readShort() & 0xFFFF;
        }
        byte[] row = new byte[this.bytesPerRow];
        int NUM_ROWS = this.getBoundsY2() + 1;
        int y = 0;
        while (y < NUM_ROWS) {
            switch (this.compression) {
                case 255: {
                    in.readFully(row, 0, this.bytesPerRow);
                    break;
                }
                case 1: {
                    int index = 0;
                    do {
                        int num;
                        if ((num = in.readUnsignedByte()) < 1 || index + num > this.bytesPerRow) {
                            String message = "At index=" + index + ", y=" + y + " there is a run length of " + num;
                            System.err.println("ERROR decoding RLE: " + message);
                            throw new InvalidFileStructureException(message);
                        }
                        byte value = in.readByte();
                        while (num-- > 0) {
                            row[index++] = value;
                        }
                    } while (index < this.bytesPerRow);
                    break;
                }
                case 0: {
                    int index = 0;
                    int pixelMask = 0;
                    int mask = 0;
                    do {
                        if (mask == 0) {
                            pixelMask = in.readUnsignedByte();
                            mask = 128;
                        }
                        if ((pixelMask & mask) == 0) {
                            ++index;
                        } else {
                            row[index++] = in.readByte();
                        }
                        mask >>= 1;
                    } while (index < this.bytesPerRow);
                    break;
                }
            }
            this.store(image, y, row);
            this.setProgress(y, NUM_ROWS);
            ++y;
        }
    }

    private void loadPalette(DataInput in) throws InvalidFileStructureException, IOException, UnsupportedTypeException, WrongFileFormatException {
        if ((this.flags & 0x4000) == 0) {
            switch (this.bitsPerPixel) {
                case 2: {
                    this.palette = PalmCodec.createSystem2BitGrayscalePalette();
                    break;
                }
                case 4: {
                    this.palette = PalmCodec.createSystem4BitGrayscalePalette();
                    break;
                }
                case 8: {
                    this.palette = PalmCodec.createSystem8BitPalette();
                }
            }
            return;
        }
        int numEntries = in.readShort() & 0xFFFF;
        if (numEntries < 1 || numEntries > 256) {
            throw new WrongFileFormatException("Not a Palm image file, invalid number of palette entries: " + numEntries);
        }
        this.palette = new Palette(numEntries, 255);
        int i = 0;
        while (i < numEntries) {
            int reserved = in.readUnsignedByte();
            int red = in.readUnsignedByte();
            int green = in.readUnsignedByte();
            int blue = in.readUnsignedByte();
            this.palette.putSample(0, i, red);
            this.palette.putSample(1, i, green);
            this.palette.putSample(2, i, blue);
            ++i;
        }
    }

    public void process() throws InvalidFileStructureException, MissingParameterException, OperationFailedException, WrongParameterException {
        block4: {
            try {
                this.initModeFromIOObjects();
                if (this.getMode() == CodecMode.LOAD) {
                    this.load();
                    break block4;
                }
                if (this.getMode() == CodecMode.SAVE) {
                    this.save();
                    break block4;
                }
                throw new WrongParameterException("Could find neither objects for loading nor for saving.");
            }
            catch (IOException ioe) {
                throw new OperationFailedException("I/O error in Palm codec: " + ioe.toString());
            }
        }
    }

    public void removeTransparencyIndex() {
        this.transparencyIndex = -1;
    }

    private void save() throws IOException, OperationFailedException, UnsupportedTypeException {
        PixelImage image = this.getImage();
        if (image == null) {
            throw new MissingParameterException("Need image to save.");
        }
        this.setBoundsIfNecessary(image.getWidth(), image.getHeight());
        this.checkBounds(image.getWidth(), image.getHeight());
        DataOutput out = this.getOutputAsDataOutput();
        if (out == null) {
            throw new MissingParameterException("Could not get DataOutput object when saving in Palm file format.");
        }
        this.width = this.getBoundsWidth();
        this.height = this.getBoundsHeight();
        this.flags = 0;
        if (this.hasTransparencyIndex()) {
            this.flags |= 0x2000;
        }
        if (this.compression != 255) {
            this.flags |= 0x8000;
        }
        this.version = 0;
        if (this.bitsPerPixel > 1) {
            this.version = 1;
        }
        if (this.hasTransparencyIndex() || this.compression != 255) {
            this.version = 2;
        }
        this.nextImageOffset = 0;
        this.compressedDataOffset = 0L;
        if (image instanceof BilevelImage) {
            this.save(out, (BilevelImage)image);
        } else if (image instanceof Gray8Image) {
            this.save(out, (Gray8Image)image);
        } else if (image instanceof Paletted8Image) {
            this.save(out, (Paletted8Image)image);
        } else if (image instanceof RGB24Image) {
            this.save(out, (RGB24Image)image);
        } else {
            throw new UnsupportedTypeException("Unsupported image type: " + image.getClass().getName());
        }
    }

    private void save(DataOutput out, BilevelImage image) throws IOException {
        this.bytesPerRow = (this.width + 7) / 8;
        if (this.bytesPerRow % 2 == 1) {
            ++this.bytesPerRow;
        }
        this.bitsPerPixel = 1;
        this.setCorrectVersion();
        this.saveHeader(out);
        byte[] row = new byte[this.bytesPerRow];
        byte[] prev = null;
        if (this.compression == 0) {
            prev = new byte[row.length];
        }
        int X1 = this.getBoundsX1();
        int Y1 = this.getBoundsY1();
        int y = 0;
        while (y < this.height) {
            image.getPackedBytes(X1, y + Y1, this.width, row, 0, 0);
            this.invertBilevelData(row);
            this.saveRow(out, y == 0, row, prev);
            if (this.compression == 0) {
                System.arraycopy(row, 0, prev, 0, row.length);
            }
            this.setProgress(y, this.height);
            ++y;
        }
        this.saveFinalCompressedSize(out);
    }

    private void save(DataOutput out, Gray8Image image) throws IOException {
        this.bytesPerRow = this.width;
        if (this.bytesPerRow % 2 == 1) {
            ++this.bytesPerRow;
        }
        this.bitsPerPixel = 8;
        this.flags |= 0x4000;
        this.setCorrectVersion();
        this.saveHeader(out);
        out.writeShort(256);
        int i = 0;
        while (i < 256) {
            out.writeByte(0);
            out.writeByte(i);
            out.writeByte(i);
            out.writeByte(i);
            ++i;
        }
        this.compressedDataOffset += 1026L;
        this.saveInitialCompressedSize(out);
        byte[] row = new byte[this.width];
        byte[] prev = null;
        if (this.compression == 0) {
            prev = new byte[this.width];
        }
        int X1 = this.getBoundsX1();
        int Y1 = this.getBoundsY1();
        int y = 0;
        while (y < this.height) {
            image.getByteSamples(0, X1, y + Y1, this.width, 1, row, 0);
            this.saveRow(out, y == 0, row, prev);
            if (this.compression == 0) {
                System.arraycopy(row, 0, prev, 0, row.length);
            }
            this.setProgress(y, this.height);
            ++y;
        }
        this.saveFinalCompressedSize(out);
    }

    private void save(DataOutput out, Paletted8Image image) throws IOException {
        boolean customPalette;
        Palette palette = image.getPalette();
        boolean system256Palette = PalmCodec.isPalmSystemPalette256(palette);
        boolean system16GrayPalette = PalmCodec.isPalmSystemPaletteGray16(palette);
        boolean system16ColorPalette = PalmCodec.isPalmSystemPaletteColor16(palette);
        boolean system4GrayPalette = PalmCodec.isPalmSystemPaletteGray4(palette);
        boolean bl = customPalette = !system256Palette && !system16GrayPalette && !system16ColorPalette && !system4GrayPalette;
        if (customPalette) {
            this.flags |= 0x4000;
        }
        if (palette.getNumEntries() <= 4) {
            this.bitsPerPixel = 2;
            this.bytesPerRow = (this.width + 3) / 4;
        } else if (palette.getNumEntries() <= 16) {
            this.bitsPerPixel = 4;
            this.bytesPerRow = (this.width + 1) / 2;
        } else {
            this.bitsPerPixel = 8;
            this.bytesPerRow = this.width;
        }
        if (this.bytesPerRow % 2 == 1) {
            ++this.bytesPerRow;
        }
        this.setCorrectVersion();
        this.saveHeader(out);
        if (customPalette) {
            this.savePalette(out, palette);
        }
        this.saveInitialCompressedSize(out);
        byte[] row = new byte[this.width];
        byte[] prev = null;
        if (this.compression == 0) {
            prev = new byte[row.length];
        }
        byte[] temp = null;
        if (this.bitsPerPixel < 8) {
            temp = new byte[this.width];
        }
        int X1 = this.getBoundsX1();
        int Y1 = this.getBoundsY1();
        int y = 0;
        while (y < this.height) {
            switch (this.bitsPerPixel) {
                case 2: {
                    image.getByteSamples(0, X1, y + Y1, this.width, 1, temp, 0);
                    ArrayConverter.encodePacked2Bit(temp, 0, row, 0, this.width);
                    break;
                }
                case 4: {
                    image.getByteSamples(0, X1, y + Y1, this.width, 1, temp, 0);
                    ArrayConverter.encodePacked4Bit(temp, 0, row, 0, this.width);
                    break;
                }
                case 8: {
                    image.getByteSamples(0, X1, y + Y1, this.width, 1, row, 0);
                }
            }
            this.saveRow(out, y == 0, row, prev);
            if (this.compression == 0) {
                System.arraycopy(row, 0, prev, 0, row.length);
            }
            this.setProgress(y, this.height);
            ++y;
        }
        this.saveFinalCompressedSize(out);
    }

    private void save(DataOutput out, RGB24Image image) throws IOException {
        this.bytesPerRow = this.width * 2;
        this.bitsPerPixel = 16;
        this.flags |= 0x400;
        this.setCorrectVersion();
        this.saveHeader(out);
        out.write(5);
        out.write(6);
        out.write(5);
        int i = 5;
        while (i-- > 0) {
            out.write(0);
        }
        this.compressedDataOffset += 8L;
        byte[] row = new byte[this.width * 2];
        byte[] prev = null;
        if (this.compression == 0) {
            prev = new byte[row.length];
        }
        byte[] red = new byte[this.width];
        byte[] green = new byte[this.width];
        byte[] blue = new byte[this.width];
        int X1 = this.getBoundsX1();
        int Y1 = this.getBoundsY1();
        int y = 0;
        while (y < this.height) {
            image.getByteSamples(0, X1, y + Y1, this.width, 1, red, 0);
            image.getByteSamples(1, X1, y + Y1, this.width, 1, green, 0);
            image.getByteSamples(2, X1, y + Y1, this.width, 1, blue, 0);
            ArrayConverter.encodeRGB24ToPackedRGB565BigEndian(red, 0, green, 0, blue, 0, row, 0, this.width);
            this.saveRow(out, y == 0, row, prev);
            if (this.compression == 0) {
                System.arraycopy(row, 0, prev, 0, row.length);
            }
            this.setProgress(y, this.height);
            ++y;
        }
        this.saveFinalCompressedSize(out);
    }

    private void saveFinalCompressedSize(DataOutput out) throws IOException {
        if ((this.flags & 0x8000) == 0) {
            return;
        }
        if (!(out instanceof RandomAccessFile) && !(out instanceof SeekableByteArrayOutputStream)) {
            return;
        }
        long pos = -1L;
        if (out instanceof RandomAccessFile) {
            RandomAccessFile raf = (RandomAccessFile)out;
            pos = raf.length();
        } else if (out instanceof SeekableByteArrayOutputStream) {
            SeekableByteArrayOutputStream sbaos = (SeekableByteArrayOutputStream)((Object)out);
            pos = sbaos.getPosition();
        }
        long compressedSize = pos - this.compressedDataOffset;
        compressedSize = Math.min(65535L, compressedSize);
        if (out instanceof RandomAccessFile) {
            RandomAccessFile raf = (RandomAccessFile)out;
            raf.seek(this.compressedDataOffset);
            raf.writeShort((int)compressedSize);
        } else if (out instanceof SeekableByteArrayOutputStream) {
            SeekableByteArrayOutputStream sbaos = (SeekableByteArrayOutputStream)((Object)out);
            sbaos.seek((int)this.compressedDataOffset);
            sbaos.write((int)(compressedSize >> 8) & 0xFF);
            sbaos.write((int)compressedSize & 0xFF);
        }
    }

    private void saveHeader(DataOutput out) throws IOException {
        out.writeShort(this.width);
        out.writeShort(this.height);
        out.writeShort(this.bytesPerRow);
        out.writeShort(this.flags);
        out.writeByte(this.bitsPerPixel);
        out.writeByte(this.version);
        out.writeShort(0);
        out.writeByte(this.transparencyIndex);
        out.writeByte(this.compression);
        out.writeShort(0);
        this.compressedDataOffset = 16L;
    }

    private void saveInitialCompressedSize(DataOutput out) throws IOException {
        if ((this.flags & 0x8000) == 0) {
            return;
        }
        out.writeShort(this.bytesPerRow * this.height);
    }

    private void savePalette(DataOutput out, Palette palette) throws IOException {
        out.writeShort(palette.getNumEntries());
        int i = 0;
        while (i < palette.getNumEntries()) {
            out.writeByte(0);
            out.writeByte(palette.getSample(0, i));
            out.writeByte(palette.getSample(1, i));
            out.writeByte(palette.getSample(2, i));
            ++i;
        }
        this.compressedDataOffset += (long)(2 + 4 * palette.getNumEntries());
    }

    private void saveRow(DataOutput out, boolean firstRow, byte[] row, byte[] prev) throws IOException {
        switch (this.compression) {
            case 255: {
                out.write(row, 0, this.bytesPerRow);
                break;
            }
            case 1: {
                this.saveRowRLE(out, row);
                break;
            }
            case 0: {
                this.saveRowScanLine(out, firstRow, row, prev);
            }
        }
    }

    private void saveRowRLE(DataOutput out, byte[] row) throws IOException {
        int runLength;
        int srcOffset = 0;
        do {
            runLength = 1;
            int bytesLeft = this.bytesPerRow - srcOffset;
            byte value = row[srcOffset];
            while (bytesLeft != 0 && srcOffset + runLength < row.length && value == row[srcOffset + runLength]) {
                --bytesLeft;
                if (++runLength != 255) continue;
                bytesLeft = 0;
            }
            out.writeByte(runLength);
            out.writeByte(value & 0xFF);
        } while ((srcOffset += runLength) < this.bytesPerRow);
    }

    private void saveRowScanLine(DataOutput out, boolean firstRow, byte[] row, byte[] prev) throws IOException {
        int bytesLeft = this.bytesPerRow;
        int srcOffset = 0;
        byte[] bytes = new byte[8];
        do {
            int pixelMask = 0;
            int bitMask = 128;
            int numBytesToCheck = Math.min(8, bytesLeft);
            int numOutputBytes = 0;
            bytesLeft -= numBytesToCheck;
            while (numBytesToCheck-- != 0) {
                if (row[srcOffset] != prev[srcOffset]) {
                    pixelMask |= bitMask;
                    bytes[numOutputBytes++] = row[srcOffset];
                }
                ++srcOffset;
                bitMask >>= 1;
            }
            out.writeByte(pixelMask);
            out.write(bytes, 0, numOutputBytes);
        } while (bytesLeft != 0);
    }

    public void setCompression(int newCompressionType) {
        if (newCompressionType != 255 && newCompressionType != 1 && newCompressionType != 0) {
            throw new IllegalArgumentException("Unsupported Palm compression type for writing.");
        }
        this.compression = newCompressionType;
    }

    private void setCorrectVersion() {
        this.version = 0;
        if (this.bitsPerPixel > 1) {
            this.version = 1;
        }
        if (this.hasTransparencyIndex() || this.getCompression() == 0 || this.getCompression() == 1) {
            this.version = 2;
        }
    }

    public void setFile(String fileName, CodecMode codecMode) throws IOException, UnsupportedCodecModeException {
        if (codecMode == CodecMode.LOAD) {
            super.setFile(fileName, codecMode);
        } else {
            this.setRandomAccessFile(new RandomAccessFile(fileName, "rw"), CodecMode.SAVE);
        }
    }

    public void setTransparencyIndex(int newIndex) {
        if (newIndex < 0) {
            throw new IllegalArgumentException("Transparency index must be 0 or larger.");
        }
        this.transparencyIndex = newIndex;
    }

    private void store(PixelImage image, int y, byte[] row) {
        if (!this.isRowRequired(y)) {
            return;
        }
        y -= this.getBoundsY1();
        switch (this.bitsPerPixel) {
            case 1: {
                BilevelImage bimage = (BilevelImage)image;
                this.invertBilevelData(row);
                bimage.putPackedBytes(0, y, this.getBoundsWidth(), row, this.getBoundsX1() / 8, this.getBoundsX1() % 8);
                break;
            }
            case 2: {
                byte[] dest = new byte[this.bytesPerRow * 4];
                ArrayConverter.decodePacked2Bit(row, 0, dest, 0, this.bytesPerRow);
                ByteChannelImage bcimg = (ByteChannelImage)image;
                bcimg.putByteSamples(0, 0, y, this.getBoundsWidth(), 1, dest, this.getBoundsX1());
                break;
            }
            case 4: {
                byte[] dest = new byte[this.bytesPerRow * 2];
                ArrayConverter.decodePacked4Bit(row, 0, dest, 0, this.bytesPerRow);
                ByteChannelImage bcimg = (ByteChannelImage)image;
                bcimg.putByteSamples(0, 0, y, this.getBoundsWidth(), 1, dest, this.getBoundsX1());
                break;
            }
            case 8: {
                ByteChannelImage bcimg = (ByteChannelImage)image;
                bcimg.putByteSamples(0, 0, y, this.getBoundsWidth(), 1, row, this.getBoundsX1());
                break;
            }
            case 16: {
                ArrayConverter.decodePackedRGB565BigEndianToRGB24(row, this.getBoundsX1() * 2, this.rgb, 0, this.rgb, this.width, this.rgb, this.width * 2, this.getBoundsWidth());
                RGB24Image img = (RGB24Image)image;
                img.putByteSamples(0, 0, y, this.getBoundsWidth(), 1, this.rgb, 0);
                img.putByteSamples(1, 0, y, this.getBoundsWidth(), 1, this.rgb, this.width);
                img.putByteSamples(2, 0, y, this.getBoundsWidth(), 1, this.rgb, this.width * 2);
            }
        }
    }

    public String suggestFileExtension(PixelImage image) {
        return ".palm";
    }
}

