/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.codecs.tiff;

import java.util.Vector;
import net.sourceforge.jiu.codecs.tiff.TIFFConstants;

public class TIFFTag
implements TIFFConstants {
    private int id;
    private int type;
    private int count;
    private int offset;
    private Vector objects;

    public TIFFTag(int id, int type, int count, int offset) {
        this.id = id;
        this.type = type;
        this.count = count;
        if (count < 1) {
            throw new IllegalArgumentException("Tiff tag count value must not be smaller than 1: " + count);
        }
        this.offset = offset;
        this.objects = null;
    }

    public TIFFTag(int id, int type, int count, int offset, Vector vector) {
        this(id, type, count, offset);
        this.objects = vector;
    }

    public int getCount() {
        return this.count;
    }

    public int getElementAsInt(int index) {
        Object element = this.getObject(index);
        if (element == null) {
            throw new IllegalArgumentException("Tag does not contain a list of values.");
        }
        if (element instanceof Short) {
            return (Short)element & 0xFFFF;
        }
        if (element instanceof Integer) {
            return (Integer)element;
        }
        if (element instanceof Byte) {
            return (Byte)element & 0xFF;
        }
        throw new IllegalArgumentException("Element #" + index + " is not an integer value.");
    }

    public int getId() {
        return this.id;
    }

    public Object getObject(int index) {
        if (this.objects == null) {
            return null;
        }
        return this.objects.elementAt(index);
    }

    public int getOffset() {
        return this.offset;
    }

    public String getString() {
        Object o;
        if (this.objects != null && this.objects.size() > 0 && (o = this.objects.elementAt(0)) != null && o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public Vector getVector() {
        return this.objects;
    }

    public boolean isInt() {
        return this.type == 1 || this.type == 3 || this.type == 4;
    }

    public void setVector(Vector vector) {
        this.objects = vector;
    }
}

