/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.conversion;

import net.sourceforge.jiu.color.YCbCrIndex;
import net.sourceforge.jiu.data.RGBIndex;

public class PCDYCbCrConversion
implements RGBIndex,
YCbCrIndex {
    private static final float c11 = 1.407488f;
    private static final float c12 = 0.0f;
    private static final float c13 = 1.3230336f;
    private static final float c21 = 1.407488f;
    private static final float c22 = -0.3954176f;
    private static final float c23 = -0.67392f;
    private static final float c31 = 1.407488f;
    private static final float c32 = 2.0360448f;
    private static final float c33 = 0.0f;

    private PCDYCbCrConversion() {
    }

    private static byte floatToByte(float f) {
        if ((double)f <= 0.0) {
            return 0;
        }
        if ((double)f >= 255.0) {
            return -1;
        }
        return (byte)f;
    }

    private static void checkArray(byte[] data, int offset, int num) throws IllegalArgumentException {
        if (data == null) {
            throw new IllegalArgumentException("Data array must be initialized.");
        }
        if (offset < 0 || offset + num > data.length) {
            throw new IllegalArgumentException("Invalid combination of offset, number and array length: offset=" + offset + ", num=" + num + ", data.length=" + data.length);
        }
    }

    public static void convertYccToRgb(byte[] y, byte[] cb, byte[] cr, int yccOffset, byte[] r, byte[] g, byte[] b, int rgbOffset, int num) throws IllegalArgumentException {
        if (num < 0) {
            throw new IllegalArgumentException("Negative number of pixels to be converted is invalid: " + num);
        }
        PCDYCbCrConversion.checkArray(y, yccOffset, num);
        PCDYCbCrConversion.checkArray(cb, yccOffset, num);
        PCDYCbCrConversion.checkArray(cr, yccOffset, num);
        PCDYCbCrConversion.checkArray(r, rgbOffset, num);
        PCDYCbCrConversion.checkArray(g, rgbOffset, num);
        PCDYCbCrConversion.checkArray(b, rgbOffset, num);
        while (num-- > 0) {
            int gray = y[yccOffset] & 0xFF;
            int chromaBlue = cb[yccOffset] & 0xFF;
            int chromaRed = cr[yccOffset++] & 0xFF;
            int cr137 = chromaRed - 137;
            int cb156 = chromaBlue - 156;
            r[rgbOffset] = PCDYCbCrConversion.floatToByte(1.407488f * (float)gray + 0.0f * (float)cb156 + 1.3230336f * (float)cr137);
            g[rgbOffset] = PCDYCbCrConversion.floatToByte(1.407488f * (float)gray + -0.3954176f * (float)cb156 + -0.67392f * (float)cr137);
            b[rgbOffset++] = PCDYCbCrConversion.floatToByte(1.407488f * (float)gray + 2.0360448f * (float)cb156 + 0.0f * (float)cr137);
        }
    }
}

