/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.data;

import net.sourceforge.jiu.color.data.Histogram3D;

public class OnDemandHistogram3D
implements Histogram3D {
    private int c1;
    private int c2;
    private int c3;
    private int[] compOrder;
    private int maxValue1;
    private int maxValue2;
    private int maxValue3;
    private int[] maxValue;
    private int[] vector;
    private Object[] top;

    public OnDemandHistogram3D(int maxValue1, int maxValue2, int maxValue3, int c1, int c2, int c3) throws IllegalArgumentException {
        if (maxValue1 < 1 || maxValue2 < 1 || maxValue3 < 1) {
            throw new IllegalArgumentException("The three maximum value arguments must all be larger than zero.");
        }
        this.maxValue1 = maxValue1;
        this.maxValue2 = maxValue2;
        this.maxValue3 = maxValue3;
        this.maxValue = new int[3];
        this.maxValue[0] = maxValue1;
        this.maxValue[1] = maxValue2;
        this.maxValue[2] = maxValue3;
        if (c1 < 0 || c1 > 2 || c2 < 0 || c2 > 2 || c3 < 0 || c3 > 2) {
            throw new IllegalArgumentException("Arguments for components must be from 0..2.");
        }
        if (c1 == c2 || c1 == c3 || c2 == c3) {
            throw new IllegalArgumentException("No two arguments for components are allowed to be equal.");
        }
        this.c1 = c1;
        this.c2 = c2;
        this.c3 = c3;
        this.compOrder = new int[3];
        this.compOrder[0] = c1;
        this.compOrder[1] = c2;
        this.compOrder[2] = c3;
        this.vector = new int[3];
        this.clear();
    }

    public OnDemandHistogram3D(int maxValue1, int maxValue2, int maxValue3) {
        this(maxValue1, maxValue2, maxValue3, 0, 1, 2);
    }

    public OnDemandHistogram3D(int maxValue) {
        this(maxValue, maxValue, maxValue);
    }

    public void clear() {
        this.top = this.createObjectArray(this.maxValue[this.c1] + 1);
    }

    private int[] createIntArray(int LENGTH) {
        int[] result = new int[LENGTH];
        int i = 0;
        while (i < LENGTH) {
            result[i] = 0;
            ++i;
        }
        return result;
    }

    private Object[] createObjectArray(int LENGTH) {
        Object[] result = new Object[LENGTH];
        int i = 0;
        while (i < LENGTH) {
            result[i] = null;
            ++i;
        }
        return result;
    }

    public int getEntry(int index1, int index2, int index3) throws IllegalArgumentException {
        if (index1 < 0 && index1 > this.maxValue1 && index2 < 0 && index2 > this.maxValue2 && index3 < 0 && index3 > this.maxValue3) {
            throw new IllegalArgumentException("Invalid value " + index1 + " " + index2 + " " + index3);
        }
        this.vector[0] = index1;
        this.vector[1] = index2;
        this.vector[2] = index3;
        Object[] second = (Object[])this.top[this.vector[this.compOrder[0]]];
        if (second == null) {
            return 0;
        }
        int[] counters = (int[])second[this.vector[this.compOrder[1]]];
        if (counters == null) {
            return 0;
        }
        return counters[this.vector[this.compOrder[2]]];
    }

    public int getMaxValue(int index) throws IllegalArgumentException {
        if (index >= 0 && index <= 2) {
            return this.maxValue[index];
        }
        throw new IllegalArgumentException("The index argument must be from 0 to 2; got " + index);
    }

    public int getNumUsedEntries() {
        int result = 0;
        int i1 = 0;
        while (i1 <= this.maxValue[this.c1]) {
            Object[] second;
            if (this.top[i1] != null && (second = (Object[])this.top[i1]) != null) {
                int i2 = 0;
                while (i2 <= this.maxValue[this.c2]) {
                    if (second[i2] != null) {
                        int[] third = (int[])second[i2];
                        int i3 = 0;
                        while (i3 <= this.maxValue[this.c3]) {
                            if (third[i3] != 0) {
                                ++result;
                            }
                            ++i3;
                        }
                    }
                    ++i2;
                }
            }
            ++i1;
        }
        return result;
    }

    public void increaseEntry(int red, int green, int blue) throws IllegalArgumentException {
        int index3;
        int index2;
        int[] counters;
        if (red < 0 || red > this.maxValue1 || green < 0 || green > this.maxValue2 || blue < 0 || blue > this.maxValue3) {
            throw new IllegalArgumentException("Invalid color value in increaseEntry(): " + red + " " + green + " " + blue);
        }
        this.vector[0] = red;
        this.vector[1] = green;
        this.vector[2] = blue;
        int index1 = this.vector[this.compOrder[0]];
        Object[] second = (Object[])this.top[index1];
        if (second == null) {
            int num = this.maxValue[this.compOrder[1]] + 1;
            this.top[index1] = this.createObjectArray(num);
            second = (Object[])this.top[index1];
        }
        if ((counters = (int[])second[index2 = this.vector[this.compOrder[1]]]) == null) {
            int num = this.maxValue[this.compOrder[2]] + 1;
            second[index2] = this.createIntArray(num);
            counters = (int[])second[index2];
        }
        int n = index3 = this.vector[this.compOrder[2]];
        counters[n] = counters[n] + 1;
    }

    public void setEntry(int r, int g, int b, int newValue) throws IllegalArgumentException {
        int index2;
        int[] counters;
        if (r < 0 || r > this.maxValue1 || g < 0 || g > this.maxValue2 || b < 0 || b > this.maxValue3) {
            throw new IllegalArgumentException("Invalid index triplet: " + r + " " + g + " " + b);
        }
        this.vector[0] = r;
        this.vector[1] = g;
        this.vector[2] = b;
        int index1 = this.vector[this.compOrder[0]];
        Object[] second = (Object[])this.top[index1];
        if (second == null) {
            int num = this.maxValue[this.compOrder[1]] + 1;
            this.top[index1] = this.createObjectArray(num);
            second = (Object[])this.top[index1];
        }
        if ((counters = (int[])second[index2 = this.vector[this.compOrder[1]]]) == null) {
            int num = this.maxValue[this.compOrder[2]] + 1;
            second[index2] = this.createIntArray(num);
            counters = (int[])second[index2];
        }
        int index3 = this.vector[this.compOrder[2]];
        counters[index3] = newValue;
    }
}

