/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.dithering;

import net.sourceforge.jiu.color.quantization.UniformPaletteQuantizer;
import net.sourceforge.jiu.data.BilevelImage;
import net.sourceforge.jiu.data.Gray8Image;
import net.sourceforge.jiu.data.MemoryBilevelImage;
import net.sourceforge.jiu.data.MemoryGray8Image;
import net.sourceforge.jiu.data.MemoryPaletted8Image;
import net.sourceforge.jiu.data.MemoryRGB24Image;
import net.sourceforge.jiu.data.Paletted8Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.data.RGBIndex;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class OrderedDither
extends ImageToImageOperation
implements RGBIndex {
    private int[] values;
    private int valueWidth;
    private int valueHeight;
    private int grayBits = 3;
    private int redBits = 3;
    private int greenBits = 3;
    private int blueBits = 2;

    private void process(Gray8Image in, Gray8Image out) {
        if (out == null) {
            out = new MemoryGray8Image(in.getWidth(), in.getHeight());
            this.setOutputImage(out);
        }
        int D1 = 4;
        int D2 = 4;
        int D1D2 = D1 * D2;
        int[] nArray = new int[16];
        nArray[1] = 8;
        nArray[2] = 2;
        nArray[3] = 10;
        nArray[4] = 12;
        nArray[5] = 4;
        nArray[6] = 14;
        nArray[7] = 6;
        nArray[8] = 3;
        nArray[9] = 11;
        nArray[10] = 1;
        nArray[11] = 9;
        nArray[12] = 15;
        nArray[13] = 7;
        nArray[14] = 13;
        nArray[15] = 5;
        int[] DITHER_MATRIX = nArray;
        int SPACE = 255 / ((1 << this.grayBits) - 1);
        int SHIFT = 8 - this.grayBits;
        int NUM_VALUES = 1 << this.grayBits;
        byte[] OUTPUT_SAMPLES = new byte[NUM_VALUES];
        int i = 0;
        while (i < OUTPUT_SAMPLES.length) {
            OUTPUT_SAMPLES[i] = (byte)(i * 255 / NUM_VALUES);
            ++i;
        }
        int[] DITHER_SIGNAL = new int[D1D2];
        int i2 = 0;
        while (i2 < D1D2) {
            DITHER_SIGNAL[i2] = (2 * DITHER_MATRIX[i2] - D1D2 + 1) * SPACE / (2 * D1D2);
            ++i2;
        }
        int HEIGHT = in.getHeight();
        int WIDTH = in.getWidth();
        int rowOffset = 0;
        int y = 0;
        while (y < HEIGHT) {
            int offset = rowOffset;
            int MAX_OFFSET = rowOffset + D1;
            int x = 0;
            while (x < WIDTH) {
                int sample = in.getSample(0, x, y);
                sample += DITHER_SIGNAL[offset++];
                if (offset == MAX_OFFSET) {
                    offset = rowOffset;
                }
                if (sample < 0) {
                    sample = 0;
                } else if (sample > 255) {
                    sample = 255;
                }
                out.putByteSample(0, x, y, OUTPUT_SAMPLES[sample >> SHIFT]);
                ++x;
            }
            if ((rowOffset += D1) >= DITHER_SIGNAL.length) {
                rowOffset = 0;
            }
            this.setProgress(y, HEIGHT);
            ++y;
        }
    }

    private void process(Gray8Image in, BilevelImage out) {
        if (out == null) {
            out = new MemoryBilevelImage(in.getWidth(), in.getHeight());
            this.setOutputImage(out);
        }
        if (this.values == null) {
            this.setStandardThresholdValues();
        }
        out.clear(0);
        int rowOffset = 0;
        int HEIGHT = in.getHeight();
        int y = 0;
        while (y < HEIGHT) {
            int offset = rowOffset;
            int MAX_OFFSET = rowOffset + this.valueWidth;
            int x = 0;
            while (x < in.getWidth()) {
                if (in.getSample(x, y) >= this.values[offset++]) {
                    out.putWhite(x, y);
                }
                if (offset == MAX_OFFSET) {
                    offset = rowOffset;
                }
                ++x;
            }
            this.setProgress(y, HEIGHT);
            if ((rowOffset += this.valueWidth) >= this.values.length) {
                rowOffset = 0;
            }
            ++y;
        }
    }

    private void process(RGB24Image in, Paletted8Image out) {
        UniformPaletteQuantizer upq = new UniformPaletteQuantizer(this.redBits, this.greenBits, this.blueBits);
        if (out == null) {
            out = new MemoryPaletted8Image(in.getWidth(), in.getHeight(), upq.createPalette());
            this.setOutputImage(out);
        }
        int D1 = 4;
        int D2 = 4;
        int D1D2 = D1 * D2;
        int[] nArray = new int[16];
        nArray[1] = 8;
        nArray[2] = 2;
        nArray[3] = 10;
        nArray[4] = 12;
        nArray[5] = 4;
        nArray[6] = 14;
        nArray[7] = 6;
        nArray[8] = 3;
        nArray[9] = 11;
        nArray[10] = 1;
        nArray[11] = 9;
        nArray[12] = 15;
        nArray[13] = 7;
        nArray[14] = 13;
        nArray[15] = 5;
        int[] DITHER_MATRIX = nArray;
        int RED_SPACE = 255 / ((1 << this.redBits) - 1);
        int GREEN_SPACE = 255 / ((1 << this.greenBits) - 1);
        int BLUE_SPACE = 255 / ((1 << this.blueBits) - 1);
        int[] RED_DITHER_SIGNAL = new int[D1D2];
        int[] GREEN_DITHER_SIGNAL = new int[D1D2];
        int[] BLUE_DITHER_SIGNAL = new int[D1D2];
        int i = 0;
        while (i < D1D2) {
            RED_DITHER_SIGNAL[i] = (2 * DITHER_MATRIX[i] - D1D2 + 1) * RED_SPACE / (2 * D1D2);
            GREEN_DITHER_SIGNAL[i] = (2 * DITHER_MATRIX[i] - D1D2 + 1) * GREEN_SPACE / (2 * D1D2);
            BLUE_DITHER_SIGNAL[i] = (2 * DITHER_MATRIX[i] - D1D2 + 1) * BLUE_SPACE / (2 * D1D2);
            ++i;
        }
        int HEIGHT = in.getHeight();
        int WIDTH = in.getWidth();
        int rowOffset = 0;
        int y = 0;
        while (y < HEIGHT) {
            int offset = rowOffset;
            int MAX_OFFSET = rowOffset + D1;
            int x = 0;
            while (x < WIDTH) {
                int redSample = in.getSample(0, x, y);
                if ((redSample += RED_DITHER_SIGNAL[offset]) < 0) {
                    redSample = 0;
                } else if (redSample > 255) {
                    redSample = 255;
                }
                int greenSample = in.getSample(1, x, y);
                if ((greenSample += GREEN_DITHER_SIGNAL[offset]) < 0) {
                    greenSample = 0;
                } else if (greenSample > 255) {
                    greenSample = 255;
                }
                int blueSample = in.getSample(2, x, y);
                if ((blueSample += BLUE_DITHER_SIGNAL[offset]) < 0) {
                    blueSample = 0;
                } else if (blueSample > 255) {
                    blueSample = 255;
                }
                out.putSample(0, x, y, upq.mapToIndex(redSample, greenSample, blueSample));
                if (++offset == MAX_OFFSET) {
                    offset = rowOffset;
                }
                ++x;
            }
            if ((rowOffset += D1) >= DITHER_MATRIX.length) {
                rowOffset = 0;
            }
            this.setProgress(y, HEIGHT);
            ++y;
        }
    }

    private void process(RGB24Image in, RGB24Image out) {
        if (out == null) {
            out = new MemoryRGB24Image(in.getWidth(), in.getHeight());
            this.setOutputImage(out);
        }
        int D1 = 4;
        int D2 = 4;
        int D1D2 = D1 * D2;
        int[] nArray = new int[16];
        nArray[1] = 8;
        nArray[2] = 2;
        nArray[3] = 10;
        nArray[4] = 12;
        nArray[5] = 4;
        nArray[6] = 14;
        nArray[7] = 6;
        nArray[8] = 3;
        nArray[9] = 11;
        nArray[10] = 1;
        nArray[11] = 9;
        nArray[12] = 15;
        nArray[13] = 7;
        nArray[14] = 13;
        nArray[15] = 5;
        int[] DITHER_MATRIX = nArray;
        int RED_SPACE = 255 / ((1 << this.redBits) - 1);
        int GREEN_SPACE = 255 / ((1 << this.greenBits) - 1);
        int BLUE_SPACE = 255 / ((1 << this.blueBits) - 1);
        int RED_SHIFT = 8 - this.redBits;
        int GREEN_SHIFT = 8 - this.greenBits;
        int BLUE_SHIFT = 8 - this.blueBits;
        int MAX_RED = (1 << this.redBits) - 1;
        int MAX_GREEN = (1 << this.greenBits) - 1;
        int MAX_BLUE = (1 << this.blueBits) - 1;
        int[] RED_DITHER_SIGNAL = new int[D1D2];
        int[] GREEN_DITHER_SIGNAL = new int[D1D2];
        int[] BLUE_DITHER_SIGNAL = new int[D1D2];
        int i = 0;
        while (i < D1D2) {
            RED_DITHER_SIGNAL[i] = (2 * DITHER_MATRIX[i] - D1D2 + 1) * RED_SPACE / (2 * D1D2);
            GREEN_DITHER_SIGNAL[i] = (2 * DITHER_MATRIX[i] - D1D2 + 1) * GREEN_SPACE / (2 * D1D2);
            BLUE_DITHER_SIGNAL[i] = (2 * DITHER_MATRIX[i] - D1D2 + 1) * BLUE_SPACE / (2 * D1D2);
            ++i;
        }
        int HEIGHT = in.getHeight();
        int WIDTH = in.getWidth();
        int rowOffset = 0;
        int y = 0;
        while (y < HEIGHT) {
            int offset = rowOffset;
            int MAX_OFFSET = rowOffset + D1;
            int x = 0;
            while (x < WIDTH) {
                int redSample = in.getSample(0, x, y);
                if ((redSample += RED_DITHER_SIGNAL[offset]) < 0) {
                    redSample = 0;
                } else if (redSample > 255) {
                    redSample = 255;
                }
                out.putSample(0, x, y, (redSample >>= RED_SHIFT) * 255 / MAX_RED);
                int greenSample = in.getSample(1, x, y);
                if ((greenSample += GREEN_DITHER_SIGNAL[offset]) < 0) {
                    greenSample = 0;
                } else if (greenSample > 255) {
                    greenSample = 255;
                }
                out.putSample(1, x, y, (greenSample >>= GREEN_SHIFT) * 255 / MAX_GREEN);
                int blueSample = in.getSample(2, x, y);
                if ((blueSample += BLUE_DITHER_SIGNAL[offset]) < 0) {
                    blueSample = 0;
                } else if (blueSample > 255) {
                    blueSample = 255;
                }
                out.putSample(2, x, y, (blueSample >>= BLUE_SHIFT) * 255 / MAX_BLUE);
                if (++offset == MAX_OFFSET) {
                    offset = rowOffset;
                }
                ++x;
            }
            if ((rowOffset += D1) >= DITHER_MATRIX.length) {
                rowOffset = 0;
            }
            this.setProgress(y, HEIGHT);
            ++y;
        }
    }

    public void process() throws MissingParameterException, WrongParameterException {
        this.ensureInputImageIsAvailable();
        this.ensureImagesHaveSameResolution();
        PixelImage in = this.getInputImage();
        PixelImage out = this.getOutputImage();
        if (in instanceof RGB24Image) {
            int sum = this.redBits + this.greenBits + this.blueBits;
            if (sum > 8) {
                this.process((RGB24Image)in, (RGB24Image)out);
            } else {
                this.process((RGB24Image)in, (Paletted8Image)out);
            }
        } else if (this.grayBits == 1) {
            this.process((Gray8Image)in, (BilevelImage)out);
        } else if (this.grayBits >= 2 && this.grayBits <= 7) {
            this.process((Gray8Image)in, (Gray8Image)out);
        }
    }

    public void setOutputBits(int bits) {
        if (bits < 1 || bits > 7) {
            throw new IllegalArgumentException("Grayscale output bits must be from 1..7; got " + bits);
        }
        this.grayBits = bits;
    }

    public void setRgbBits(int red, int green, int blue) {
        if (red <= 0 || green <= 0 || blue <= 0) {
            throw new IllegalArgumentException("All parameters must be 1 or larger.");
        }
        this.redBits = red;
        this.greenBits = green;
        this.blueBits = blue;
    }

    public void setStandardThresholdValues() {
        int[] nArray = new int[256];
        nArray[1] = 192;
        nArray[2] = 48;
        nArray[3] = 240;
        nArray[4] = 12;
        nArray[5] = 204;
        nArray[6] = 60;
        nArray[7] = 252;
        nArray[8] = 3;
        nArray[9] = 195;
        nArray[10] = 51;
        nArray[11] = 243;
        nArray[12] = 15;
        nArray[13] = 207;
        nArray[14] = 63;
        nArray[15] = 255;
        nArray[16] = 128;
        nArray[17] = 64;
        nArray[18] = 176;
        nArray[19] = 112;
        nArray[20] = 140;
        nArray[21] = 76;
        nArray[22] = 188;
        nArray[23] = 124;
        nArray[24] = 131;
        nArray[25] = 67;
        nArray[26] = 179;
        nArray[27] = 115;
        nArray[28] = 143;
        nArray[29] = 79;
        nArray[30] = 191;
        nArray[31] = 127;
        nArray[32] = 32;
        nArray[33] = 224;
        nArray[34] = 16;
        nArray[35] = 208;
        nArray[36] = 44;
        nArray[37] = 236;
        nArray[38] = 28;
        nArray[39] = 220;
        nArray[40] = 35;
        nArray[41] = 227;
        nArray[42] = 19;
        nArray[43] = 211;
        nArray[44] = 47;
        nArray[45] = 239;
        nArray[46] = 31;
        nArray[47] = 223;
        nArray[48] = 160;
        nArray[49] = 96;
        nArray[50] = 144;
        nArray[51] = 80;
        nArray[52] = 172;
        nArray[53] = 108;
        nArray[54] = 156;
        nArray[55] = 92;
        nArray[56] = 163;
        nArray[57] = 99;
        nArray[58] = 147;
        nArray[59] = 83;
        nArray[60] = 175;
        nArray[61] = 111;
        nArray[62] = 159;
        nArray[63] = 95;
        nArray[64] = 8;
        nArray[65] = 200;
        nArray[66] = 56;
        nArray[67] = 248;
        nArray[68] = 4;
        nArray[69] = 196;
        nArray[70] = 52;
        nArray[71] = 244;
        nArray[72] = 11;
        nArray[73] = 203;
        nArray[74] = 59;
        nArray[75] = 251;
        nArray[76] = 7;
        nArray[77] = 199;
        nArray[78] = 55;
        nArray[79] = 247;
        nArray[80] = 136;
        nArray[81] = 72;
        nArray[82] = 184;
        nArray[83] = 120;
        nArray[84] = 132;
        nArray[85] = 68;
        nArray[86] = 180;
        nArray[87] = 116;
        nArray[88] = 139;
        nArray[89] = 75;
        nArray[90] = 187;
        nArray[91] = 123;
        nArray[92] = 135;
        nArray[93] = 71;
        nArray[94] = 183;
        nArray[95] = 119;
        nArray[96] = 40;
        nArray[97] = 232;
        nArray[98] = 24;
        nArray[99] = 216;
        nArray[100] = 36;
        nArray[101] = 228;
        nArray[102] = 20;
        nArray[103] = 212;
        nArray[104] = 43;
        nArray[105] = 235;
        nArray[106] = 27;
        nArray[107] = 219;
        nArray[108] = 39;
        nArray[109] = 231;
        nArray[110] = 23;
        nArray[111] = 215;
        nArray[112] = 168;
        nArray[113] = 104;
        nArray[114] = 152;
        nArray[115] = 88;
        nArray[116] = 164;
        nArray[117] = 100;
        nArray[118] = 148;
        nArray[119] = 84;
        nArray[120] = 171;
        nArray[121] = 107;
        nArray[122] = 155;
        nArray[123] = 91;
        nArray[124] = 167;
        nArray[125] = 103;
        nArray[126] = 151;
        nArray[127] = 87;
        nArray[128] = 2;
        nArray[129] = 194;
        nArray[130] = 50;
        nArray[131] = 242;
        nArray[132] = 14;
        nArray[133] = 206;
        nArray[134] = 62;
        nArray[135] = 254;
        nArray[136] = 1;
        nArray[137] = 193;
        nArray[138] = 49;
        nArray[139] = 241;
        nArray[140] = 13;
        nArray[141] = 205;
        nArray[142] = 61;
        nArray[143] = 253;
        nArray[144] = 130;
        nArray[145] = 66;
        nArray[146] = 178;
        nArray[147] = 114;
        nArray[148] = 142;
        nArray[149] = 78;
        nArray[150] = 190;
        nArray[151] = 126;
        nArray[152] = 129;
        nArray[153] = 65;
        nArray[154] = 177;
        nArray[155] = 113;
        nArray[156] = 141;
        nArray[157] = 77;
        nArray[158] = 189;
        nArray[159] = 125;
        nArray[160] = 34;
        nArray[161] = 226;
        nArray[162] = 18;
        nArray[163] = 210;
        nArray[164] = 46;
        nArray[165] = 238;
        nArray[166] = 30;
        nArray[167] = 222;
        nArray[168] = 33;
        nArray[169] = 225;
        nArray[170] = 17;
        nArray[171] = 209;
        nArray[172] = 45;
        nArray[173] = 237;
        nArray[174] = 29;
        nArray[175] = 221;
        nArray[176] = 162;
        nArray[177] = 98;
        nArray[178] = 146;
        nArray[179] = 82;
        nArray[180] = 174;
        nArray[181] = 110;
        nArray[182] = 158;
        nArray[183] = 94;
        nArray[184] = 161;
        nArray[185] = 97;
        nArray[186] = 145;
        nArray[187] = 81;
        nArray[188] = 173;
        nArray[189] = 109;
        nArray[190] = 157;
        nArray[191] = 93;
        nArray[192] = 10;
        nArray[193] = 202;
        nArray[194] = 58;
        nArray[195] = 250;
        nArray[196] = 6;
        nArray[197] = 198;
        nArray[198] = 54;
        nArray[199] = 246;
        nArray[200] = 9;
        nArray[201] = 201;
        nArray[202] = 57;
        nArray[203] = 249;
        nArray[204] = 5;
        nArray[205] = 197;
        nArray[206] = 53;
        nArray[207] = 245;
        nArray[208] = 138;
        nArray[209] = 74;
        nArray[210] = 186;
        nArray[211] = 122;
        nArray[212] = 134;
        nArray[213] = 70;
        nArray[214] = 182;
        nArray[215] = 118;
        nArray[216] = 137;
        nArray[217] = 73;
        nArray[218] = 185;
        nArray[219] = 121;
        nArray[220] = 133;
        nArray[221] = 69;
        nArray[222] = 181;
        nArray[223] = 117;
        nArray[224] = 42;
        nArray[225] = 234;
        nArray[226] = 26;
        nArray[227] = 218;
        nArray[228] = 38;
        nArray[229] = 230;
        nArray[230] = 22;
        nArray[231] = 214;
        nArray[232] = 41;
        nArray[233] = 233;
        nArray[234] = 25;
        nArray[235] = 217;
        nArray[236] = 37;
        nArray[237] = 229;
        nArray[238] = 21;
        nArray[239] = 213;
        nArray[240] = 170;
        nArray[241] = 106;
        nArray[242] = 154;
        nArray[243] = 90;
        nArray[244] = 166;
        nArray[245] = 102;
        nArray[246] = 150;
        nArray[247] = 86;
        nArray[248] = 169;
        nArray[249] = 105;
        nArray[250] = 153;
        nArray[251] = 89;
        nArray[252] = 165;
        nArray[253] = 101;
        nArray[254] = 149;
        nArray[255] = 85;
        int[] VALUES = nArray;
        this.setThresholdValues(VALUES, 16, 16);
    }

    public void setThresholdValues(int[] values, int valueWidth, int valueHeight) {
        if (values == null) {
            throw new IllegalArgumentException("The value array must be non-null.");
        }
        if (valueWidth < 1) {
            throw new IllegalArgumentException("The width argument must be at least 1.");
        }
        if (valueHeight < 1) {
            throw new IllegalArgumentException("The height argument must be at least 1.");
        }
        if (valueHeight * valueWidth < values.length) {
            throw new IllegalArgumentException("The array must have at least valuesWidth * valuesHeight elements..");
        }
        this.values = values;
        this.valueWidth = valueWidth;
        this.valueHeight = valueHeight;
    }
}

