/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.promotion;

import net.sourceforge.jiu.data.BilevelImage;
import net.sourceforge.jiu.data.Gray16Image;
import net.sourceforge.jiu.data.Gray8Image;
import net.sourceforge.jiu.data.MemoryRGB48Image;
import net.sourceforge.jiu.data.Palette;
import net.sourceforge.jiu.data.Paletted8Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.data.RGB48Image;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class PromotionRGB48
extends ImageToImageOperation {
    private void prepare(PixelImage in) throws MissingParameterException, WrongParameterException {
        if (!(in instanceof BilevelImage || in instanceof Paletted8Image || in instanceof Gray16Image || in instanceof Gray8Image || in instanceof RGB24Image)) {
            throw new WrongParameterException("Unsupported input image type: " + in.getClass().getName());
        }
        PixelImage out = this.getOutputImage();
        if (out == null) {
            this.setOutputImage(new MemoryRGB48Image(in.getWidth(), in.getHeight()));
        } else {
            if (!(out instanceof RGB48Image)) {
                throw new WrongParameterException("Specified output image type must be of class RGB48Image; got " + in.getClass().getName());
            }
            this.ensureImagesHaveSameResolution();
        }
    }

    private void process(BilevelImage in, RGB48Image out) {
        int HEIGHT = in.getHeight();
        int MAX = -1;
        boolean MIN = false;
        int y = 0;
        while (y < HEIGHT) {
            int x = 0;
            while (x < in.getWidth()) {
                if (in.isBlack(x, y)) {
                    out.putShortSample(0, x, y, (short)0);
                    out.putShortSample(1, x, y, (short)0);
                    out.putShortSample(2, x, y, (short)0);
                } else {
                    out.putShortSample(0, x, y, (short)-1);
                    out.putShortSample(1, x, y, (short)-1);
                    out.putShortSample(2, x, y, (short)-1);
                }
                ++x;
            }
            this.setProgress(y, HEIGHT);
            ++y;
        }
    }

    private void process(Paletted8Image in, RGB48Image out) {
        int WIDTH = in.getWidth();
        int HEIGHT = in.getHeight();
        Palette PAL = in.getPalette();
        int y = 0;
        while (y < HEIGHT) {
            int x = 0;
            while (x < WIDTH) {
                int value = in.getSample(0, x, y);
                int red = PAL.getSample(0, value);
                int green = PAL.getSample(1, value);
                int blue = PAL.getSample(2, value);
                out.putSample(0, x, y, red | red << 8);
                out.putSample(1, x, y, green | green << 8);
                out.putSample(2, x, y, blue | blue << 8);
                ++x;
            }
            this.setProgress(y, HEIGHT);
            ++y;
        }
    }

    private void process(Gray16Image in, RGB48Image out) {
        int WIDTH = in.getWidth();
        int HEIGHT = in.getHeight();
        int y = 0;
        while (y < HEIGHT) {
            int x = 0;
            while (x < WIDTH) {
                int value = in.getSample(0, x, y);
                out.putSample(0, x, y, value);
                out.putSample(1, x, y, value);
                out.putSample(2, x, y, value);
                ++x;
            }
            this.setProgress(y, HEIGHT);
            ++y;
        }
    }

    private void process(Gray8Image in, RGB48Image out) {
        int WIDTH = in.getWidth();
        int HEIGHT = in.getHeight();
        int y = 0;
        while (y < HEIGHT) {
            int x = 0;
            while (x < WIDTH) {
                int value = in.getSample(0, x, y);
                value |= value << 8;
                out.putSample(0, x, y, value);
                out.putSample(1, x, y, value);
                out.putSample(2, x, y, value);
                ++x;
            }
            this.setProgress(y, HEIGHT);
            ++y;
        }
    }

    private void process(RGB24Image in, RGB48Image out) {
        int WIDTH = in.getWidth();
        int HEIGHT = in.getHeight();
        int y = 0;
        while (y < HEIGHT) {
            int x = 0;
            while (x < WIDTH) {
                int red = in.getSample(0, x, y);
                red = red << 8 | red;
                int green = in.getSample(1, x, y);
                green = green << 8 | green;
                int blue = in.getSample(2, x, y);
                blue = blue << 8 | blue;
                out.putSample(0, x, y, red);
                out.putSample(1, x, y, green);
                out.putSample(2, x, y, blue);
                ++x;
            }
            this.setProgress(y, HEIGHT);
            ++y;
        }
    }

    public void process() throws MissingParameterException, WrongParameterException {
        this.ensureInputImageIsAvailable();
        PixelImage in = this.getInputImage();
        this.prepare(in);
        RGB48Image out = (RGB48Image)this.getOutputImage();
        if (in instanceof BilevelImage) {
            this.process((BilevelImage)in, out);
        } else if (in instanceof Gray16Image) {
            this.process((Gray16Image)in, out);
        } else if (in instanceof Gray8Image) {
            this.process((Gray8Image)in, out);
        } else if (in instanceof Paletted8Image) {
            this.process((Paletted8Image)in, out);
        } else if (in instanceof RGB24Image) {
            this.process((RGB24Image)in, out);
        }
    }
}

