/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.quantization;

import net.sourceforge.jiu.color.data.Histogram3D;
import net.sourceforge.jiu.color.quantization.RGBColor;
import net.sourceforge.jiu.color.quantization.RGBColorComparator;
import net.sourceforge.jiu.data.RGBIndex;
import net.sourceforge.jiu.util.ComparatorInterface;
import net.sourceforge.jiu.util.Sort;

public class RGBColorList
implements RGBIndex {
    private RGBColor[] list;
    private final int numEntries;

    private RGBColorList(int NUM_ENTRIES) {
        if (NUM_ENTRIES < 1) {
            throw new IllegalArgumentException("RGBColorList must have at least one entry; got " + NUM_ENTRIES);
        }
        this.numEntries = NUM_ENTRIES;
        this.list = new RGBColor[NUM_ENTRIES];
    }

    public RGBColorList(Histogram3D hist) {
        this(hist.getNumUsedEntries());
        int i = 0;
        int MAX_RED = hist.getMaxValue(0);
        int MAX_GREEN = hist.getMaxValue(1);
        int MAX_BLUE = hist.getMaxValue(2);
        int r = 0;
        while (r <= MAX_RED) {
            int g = 0;
            while (g <= MAX_GREEN) {
                int b = 0;
                while (b <= MAX_BLUE) {
                    int counter = hist.getEntry(r, g, b);
                    if (counter > 0) {
                        this.list[i++] = new RGBColor(r, g, b, counter);
                    }
                    ++b;
                }
                ++g;
            }
            ++r;
        }
    }

    public int[] findExtrema(int i1, int i2) {
        if (i1 < 0 || i1 >= this.numEntries || i2 < 0 || i2 >= this.numEntries || i1 > i2) {
            return null;
        }
        int[] max = new int[3];
        int[] min = new int[3];
        RGBColor c = this.list[i1];
        int i = 0;
        while (i < 3) {
            min[i] = max[i] = c.getSample(i);
            ++i;
        }
        i = i1 + 1;
        while (i < i2) {
            c = this.list[i++];
            int j = 0;
            while (j < 3) {
                int cSample = c.getSample(j);
                if (cSample < min[j]) {
                    min[j] = cSample;
                } else if (cSample > max[j]) {
                    max[j] = cSample;
                }
                ++j;
            }
        }
        int[] result = new int[2];
        result[1] = -1;
        result[0] = -1;
        i = 0;
        while (i < 3) {
            int newDiff = max[i] - min[i];
            if (newDiff > result[1]) {
                result[0] = i;
                result[1] = newDiff;
            }
            ++i;
        }
        return result;
    }

    public RGBColor getColor(int index) {
        return this.list[index];
    }

    public int getNumEntries() {
        return this.list.length;
    }

    public void sortByAxis(int index1, int index2, int axis) {
        Sort.sort(this.list, index1, index2, new RGBColorComparator(axis));
    }

    public void sortByCounter(int index1, int index2) {
        Sort.sort(this.list, index1, index2, new ComparatorInterface(){

            public int compare(Object obj1, Object obj2) {
                RGBColor col1 = (RGBColor)obj1;
                RGBColor col2 = (RGBColor)obj2;
                return col1.getCounter() - col2.getCounter();
            }
        });
    }
}

