/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.reduction;

import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.MemoryRGB24Image;
import net.sourceforge.jiu.data.MemoryRGB48Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.data.RGB48Image;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class ReduceRGB
extends ImageToImageOperation {
    private Integer destBits;

    public void process() throws MissingParameterException, WrongParameterException {
        if (this.destBits == null) {
            throw new MissingParameterException("The number of destination bits has not been specified.");
        }
        int bits = this.destBits;
        this.ensureInputImageIsAvailable();
        this.ensureImagesHaveSameResolution();
        PixelImage in = this.getInputImage();
        boolean rgb24 = in instanceof RGB24Image;
        boolean rgb48 = in instanceof RGB48Image;
        if (!rgb24 && !rgb48) {
            throw new WrongParameterException("Input image must be either RGB24Image or RGB48Image.");
        }
        if (rgb24 && bits >= 8) {
            throw new WrongParameterException("Number of output bits per sample must be 7 or lower for RGB24Image.");
        }
        PixelImage out = this.getOutputImage();
        int inDepth = 0;
        if (rgb24) {
            inDepth = 8;
        }
        if (rgb48) {
            inDepth = 16;
        }
        int maxOutputValue = 1;
        int maxShiftedValue = (1 << bits) - 1;
        if (bits <= 8) {
            if (out == null) {
                out = new MemoryRGB24Image(in.getWidth(), in.getHeight());
            } else if (!(out instanceof RGB24Image)) {
                throw new WrongParameterException("Output image must be of type RGB24Image.");
            }
            maxOutputValue = 255;
        } else if (bits <= 16) {
            if (out == null) {
                out = new MemoryRGB48Image(in.getWidth(), in.getHeight());
            } else if (!(out instanceof RGB48Image)) {
                throw new WrongParameterException("Output image must be of type RGB48Image.");
            }
            maxOutputValue = 65535;
        } else {
            throw new WrongParameterException("Can only process up to 16 bits per sample.");
        }
        int SHIFT = inDepth - bits;
        IntegerImage ii = (IntegerImage)in;
        IntegerImage oo = (IntegerImage)out;
        int y = 0;
        while (y < in.getHeight()) {
            int x = 0;
            while (x < in.getWidth()) {
                int c = 0;
                while (c < 3) {
                    int inputSample = ii.getSample(c, x, y);
                    int outputSample = (inputSample >> SHIFT) * maxOutputValue / maxShiftedValue;
                    oo.putSample(c, x, y, outputSample);
                    ++c;
                }
                ++x;
            }
            this.setProgress(y, in.getHeight());
            ++y;
        }
    }

    public void setBitsPerSample(int bits) {
        if (bits < 1) {
            throw new IllegalArgumentException("Number of bits must be 1 or larger.");
        }
        if (bits > 15) {
            throw new IllegalArgumentException("Number of bits must be 15 or smaller.");
        }
        this.destBits = new Integer(bits);
    }
}

