/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.data;

import net.sourceforge.jiu.data.BilevelImage;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.util.ArrayConverter;

public class MemoryBilevelImage
implements BilevelImage {
    private final int BYTES_PER_ROW;
    private final byte[] data;
    private final int HEIGHT;
    private final int WIDTH;
    static /* synthetic */ Class class$0;

    public MemoryBilevelImage(int width, int height) {
        if (width < 1) {
            throw new IllegalArgumentException("Width must be larger than zero; got " + width);
        }
        if (height < 1) {
            throw new IllegalArgumentException("Height must be larger than zero; got " + height);
        }
        this.BYTES_PER_ROW = (width + 7) / 8;
        this.WIDTH = width;
        this.HEIGHT = height;
        this.data = new byte[this.BYTES_PER_ROW * this.HEIGHT];
    }

    private void checkBitOffset(int bitOffset) {
        if (bitOffset < 0 || bitOffset > 7) {
            throw new IllegalArgumentException("A bit offset value must be from the interval 0..7.");
        }
    }

    private void checkPositionAndNumber(int x, int y, int w, int h) {
        if (w < 0) {
            throw new IllegalArgumentException("Negative number of samples to be copied: " + w);
        }
        if (h < 0) {
            throw new IllegalArgumentException("Negative number of rows to be copied: " + h);
        }
        if (x < 0 || x >= this.getWidth()) {
            throw new IllegalArgumentException("The value for x is invalid: " + x + ".");
        }
        if (y < 0 || y >= this.getHeight()) {
            throw new IllegalArgumentException("The value for y is invalid: " + y + ".");
        }
        if (x + w > this.getWidth()) {
            throw new IllegalArgumentException("Cannot copy " + w + " values starting at " + "offset " + x + " (width is only " + this.getWidth() + ").");
        }
        if (y + h > this.getHeight()) {
            throw new IllegalArgumentException("Cannot copy " + h + " rows starting at " + y + " (height is only " + this.getHeight() + ").");
        }
    }

    private void checkValue(int value) {
        if (value != 1 && value != 0) {
            throw new IllegalArgumentException("Sample value must be either BilevelImage.BLACK or BilevelImage.WHITE.");
        }
    }

    public void clear(int newValue) {
        this.clear(0, newValue);
    }

    public void clear(int channelIndex, int newValue) {
        if (channelIndex != 0) {
            throw new IllegalArgumentException("Invalid channel index; bilevel images have only one channel, so 0 is the only valid argument; got " + channelIndex);
        }
        this.checkValue(newValue);
        int value = newValue == 0 ? 0 : -1;
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = value;
            ++i;
        }
    }

    public PixelImage createCompatibleImage(int width, int height) {
        return new MemoryBilevelImage(width, height);
    }

    public PixelImage createCopy() {
        PixelImage copy = this.createCompatibleImage(this.getWidth(), this.getHeight());
        MemoryBilevelImage result = (MemoryBilevelImage)copy;
        System.arraycopy(this.data, 0, result.data, 0, this.data.length);
        return result;
    }

    public long getAllocatedMemory() {
        return this.data.length;
    }

    public int getBitsPerPixel() {
        return 1;
    }

    public int getHeight() {
        return this.HEIGHT;
    }

    public Class getImageType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.jiu.data.BilevelImage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public int getMaxSample(int channelIndex) {
        return 1;
    }

    public int getNumChannels() {
        return 1;
    }

    public void getPackedBytes(int x, int y, int numSamples, byte[] dest, int destOffset, int destBitOffset) {
        this.checkPositionAndNumber(x, y, numSamples, 1);
        this.checkBitOffset(destBitOffset);
        int srcOffset = y * this.BYTES_PER_ROW + (x >> 3);
        int srcBitOffset = x & 7;
        ArrayConverter.copyPackedBytes(this.data, srcOffset, srcBitOffset, dest, destOffset, destBitOffset, numSamples);
    }

    public int getSample(int x, int y) {
        if (this.isBlack(x, y)) {
            return 0;
        }
        return 1;
    }

    public int getSample(int channelIndex, int x, int y) {
        if (channelIndex == 0) {
            if (this.isBlack(x, y)) {
                return 0;
            }
            return 1;
        }
        throw new IllegalArgumentException("The channelIndex argument must be 0 for bilevel images; got " + channelIndex);
    }

    public void getSamples(int channelIndex, int x, int y, int w, int h, int[] dest, int destOffset) {
        int INITIAL_MASK = 1 << 7 - x % 8;
        int offset = y * this.BYTES_PER_ROW + x / 8;
        while (h-- > 0) {
            int mask = INITIAL_MASK;
            int srcOffset = offset;
            int remainingColumns = w;
            int srcValue = this.data[srcOffset++] & 0xFF;
            while (remainingColumns-- != 0) {
                dest[destOffset++] = (srcValue & mask) == 0 ? 0 : 1;
                if (mask == 1) {
                    mask = 128;
                    srcValue = this.data[srcOffset++] & 0xFF;
                    continue;
                }
                mask >>= 1;
            }
            offset += this.BYTES_PER_ROW;
        }
    }

    public int getWidth() {
        return this.WIDTH;
    }

    public boolean isBlack(int x, int y) {
        try {
            int offset = y * this.BYTES_PER_ROW + (x >> 3);
            return (this.data[offset] & (byte)(1 << 7 - (x & 7))) == 0;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            this.checkPositionAndNumber(x, y, 1, 1);
            return true;
        }
    }

    public boolean isWhite(int x, int y) {
        try {
            int offset = y * this.BYTES_PER_ROW + (x >> 3);
            return (this.data[offset] & (byte)(1 << 7 - (x & 7))) != 0;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            this.checkPositionAndNumber(x, y, 1, 1);
            return true;
        }
    }

    public void putBlack(int x, int y) {
        try {
            int offset;
            int n = offset = y * this.BYTES_PER_ROW + (x >> 3);
            this.data[n] = (byte)(this.data[n] & (byte)(255 - (1 << 7 - (x & 7))));
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            this.checkPositionAndNumber(x, y, 1, 1);
        }
    }

    public void putPackedBytes(int x, int y, int numSamples, byte[] src, int srcOffset, int srcBitOffset) {
        this.checkPositionAndNumber(x, y, numSamples, 1);
        this.checkBitOffset(srcBitOffset);
        int destOffset = y * this.BYTES_PER_ROW + (x >> 3);
        int destBitOffset = x & 7;
        ArrayConverter.copyPackedBytes(src, srcOffset, srcBitOffset, this.data, destOffset, destBitOffset, numSamples);
    }

    public void putSample(int x, int y, int newValue) {
        this.putSample(0, x, y, newValue);
    }

    public void putSample(int channelIndex, int x, int y, int newValue) {
        this.checkValue(newValue);
        try {
            int offset = y * this.BYTES_PER_ROW + (x >> 3);
            if (newValue == 0) {
                int n = offset;
                this.data[n] = (byte)(this.data[n] & (byte)(255 - (1 << 7 - (x & 7))));
            } else {
                int n = offset;
                this.data[n] = (byte)(this.data[n] | (byte)(1 << 7 - (x & 7)));
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            this.checkPositionAndNumber(x, y, 1, 1);
        }
    }

    public void putSamples(int channelIndex, int x, int y, int w, int h, int[] src, int srcOffset) {
        this.checkPositionAndNumber(x, y, w, h);
        int INITIAL_ROW_MASK = 1 << 7 - (x & 7);
        int initialDestOffset = y * this.BYTES_PER_ROW + (x >> 3);
        while (h-- > 0) {
            int mask = INITIAL_ROW_MASK;
            int destOffset = initialDestOffset;
            int pixelsLeft = w;
            while (pixelsLeft-- > 0) {
                if (src[srcOffset++] == 0) {
                    int n = destOffset;
                    this.data[n] = (byte)(this.data[n] & (byte)(255 - mask));
                } else {
                    int n = destOffset;
                    this.data[n] = (byte)(this.data[n] | (byte)mask);
                }
                if (mask != 1) continue;
                mask = 128;
                ++destOffset;
            }
            initialDestOffset += this.BYTES_PER_ROW;
        }
    }

    public void putWhite(int x, int y) {
        try {
            int offset;
            int n = offset = y * this.BYTES_PER_ROW + (x >> 3);
            this.data[n] = (byte)(this.data[n] | (byte)(1 << 7 - (x & 7)));
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            this.checkPositionAndNumber(x, y, 1, 1);
        }
    }
}

