/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.geometry;

import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.geometry.BSplineFilter;
import net.sourceforge.jiu.geometry.BellFilter;
import net.sourceforge.jiu.geometry.BoxFilter;
import net.sourceforge.jiu.geometry.HermiteFilter;
import net.sourceforge.jiu.geometry.Lanczos3Filter;
import net.sourceforge.jiu.geometry.MitchellFilter;
import net.sourceforge.jiu.geometry.ResampleFilter;
import net.sourceforge.jiu.geometry.TriangleFilter;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class Resample
extends ImageToImageOperation {
    public static final int FILTER_TYPE_BOX = 0;
    public static final int FILTER_TYPE_TRIANGLE = 1;
    public static final int FILTER_TYPE_HERMITE = 2;
    public static final int FILTER_TYPE_BELL = 3;
    public static final int FILTER_TYPE_B_SPLINE = 4;
    public static final int FILTER_TYPE_LANCZOS3 = 5;
    public static final int FILTER_TYPE_MITCHELL = 6;
    private Integer outWidth;
    private Integer outHeight;
    private ResampleFilter filter;

    private static ResampleFilter createFilter(int filterType) {
        switch (filterType) {
            case 0: {
                return new BoxFilter();
            }
            case 1: {
                return new TriangleFilter();
            }
            case 2: {
                return new HermiteFilter();
            }
            case 3: {
                return new BellFilter();
            }
            case 4: {
                return new BSplineFilter();
            }
            case 5: {
                return new Lanczos3Filter();
            }
            case 6: {
                return new MitchellFilter();
            }
        }
        throw new IllegalArgumentException("Unknown filter type in Resample: " + filterType);
    }

    public ResampleFilter getFilter() {
        return this.filter;
    }

    public static String[] getFilterNames() {
        String[] result = new String[Resample.getNumFilters()];
        int i = 0;
        while (i < Resample.getNumFilters()) {
            ResampleFilter filter = Resample.createFilter(i);
            result[i] = filter.getName();
            ++i;
        }
        return result;
    }

    public static int getNumFilters() {
        return 7;
    }

    private void process(IntegerImage in, IntegerImage out) {
        int k;
        int n;
        float weight;
        int right;
        int i;
        if (out == null) {
            out = (IntegerImage)in.createCompatibleImage(this.outWidth, this.outHeight);
            this.setOutputImage(out);
        }
        if (this.filter == null) {
            this.filter = new TriangleFilter();
        }
        float fwidth = this.filter.getSamplingRadius();
        int dstWidth = this.outWidth;
        int dstHeight = this.outHeight;
        int srcWidth = in.getWidth();
        int srcHeight = in.getHeight();
        IntegerImage work = (IntegerImage)in.createCompatibleImage(dstWidth, srcHeight);
        float xscale = srcWidth == 1 ? (float)dstWidth / (float)srcWidth : (float)(dstWidth - 1) / (float)(srcWidth - 1);
        float yscale = srcHeight == 1 ? (float)dstHeight / (float)srcHeight : (float)(dstHeight - 1) / (float)(srcHeight - 1);
        int processedItems = 0;
        int totalItems = srcHeight + dstWidth;
        CList[] contrib = new CList[dstWidth];
        int i2 = 0;
        while (i2 < contrib.length) {
            contrib[i2] = new CList();
            ++i2;
        }
        if (xscale < 1.0f) {
            float width = fwidth / xscale;
            float fscale = 1.0f / xscale;
            int numPixels = (int)(width * 2.0f + 1.0f);
            i = 0;
            while (i < dstWidth) {
                contrib[i].n = 0;
                contrib[i].p = new Contributor[numPixels];
                int j = 0;
                while (j < contrib[i].p.length) {
                    contrib[i].p[j] = new Contributor();
                    ++j;
                }
                float center = (float)i / xscale;
                int left = (int)Math.floor(center - width);
                right = (int)Math.ceil(center + width);
                int j2 = left;
                while (j2 <= right) {
                    weight = this.filter.apply((center - (float)j2) / fscale) / fscale;
                    if (weight != 0.0f) {
                        n = j2 < 0 ? -j2 : (j2 >= srcWidth ? srcWidth - j2 + srcWidth - 1 : j2);
                        k = contrib[i].n++;
                        contrib[i].p[k].pixel = n;
                        contrib[i].p[k].weight = weight;
                    }
                    ++j2;
                }
                ++i;
            }
        } else {
            int numPixels = (int)(fwidth * 2.0f + 1.0f);
            int i3 = 0;
            while (i3 < dstWidth) {
                contrib[i3].n = 0;
                contrib[i3].p = new Contributor[numPixels];
                int j = 0;
                while (j < contrib[i3].p.length) {
                    contrib[i3].p[j] = new Contributor();
                    ++j;
                }
                float center = (float)i3 / xscale;
                int left = (int)Math.floor(center - fwidth);
                int right2 = (int)Math.ceil(center + fwidth);
                int j3 = left;
                while (j3 <= right2) {
                    float weight2 = this.filter.apply(center - (float)j3);
                    if (weight2 != 0.0f) {
                        int n2 = j3 < 0 ? -j3 : (j3 >= srcWidth ? srcWidth - j3 + srcWidth - 1 : j3);
                        int k2 = contrib[i3].n;
                        if (n2 < 0 || n2 >= srcWidth) {
                            weight2 = 0.0f;
                        }
                        ++contrib[i3].n;
                        contrib[i3].p[k2].pixel = n2;
                        contrib[i3].p[k2].weight = weight2;
                    }
                    ++j3;
                }
                ++i3;
            }
        }
        int NUM_CHANNELS = work.getNumChannels();
        int[] MAX = new int[NUM_CHANNELS];
        int k3 = 0;
        while (k3 < NUM_CHANNELS) {
            MAX[k3] = work.getMaxSample(k3);
            ++k3;
        }
        k3 = 0;
        while (k3 < srcHeight) {
            i = 0;
            while (i < dstWidth) {
                int channel = 0;
                while (channel < NUM_CHANNELS) {
                    float sample = 0.0f;
                    int j = 0;
                    while (j < contrib[i].n) {
                        float weight3 = contrib[i].p[j].weight;
                        if (weight3 != 0.0f) {
                            int color = in.getSample(channel, contrib[i].p[j].pixel, k3);
                            sample += (float)color * weight3;
                        }
                        ++j;
                    }
                    int result = (int)sample;
                    if (result < 0) {
                        result = 0;
                    } else if (result > MAX[channel]) {
                        result = MAX[channel];
                    }
                    work.putSample(channel, i, k3, result);
                    ++channel;
                }
                ++i;
            }
            this.setProgress(processedItems++, totalItems);
            ++k3;
        }
        contrib = new CList[dstHeight];
        int i4 = 0;
        while (i4 < contrib.length) {
            contrib[i4] = new CList();
            ++i4;
        }
        if (yscale < 1.0f) {
            float width = fwidth / yscale;
            float fscale = 1.0f / yscale;
            int numContributors = (int)(width * 2.0f + 1.0f);
            int i5 = 0;
            while (i5 < dstHeight) {
                contrib[i5].n = 0;
                contrib[i5].p = new Contributor[numContributors];
                int j = 0;
                while (j < contrib[i5].p.length) {
                    contrib[i5].p[j] = new Contributor();
                    ++j;
                }
                float center = (float)i5 / yscale;
                int left = (int)Math.floor(center - width);
                int right3 = (int)Math.ceil(center + width);
                int j4 = left;
                while (j4 <= right3) {
                    float weight4 = this.filter.apply((center - (float)j4) / fscale) / fscale;
                    if (weight4 != 0.0f) {
                        int n3 = j4 < 0 ? -j4 : (j4 >= srcHeight ? srcHeight - j4 + srcHeight - 1 : j4);
                        int k4 = contrib[i5].n++;
                        if (n3 < 0 || n3 >= srcHeight) {
                            weight4 = 0.0f;
                        }
                        contrib[i5].p[k4].pixel = n3;
                        contrib[i5].p[k4].weight = weight4;
                    }
                    ++j4;
                }
                ++i5;
            }
        } else {
            int numContributors = (int)(fwidth * 2.0f + 1.0f);
            i = 0;
            while (i < dstHeight) {
                contrib[i].n = 0;
                contrib[i].p = new Contributor[numContributors];
                int j = 0;
                while (j < contrib[i].p.length) {
                    contrib[i].p[j] = new Contributor();
                    ++j;
                }
                float center = (float)i / yscale;
                int left = (int)Math.floor(center - fwidth);
                right = (int)Math.ceil(center + fwidth);
                int j5 = left;
                while (j5 <= right) {
                    weight = this.filter.apply(center - (float)j5);
                    if (weight != 0.0f) {
                        n = j5 < 0 ? -j5 : (j5 >= srcHeight ? srcHeight - j5 + srcHeight - 1 : j5);
                        k = contrib[i].n++;
                        if (n < 0 || n >= srcHeight) {
                            weight = 0.0f;
                        }
                        contrib[i].p[k].pixel = n;
                        contrib[i].p[k].weight = weight;
                    }
                    ++j5;
                }
                ++i;
            }
        }
        k = 0;
        while (k < dstWidth) {
            int i6 = 0;
            while (i6 < dstHeight) {
                int channel = 0;
                while (channel < NUM_CHANNELS) {
                    float sample = 0.0f;
                    int j = 0;
                    while (j < contrib[i6].n) {
                        float weight5 = contrib[i6].p[j].weight;
                        if (weight5 != 0.0f) {
                            float color = work.getSample(channel, k, contrib[i6].p[j].pixel);
                            int result = (int)(sample += color * weight5);
                            if (result < 0) {
                                result = 0;
                            } else if (result > MAX[channel]) {
                                result = MAX[channel];
                            }
                            out.putSample(channel, k, i6, result);
                        }
                        ++j;
                    }
                    ++channel;
                }
                ++i6;
            }
            this.setProgress(processedItems++, totalItems);
            ++k;
        }
    }

    public void process() throws MissingParameterException, WrongParameterException {
        this.ensureInputImageIsAvailable();
        if (this.outWidth == null && this.outHeight == null && this.getOutputImage() != null) {
            PixelImage out = this.getOutputImage();
            this.outWidth = new Integer(out.getWidth());
            this.outHeight = new Integer(out.getHeight());
        }
        if (this.outWidth == null) {
            throw new MissingParameterException("Output width has not been initialized");
        }
        if (this.outHeight == null) {
            throw new MissingParameterException("Output height has not been initialized");
        }
        PixelImage image = this.getInputImage();
        if (image.getWidth() == this.outWidth.intValue() && image.getHeight() == this.outHeight.intValue()) {
            throw new WrongParameterException("Input image already has the size specified by setSize.");
        }
        this.ensureOutputImageResolution(this.outWidth, this.outHeight);
        if (!(image instanceof IntegerImage)) {
            throw new WrongParameterException("Input image must implement IntegerImage.");
        }
        this.process((IntegerImage)image, (IntegerImage)this.getOutputImage());
    }

    public void setSize(int width, int height) {
        this.outWidth = new Integer(width);
        this.outHeight = new Integer(height);
    }

    public void setFilter(ResampleFilter newFilter) {
        this.filter = newFilter;
    }

    public void setFilter(int filterType) {
        this.setFilter(Resample.createFilter(filterType));
    }

    public void setFilter(int filterType, float samplingRadius) {
        ResampleFilter newFilter = Resample.createFilter(filterType);
        newFilter.setSamplingRadius(samplingRadius);
        this.setFilter(newFilter);
    }

    class Contributor {
        int pixel;
        float weight;

        Contributor() {
        }
    }

    class CList {
        int n;
        Contributor[] p;

        CList() {
        }
    }
}

