/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.gui.awt;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import net.sourceforge.jiu.apps.EditorState;
import net.sourceforge.jiu.apps.ImageDescriptionCreator;
import net.sourceforge.jiu.apps.JiuInfo;
import net.sourceforge.jiu.apps.Strings;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.gui.awt.AwtMenuWrapper;
import net.sourceforge.jiu.gui.awt.AwtOperationProcessor;
import net.sourceforge.jiu.gui.awt.ImageCanvas;
import net.sourceforge.jiu.gui.awt.ImageCreator;
import net.sourceforge.jiu.gui.awt.dialogs.InfoDialog;
import net.sourceforge.jiu.ops.ProgressListener;

public class JiuAwtFrame
extends Frame
implements ActionListener,
ComponentListener,
JiuInfo,
ProgressListener {
    public static final String APP_NAME = "jiuawt " + JiuInfo.JIU_VERSION;
    private EditorState editor;
    private AwtMenuWrapper menuWrapper;
    private AwtOperationProcessor processor;
    private Label statusBar;
    private ScrollPane scrollPane;
    private ImageCanvas canvas;

    public JiuAwtFrame(EditorState editorState) {
        super(APP_NAME);
        this.processor = new AwtOperationProcessor(editorState, this);
        this.editor = editorState;
        this.editor.addProgressListener(this);
        this.addComponentListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JiuAwtFrame.this.processor.fileExit();
            }
        });
        this.menuWrapper = new AwtMenuWrapper(this.editor.getStrings(), this);
        this.setMenuBar(this.menuWrapper.getMenuBar());
        this.menuWrapper.updateEnabled(this.processor);
        this.statusBar = new Label("");
        this.add((Component)this.statusBar, "South");
        this.maximize();
        this.repaint();
        this.setVisible(true);
        if (this.editor.getStartupImageName() != null) {
            this.processor.fileOpen(null);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        int index = this.menuWrapper.findIndex(source);
        if (index != -1) {
            this.processor.process(index);
        }
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        if (this.scrollPane != null) {
            this.canvas.computeZoomToFitSize();
            this.scrollPane.doLayout();
        }
    }

    public void componentShown(ComponentEvent e) {
    }

    public void maximize() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit == null) {
            return;
        }
        Dimension screenSize = toolkit.getScreenSize();
        if (screenSize == null) {
            return;
        }
        int w = screenSize.width;
        int h = screenSize.height;
        int x = 20;
        int y = 80;
        this.setLocation(x / 2, y / 2);
        this.setSize(w - x, h - y);
    }

    public void showError(String text) {
        Strings strings = this.editor.getStrings();
        this.showInfo(strings.get(40), text);
    }

    public void setDefaultCursor() {
        Cursor cursor = new Cursor(0);
        this.setCursor(cursor);
    }

    public void setOriginalSize() {
        if (this.canvas != null && !this.editor.isZoomOriginalSize()) {
            this.editor.zoomSetOriginalSize();
            this.canvas.setZoomFactors(this.editor.getZoomFactorX(), this.editor.getZoomFactorY());
            this.updateTitle();
            this.menuWrapper.updateEnabled(this.processor);
        }
    }

    public void setProgress(int zeroBasedIndex, int totalItems) {
        if (totalItems < 1) {
            throw new IllegalArgumentException("Total number of items (second parameter) must be larger than zero.");
        }
        if (zeroBasedIndex < 0) {
            throw new IllegalArgumentException("Zero-based index must be at least zero.");
        }
        if (zeroBasedIndex >= totalItems) {
            throw new IllegalArgumentException("Zero-based index must be smaller than total number of items; zeroBasedIndex=" + zeroBasedIndex + ", totalItems=" + totalItems);
        }
        this.setProgress((float)(zeroBasedIndex + 1) / (float)totalItems);
    }

    public void setProgress(float progress) {
        if (progress >= 0.0f && progress <= 1.0f) {
            this.setStatusBar(" " + Math.round(progress * 100.0f) + "%");
        }
    }

    public void setStatusBar(String text) {
        this.statusBar.setText(text);
    }

    public void setWaitCursor() {
        Cursor cursor = new Cursor(3);
        this.setCursor(cursor);
    }

    public void showInfo(String title, String text) {
        InfoDialog d = new InfoDialog((Frame)this, title, text);
        d.show();
    }

    public void updateCanvas() {
        if (this.canvas != null) {
            this.canvas.setInterpolation(this.editor.getInterpolation());
            this.canvas.repaint();
        }
    }

    public void updateImage() {
        PixelImage image = this.editor.getImage();
        if (this.scrollPane != null) {
            this.remove(this.scrollPane);
        }
        if (image != null) {
            Image awtImage = ImageCreator.convertToAwtImage(image, -16777216);
            this.scrollPane = new ScrollPane(0);
            this.canvas = new ImageCanvas(this.scrollPane);
            this.canvas.setInterpolation(this.editor.getInterpolation());
            this.canvas.setZoomToFit(this.editor.getZoomToFit());
            this.canvas.setImage(awtImage);
            this.canvas.setZoomFactors(this.editor.getZoomFactorX(), this.editor.getZoomFactorY());
            this.scrollPane.add(this.canvas);
            this.add(this.scrollPane);
        }
        this.updateStatusBar();
        this.updateTitle();
        this.validate();
        this.menuWrapper.updateEnabled(this.processor);
    }

    public void updateStatusBar() {
        PixelImage image = this.editor.getImage();
        String statusBarText = image == null ? "" : ImageDescriptionCreator.getDescription(image, this.editor.getLocale(), this.editor.getStrings());
        this.setStatusBar(statusBarText);
    }

    public void updateTitle() {
        StringBuffer sb = new StringBuffer(APP_NAME);
        String fileName = this.editor.getFileName();
        if (fileName != null && fileName.length() > 0) {
            sb.append(" [");
            sb.append(fileName);
            if (this.editor.getModified()) {
                sb.append('*');
            }
            sb.append(']');
        }
        if (this.editor.getImage() != null) {
            double zoom = this.editor.getZoomFactorX();
            int percent = (int)(zoom * 100.0);
            sb.append(' ');
            sb.append(Integer.toString(percent));
            sb.append('%');
        }
        this.setTitle(sb.toString());
    }

    public void zoomIn() {
        if (this.canvas != null && !this.editor.isMaximumZoom()) {
            this.editor.zoomIn();
            this.canvas.setZoomFactors(this.editor.getZoomFactorX(), this.editor.getZoomFactorY());
            this.updateTitle();
            this.menuWrapper.updateEnabled(this.processor);
        }
    }

    public void zoomOut() {
        if (this.canvas != null && !this.editor.isMinimumZoom()) {
            this.editor.zoomOut();
            this.canvas.setZoomFactors(this.editor.getZoomFactorX(), this.editor.getZoomFactorY());
            this.updateTitle();
            this.menuWrapper.updateEnabled(this.processor);
        }
    }
}

