/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.beans;

import com.jgoodies.binding.beans.BeanUtils;
import com.jgoodies.binding.beans.PropertyNotFoundException;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;

public final class PropertyConnector {
    private final Object bean1;
    private final Object bean2;
    private final Class bean1Class;
    private final Class bean2Class;
    private final String property1Name;
    private final String property2Name;
    private final PropertyChangeListener property1ChangeHandler;
    private final PropertyChangeListener property2ChangeHandler;
    private final PropertyDescriptor property1Descriptor;
    private final PropertyDescriptor property2Descriptor;
    private final boolean property1Writable;
    private final boolean property2Writable;

    public PropertyConnector(Object bean1, String property1Name, Object bean2, String property2Name) {
        if (bean1 == null) {
            throw new NullPointerException("Bean1 must not be null.");
        }
        if (bean2 == null) {
            throw new NullPointerException("Bean2 must not be null.");
        }
        if (property1Name == null) {
            throw new NullPointerException("PropertyName1 must not be null.");
        }
        if (property2Name == null) {
            throw new NullPointerException("PropertyName2 must not be null.");
        }
        if (bean1 == bean2 && property1Name.equals(property2Name)) {
            throw new IllegalArgumentException("Cannot connect a bean property to itself on the same bean.");
        }
        this.bean1 = bean1;
        this.bean2 = bean2;
        this.bean1Class = bean1.getClass();
        this.bean2Class = bean2.getClass();
        this.property1Name = property1Name;
        this.property2Name = property2Name;
        this.property1Descriptor = PropertyConnector.getPropertyDescriptor(this.bean1Class, property1Name);
        this.property2Descriptor = PropertyConnector.getPropertyDescriptor(this.bean2Class, property2Name);
        this.property1Writable = this.property1Descriptor.getWriteMethod() != null;
        boolean bl = this.property2Writable = this.property2Descriptor.getWriteMethod() != null;
        if (!this.property1Writable && !this.property2Writable) {
            throw new IllegalArgumentException("Cannot connect two read-only properties.");
        }
        this.property1ChangeHandler = new PropertyChangeHandler(bean1, this.property1Descriptor, bean2, this.property2Descriptor);
        this.property2ChangeHandler = new PropertyChangeHandler(bean2, this.property2Descriptor, bean1, this.property1Descriptor);
        if (this.property2Writable) {
            PropertyConnector.addPropertyChangeHandler(bean1, this.bean1Class, this.property1ChangeHandler);
        }
        if (this.property1Writable) {
            PropertyConnector.addPropertyChangeHandler(bean2, this.bean2Class, this.property2ChangeHandler);
        }
    }

    public static void connect(Object bean1, String property1Name, Object bean2, String property2Name) {
        new PropertyConnector(bean1, property1Name, bean2, property2Name);
    }

    public Object getBean1() {
        return this.bean1;
    }

    public Object getBean2() {
        return this.bean2;
    }

    public String getProperty1Name() {
        return this.property1Name;
    }

    public String getProperty2Name() {
        return this.property2Name;
    }

    public void updateProperty1() {
        Object property2Value = BeanUtils.getValue(this.bean2, this.property2Descriptor);
        this.setValueSilently(this.bean1, this.property1Descriptor, property2Value);
    }

    public void updateProperty2() {
        Object property1Value = BeanUtils.getValue(this.bean1, this.property1Descriptor);
        this.setValueSilently(this.bean2, this.property2Descriptor, property1Value);
    }

    public void release() {
        PropertyConnector.removePropertyChangeHandler(this.bean1, this.bean1Class, this.property1ChangeHandler);
        PropertyConnector.removePropertyChangeHandler(this.bean2, this.bean2Class, this.property2ChangeHandler);
    }

    private static void addPropertyChangeHandler(Object bean, Class beanClass, PropertyChangeListener listener) {
        if (bean != null) {
            BeanUtils.addPropertyChangeListener(bean, beanClass, listener);
        }
    }

    private static void removePropertyChangeHandler(Object bean, Class beanClass, PropertyChangeListener listener) {
        if (bean != null) {
            BeanUtils.removePropertyChangeListener(bean, beanClass, listener);
        }
    }

    private void setValueSilently(Object bean, PropertyDescriptor propertyDescriptor, Object newValue) {
        if (this.property2Writable) {
            PropertyConnector.removePropertyChangeHandler(this.bean1, this.bean1Class, this.property1ChangeHandler);
        }
        if (this.property1Writable) {
            PropertyConnector.removePropertyChangeHandler(this.bean2, this.bean2Class, this.property2ChangeHandler);
        }
        try {
            BeanUtils.setValue(bean, propertyDescriptor, newValue);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        if (this.property2Writable) {
            PropertyConnector.addPropertyChangeHandler(this.bean1, this.bean1Class, this.property1ChangeHandler);
        }
        if (this.property1Writable) {
            PropertyConnector.addPropertyChangeHandler(this.bean2, this.bean2Class, this.property2ChangeHandler);
        }
    }

    private static PropertyDescriptor getPropertyDescriptor(Class beanClass, String propertyName) {
        try {
            return BeanUtils.getPropertyDescriptor(beanClass, propertyName);
        }
        catch (IntrospectionException e) {
            throw new PropertyNotFoundException(propertyName, beanClass, (Throwable)e);
        }
    }

    private final class PropertyChangeHandler
    implements PropertyChangeListener {
        private final Object sourceBean;
        private final PropertyDescriptor sourcePropertyDescriptor;
        private final Object targetBean;
        private final PropertyDescriptor targetPropertyDescriptor;

        private PropertyChangeHandler(Object sourceBean, PropertyDescriptor sourcePropertyDescriptor, Object targetBean, PropertyDescriptor targetPropertyDescriptor) {
            this.sourceBean = sourceBean;
            this.sourcePropertyDescriptor = sourcePropertyDescriptor;
            this.targetBean = targetBean;
            this.targetPropertyDescriptor = targetPropertyDescriptor;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String sourcePropertyName = this.sourcePropertyDescriptor.getName();
            if (evt.getPropertyName() == null || evt.getPropertyName().equals(sourcePropertyName)) {
                Object newValue = evt.getNewValue();
                if (newValue == null) {
                    newValue = BeanUtils.getValue(this.sourceBean, this.sourcePropertyDescriptor);
                }
                PropertyConnector.this.setValueSilently(this.targetBean, this.targetPropertyDescriptor, newValue);
            }
        }
    }
}

