/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.beans;

import com.jgoodies.binding.beans.BeanUtils;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;

public final class PropertyAdapter
extends AbstractValueModel {
    public static final String PROPERTYNAME_BEFORE_BEAN = "beforeBean";
    public static final String PROPERTYNAME_BEAN = "bean";
    public static final String PROPERTYNAME_AFTER_BEAN = "afterBean";
    public static final String PROPERTYNAME_CHANGED = "changed";
    private final ValueModel beanChannel;
    private final String propertyName;
    private final String getterName;
    private final String setterName;
    private final boolean observeChanges;
    private Object storedOldBean;
    private boolean changed = false;
    private PropertyChangeListener propertyChangeHandler;
    private PropertyDescriptor cachedPropertyDescriptor;
    private Class cachedBeanClass;

    public PropertyAdapter(Object bean, String propertyName) {
        this(bean, propertyName, false);
    }

    public PropertyAdapter(Object bean, String propertyName, boolean observeChanges) {
        this(bean, propertyName, null, null, observeChanges);
    }

    public PropertyAdapter(Object bean, String propertyName, String getterName, String setterName) {
        this(bean, propertyName, getterName, setterName, false);
    }

    public PropertyAdapter(Object bean, String propertyName, String getterName, String setterName, boolean observeChanges) {
        this(new ValueHolder(bean, true), propertyName, getterName, setterName, observeChanges);
    }

    public PropertyAdapter(ValueModel beanChannel, String propertyName) {
        this(beanChannel, propertyName, false);
    }

    public PropertyAdapter(ValueModel beanChannel, String propertyName, boolean observeChanges) {
        this(beanChannel, propertyName, null, null, observeChanges);
    }

    public PropertyAdapter(ValueModel beanChannel, String propertyName, String getterName, String setterName) {
        this(beanChannel, propertyName, getterName, setterName, false);
    }

    public PropertyAdapter(ValueModel beanChannel, String propertyName, String getterName, String setterName, boolean observeChanges) {
        this.beanChannel = beanChannel != null ? beanChannel : new ValueHolder(null, true);
        this.propertyName = propertyName;
        this.getterName = getterName;
        this.setterName = setterName;
        this.observeChanges = observeChanges;
        if (propertyName == null) {
            throw new NullPointerException("The property name must not be null.");
        }
        if (propertyName.length() == 0) {
            throw new IllegalArgumentException("The property name must not be empty.");
        }
        this.checkBeanChannelIdentityCheck(beanChannel);
        this.beanChannel.addValueChangeListener(new BeanChangeHandler());
        Object initialBean = this.getBean();
        if (initialBean != null) {
            this.getPropertyDescriptor(initialBean);
            this.addChangeHandlerTo(initialBean);
        }
        this.storedOldBean = initialBean;
    }

    public Object getBean() {
        return this.beanChannel.getValue();
    }

    public void setBean(Object newBean) {
        this.beanChannel.setValue(newBean);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean getObserveChanges() {
        return this.observeChanges;
    }

    public Object getValue() {
        Object bean = this.getBean();
        if (bean == null) {
            return null;
        }
        return this.getValue0(bean);
    }

    public void setValue(Object newValue) {
        Object bean = this.getBean();
        if (bean == null) {
            return;
        }
        try {
            this.setValue0(bean, newValue);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void setVetoableValue(Object newValue) throws PropertyVetoException {
        Object bean = this.getBean();
        if (bean == null) {
            return;
        }
        this.setValue0(this.getBean(), newValue);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void resetChanged() {
        this.setChanged(false);
    }

    private void setChanged(boolean newValue) {
        boolean oldValue = this.isChanged();
        this.changed = newValue;
        this.firePropertyChange(PROPERTYNAME_CHANGED, oldValue, newValue);
    }

    public void release() {
        this.removeChangeHandlerFrom(this.getBean());
    }

    private void setBean0(Object oldBean, Object newBean) {
        this.firePropertyChange(PROPERTYNAME_BEFORE_BEAN, oldBean, newBean, true);
        this.removeChangeHandlerFrom(oldBean);
        this.forwardAdaptedValueChanged(oldBean, newBean);
        this.resetChanged();
        this.addChangeHandlerTo(newBean);
        this.firePropertyChange(PROPERTYNAME_BEAN, oldBean, newBean, true);
        this.firePropertyChange(PROPERTYNAME_AFTER_BEAN, oldBean, newBean, true);
    }

    private void forwardAdaptedValueChanged(Object oldBean, Object newBean) {
        Object newValue;
        Object oldValue = oldBean == null || this.isWriteOnlyProperty(oldBean) ? null : this.getValue0(oldBean);
        Object object = newValue = newBean == null || this.isWriteOnlyProperty(newBean) ? null : this.getValue0(newBean);
        if (oldValue != null || newValue != null) {
            this.fireValueChange(oldValue, newValue, true);
        }
    }

    private void forwardAdaptedValueChanged(Object newBean) {
        Object newValue = newBean == null || this.isWriteOnlyProperty(newBean) ? null : this.getValue0(newBean);
        this.fireValueChange(null, newValue);
    }

    private void addChangeHandlerTo(Object bean) {
        if (!this.observeChanges || bean == null) {
            return;
        }
        this.propertyChangeHandler = new PropertyChangeHandler();
        BeanUtils.addPropertyChangeListener(bean, this.getBeanClass(bean), this.propertyChangeHandler);
    }

    private void removeChangeHandlerFrom(Object bean) {
        if (!this.observeChanges || bean == null) {
            return;
        }
        BeanUtils.removePropertyChangeListener(bean, this.getBeanClass(bean), this.propertyChangeHandler);
        this.propertyChangeHandler = null;
    }

    private Class getBeanClass(Object bean) {
        return bean.getClass();
    }

    private Object getValue0(Object bean) {
        return bean == null ? null : BeanUtils.getValue(bean, this.getPropertyDescriptor(bean));
    }

    private void setValue0(Object bean, Object newValue) throws PropertyVetoException {
        BeanUtils.setValue(bean, this.getPropertyDescriptor(bean), newValue);
    }

    private PropertyDescriptor getPropertyDescriptor(Object bean) {
        Class beanClass = this.getBeanClass(bean);
        if (this.cachedPropertyDescriptor == null || beanClass != this.cachedBeanClass) {
            this.cachedPropertyDescriptor = BeanUtils.getPropertyDescriptor(beanClass, this.getPropertyName(), this.getterName, this.setterName);
            this.cachedBeanClass = beanClass;
        }
        return this.cachedPropertyDescriptor;
    }

    private boolean isWriteOnlyProperty(Object bean) {
        return null == this.getPropertyDescriptor(bean).getReadMethod();
    }

    private void checkBeanChannelIdentityCheck(ValueModel valueModel) throws IllegalArgumentException {
        if (!(valueModel instanceof ValueHolder)) {
            return;
        }
        ValueHolder valueHolder = (ValueHolder)valueModel;
        if (!valueHolder.isIdentityCheckEnabled()) {
            throw new IllegalArgumentException("The bean channel must have the identity check enabled.");
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            PropertyAdapter.this.setChanged(true);
            if (evt.getPropertyName() == null) {
                PropertyAdapter.this.forwardAdaptedValueChanged(PropertyAdapter.this.getBean());
            } else if (evt.getPropertyName().equals(PropertyAdapter.this.getPropertyName())) {
                PropertyAdapter.this.fireValueChange(evt.getOldValue(), evt.getNewValue(), true);
            }
        }
    }

    private class BeanChangeHandler
    implements PropertyChangeListener {
        private BeanChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Object newBean = evt.getNewValue() != null ? evt.getNewValue() : PropertyAdapter.this.getBean();
            PropertyAdapter.this.setBean0(PropertyAdapter.this.storedOldBean, newBean);
            PropertyAdapter.this.storedOldBean = newBean;
        }
    }
}

