/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.list;

import com.jgoodies.binding.list.ObservableList;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public final class ArrayListModel
extends ArrayList
implements ObservableList {
    private static final long serialVersionUID = -6165677201152015546L;
    private EventListenerList listenerList;

    public ArrayListModel() {
        this(10);
    }

    public ArrayListModel(int initialCapacity) {
        super(initialCapacity);
    }

    public ArrayListModel(Collection c) {
        super(c);
    }

    public void add(int index, Object element) {
        super.add(index, element);
        this.fireIntervalAdded(index, index);
    }

    public boolean add(Object o) {
        int newIndex = this.size();
        super.add(o);
        this.fireIntervalAdded(newIndex, newIndex);
        return true;
    }

    public boolean addAll(int index, Collection c) {
        boolean changed = super.addAll(index, c);
        if (changed) {
            int lastIndex = index + c.size() - 1;
            this.fireIntervalAdded(index, lastIndex);
        }
        return changed;
    }

    public boolean addAll(Collection c) {
        int firstIndex = this.size();
        boolean changed = super.addAll(c);
        if (changed) {
            int lastIndex = firstIndex + c.size() - 1;
            this.fireIntervalAdded(firstIndex, lastIndex);
        }
        return changed;
    }

    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        int oldLastIndex = this.size() - 1;
        super.clear();
        this.fireIntervalRemoved(0, oldLastIndex);
    }

    public Object remove(int index) {
        Object removedElement = super.remove(index);
        this.fireIntervalRemoved(index, index);
        return removedElement;
    }

    public boolean remove(Object o) {
        boolean contained;
        int index = this.indexOf(o);
        boolean bl = contained = index != -1;
        if (contained) {
            this.remove(index);
        }
        return contained;
    }

    protected void removeRange(int fromIndex, int toIndex) {
        super.removeRange(fromIndex, toIndex);
        this.fireIntervalRemoved(fromIndex, toIndex - 1);
    }

    public Object set(int index, Object element) {
        Object previousElement = super.set(index, element);
        this.fireContentsChanged(index, index);
        return previousElement;
    }

    public void addListDataListener(ListDataListener l) {
        this.getEventListenerList().add(ListDataListener.class, l);
    }

    public void removeListDataListener(ListDataListener l) {
        this.getEventListenerList().remove(ListDataListener.class, l);
    }

    public Object getElementAt(int index) {
        return this.get(index);
    }

    public int getSize() {
        return this.size();
    }

    public void fireContentsChanged(int index) {
        this.fireContentsChanged(index, index);
    }

    public ListDataListener[] getListDataListeners() {
        return (ListDataListener[])this.getEventListenerList().getListeners(ListDataListener.class);
    }

    private void fireContentsChanged(int index0, int index1) {
        Object[] listeners = this.getEventListenerList().getListenerList();
        ListDataEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ListDataListener == null ? ArrayListModel.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (e == null) {
                e = new ListDataEvent(this, 0, index0, index1);
            }
            ((ListDataListener)listeners[i + 1]).contentsChanged(e);
        }
    }

    private void fireIntervalAdded(int index0, int index1) {
        Object[] listeners = this.getEventListenerList().getListenerList();
        ListDataEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ListDataListener == null ? ArrayListModel.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (e == null) {
                e = new ListDataEvent(this, 1, index0, index1);
            }
            ((ListDataListener)listeners[i + 1]).intervalAdded(e);
        }
    }

    private void fireIntervalRemoved(int index0, int index1) {
        Object[] listeners = this.getEventListenerList().getListenerList();
        ListDataEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ListDataListener == null ? ArrayListModel.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (e == null) {
                e = new ListDataEvent(this, 2, index0, index1);
            }
            ((ListDataListener)listeners[i + 1]).intervalRemoved(e);
        }
    }

    private EventListenerList getEventListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        return this.listenerList;
    }
}

