/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.list;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ListHolder
extends Model
implements ListModel {
    public static final String PROPERTYNAME_LIST = "list";
    public static final String PROPERTYNAME_LIST_HOLDER = "listHolder";
    private ValueModel listHolder;
    protected List list;
    private final PropertyChangeListener listChangeHandler;
    private final EventListenerList listenerList = new EventListenerList();

    public ListHolder() {
        this(new ArrayList());
    }

    public ListHolder(List list) {
        this(new ValueHolder(list, true));
    }

    public ListHolder(ValueModel listHolder) {
        this.listHolder = listHolder;
        if (listHolder == null) {
            throw new NullPointerException("The List holder must not be null.");
        }
        this.listChangeHandler = new ListChangeHandler();
        listHolder.addValueChangeListener(this.listChangeHandler);
        this.list = (List)listHolder.getValue();
    }

    public final List getList() {
        return (List)this.getListHolder().getValue();
    }

    public final void setList(List newList) {
        this.getListHolder().setValue(newList);
    }

    public final ValueModel getListHolder() {
        return this.listHolder;
    }

    public final void setListHolder(ValueModel newListHolder) {
        if (newListHolder == null) {
            throw new NullPointerException("The new list holder must not be null.");
        }
        ValueModel oldListHolder = this.getListHolder();
        if (this.equals(oldListHolder, newListHolder)) {
            return;
        }
        List oldListModel = this.list;
        List newListModel = (List)newListHolder.getValue();
        oldListHolder.removeValueChangeListener(this.listChangeHandler);
        this.listHolder = newListHolder;
        newListHolder.addValueChangeListener(this.listChangeHandler);
        this.updateList(oldListModel, newListModel);
        this.firePropertyChange(PROPERTYNAME_LIST_HOLDER, oldListHolder, newListHolder);
    }

    public final boolean isEmpty() {
        return this.getSize() == 0;
    }

    public final int getSize() {
        return this.getSize(this.getList());
    }

    public final Object getElementAt(int index) {
        return this.getList().get(index);
    }

    public final void addListDataListener(ListDataListener l) {
        this.listenerList.add(ListDataListener.class, l);
    }

    public final void removeListDataListener(ListDataListener l) {
        this.listenerList.remove(ListDataListener.class, l);
    }

    public final ListDataListener[] getListDataListeners() {
        return (ListDataListener[])this.listenerList.getListeners(ListDataListener.class);
    }

    public final void fireContentsChanged(int index0, int index1) {
        Object[] listeners = this.listenerList.getListenerList();
        ListDataEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ListDataListener == null ? ListHolder.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (e == null) {
                e = new ListDataEvent(this, 0, index0, index1);
            }
            ((ListDataListener)listeners[i + 1]).contentsChanged(e);
        }
    }

    public final void fireIntervalAdded(int index0, int index1) {
        Object[] listeners = this.listenerList.getListenerList();
        ListDataEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ListDataListener == null ? ListHolder.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (e == null) {
                e = new ListDataEvent(this, 1, index0, index1);
            }
            ((ListDataListener)listeners[i + 1]).intervalAdded(e);
        }
    }

    public final void fireIntervalRemoved(int index0, int index1) {
        Object[] listeners = this.listenerList.getListenerList();
        ListDataEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ListDataListener == null ? ListHolder.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (e == null) {
                e = new ListDataEvent(this, 2, index0, index1);
            }
            ((ListDataListener)listeners[i + 1]).intervalRemoved(e);
        }
    }

    protected void updateList(List oldList, List newList) {
        this.list = newList;
        this.firePropertyChange(PROPERTYNAME_LIST, oldList, newList);
        this.fireListChanged(this.getSize(oldList) - 1, this.getSize(newList) - 1);
    }

    protected final void fireListChanged(int oldLastIndex, int newLastIndex) {
        if (oldLastIndex == newLastIndex) {
            if (newLastIndex == -1) {
                return;
            }
            this.fireContentsChanged(0, newLastIndex);
        } else {
            if (oldLastIndex >= 0) {
                this.fireIntervalRemoved(0, oldLastIndex);
            }
            if (newLastIndex >= 0) {
                this.fireIntervalAdded(0, newLastIndex);
            }
        }
    }

    protected final int getSize(List aListOrNull) {
        return aListOrNull == null ? 0 : aListOrNull.size();
    }

    private final class ListChangeHandler
    implements PropertyChangeListener {
        private ListChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            List oldList = ListHolder.this.list;
            List newList = (List)evt.getNewValue();
            ListHolder.this.updateList(oldList, newList);
        }
    }
}

